/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.util.net.cookie;

import java.net.URI;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

class Cookie {
    String name;
    String value;
    URI uri;
    String domain;
    Date expires;
    String path;
    private static DateFormat expiresFormat1 = new SimpleDateFormat("E, dd MMM yyyy k:m:s 'GMT'", Locale.US);
    private static DateFormat expiresFormat2 = new SimpleDateFormat("E, dd-MMM-yyyy k:m:s 'GMT'", Locale.US);

    public Cookie(URI uri, String header) {
        String[] attributes = header.split(";");
        String nameValue = attributes[0].trim();
        this.uri = uri;
        this.name = nameValue.substring(0, nameValue.indexOf(61));
        this.value = nameValue.substring(nameValue.indexOf(61) + 1);
        this.path = "/";
        this.domain = uri.getHost();
        int i = 1;
        while (i < attributes.length) {
            nameValue = attributes[i].trim();
            int equals = nameValue.indexOf(61);
            if (equals != -1) {
                String name = nameValue.substring(0, equals);
                String value = nameValue.substring(equals + 1);
                if (name.equalsIgnoreCase("domain")) {
                    String uriDomain = uri.getHost();
                    if (uriDomain.equals(value)) {
                        this.domain = value;
                    } else {
                        if (!value.startsWith(".")) {
                            value = "." + value;
                        }
                        if (!(uriDomain = uriDomain.substring(uriDomain.indexOf(46))).equals(value)) {
                            throw new IllegalArgumentException("Trying to set foreign cookie");
                        }
                        this.domain = value;
                    }
                } else if (name.equalsIgnoreCase("path")) {
                    this.path = value;
                } else if (name.equalsIgnoreCase("expires")) {
                    try {
                        this.expires = expiresFormat1.parse(value);
                    }
                    catch (ParseException e) {
                        try {
                            this.expires = expiresFormat2.parse(value);
                        }
                        catch (ParseException e2) {
                            throw new IllegalArgumentException("Bad date format in header: " + value);
                        }
                    }
                }
            }
            ++i;
        }
    }

    public boolean hasExpired() {
        if (this.expires == null) {
            return false;
        }
        Date now = new Date();
        return now.after(this.expires);
    }

    public String getName() {
        return this.name;
    }

    public URI getURI() {
        return this.uri;
    }

    public boolean matches(URI uri) {
        if (this.hasExpired()) {
            return false;
        }
        String path = uri.getPath();
        if (path == null) {
            path = "/";
        }
        return path.startsWith(this.path);
    }

    public String toString() {
        StringBuilder result = new StringBuilder(this.name);
        result.append("=");
        result.append(this.value);
        return result.toString();
    }
}

