/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.util.net.cookie;

import br.com.bb.plugins.gac.util.net.cookie.Cookie;
import java.io.IOException;
import java.net.CookieHandler;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListCookieHandler
extends CookieHandler {
    private List<Cookie> cookieJar = new LinkedList<Cookie>();

    @Override
    public void put(URI uri, Map<String, List<String>> responseHeaders) throws IOException {
        List<String> setCookieList = responseHeaders.get("Set-Cookie");
        if (setCookieList != null) {
            for (String item : setCookieList) {
                Cookie cookie = new Cookie(uri, item);
                for (Cookie existingCookie : this.cookieJar) {
                    if (!cookie.getURI().equals(existingCookie.getURI()) || !cookie.getName().equals(existingCookie.getName())) continue;
                    this.cookieJar.remove(existingCookie);
                    break;
                }
                this.cookieJar.add(cookie);
            }
        }
    }

    @Override
    public Map<String, List<String>> get(URI uri, Map<String, List<String>> requestHeaders) throws IOException {
        StringBuilder cookies = new StringBuilder();
        for (Cookie cookie : this.cookieJar) {
            if (cookie.hasExpired()) {
                this.cookieJar.remove(cookie);
                continue;
            }
            if (!cookie.matches(uri)) continue;
            if (cookies.length() > 0) {
                cookies.append(", ");
            }
            cookies.append(cookie.toString());
        }
        HashMap<String, List<String>> cookieMap = new HashMap<String, List<String>>(requestHeaders);
        if (cookies.length() > 0) {
            List<String> list = Collections.singletonList(cookies.toString());
            cookieMap.put("Cookie", list);
        }
        return Collections.unmodifiableMap(cookieMap);
    }
}

