/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.util.net.proxy;

import br.com.bb.plugins.gac.apresentacao.configurardadosservidorproxy.action.RecuperarDadosServidorProxyAction;
import br.com.bb.plugins.gac.apresentacao.configurardadosservidorproxy.form.DadosServidorProxyForm;
import br.com.bb.plugins.gac.excecao.BBException;
import br.com.bb.plugins.gac.factory.ActionFactory;
import br.com.bb.plugins.gac.factory.FormFactory;
import br.com.bb.plugins.gac.util.net.cookie.ListCookieHandler;
import br.com.bb.plugins.gac.util.net.proxy.BBGACProxyTest;
import br.com.bb.plugins.gac.util.seguranca.AutenticadorBBGAC;
import java.net.Authenticator;
import java.net.CookieHandler;

public class BBGACProxy {
    public void conecta(String s_arquivo) throws BBException {
        DadosServidorProxyForm dadosServidorProxyForm = (DadosServidorProxyForm)FormFactory.getInstancia().novoDadosServidorProxyForm();
        RecuperarDadosServidorProxyAction recuperarDadosServidorProxyAction = ActionFactory.getInstancia().novoRecuperarDadosServidorProxyAction();
        recuperarDadosServidorProxyAction.executar(dadosServidorProxyForm);
        Boolean usaServidorProxy = dadosServidorProxyForm.getUsaServidorProxy();
        boolean usuarioNaoClicouEmCancelarAutenticacao = true;
        if (usaServidorProxy.booleanValue()) {
            this.configuraConexaoProxy(dadosServidorProxyForm);
            while (usuarioNaoClicouEmCancelarAutenticacao && this.testaConexao(s_arquivo, dadosServidorProxyForm)) {
                AutenticadorBBGAC.limpaDados();
                Authenticator.setDefault(AutenticadorBBGAC.autentica());
                usuarioNaoClicouEmCancelarAutenticacao = AutenticadorBBGAC.isNaoCancelado();
            }
        }
    }

    private boolean testaConexao(String s_arquivo, DadosServidorProxyForm dadosServidorProxyForm) throws BBException {
        BBGACProxyTest proxyTest;
        boolean ehPrecisoAutenticar = false;
        try {
            proxyTest = new BBGACProxyTest();
            proxyTest.setDadosServidorProxyForm(dadosServidorProxyForm);
            ehPrecisoAutenticar = proxyTest.necessitaDeAutenticacao(s_arquivo);
        }
        finally {
            proxyTest = null;
        }
        return ehPrecisoAutenticar;
    }

    private void configuraConexaoProxy(DadosServidorProxyForm dadosServidorProxyForm) {
        CookieHandler.setDefault(new ListCookieHandler());
        System.setProperty("http.proxyHost", dadosServidorProxyForm.getEndereco());
        System.setProperty("http.proxyPort", dadosServidorProxyForm.getPorta());
        System.setProperty("https.proxyHost", dadosServidorProxyForm.getEndereco());
        System.setProperty("https.proxyPort", dadosServidorProxyForm.getPorta());
        System.setProperty("proxySet", "true");
        System.setProperty("http.proxySet", "true");
        System.setProperty("https.proxySet", "true");
    }
}

