/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.util.objecttablemodel;

import br.com.bb.plugins.gac.negocio.to.ConvenioTO;
import br.com.bb.plugins.gac.negocio.to.PluginTOAbstrato;
import br.com.bb.plugins.gac.negocio.to.decorator.RemessaTODecorator;
import br.com.bb.plugins.gac.util.swing.componente.IObjectTableModel;
import br.com.politec.generico.conversor.instancia.ConversorDeUtilDateParaStringNoPadrao;
import br.com.politec.generico.excecao.ConversorException;
import br.com.politec.generico.formatador.UtilFormatadorDeReal;
import br.com.politec.infra.util.UtilLog;
import java.math.BigDecimal;
import java.sql.Date;

public class IObjectRecuperarRemessas
extends IObjectTableModel {
    private RemessaTODecorator remessaTODecorator;

    public IObjectRecuperarRemessas(RemessaTODecorator decorator) {
        this.setRemessaTODecorator(decorator);
    }

    public IObjectRecuperarRemessas(int numeroRemessa, Date dataRemessa, int numeroConvenio, double valorRemessa, String nomeArquivo) {
        RemessaTODecorator to = new RemessaTODecorator();
        to.setNumeroRemessa(new Integer(numeroRemessa));
        to.setDataRemessa(dataRemessa);
        to.setNumeroConvenio(numeroConvenio);
        to.setValorRemessa(new BigDecimal(valorRemessa));
        to.setTextoNomeArquivo(nomeArquivo);
        this.setRemessaTODecorator(to);
    }

    public Object getColumn(int column) {
        switch (column) {
            case 0: {
                return this.getDataRemessa();
            }
            case 1: {
                return this.getRemessaTODecorator().getNumeroConvenio();
            }
            case 2: {
                return this.getNumeroRemessa();
            }
            case 3: {
                return UtilFormatadorDeReal.formatar(this.getRemessaTODecorator().getValorRemessa());
            }
            case 4: {
                return this.getTextoNomeArquivo();
            }
        }
        return null;
    }

    public PluginTOAbstrato getTO() {
        return this.getRemessaTODecorator();
    }

    public RemessaTODecorator getRemessaTODecorator() {
        return this.remessaTODecorator;
    }

    public String getNumeroRemessa() {
        return this.getRemessaTODecorator().getNumeroRemessa().toString();
    }

    public ConvenioTO getConvenioTO() {
        return this.getRemessaTODecorator().getConvenioTO();
    }

    public String getDataRemessa() {
        ConversorDeUtilDateParaStringNoPadrao padrao = new ConversorDeUtilDateParaStringNoPadrao();
        String converter = "";
        try {
            converter = (String)padrao.converter(this.getRemessaTODecorator().getDataRemessa());
        }
        catch (ConversorException e) {
            UtilLog.getLog().debug(e);
        }
        return converter;
    }

    public String getTextoNomeArquivo() {
        return this.getRemessaTODecorator().getTextoNomeArquivo();
    }

    public String getTipoRegistro() {
        return this.getRemessaTODecorator().getTipoRegistro();
    }

    public void setRemessaTODecorator(RemessaTODecorator remessaTODecorator) {
        this.remessaTODecorator = remessaTODecorator;
    }
}

