/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.util.parserarquivo;

import br.com.bb.plugins.gac.excecao.BBException;
import br.com.bb.plugins.gac.util.parserarquivo.IParserArquivo;
import br.com.bb.plugins.gac.util.parserarquivo.bean.RegistroBean;
import br.com.bb.plugins.gac.util.parserarquivo.model.RegistrosDoArquivoModel;
import br.com.politec.generico.fabrica.ColecaoFactory;
import br.com.politec.generico.objeto.UtilObjeto;
import br.com.politec.generico.string.UtilString;
import java.io.File;
import java.util.Collection;
import java.util.Date;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParserArquivo
implements IParserArquivo {
    private File arquivo;
    private Map<String, RegistrosDoArquivoModel> mapaDeRegistros;

    @Override
    public void setArquivo(File arquivo) {
        this.arquivo = arquivo;
    }

    @Override
    public Object getValorDoCabecalho(String campo) throws BBException {
        return this.getRegistrosDoArquivoModel().getValorDoCabecalho(campo);
    }

    @Override
    public Date getValorDoCabecalhoDate(String campo) throws BBException {
        return this.getRegistrosDoArquivoModel().getValorDoCabecalhoDate(campo);
    }

    @Override
    public Double getValorDoCabecalhoDouble(String campo) throws BBException {
        return this.getRegistrosDoArquivoModel().getValorDoCabecalhoDouble(campo);
    }

    @Override
    public Long getValorDoCabecalhoLong(String campo) throws BBException {
        return this.getRegistrosDoArquivoModel().getValorDoCabecalhoLong(campo);
    }

    @Override
    public Integer getValorDoCabecalhoInteger(String campo) throws BBException {
        return this.getRegistrosDoArquivoModel().getValorDoCabecalhoInteger(campo);
    }

    @Override
    public String getValorDoCabecalhoString(String campo) throws BBException {
        return this.getRegistrosDoArquivoModel().getValorDoCabecalhoString(campo);
    }

    @Override
    public Collection<RegistroBean> getColecaoDeRegistros() throws BBException {
        return this.getRegistrosDoArquivoModel().getColecaoDeRegistros();
    }

    @Override
    public Object getValorDoRegistro(int indice, String campo) throws BBException {
        return this.getRegistrosDoArquivoModel().getValorDoRegistro(indice, campo);
    }

    @Override
    public Date getValorDoRegistroDate(int indice, String campo) throws BBException {
        return this.getRegistrosDoArquivoModel().getValorDoRegistroDate(indice, campo);
    }

    @Override
    public Double getValorDoRegistroDouble(int indice, String campo) throws BBException {
        return this.getRegistrosDoArquivoModel().getValorDoRegistroDouble(indice, campo);
    }

    @Override
    public Integer getValorDoRegistroInteger(int indice, String campo) throws BBException {
        return this.getRegistrosDoArquivoModel().getValorDoRegistroInteger(indice, campo);
    }

    @Override
    public Long getValorDoRegistroLong(int indice, String campo) throws BBException {
        return this.getRegistrosDoArquivoModel().getValorDoRegistroLong(indice, campo);
    }

    @Override
    public String getValorDoRegistroString(int indice, String campo) throws BBException {
        return this.getRegistrosDoArquivoModel().getValorDoRegistroString(indice, campo);
    }

    @Override
    public String getNomeDoRegistro(int indice) throws BBException {
        return this.getRegistrosDoArquivoModel().getNomeDoRegistro(indice);
    }

    protected RegistrosDoArquivoModel getRegistrosDoArquivoModel() throws BBException {
        String servico = this.getNomeDoServico();
        RegistrosDoArquivoModel m = this.getRegistrosDoArquivoModel(servico);
        if (!this.isReferencia(m)) {
            m = this.carregarRegistrosDoArquivoModel();
        }
        return m;
    }

    protected RegistrosDoArquivoModel getRegistrosDoArquivoModel(String servico) {
        return this.getMapaDeRegistros().get(servico);
    }

    protected RegistrosDoArquivoModel carregarRegistrosDoArquivoModel() throws BBException {
        RegistrosDoArquivoModel model = new RegistrosDoArquivoModel();
        model.setArquivoTXT(this.getArquivo());
        model.carregar();
        this.getMapaDeRegistros().put(this.getNomeDoServico(), model);
        return model;
    }

    protected String getNomeDoServico() {
        return UtilString.substring(this.getNomeDoArquivo(), 0, 3);
    }

    protected String getNomeDoArquivo() {
        return this.getArquivo().getName();
    }

    protected File getArquivo() {
        return this.arquivo;
    }

    protected boolean isReferencia(Object objeto) {
        return UtilObjeto.isReferencia(objeto);
    }

    protected Map<String, RegistrosDoArquivoModel> getMapaDeRegistros() {
        if (!UtilObjeto.isReferencia(this.mapaDeRegistros)) {
            this.mapaDeRegistros = this.getColecaoFactory().novoHashMap();
        }
        return this.mapaDeRegistros;
    }

    protected ColecaoFactory getColecaoFactory() {
        return ColecaoFactory.getInstance();
    }

    @Override
    public int getTotalDeRegistros() throws BBException {
        return this.getRegistrosDoArquivoModel().getTotalDeRegistros();
    }

    @Override
    public Integer getNumeroRemessa() throws BBException {
        String[] nomeArquivo = this.getNomeDoArquivo().replace('.', ':').split(":");
        return Integer.parseInt(nomeArquivo[3]);
    }
}

