/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.util.parserarquivo.model;

import br.com.bb.plugins.gac.excecao.BBException;
import br.com.bb.plugins.gac.factory.BeanFactory;
import br.com.bb.plugins.gac.util.constante.Arquivo;
import br.com.bb.plugins.gac.util.constante.TipoDeRegistro;
import br.com.bb.plugins.gac.util.parserarquivo.bean.CampoBean;
import br.com.bb.plugins.gac.util.parserarquivo.bean.RegistroBean;
import br.com.bb.plugins.gac.util.parserarquivo.bean.ServicoBean;
import br.com.bb.plugins.gac.util.parserarquivo.util.UtilParserArquivoTXT;
import br.com.bb.plugins.gac.util.parserarquivo.util.UtilParserArquivoXML;
import br.com.politec.generico.arquivo.UtilArquivo;
import br.com.politec.generico.colecao.IComparador;
import br.com.politec.generico.colecao.UtilColecao;
import br.com.politec.generico.fabrica.ColecaoFactory;
import br.com.politec.generico.objeto.UtilObjeto;
import br.com.politec.generico.string.UtilString;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegistrosDoArquivoModel
implements Serializable {
    private Map<String, Collection<RegistroBean>> mapaDeRegistros;
    private File arquivoTXT;
    private static Map<String, String> mapaDeArquivoXML;

    public Object getValorDoRegistro(int indice, String campo) {
        return this.getValor(indice, campo);
    }

    public Date getValorDoRegistroDate(int indice, String campo) {
        return (Date)this.getValorDoRegistro(indice, campo);
    }

    public Double getValorDoRegistroDouble(int indice, String campo) {
        return (Double)this.getValorDoRegistro(indice, campo);
    }

    public Integer getValorDoRegistroInteger(int indice, String campo) {
        return (Integer)this.getValorDoRegistro(indice, campo);
    }

    public Long getValorDoRegistroLong(int indice, String campo) {
        return (Long)this.getValorDoRegistro(indice, campo);
    }

    public String getValorDoRegistroString(int indice, String campo) {
        return (String)this.getValorDoRegistro(indice, campo);
    }

    public Object getValorDoCabecalho(String campo) {
        return this.getValor(TipoDeRegistro.getCabecalho(), campo);
    }

    public Date getValorDoCabecalhoDate(String campo) {
        return (Date)this.getValor(TipoDeRegistro.getCabecalho(), campo);
    }

    public Double getValorDoCabecalhoDouble(String campo) {
        return (Double)this.getValor(TipoDeRegistro.getCabecalho(), campo);
    }

    public Long getValorDoCabecalhoLong(String campo) {
        return (Long)this.getValor(TipoDeRegistro.getCabecalho(), campo);
    }

    public Integer getValorDoCabecalhoInteger(String campo) {
        return (Integer)this.getValor(TipoDeRegistro.getCabecalho(), campo);
    }

    public String getValorDoCabecalhoString(String campo) {
        return (String)this.getValor(TipoDeRegistro.getCabecalho(), campo);
    }

    public Date getValorDate(String registro, String campo) {
        return (Date)this.getValor(registro, campo);
    }

    public Double getValorDouble(String registro, String campo) {
        return (Double)this.getValor(registro, campo);
    }

    public Long getValorLong(String registro, String campo) {
        return (Long)this.getValor(registro, campo);
    }

    public Integer getValorInteger(String registro, String campo) {
        return (Integer)this.getValor(registro, campo);
    }

    public String getValorString(String registro, String campo) {
        return (String)this.getValor(registro, campo);
    }

    public Object getValor(String registro, String campo) {
        return this.getCampo(registro, campo).getValor();
    }

    public Object getValor(int indice, String campo) {
        return this.getCampo(indice, campo).getValor();
    }

    public List<RegistroBean> getListaDeRegistros() {
        return (List)this.getColecaoDeRegistros();
    }

    public Collection<RegistroBean> getColecaoDeRegistros() {
        List resultado = this.novoArrayList();
        Set<String> set = this.getMapaDeRegistros().keySet();
        for (String tipo : set) {
            if (!this.isRegistroTipoDetalhe(tipo)) continue;
            resultado.addAll(this.getRegistros(tipo));
        }
        return resultado;
    }

    public int getTotalDeRegistros() {
        return UtilColecao.getTamanho(this.getColecaoDeRegistros());
    }

    public String getNomeDoRegistro(int indice) {
        return this.getRegistro(indice).getNome();
    }

    public void setArquivoTXT(File arquivoTXT) {
        this.arquivoTXT = arquivoTXT;
    }

    public boolean isExisteRegistro(String registro) {
        return !this.isVazio(this.getRegistro(registro).getNome());
    }

    public Map<String, Collection<RegistroBean>> getMapaDeRegistros() {
        if (!this.isReferencia(this.mapaDeRegistros)) {
            this.mapaDeRegistros = this.novoHashMap();
        }
        return this.mapaDeRegistros;
    }

    public void carregar() throws BBException {
        String servico = this.getNomeDoServico();
        InputStream xml = this.getXML();
        ServicoBean sb = UtilParserArquivoXML.getServico(servico, xml);
        this.setMapaDeRegistros(UtilParserArquivoTXT.parser(sb, this.getArquivoTXT()));
    }

    protected CampoBean getCampo(String registro, String campo) {
        Collection<CampoBean> campos = this.getCampos(registro);
        return this.localizarCampoBean(campos, campo);
    }

    protected CampoBean getCampo(int indice, String campo) {
        List registros = (List)this.getColecaoDeRegistros();
        RegistroBean registro = (RegistroBean)registros.get(indice);
        List<CampoBean> campos = registro.getListaDeCampos();
        return this.localizarCampoBean(campos, campo);
    }

    protected IComparador novoComparadorDeCampos(Collection colecao, String campo) {
        return new IComparador(){

            public boolean isIguais(Object arg0, Object arg1) {
                String campo = (String)arg0;
                String campoBean = ((CampoBean)arg1).getNome();
                return UtilString.isStringsIguais(campoBean, campo);
            }
        };
    }

    protected Collection<CampoBean> getCampos(String registro) {
        return this.getRegistro(registro).getListaDeCampos();
    }

    protected RegistroBean getRegistro(String registro) {
        Collection<RegistroBean> registros = this.getRegistros(registro);
        return this.getElementoDaColecao(registros, 0);
    }

    protected RegistroBean getRegistro(int indice) {
        List<RegistroBean> registros = this.getListaDeRegistros();
        return this.getElementoDaColecao(registros, indice);
    }

    protected Collection<RegistroBean> getRegistros(String registro) {
        List colecao = this.getMapaDeRegistros().get(registro);
        if (!this.isReferencia(colecao)) {
            colecao = this.novoArrayList();
        }
        return colecao;
    }

    protected boolean isRegistroTipoCabecalho(String tipo) {
        return UtilString.isStringsIguais(TipoDeRegistro.getCabecalho(), tipo);
    }

    protected boolean isRegistroTipoRodape(String tipo) {
        return UtilString.isStringsIguais(TipoDeRegistro.getRodape(), tipo);
    }

    protected boolean isRegistroTipoDetalhe(String tipo) {
        return !this.isRegistroTipoCabecalho(tipo) && !this.isRegistroTipoRodape(tipo);
    }

    protected CampoBean localizarCampoBean(Collection<CampoBean> campos, String campo) {
        CampoBean bean = null;
        IComparador comparador = this.novoComparadorDeCampos(campos, campo);
        bean = (CampoBean)UtilColecao.getElemento(campos, campo, comparador);
        if (!this.isReferencia(bean)) {
            bean = this.getBeanFactory().novoCampoBean();
        }
        return bean;
    }

    protected RegistroBean getElementoDaColecao(Collection<RegistroBean> colecao, int indice) {
        RegistroBean bean = null;
        bean = (RegistroBean)UtilColecao.getElementoDoIndice(colecao, indice);
        if (!this.isReferencia(bean)) {
            bean = this.getBeanFactory().novoRegistroBean();
        }
        return bean;
    }

    protected Map novoHashMap() {
        return this.getColecaoFactory().novoHashMap();
    }

    protected List novoArrayList() {
        return this.getColecaoFactory().novoArrayList();
    }

    protected ColecaoFactory getColecaoFactory() {
        return ColecaoFactory.getInstance();
    }

    protected BeanFactory getBeanFactory() {
        return BeanFactory.getInstancia();
    }

    protected boolean isReferencia(Object objeto) {
        return UtilObjeto.isReferencia(objeto);
    }

    protected boolean isVazio(String string) {
        return UtilString.isVazio(string);
    }

    protected File getArquivoTXT() {
        return this.arquivoTXT;
    }

    protected InputStream getXML() {
        String path = this.getPathXML(this.getNomeDoServico());
        return UtilArquivo.getInputStream(path);
    }

    protected String getPathXML(String servico) {
        return this.getMapaDeArquivoXML().get(servico);
    }

    protected Map<String, String> getMapaDeArquivoXML() {
        if (!this.isReferencia(mapaDeArquivoXML)) {
            mapaDeArquivoXML = this.novoHashMap();
            mapaDeArquivoXML.put("DBT", Arquivo.getPathArquivoDBT());
        }
        return mapaDeArquivoXML;
    }

    protected String getNomeDoServico() {
        return UtilString.substring(this.getNomeDoArquivo(), 0, 3);
    }

    protected String getNomeDoArquivo() {
        return this.getArquivoTXT().getName();
    }

    protected void setMapaDeRegistros(Map<String, Collection<RegistroBean>> mapaDeRegistros) {
        this.mapaDeRegistros = mapaDeRegistros;
    }
}

