/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.util.seguranca.criptografia;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import sun.misc.BASE64Encoder;

public abstract class CryptographyGeneric {
    private MessageDigest messageDigest;
    private BASE64Encoder encoder;

    protected void useAlgorithm(String algorithm) throws NoSuchAlgorithmException {
        if (this.messageDigest == null || this.messageDigest.getAlgorithm() != algorithm) {
            this.messageDigest = MessageDigest.getInstance(algorithm);
        }
        if (this.encoder == null) {
            this.encoder = new BASE64Encoder();
        }
    }

    protected String encryptByAlgorithm(String algorithm, String value) throws NoSuchAlgorithmException {
        if (value == null) {
            throw new IllegalArgumentException("The value is null.");
        }
        this.useAlgorithm(algorithm);
        byte[] hash = this.messageDigest.digest(value.getBytes());
        return this.encoder.encode(hash);
    }
}

