/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.util.swing;

import br.com.politec.generico.objeto.UtilObjeto;
import br.com.politec.infra.util.UtilLog;
import java.awt.Toolkit;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class LimitedLengthDocument
extends PlainDocument {
    protected int maxLength = 0;
    private int tipo = -1;
    public static final int SO_CHARACTER = 0;
    public static final int SO_NUMER0 = 1;
    public static final int SO_NUMERO_E_CARACTER = 2;

    public LimitedLengthDocument(int maxLength) {
        this.maxLength = maxLength;
    }

    public LimitedLengthDocument(int maxLength, int tipo) {
        this.maxLength = maxLength;
        this.tipo = tipo;
    }

    public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
        if (UtilObjeto.isReferencia(str)) {
            int strLen = str.length();
            int len = this.getLength();
            if (this.tipo == 0) {
                str = this.permitirSoCaracter(str);
            }
            if (this.tipo == 1) {
                str = this.permitirSoNumero(str);
            }
            if (this.tipo == 2) {
                str = this.permitirAlfaNumerico(str);
            }
            if (strLen + len > this.maxLength && this.maxLength != 0) {
                Toolkit.getDefaultToolkit().beep();
                str = str.substring(0, this.maxLength - len);
            }
            super.insertString(offs, str, a);
        }
    }

    private String permitirSoCaracter(String str) {
        try {
            char[] caracter = str.trim().toCharArray();
            int i = 0;
            while (i < caracter.length) {
                if (!Character.isLetter(caracter[i])) {
                    Toolkit.getDefaultToolkit().beep();
                    str = String.valueOf(str.substring(0, i)) + str.substring(i + 1, caracter.length);
                }
                ++i;
            }
        }
        catch (RuntimeException e) {
            UtilLog.getLog().debug(e);
        }
        return str;
    }

    private String permitirSoNumero(String str) {
        try {
            char[] caracter = str.trim().toCharArray();
            int i = 0;
            while (i < caracter.length) {
                if (!Character.isDigit(caracter[i])) {
                    Toolkit.getDefaultToolkit().beep();
                    str = String.valueOf(str.substring(0, i)) + str.substring(i + 1, caracter.length);
                }
                ++i;
            }
        }
        catch (RuntimeException e) {
            UtilLog.getLog().debug(e);
        }
        return str;
    }

    private String permitirAlfaNumerico(String str) {
        try {
            char[] caracter = str.trim().toCharArray();
            int i = 0;
            while (i < caracter.length) {
                if (!this.isLetraDigitoEspaco(caracter[i])) {
                    Toolkit.getDefaultToolkit().beep();
                    str = String.valueOf(str.substring(0, i)) + str.substring(i + 1, caracter.length);
                }
                ++i;
            }
        }
        catch (RuntimeException e) {
            UtilLog.getLog().debug(e);
        }
        return str;
    }

    private boolean isLetraDigitoEspaco(char c) {
        return this.isCaracterEspecial(c) || Character.isLetterOrDigit(c) || Character.getNumericValue(c) > -1;
    }

    private boolean isCaracterEspecial(char entrada) {
        return " /\\@._,-".indexOf(entrada) > -1;
    }
}

