/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.util.swing.componente;

import br.com.politec.infra.util.UtilLog;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class BBDateDocument
extends PlainDocument {
    public static final int NUMERO_DIGITOS_MAXIMO = 10;

    public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
        String texto = this.getText(0, this.getLength());
        int i = 0;
        while (i < str.length()) {
            char c = str.charAt(i);
            if (!Character.isDigit(c)) {
                return;
            }
            ++i;
        }
        if (texto.length() < 10) {
            super.remove(0, this.getLength());
            texto = texto.replace(".", "").replace(",", "").replace("/", "");
            StringBuffer s = new StringBuffer(String.valueOf(texto) + str);
            s = this.validarData(s);
            if (s.length() > 2) {
                s.insert(2, "/");
            }
            if (s.length() > 6) {
                s.insert(5, "/");
            }
            super.insertString(0, s.toString(), a);
        }
    }

    public StringBuffer validarData(StringBuffer s) {
        if (s.length() > 1) {
            if (this.parseInt(s.substring(0, 2)) > 31) {
                s.setCharAt(0, '3');
                s.setCharAt(1, '1');
            } else if (this.parseInt(s.substring(0, 2)) == 0) {
                s.setCharAt(0, '0');
                s.setCharAt(1, '1');
            }
        }
        if (s.length() > 3) {
            int ano;
            if (this.parseInt(s.substring(2, 4)) > 12) {
                s.setCharAt(2, '1');
                s.setCharAt(3, '2');
            } else if (this.parseInt(s.substring(2, 4)) == 0) {
                s.setCharAt(2, '0');
                s.setCharAt(3, '1');
            }
            int dia = this.parseInt(s.substring(0, 2));
            int mes = this.parseInt(s.substring(2, 4));
            if (dia == 31 && !this.FazParteDe(mes, new int[]{1, 3, 5, 7, 8, 10, 12})) {
                s.setCharAt(0, '3');
                s.setCharAt(1, '0');
            }
            if (mes == 2 && dia > 29) {
                s.setCharAt(0, '2');
                s.setCharAt(1, '9');
            }
            if (s.length() == 8 && dia > 28 && mes == 2 && (ano = this.parseInt(s.substring(4, 8))) % 4 != 0) {
                s.setCharAt(0, '2');
                s.setCharAt(1, '8');
            }
        }
        return s;
    }

    private boolean FazParteDe(int mes, int[] meses) {
        int icnt = 0;
        while (icnt < meses.length) {
            if (meses[icnt] == mes) {
                return true;
            }
            ++icnt;
        }
        return false;
    }

    private int parseInt(String value) {
        int intValue = 0;
        try {
            intValue = Integer.parseInt(value);
        }
        catch (Exception ex) {
            UtilLog.getLog().debug(ex);
        }
        return intValue;
    }

    public void remove(int offset, int length) throws BadLocationException {
        super.remove(offset, length);
        String texto = this.getText(0, this.getLength());
        texto = texto.replace("/", "");
        super.remove(0, this.getLength());
        this.insertString(0, texto, null);
    }

    public void setText(String texto) {
        try {
            String textoContent = this.getText(0, this.getLength());
            if (textoContent.length() > 0) {
                this.getContent().remove(0, textoContent.length());
            }
            if (texto != null) {
                this.getContent().insertString(0, texto);
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }
}

