/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.util.swing.componente;

import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class BBDecimalDocument
extends PlainDocument {
    private int numeroMaximoDigitos = 12;
    private boolean formatar = true;

    public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
        String texto = this.getText(0, this.getLength());
        if (!this.isFormatar()) {
            super.insertString(0, str, a);
            return;
        }
        int i = 0;
        while (i < str.length()) {
            char c = str.charAt(i);
            if (!Character.isDigit(c)) {
                return;
            }
            ++i;
        }
        if (texto.length() < this.getNumeroMaximoDigitos()) {
            super.remove(0, this.getLength());
            texto = texto.replace(".", "").replace(",", "");
            StringBuffer s = new StringBuffer(String.valueOf(texto) + str);
            if (s.length() > 0 && s.charAt(0) == '0') {
                s.deleteCharAt(0);
            }
            if (s.length() < 3) {
                if (s.length() < 1) {
                    s.insert(0, "000");
                } else if (s.length() < 2) {
                    s.insert(0, "00");
                } else {
                    s.insert(0, "0");
                }
            }
            s.insert(s.length() - 2, ",");
            if (s.length() > 6) {
                s.insert(s.length() - 6, ".");
            }
            if (s.length() > 10) {
                s.insert(s.length() - 10, ".");
            }
            if (s.length() > 14) {
                s.insert(s.length() - 14, ".");
            }
            if (s.length() > 18) {
                s.insert(s.length() - 18, ".");
            }
            super.insertString(0, s.toString(), a);
        }
    }

    private int getNumeroMaximoDigitos() {
        return this.numeroMaximoDigitos;
    }

    public void setNumeroMaximoDigitos(int numeroMaximoDigitos) {
        this.numeroMaximoDigitos = numeroMaximoDigitos;
    }

    public void remove(int offset, int length) throws BadLocationException {
        super.remove(offset, length);
        String texto = this.getText(0, this.getLength());
        texto = texto.replace(",", "");
        texto = texto.replace(".", "");
        super.remove(0, this.getLength());
        this.insertString(0, texto, null);
    }

    public boolean isFormatar() {
        return this.formatar;
    }

    public void setFormatar(boolean formatar) {
        this.formatar = formatar;
    }
}

