/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.util.swing.componente;

import br.com.bb.plugins.gac.excecao.BBException;
import br.com.bb.plugins.gac.util.ConfiguracaoProperties;
import br.com.bb.plugins.gac.util.Util;
import br.com.bb.plugins.gac.util.net.proxy.BBGACProxy;
import br.com.bb.plugins.gac.util.seguranca.AutenticadorBBGAC;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;

public class BBFileDownLoad {
    private String protocol = "http";
    private String url = "";
    private String file = "";
    private String path = "";
    private ActionListener listener;
    private Boolean cancelar = false;
    private long filelength = 0L;

    public BBFileDownLoad() {
    }

    public BBFileDownLoad(String file, long filelength) {
        this.file = file;
        this.filelength = filelength;
        this.url = ConfiguracaoProperties.getConfiguracaoProperties().getURLAtualizarSistema();
        if (this.url == null || this.url.trim().length() == 0) {
            this.url = "BSB015888:8080/bb/aplicativos";
        }
    }

    public BBFileDownLoad(String url, String path, String file, long filelength) {
        this.file = file;
        this.filelength = filelength;
        this.url = url;
        this.path = path;
    }

    public void doDownLoad() {
        block27: {
            HttpURLConnection httpUrlAtualizacao = null;
            InputStream is = null;
            BufferedInputStream bis = null;
            FileOutputStream fos = null;
            long totalLido = 0L;
            String s_arquivo = this.url;
            if (!s_arquivo.startsWith(String.valueOf(this.protocol) + "://")) {
                s_arquivo = String.valueOf(this.protocol) + "://" + s_arquivo;
            }
            if (!s_arquivo.endsWith("/")) {
                s_arquivo = String.valueOf(s_arquivo) + "/";
            }
            s_arquivo = String.valueOf(s_arquivo) + this.file;
            this.verificaSeUtilizaConexaoProxy(s_arquivo);
            URL urlDaAtualizacao = new URL(String.valueOf(s_arquivo) + "?timeInMillis=" + Util.getTimeInMillis());
            httpUrlAtualizacao = (HttpURLConnection)urlDaAtualizacao.openConnection();
            httpUrlAtualizacao.setInstanceFollowRedirects(false);
            try {
                Object object = httpUrlAtualizacao.getContent();
            }
            catch (RuntimeException ex) {
                System.out.println("Erro ao conectar em: " + s_arquivo);
                this.fireAction("ERRO:" + ex.getMessage());
                ex.printStackTrace();
                try {
                    this.finalizaStream(is, bis, fos);
                }
                catch (IOException iox) {
                    iox.printStackTrace();
                }
                return;
            }
            try {
                int lidos;
                File arquivoRecebido = new File(String.valueOf(this.getPath()) + "/" + this.file);
                is = urlDaAtualizacao.openStream();
                bis = new BufferedInputStream(is);
                fos = new FileOutputStream(arquivoRecebido);
                byte[] b1 = new byte[512];
                while ((lidos = bis.read(b1)) > 0) {
                    fos.write(b1, 0, lidos);
                    this.fireAction("POSICAO:" + (totalLido += (long)lidos));
                    if (!this.cancelar.booleanValue()) continue;
                }
                bis.close();
                fos.close();
                is.close();
                if (this.cancelar.booleanValue()) {
                    this.fireAction("CANCELADO" + totalLido);
                } else if (this.getFilelength() != 0L && (totalLido < this.getFilelength() || totalLido > this.getFilelength())) {
                    this.fireAction("INCOMPLETO:" + totalLido);
                } else {
                    this.fireAction("CONCLUIDO:" + totalLido);
                }
            }
            catch (IOException ioe) {
                AutenticadorBBGAC.limpaDados();
                this.fireAction("ERRO:" + ioe.getMessage());
                try {
                    this.finalizaStream(is, bis, fos);
                }
                catch (IOException iox) {
                    iox.printStackTrace();
                }
                break block27;
            }
            catch (BBException bbex) {
                try {
                    AutenticadorBBGAC.limpaDados();
                    this.fireAction("ERRO:" + bbex.getKey() + ":" + bbex.getMessage());
                    break block27;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    try {
                        this.finalizaStream(is, bis, fos);
                    }
                    catch (IOException iox) {
                        iox.printStackTrace();
                    }
                }
            }
            try {
                this.finalizaStream(is, bis, fos);
            }
            catch (IOException iox) {
                iox.printStackTrace();
            }
        }
    }

    private void finalizaStream(InputStream is, BufferedInputStream bis, FileOutputStream fos) throws IOException {
        if (bis != null) {
            bis.close();
        }
        if (fos != null) {
            fos.close();
        }
        if (is != null) {
            is.close();
        }
    }

    private void verificaSeUtilizaConexaoProxy(String sArquivo) throws BBException {
        BBGACProxy bbgacProxy = new BBGACProxy();
        bbgacProxy.conecta(sArquivo);
    }

    public static void main(String[] args) {
        BBFileDownLoad down = new BBFileDownLoad("abc.jar", 3659L);
        down.setPath("c:/Projetos");
        down.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                System.out.println(e.getActionCommand());
            }
        });
        down.doDownLoad();
    }

    public void fireAction(String command) {
        ActionEvent evt = new ActionEvent(this, 2008, command);
        this.fireAction(evt);
    }

    public void fireAction(ActionEvent event) {
        if (this.listener != null) {
            this.listener.actionPerformed(event);
        }
    }

    public void addActionListener(ActionListener listener) {
        this.listener = listener;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getFile() {
        return this.file;
    }

    public void setFile(String file) {
        this.file = file;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public long getFilelength() {
        return this.filelength;
    }

    public void setFilelength(long filelength) {
        this.filelength = filelength;
    }

    public void setCancelar(boolean cancelar) {
        this.cancelar = cancelar;
    }
}

