/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.util.swing.componente;

import br.com.bb.plugins.gac.util.swing.componente.BBJCheckBox;
import br.com.bb.plugins.gac.util.swing.componente.BBJEstilos;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BBJCheckBoxLabel
extends JPanel {
    private String titulo;
    private int posicaoLabel = 0;
    private int larguralabel;
    private int quantidadeColuna = 0;
    private JLabel jlTitulo;
    private Map<String, BBJCheckBox> opcoesCheck;
    public static final int POSICAO_TITULO_LATERAL = 0;
    public static final int POSICAO_TITULO_SUPERIOR = 1;
    private BBJEstilos estilotexto;
    private BBJEstilos estilolabel;

    public int getLarguralabel() {
        return this.larguralabel;
    }

    public void setLarguralabel(int larguralabel) {
        this.larguralabel = larguralabel;
    }

    public BBJCheckBoxLabel(String titulo, int posicaoLabel, Map<String, BBJCheckBox> opcoesCheck) {
        this.titulo = titulo;
        this.posicaoLabel = posicaoLabel;
        this.opcoesCheck = opcoesCheck;
        this.initialize();
    }

    public BBJCheckBoxLabel(String titulo, int posicaoLabel, Map<String, BBJCheckBox> opcoesCheck, int larguralabel) {
        this.titulo = titulo;
        this.posicaoLabel = posicaoLabel;
        this.opcoesCheck = opcoesCheck;
        this.larguralabel = larguralabel;
        this.initialize();
    }

    public BBJCheckBoxLabel(String titulo, int posicaoLabel, Map<String, BBJCheckBox> opcoesCheck, int larguralabel, int quantidadeColuna) {
        this.titulo = titulo;
        this.posicaoLabel = posicaoLabel;
        this.opcoesCheck = opcoesCheck;
        this.larguralabel = larguralabel;
        this.quantidadeColuna = quantidadeColuna;
        this.initialize();
    }

    private void initialize() {
        this.estilotexto = BBJEstilos.TEXTOEDITAVEL;
        this.estilolabel = BBJEstilos.LABELTEXTO;
        this.setOpaque(false);
        this.jlTitulo = new JLabel(this.titulo);
        this.setLayout(new BoxLayout(this, this.posicaoLabel == 0 ? 0 : 1));
        JLabel jlTitulo = new JLabel(" ");
        jlTitulo.setFont(this.estilolabel.getFont());
        jlTitulo.setForeground(this.estilolabel.getColor());
        if (this.posicaoLabel == 0) {
            jlTitulo.setText(this.titulo);
        }
        this.add(jlTitulo);
        if (this.larguralabel > 0) {
            FontRenderContext frc = new FontRenderContext(null, true, false);
            Rectangle2D bounds = jlTitulo.getFont().getStringBounds(this.titulo, frc);
            if ((double)this.larguralabel - bounds.getWidth() > 0.0) {
                this.add(Box.createRigidArea(new Dimension((int)((double)this.larguralabel - bounds.getWidth()), 10)));
            }
        }
        this.add(this.loadCheck());
    }

    private int GetQtdLinhas() {
        if (this.quantidadeColuna <= 0) {
            this.quantidadeColuna = this.opcoesCheck.size();
            return 1;
        }
        return this.opcoesCheck.size() / this.quantidadeColuna + (this.opcoesCheck.size() % this.quantidadeColuna > 0 ? 1 : 0);
    }

    public JPanel loadCheck() {
        JPanel panelRadios = new JPanel();
        panelRadios.setOpaque(false);
        Iterator<BBJCheckBox> itr = this.opcoesCheck.values().iterator();
        if (this.quantidadeColuna > 0) {
            panelRadios.setLayout(new GridLayout(this.GetQtdLinhas(), this.quantidadeColuna));
        } else {
            panelRadios.setLayout(new BoxLayout(panelRadios, 0));
        }
        while (itr.hasNext()) {
            BBJCheckBox checkBox = itr.next();
            checkBox.setOpaque(false);
            checkBox.setFont(this.estilotexto.getFont());
            panelRadios.add(checkBox);
            if (this.quantidadeColuna != 0) continue;
            panelRadios.add(Box.createRigidArea(new Dimension(15, 0)));
        }
        return panelRadios;
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (this.posicaoLabel == 1) {
            g.setFont(this.estilolabel.getFont());
            g.setColor(this.estilolabel.getColor());
            g.drawString(this.titulo, 2, 10);
        }
    }

    public Collection<BBJCheckBox> getSelectedObjects() {
        Collection<BBJCheckBox> enubt = this.opcoesCheck.values();
        Iterator<BBJCheckBox> itr = enubt.iterator();
        HashSet<BBJCheckBox> hs = new HashSet<BBJCheckBox>();
        while (itr.hasNext()) {
            BBJCheckBox jcheck = itr.next();
            jcheck.setFont(this.estilotexto.getFont());
            if (!jcheck.isSelected()) continue;
            hs.add(jcheck);
        }
        return hs;
    }

    public int getPosicaoLabel() {
        return this.posicaoLabel;
    }

    public void setPosicaoLabel(int posicaoLabel) {
        this.posicaoLabel = posicaoLabel;
    }

    public String getTitulo() {
        return this.titulo;
    }

    public void setTitulo(String titulo) {
        this.titulo = titulo;
    }

    public Map<String, BBJCheckBox> getOpcoesCheck() {
        return this.opcoesCheck;
    }

    public void setOpcoesCheck(Map<String, BBJCheckBox> opcoesCheck) {
        this.opcoesCheck = opcoesCheck;
    }

    public JLabel getJlTitulo() {
        return this.jlTitulo;
    }

    public void setJlTitulo(JLabel jlTitulo) {
        this.jlTitulo = jlTitulo;
    }
}

