/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.util.swing.componente;

import br.com.bb.plugins.gac.util.swing.componente.BBJCalendar;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSpinner;
import javax.swing.SpinnerDateModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class BBJDateChooser
extends JPanel
implements ActionListener,
PropertyChangeListener,
ChangeListener {
    protected JButton calendarButton;
    protected JSpinner dateSpinner;
    protected JSpinner.DateEditor editor;
    protected BBJCalendar jcalendar;
    protected JPopupMenu popup;
    protected SpinnerDateModel model;
    protected String dateFormatString;
    protected boolean dateSelected;
    protected boolean isInitialized;
    protected Date lastSelectedDate;
    protected boolean startEmpty;

    public BBJDateChooser() {
        this(null, null, false, null);
    }

    public void setEnabled(boolean b) {
        this.editor.setEnabled(b);
        this.dateSpinner.setEnabled(b);
        this.calendarButton.setEnabled(b);
    }

    public BBJDateChooser(ImageIcon icon) {
        this(null, null, false, icon);
    }

    public BBJDateChooser(boolean startEmpty) {
        this(null, null, startEmpty, null);
    }

    public BBJDateChooser(String dateFormatString, boolean startEmpty) {
        this(null, dateFormatString, startEmpty, null);
    }

    public BBJDateChooser(BBJCalendar jcalendar) {
        this(jcalendar, null, false, null);
    }

    public BBJDateChooser(BBJCalendar jcalendar, String dateFormatString, boolean startEmpty, ImageIcon icon) {
        URL iconURL;
        if (jcalendar == null) {
            jcalendar = new BBJCalendar();
        }
        this.jcalendar = jcalendar;
        if (dateFormatString == null) {
            dateFormatString = "dd/MM/yyyy";
        }
        this.dateFormatString = dateFormatString;
        this.startEmpty = startEmpty;
        this.setLayout(new BorderLayout());
        jcalendar.getDayChooser().addPropertyChangeListener(this);
        jcalendar.getDayChooser().setAlwaysFireDayProperty(true);
        jcalendar.setWeekOfYearVisible(false);
        this.model = new SpinnerDateModel();
        this.model.removeChangeListener(this);
        this.setModel(this.model);
        this.dateSpinner = new JSpinner(this.model){

            public void setEnabled(boolean enabled) {
                super.setEnabled(enabled);
                BBJDateChooser.this.calendarButton.setEnabled(enabled);
            }
        };
        String tempDateFortmatString = "";
        if (!startEmpty) {
            tempDateFortmatString = dateFormatString;
        }
        this.editor = new JSpinner.DateEditor(this.dateSpinner, tempDateFortmatString);
        this.editor.setFont(new Font("Dialog", 0, 12));
        this.dateSpinner.setEditor(this.editor);
        this.add((Component)this.dateSpinner, "Center");
        if (icon == null && (iconURL = this.getClass().getResource("/images/ico_calendario.gif")) != null) {
            icon = new ImageIcon(iconURL);
        }
        this.calendarButton = new JButton(icon);
        this.calendarButton.setBackground(Color.WHITE);
        this.calendarButton.setMargin(new Insets(0, 0, 0, 0));
        this.calendarButton.addActionListener(this);
        this.calendarButton.setFocusable(false);
        this.calendarButton.setRolloverEnabled(false);
        this.calendarButton.setCursor(Cursor.getPredefinedCursor(12));
        this.calendarButton.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        this.calendarButton.setMnemonic(67);
        this.add((Component)this.calendarButton, "East");
        this.calendarButton.setMargin(new Insets(0, 0, 0, 0));
        this.popup = new JPopupMenu(){

            public void setVisible(boolean b) {
                Boolean isCanceled = (Boolean)this.getClientProperty("JPopupMenu.firePopupMenuCanceled");
                if (b || !b && BBJDateChooser.this.dateSelected || isCanceled != null && !b && isCanceled.booleanValue()) {
                    super.setVisible(b);
                }
            }
        };
        this.popup.setLightWeightPopupEnabled(true);
        this.popup.add(jcalendar);
        this.lastSelectedDate = this.model.getDate();
        this.isInitialized = true;
        ((JSpinner.DateEditor)this.dateSpinner.getEditor()).getTextField().setFont(new Font("Dialog", 0, 12));
    }

    public void limpar() {
        ((JSpinner.DateEditor)this.dateSpinner.getEditor()).getTextField().setText("");
    }

    public void actionPerformed(ActionEvent e) {
        int x = this.calendarButton.getWidth() - (int)this.popup.getPreferredSize().getWidth();
        int y = this.calendarButton.getY() + this.calendarButton.getHeight();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(this.model.getDate());
        this.jcalendar.setCalendar(calendar);
        this.popup.show(this.calendarButton, x, y);
        this.dateSelected = false;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("day")) {
            this.dateSelected = true;
            this.popup.setVisible(false);
            this.setDate(this.jcalendar.getCalendar().getTime());
            this.setDateFormatString(this.dateFormatString);
        } else if (evt.getPropertyName().equals("date")) {
            this.setDate((Date)evt.getNewValue());
        }
    }

    public void updateUI() {
        super.updateUI();
        if (this.jcalendar != null) {
            SwingUtilities.updateComponentTreeUI(this.popup);
        }
    }

    public void setLocale(Locale l) {
        this.dateSpinner.setLocale(l);
        this.editor = new JSpinner.DateEditor(this.dateSpinner, this.dateFormatString);
        this.dateSpinner.setEditor(this.editor);
        this.jcalendar.setLocale(l);
    }

    public String getDateFormatString() {
        return this.dateFormatString;
    }

    public void setDateFormatString(String dateFormatString) {
        this.dateFormatString = dateFormatString;
        this.editor.getFormat().applyPattern(dateFormatString);
        this.invalidate();
    }

    public String getName() {
        return "JDateChooser";
    }

    public Date getDate() {
        String strDate = ((JSpinner.DateEditor)this.dateSpinner.getEditor()).getTextField().getText();
        if (strDate.trim().equals("")) {
            return null;
        }
        return this.model.getDate();
    }

    public void setDate(Date date) {
        if (date == null) {
            return;
        }
        this.model.setValue(date);
    }

    public void stateChanged(ChangeEvent e) {
        if (this.isInitialized) {
            this.firePropertyChange("date", this.lastSelectedDate, this.model.getDate());
            this.lastSelectedDate = this.model.getDate();
        }
    }

    public JSpinner getSpinner() {
        return this.dateSpinner;
    }

    public SpinnerDateModel getModel() {
        return this.model;
    }

    public void setModel(SpinnerDateModel mdl) {
        this.model = mdl;
        this.model.setCalendarField(4);
        this.model.addChangeListener(this);
        if (this.dateSpinner != null) {
            this.dateSpinner.setModel(this.model);
        }
    }
}

