/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.util.swing.componente;

import br.com.bb.plugins.gac.apresentacao.BasicDialog;
import br.com.bb.plugins.gac.excecao.BBException;
import br.com.bb.plugins.gac.factory.FabricaDeControladorDeAcesso;
import br.com.bb.plugins.gac.util.AbreBrowser;
import br.com.bb.plugins.gac.util.Ajuda;
import br.com.bb.plugins.gac.util.controller.view.ViewController;
import br.com.bb.plugins.gac.util.view.BBJPanelBotoesManut;
import br.com.politec.generico.arquivo.UtilArquivo;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class BBJDialogHelp
extends BasicDialog {
    private PanelHelpInterno panelMain = null;
    private Frame owner;
    private static BBJDialogHelp popuphelp;
    private Properties propriedade;
    private JEditorPane htmlPane = null;
    private JScrollPane scrollPane = null;
    private BBJPanelBotoesManut panelBotoes = null;
    private static final int DISTANCIA_BOTAO = 32;

    public BBJDialogHelp(Frame owner) throws HeadlessException {
        super(owner);
        this.setModal(true);
        this.owner = owner;
        this.initComponents();
    }

    public BBJDialogHelp() {
        this.initComponents();
    }

    public static BBJDialogHelp getInstance() {
        if (popuphelp == null) {
            popuphelp = (BBJDialogHelp)ViewController.getInstance().goToView("GACPOPUPHELP", null);
        }
        return popuphelp;
    }

    private void initComponents() {
        this.setUndecorated(true);
        this.setContentPane(this.getPanelMain());
        this.configurarPosicao();
        this.setResizable(true);
        this.setDefaultCloseOperation(1);
    }

    private void configurarPosicao() {
        this.setPreferredSize(new Dimension(400, 300));
        this.setBounds(this.getPosicaoHorizontal(), this.getPosicaoVertical(), 400, 300);
    }

    public PanelHelpInterno getPanelMain() {
        if (this.panelMain == null) {
            this.panelMain = new PanelHelpInterno();
            this.panelMain.setBackground(Color.WHITE);
        }
        return this.panelMain;
    }

    public static void main(String[] args) {
        BBJDialogHelp popup = new BBJDialogHelp();
        popup.pack();
        popup.setBounds(250, 225, 400, 300);
        popup.Show();
    }

    public Frame getOwner() {
        return this.owner;
    }

    private int getPosicaoHorizontal() {
        int larguraTela = this.getOwner().getWidth();
        int posicaoHorizontal = (int)this.getOwner().getLocationOnScreen().getX();
        return (int)((double)posicaoHorizontal + ((double)(larguraTela - 32) - this.getPreferredSize().getWidth()));
    }

    private int getPosicaoVertical() {
        return (int)(this.getOwner().getLocationOnScreen().getY() + 235.0);
    }

    private int getAcao() {
        int acao = -1;
        try {
            if (ViewController.getInstance().getContext() != null && ViewController.getInstance().getContext().get("ACAO") != null) {
                acao = (Integer)ViewController.getInstance().getContext().get("ACAO");
            }
        }
        catch (Throwable t) {
            System.out.println(t.getMessage());
        }
        return acao;
    }

    private String getAncora() {
        String ancora = "";
        try {
            if (ViewController.getInstance().getContext() != null && ViewController.getInstance().getContext().get("pagina") != null) {
                ancora = "#" + ViewController.getInstance().getContext().get("pagina");
            }
        }
        catch (Throwable t) {
            System.out.println(t.getMessage());
        }
        return ancora;
    }

    private URL getURL() {
        String nomePropAjuda = ViewController.getInstance().getViewName().trim();
        String nomeAcao = this.montaNomeAcao();
        String nomePropriedade = String.valueOf(nomePropAjuda) + nomeAcao;
        System.out.println(nomePropriedade);
        String nomeArquivoAjuda = this.getPropriedade().getProperty(nomePropriedade);
        String servico = FabricaDeControladorDeAcesso.getInstancia().novoPluginControladorDeAcesso().getServico().toLowerCase();
        StringBuilder sbAjudaZIP = this.montaAjudaServicoZip(servico);
        return this.montaURL(nomeArquivoAjuda, servico, sbAjudaZIP);
    }

    private String montaNomeAcao() {
        String nomeAcao = "";
        int tipoAcao = this.getAcao();
        if (tipoAcao == 1) {
            nomeAcao = "INCLUIR";
        } else if (tipoAcao == 2) {
            nomeAcao = "EDITAR";
        } else if (tipoAcao == 3) {
            nomeAcao = "EXCLUIR";
        }
        return nomeAcao;
    }

    private StringBuilder montaAjudaServicoZip(String servico) {
        StringBuilder sbAjudaZIP = new StringBuilder("");
        sbAjudaZIP.append("ajuda");
        sbAjudaZIP.append(servico.toLowerCase());
        sbAjudaZIP.append(".zip");
        return sbAjudaZIP;
    }

    private URL montaURL(String nomeArquivoAjuda, String servico, StringBuilder sbAjudaZIP) {
        URL url = null;
        if (nomeArquivoAjuda != null) {
            try {
                String caminho = Ajuda.procuraURL(sbAjudaZIP.toString(), nomeArquivoAjuda.trim(), servico);
                String URLSend = AbreBrowser.urlCaracteresInvalidos("file:///" + caminho);
                url = new URL(URLSend);
            }
            catch (BBException e) {
                e.printStackTrace();
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
            return url;
        }
        return null;
    }

    private JScrollPane getPainelAjudaPane() {
        try {
            this.getHtmlPane().setEditable(false);
            URL url = this.getURL();
            if (url != null) {
                this.getHtmlPane().setPage(this.getURL());
                this.getScrollPane().setVisible(true);
            } else {
                this.getScrollPane().setVisible(false);
            }
            this.getScrollPane().setViewportView(this.getHtmlPane());
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return this.getScrollPane();
    }

    public void Show() {
        this.configurarPropriedades();
        this.configurarPosicao();
        this.getPanelMain().getPanelConteudo().removeAll();
        this.getPanelMain().getPanelConteudo().add(this.getPainelAjudaPane());
        this.getPanelMain().repaint();
        this.setVisible(true);
    }

    public void Show(String servico) {
        this.configurarPropriedades(servico);
        this.configurarPosicao();
        this.getPanelMain().getPanelConteudo().removeAll();
        this.getPanelMain().getPanelConteudo().add(this.getPainelAjudaPane());
        this.getPanelMain().repaint();
        this.setVisible(true);
    }

    private void configurarPropriedades() {
        this.configurarPropriedades(FabricaDeControladorDeAcesso.getInstancia().novoPluginControladorDeAcesso().getServico());
    }

    private void configurarPropriedades(String servico) {
        if (servico != null) {
            String arquivo = null;
            StringBuilder sb = new StringBuilder();
            sb.append("BB");
            sb.append(Ajuda.obtenhaPLuginEmbutidoOuNomeModulo(servico).toUpperCase());
            sb.append("-Ajuda.properties");
            arquivo = sb.toString();
            this.setPropriedade(UtilArquivo.getProperties(arquivo));
        }
    }

    public void doClose() {
        this.setVisible(false);
    }

    public void beforeShow(Map context) {
    }

    public void doShow(Map context) {
    }

    public String getTitulo() {
        return null;
    }

    public Properties getPropriedade() {
        if (this.propriedade == null) {
            this.configurarPropriedades();
        }
        return this.propriedade;
    }

    public void setPropriedade(Properties propriedade) {
        this.propriedade = propriedade;
    }

    public JEditorPane getHtmlPane() {
        if (this.htmlPane == null) {
            this.htmlPane = new JEditorPane();
            this.htmlPane.addMouseListener(new MouseListener(){

                public void mouseClicked(MouseEvent e) {
                    BBJDialogHelp.this.doClose();
                }

                public void mouseEntered(MouseEvent e) {
                }

                public void mouseExited(MouseEvent e) {
                }

                public void mousePressed(MouseEvent e) {
                }

                public void mouseReleased(MouseEvent e) {
                }
            });
        }
        return this.htmlPane;
    }

    public void setHtmlPane(JEditorPane htmlPane) {
        this.htmlPane = htmlPane;
    }

    public JScrollPane getScrollPane() {
        if (this.scrollPane == null) {
            this.scrollPane = new JScrollPane();
            this.scrollPane.setVerticalScrollBarPolicy(20);
            this.scrollPane.setHorizontalScrollBarPolicy(30);
            this.scrollPane.getViewport().setOpaque(false);
        }
        return this.scrollPane;
    }

    public void setScrollPane(JScrollPane scrollPane) {
        this.scrollPane = scrollPane;
    }

    public boolean fechada() {
        return false;
    }

    private class PanelHelpInterno
    extends JPanel {
        private int alturasombra = 12;
        private int iniciobordasuperior = 20;
        private int margemseta = 50;
        private int larguraborda = 8;
        private JPanel panelSuperior = null;
        private JPanel panelConteudo = null;
        private JPanel panelEsquerda = null;
        private JPanel panelDireita = null;
        private JPanel panelFundo = null;

        public PanelHelpInterno() {
            this.setLayout(new BorderLayout());
            this.add((Component)this.getPanelSuperior(), "North");
            this.add((Component)this.getPanelConteudo(), "Center");
            this.add((Component)this.getPanelEsquerda(), "West");
            this.add((Component)this.getPanelDireita(), "East");
            this.setBorder(BorderFactory.createEmptyBorder());
            this.add((Component)this.getPanelBotoes(), "South");
        }

        public BBJPanelBotoesManut getPanelBotoes() {
            if (BBJDialogHelp.this.panelBotoes == null) {
                BBJDialogHelp.this.panelBotoes = new BBJPanelBotoesManut(new String[]{"FECHAR"}, 1, false);
                BBJDialogHelp.this.panelBotoes.setAdicionarbotaovoltar(false);
                BBJDialogHelp.this.panelBotoes.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        BBJDialogHelp.this.doClose();
                    }
                });
            }
            return BBJDialogHelp.this.panelBotoes;
        }

        public JPanel getPanelConteudo() {
            if (this.panelConteudo == null) {
                this.panelConteudo = new JPanel();
                this.panelConteudo.setBackground(new Color(247, 247, 247));
                this.panelConteudo.setLayout(new GridLayout());
            }
            return this.panelConteudo;
        }

        public JPanel getPanelSuperior() {
            if (this.panelSuperior == null) {
                this.panelSuperior = new JPanel();
                this.panelSuperior.setOpaque(false);
                this.panelSuperior.setPreferredSize(new Dimension(0, 30));
            }
            return this.panelSuperior;
        }

        public JPanel getPanelDireita() {
            if (this.panelDireita == null) {
                this.panelDireita = new JPanel();
                this.panelDireita.setOpaque(false);
                this.panelDireita.setPreferredSize(new Dimension(8, 0));
            }
            return this.panelDireita;
        }

        public JPanel getPanelEsquerda() {
            if (this.panelEsquerda == null) {
                this.panelEsquerda = new JPanel();
                this.panelEsquerda.setOpaque(false);
                this.panelEsquerda.setPreferredSize(new Dimension(8, 0));
            }
            return this.panelEsquerda;
        }

        public JPanel getPanelFundo() {
            if (this.panelFundo == null) {
                this.panelFundo = new JPanel();
                this.panelFundo.setOpaque(false);
                this.panelFundo.setPreferredSize(new Dimension(0, 20));
            }
            return this.panelFundo;
        }

        public void paint(Graphics graphics) {
            super.paint(graphics);
            graphics.setColor(new Color(228, 228, 228));
            graphics.fillRect(this.larguraborda, this.iniciobordasuperior, (int)this.getSize().getWidth() - (this.margemseta + this.larguraborda), 2);
            graphics.fillRect((int)this.getSize().getWidth() - (this.margemseta - 20), this.iniciobordasuperior, 22, 2);
            graphics.drawLine((int)this.getSize().getWidth() - (this.margemseta - 35), 2, (int)this.getSize().getWidth() - this.margemseta, this.iniciobordasuperior);
            graphics.drawLine((int)this.getSize().getWidth() - (this.margemseta - 36), 3, (int)this.getSize().getWidth() - (this.margemseta - 1), this.iniciobordasuperior);
            graphics.drawLine((int)this.getSize().getWidth() - (this.margemseta - 35), 2, (int)this.getSize().getWidth() - (this.margemseta - 20), this.iniciobordasuperior);
            graphics.drawLine((int)this.getSize().getWidth() - (this.margemseta - 35), 3, (int)this.getSize().getWidth() - (this.margemseta - 21), this.iniciobordasuperior);
            graphics.fillRect(0, this.iniciobordasuperior + this.larguraborda, 2, (int)(this.getSize().getHeight() - (double)(this.alturasombra + this.iniciobordasuperior + this.larguraborda * 2)));
            graphics.fillRect((int)this.getSize().getWidth() - 2, this.iniciobordasuperior + this.larguraborda, 2, (int)(this.getSize().getHeight() - (double)(this.alturasombra + this.iniciobordasuperior + this.larguraborda * 2) + 1.0));
            graphics.fillRect(this.larguraborda, (int)(this.getSize().getHeight() - (double)this.alturasombra), (int)this.getSize().getWidth() - this.larguraborda * 2, 2);
            graphics.drawArc(0, this.iniciobordasuperior, this.larguraborda * 2, this.larguraborda * 2, 90, 90);
            graphics.drawArc(1, this.iniciobordasuperior + 1, this.larguraborda * 2, this.larguraborda * 2, 90, 90);
            graphics.drawArc(0, (int)(this.getSize().getHeight() - (double)(this.alturasombra + this.larguraborda * 2)), this.larguraborda * 2, this.larguraborda * 2, -90, -90);
            graphics.drawArc(1, (int)(this.getSize().getHeight() - (double)(this.alturasombra + this.larguraborda * 2) + 1.0), this.larguraborda * 2, this.larguraborda * 2, -90, -90);
            graphics.drawArc((int)this.getSize().getWidth() - (this.larguraborda * 2 + 2), (int)(this.getSize().getHeight() - (double)(this.alturasombra + this.larguraborda * 2)), this.larguraborda * 2, this.larguraborda * 2, -90, 90);
            graphics.drawArc((int)this.getSize().getWidth() - (this.larguraborda * 2 + 1), (int)(this.getSize().getHeight() - (double)(this.alturasombra + this.larguraborda * 2)), this.larguraborda * 2, this.larguraborda * 2, -90, 90);
            graphics.drawArc((int)this.getSize().getWidth() - this.larguraborda * 2 - 2, this.iniciobordasuperior + 1, this.larguraborda * 2, this.larguraborda * 2, 90, -90);
            graphics.drawArc((int)this.getSize().getWidth() - this.larguraborda * 2 - 3, this.iniciobordasuperior + 1, this.larguraborda * 2, this.larguraborda * 2, 90, -90);
        }
    }
}

