/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.util.swing.componente;

import br.com.bb.plugins.gac.util.swing.componente.BBJMask;
import br.com.politec.infra.util.UtilLog;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.InvalidObjectException;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class BBJInscricaoRadioText
extends JPanel
implements ActionListener {
    private JPanel pnlRadios = null;
    private JRadioButton rdoCpf = null;
    private JRadioButton rdoCNPJ = null;
    private JRadioButton rdoOutros = null;
    private JPanel pnlInscricao = null;
    public BBJMask txtInscricao = null;
    private ButtonGroup buttonGroup = null;

    public BBJInscricaoRadioText() {
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.getPnlRadios(), "West");
        this.add((Component)this.getPnlInscricao(), "Center");
        this.setBorder(BorderFactory.createTitledBorder(null, "Inscri\u00e7\u00e3o", 0, 0, new Font("Tahoma", 0, 11), new Color(0, 70, 213)));
        Dimension dimensao = new Dimension(337, 49);
        this.setSize(337, 49);
        this.setMinimumSize(dimensao);
        this.setPreferredSize(dimensao);
        this.getRdoCNPJ().setSelected(true);
        String mask = "##.###.###/####-##";
        this.formataMask(mask);
    }

    private void formataMask(String mask) {
        this.getTxtInscricao().setMask(mask);
        this.getTxtInscricao().validate();
        this.getTxtInscricao().repaint();
        this.getTxtInscricao().requestFocus();
    }

    private JPanel getPnlRadios() {
        if (this.pnlRadios == null) {
            this.pnlRadios = new JPanel();
            GridBagConstraints consGridBagConstraints3 = new GridBagConstraints();
            GridBagConstraints consGridBagConstraints2 = new GridBagConstraints();
            GridBagConstraints consGridBagConstraints4 = new GridBagConstraints();
            consGridBagConstraints4.insets = new Insets(0, 0, 0, 0);
            consGridBagConstraints4.gridy = 0;
            consGridBagConstraints4.gridx = 2;
            consGridBagConstraints4.anchor = 18;
            consGridBagConstraints3.insets = new Insets(0, 0, 0, 0);
            consGridBagConstraints3.gridy = 0;
            consGridBagConstraints3.gridx = 0;
            consGridBagConstraints3.anchor = 18;
            consGridBagConstraints2.insets = new Insets(0, 0, 0, 0);
            consGridBagConstraints2.gridy = 0;
            consGridBagConstraints2.gridx = 1;
            consGridBagConstraints2.anchor = 18;
            this.pnlRadios.setLayout(new GridBagLayout());
            this.pnlRadios.add((Component)this.getRdoCpf(), consGridBagConstraints2);
            this.pnlRadios.add((Component)this.getRdoCNPJ(), consGridBagConstraints3);
            this.pnlRadios.add((Component)this.getRdoOutros(), consGridBagConstraints4);
            this.getButtonGroup();
        }
        return this.pnlRadios;
    }

    public JRadioButton getRdoCpf() {
        if (this.rdoCpf == null) {
            this.rdoCpf = new JRadioButton();
            this.rdoCpf.setText("CPF");
            this.rdoCpf.setFont(new Font("Dialog", 0, 12));
            this.rdoCpf.addActionListener(this);
        }
        return this.rdoCpf;
    }

    public JRadioButton getRdoCNPJ() {
        if (this.rdoCNPJ == null) {
            this.rdoCNPJ = new JRadioButton();
            this.rdoCNPJ.setText("CNPJ");
            this.rdoCNPJ.setFont(new Font("Dialog", 0, 12));
            this.rdoCNPJ.addActionListener(this);
        }
        return this.rdoCNPJ;
    }

    public JRadioButton getRdoOutros() {
        if (this.rdoOutros == null) {
            this.rdoOutros = new JRadioButton();
            this.rdoOutros.setText("Outro");
            this.rdoOutros.setFont(new Font("Dialog", 0, 12));
            this.rdoOutros.addActionListener(this);
        }
        return this.rdoOutros;
    }

    private JPanel getPnlInscricao() {
        if (this.pnlInscricao == null) {
            this.pnlInscricao = new JPanel();
            GridBagConstraints consGridBagConstraints1 = new GridBagConstraints();
            consGridBagConstraints1.insets = new Insets(0, 0, 0, 0);
            consGridBagConstraints1.fill = 2;
            consGridBagConstraints1.weightx = 1.0;
            consGridBagConstraints1.gridy = 0;
            consGridBagConstraints1.gridx = 0;
            consGridBagConstraints1.anchor = 18;
            this.pnlInscricao.setLayout(new GridBagLayout());
            this.pnlInscricao.add((Component)this.getTxtInscricao(), consGridBagConstraints1);
        }
        return this.pnlInscricao;
    }

    public BBJMask getTxtInscricao() {
        if (this.txtInscricao == null) {
            this.txtInscricao = new BBJMask();
        }
        return this.txtInscricao;
    }

    public void actionPerformed(ActionEvent e) {
        String mask = "";
        if (e.getSource() == this.getRdoCpf()) {
            mask = "###.###.###-##";
        } else if (e.getSource() == this.getRdoCNPJ()) {
            mask = "##.###.###/####-##";
        } else if (e.getSource() == this.getRdoOutros()) {
            int i = 0;
            while (i < 14) {
                mask = String.valueOf(mask) + "A";
                ++i;
            }
        }
        this.formataMask(mask);
        this.getTxtInscricao().selectAll();
    }

    public ButtonGroup getButtonGroup() {
        if (this.buttonGroup == null) {
            this.buttonGroup = new ButtonGroup();
            this.buttonGroup.add(this.getRdoCNPJ());
            this.buttonGroup.add(this.getRdoCpf());
            this.buttonGroup.add(this.getRdoOutros());
        }
        return this.buttonGroup;
    }

    public Integer getTipoInscricao() {
        if (this.getRdoCpf().isSelected()) {
            return new Integer(1);
        }
        if (this.getRdoCNPJ().isSelected()) {
            return new Integer(2);
        }
        if (this.getRdoOutros().isSelected()) {
            return new Integer(9);
        }
        return new Integer(0);
    }

    public void setTipoInscricao(Integer tipoInscr) {
        int tipo = tipoInscr;
        switch (tipo) {
            case 1: {
                this.getRdoCpf().setSelected(true);
                break;
            }
            case 2: {
                this.getRdoCNPJ().setSelected(true);
                break;
            }
            case 9: {
                this.getRdoOutros().setSelected(true);
            }
        }
    }

    public String getNrInscricao() {
        return this.getTxtInscricao().getData().trim();
    }

    public String getTextInscricao() {
        return this.getTxtInscricao().getText().trim();
    }

    public void setTextInscricao(String txtInsc) {
        String mask = "";
        if (this.getTipoInscricao() == 1) {
            mask = "###.###.###-##";
        } else if (this.getTipoInscricao() == 2) {
            mask = "##.###.###/####-##";
        } else if (this.getTipoInscricao() == 9) {
            int i = 0;
            while (i < 14) {
                mask = String.valueOf(mask) + "#";
                ++i;
            }
        }
        this.formataMask(mask);
        try {
            this.getTxtInscricao().setData(txtInsc);
        }
        catch (InvalidObjectException e) {
            UtilLog.getLog().debug(e);
        }
    }

    public void clear() {
        this.getRdoCNPJ().setSelected(true);
        this.getTxtInscricao().setText("");
        String mask = "##.###.###/####-##";
        this.formataMask(mask);
    }

    public void setEditable(boolean b) {
        this.getRdoCpf().setEnabled(b);
        this.getRdoCNPJ().setEnabled(b);
        this.getRdoOutros().setEnabled(b);
        this.getTxtInscricao().setEditable(b);
    }
}

