/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.util.swing.componente;

import br.com.bb.plugins.gac.util.swing.componente.BBJTextFieldDesabilitado;
import br.com.politec.infra.util.UtilLog;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyVetoException;
import java.math.BigDecimal;
import javax.swing.JFrame;
import javax.swing.JTextField;

public class BBJNumber
extends JTextField
implements KeyListener {
    protected String siFmtVle = "";
    protected int iiNroDgts = 17;
    protected int iiNroDecs = 4;
    protected BigDecimal oiValor;
    protected boolean _nullAllowed = false;
    public static final int SIGNUM_ZERO = 1;
    public static final int SIGNUM_POSITIVE = 2;
    public static final int SIGNUM_NEGATIVE = 4;
    protected int _signumAllowed = 7;
    FocusListener fl = new FocusListener(){

        public void focusGained(FocusEvent arg0) {
            BBJNumber.this.selectAll();
        }

        public void focusLost(FocusEvent arg0) {
        }
    };

    public BBJNumber() {
        this.setHorizontalAlignment(4);
        this.addKeyListener(this);
        this.oiValor = null;
        this.apresentValor();
        this.addFocusListener(this.fl);
        BBJTextFieldDesabilitado.definaCorDaFonteDesabilitado(this);
    }

    protected void apresentValor() {
        String slConv;
        if (this.oiValor == null) {
            if (this.isNullAllowed()) {
                slConv = "";
            } else {
                slConv = "0";
                this.oiValor = new BigDecimal(0);
            }
        } else {
            slConv = this.oiValor.toString();
            slConv = slConv.replace('.', ',');
        }
        this.setText(slConv);
    }

    protected void apresentValor2() {
        String slConv;
        if (this.oiValor == null) {
            if (this.isNullAllowed()) {
                slConv = "";
            } else {
                slConv = "0";
                this.oiValor = new BigDecimal(0);
            }
        } else {
            slConv = this.oiValor.toString();
            slConv = slConv.replace('.', ',');
        }
        super.setText(slConv);
    }

    public void cut() {
        super.cut();
        this.tratarFormato();
    }

    public int getDecimais() {
        return this.iiNroDecs;
    }

    public int getPrecisao() {
        return this.iiNroDgts;
    }

    public int getSignumAllowed() {
        return this._signumAllowed;
    }

    public BigDecimal getValor() {
        return this.oiValor;
    }

    public Double getValorDouble() {
        if (this.oiValor == null) {
            return null;
        }
        return new Double(this.oiValor.doubleValue());
    }

    public Float getValorFloat() {
        if (this.oiValor == null) {
            return null;
        }
        return new Float(this.oiValor.floatValue());
    }

    public Integer getValorInt() {
        if (this.oiValor == null) {
            return null;
        }
        return new Integer(this.oiValor.intValue());
    }

    public Long getValorLong() {
        if (this.oiValor == null) {
            return null;
        }
        return new Long(this.oiValor.longValue());
    }

    public Short getValorShort() {
        if (this.oiValor == null) {
            return null;
        }
        return new Short(this.oiValor.shortValue());
    }

    public boolean isNullAllowed() {
        return this._nullAllowed;
    }

    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 8) {
            String valor = this.getText();
            valor.length();
            int i = 0;
            while (i < valor.length()) {
                String str = valor.replace(valor.charAt(i), ' ');
                this.setText(str);
                ++i;
            }
        }
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
        char icPress = e.getKeyChar();
        switch (icPress) {
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                String texto = this.getText();
                if (icPress == '0' || (4 & this._signumAllowed) <= 0 || (2 & this._signumAllowed) != 0) break;
                if (texto == null) {
                    texto = "";
                }
                int caretP = this.getCaretPosition();
                if (texto.indexOf(45) < 0) {
                    ++caretP;
                }
                this.setText("-" + texto);
                this.tratarFormato();
                this.setCaretPosition(caretP);
                break;
            }
            case ',': 
            case '.': {
                e.setKeyChar(',');
                break;
            }
            case '-': {
                String texto = this.getText();
                if (texto != null && texto.length() > 1 && !texto.substring(0, 1).equals("0") && (4 & this._signumAllowed) > 0) {
                    int caretP = this.getCaretPosition();
                    if (texto.indexOf(45) < 0) {
                        ++caretP;
                    }
                    this.setText("-" + texto);
                    this.tratarFormato();
                    this.setCaretPosition(caretP);
                }
                e.setKeyChar('\u0000');
                break;
            }
            default: {
                e.setKeyChar('\u0000');
            }
        }
    }

    public static void main(String[] args) {
        try {
            JFrame frame = new JFrame();
            frame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent e) {
                    System.exit(0);
                }
            });
            BBJNumber jn = new BBJNumber();
            jn.setPrecisao(17);
            jn.setDecimais(2);
            jn.setSignumAllowed(7);
            jn.setNullAllowed(true);
            jn.setValor(null);
            frame.getContentPane().add(jn);
            frame.setSize(320, 240);
            frame.show();
        }
        catch (Exception exception) {
            System.err.println("Ocorreu uma exce\u00e7\u00e3o no main() do javax.swing.JPanel");
            exception.printStackTrace(System.out);
        }
    }

    public void paste() {
        super.paste();
        this.tratarFormato();
    }

    protected void processKeyEvent(KeyEvent e) {
        super.processKeyEvent(e);
        this.tratarFormato();
    }

    public void setDecimais(int decimais) {
        if (decimais < 0) {
            decimais = 0;
        }
        this.iiNroDecs = decimais;
        this.siFmtVle = "??";
        this.tratarFormato();
    }

    public void setNullAllowed(boolean valor) {
        this._nullAllowed = valor;
    }

    public void setPrecisao(int precisao) {
        if (precisao < 1) {
            precisao = 1;
        }
        if (this.iiNroDecs > precisao) {
            this.iiNroDecs = precisao;
        }
        this.iiNroDgts = precisao;
        this.siFmtVle = "??";
        this.tratarFormato();
    }

    public void setSignumAllowed(int signumFlag) {
        this._signumAllowed = signumFlag;
    }

    public void setText(String t) {
        super.setText(t);
        if (t.length() == 0) {
            this.oiValor = null;
            if (!this.isNullAllowed()) {
                this.apresentValor();
            }
            return;
        }
        this.setSelectionStart(0);
        this.setSelectionEnd(0);
        this.tratarFormato();
    }

    public void setValor(BigDecimal valor) {
        if (valor != null) {
            int signum = valor.signum();
            boolean signumOk = false;
            switch (signum) {
                case 1: {
                    signumOk = (2 & this._signumAllowed) > 0;
                    break;
                }
                case 0: {
                    signumOk = (1 & this._signumAllowed) > 0;
                    break;
                }
                case -1: {
                    boolean bl = signumOk = (4 & this._signumAllowed) > 0;
                }
            }
            if (!signumOk) {
                this.setText("");
                return;
            }
        }
        try {
            this.fireVetoableChange("valor", this.oiValor, valor);
            this.oiValor = valor;
            this.apresentValor();
            this.firePropertyChange("valor", this.oiValor, valor);
        }
        catch (PropertyVetoException ex) {
            UtilLog.getLog().debug(ex);
            return;
        }
    }

    public void setValorDouble(double valor) {
        this.setValor(new BigDecimal(valor));
    }

    public void setValorDouble(Double valor) {
        if (valor != null) {
            this.setValorDouble((double)valor);
        } else {
            this.setValor(null);
        }
    }

    public void setValorFloat(float valor) {
        this.setValor(new BigDecimal(valor));
    }

    public void setValorFloat(Float valor) {
        if (valor != null) {
            this.setValorFloat(valor.floatValue());
        } else {
            this.setValor(null);
        }
    }

    public void setValorInt(int valor) {
        BigDecimal newValor = new BigDecimal(valor);
        newValor = newValor.setScale(1, 4);
        this.setValor(newValor);
    }

    public void setValorInt(Integer valor) {
        if (valor != null) {
            this.setValorInt((int)valor);
        } else {
            this.setValor(null);
        }
    }

    public void setValorLong(long valor) {
        BigDecimal newValor = new BigDecimal(valor);
        newValor = newValor.setScale(1, 4);
        this.setValor(newValor);
    }

    public void setValorLong(Long valor) {
        if (valor != null) {
            this.setValorLong((long)valor);
        } else {
            this.setValor(null);
        }
    }

    public void setValorShort(Short valor) {
        if (valor != null) {
            this.setValorShort((short)valor);
        } else {
            this.setValor(null);
        }
    }

    public void setValorShort(short valor) {
        BigDecimal newValor = new BigDecimal(valor);
        newValor = newValor.setScale(1, 4);
        this.setValor(newValor);
    }

    protected void tratarFormato() {
        int ilPosC = 0;
        int ilPosD = -1;
        boolean blNeg = false;
        int ilPosO = this.getSelectionStart();
        if (ilPosO != this.getSelectionEnd()) {
            return;
        }
        String slOrig = this.getText();
        if (slOrig.equals(this.siFmtVle)) {
            return;
        }
        String slTrat = "";
        int ilC = 0;
        while (ilC < slOrig.length()) {
            char clAt = slOrig.charAt(ilC);
            switch (clAt) {
                case '-': {
                    blNeg = true;
                    if (ilC >= ilPosO) break;
                    ++ilPosC;
                    break;
                }
                case '0': {
                    if (slTrat.equals("") && ilC < ilPosO) break;
                }
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    slTrat = String.valueOf(slTrat) + clAt;
                    if (ilC >= ilPosO) break;
                    ++ilPosC;
                    break;
                }
                case ',': {
                    if (ilPosD >= 0) break;
                    slTrat = String.valueOf(slTrat) + ",";
                    ilPosD = slTrat.length();
                    if (ilC >= ilPosO) break;
                    ++ilPosC;
                    break;
                }
            }
            ++ilC;
        }
        if (this.iiNroDecs > 0 && ilPosD < 0) {
            slTrat = String.valueOf(slTrat.substring(0, ilPosC)) + "," + (ilPosC == slTrat.length() ? "" : slTrat.substring(ilPosC, slTrat.length()));
            ilPosD = ilPosC + 1;
        } else if (ilPosD < 0) {
            slTrat = String.valueOf(slTrat) + ",";
            ilPosD = slTrat.length();
        }
        if (ilPosD == slTrat.length()) {
            slTrat = String.valueOf(slTrat) + "0";
        }
        while (slTrat.length() - ilPosD < this.iiNroDecs) {
            slTrat = String.valueOf(slTrat) + "0";
        }
        if (ilPosD == 1) {
            slTrat = "0" + slTrat;
            ++ilPosC;
            ++ilPosD;
        }
        if (this.iiNroDgts > 0 && (ilC = this.iiNroDgts - this.iiNroDecs - ilPosD + 1) < 0) {
            slTrat = String.valueOf(slTrat.substring(0, ilPosD + ilC - 1)) + "," + slTrat.substring(ilPosD + ilC - 1, ilPosD - 1) + slTrat.substring(ilPosD);
            if (ilPosC < ilPosD && ilPosC > ilPosD + ilC - 1) {
                ++ilPosC;
            }
            ilPosD += ilC;
        }
        String slConv = String.valueOf(blNeg ? "-" : "") + slTrat.substring(0, ilPosD - 1) + (this.iiNroDecs <= 0 ? "" : "." + slTrat.substring(ilPosD, ilPosD + this.iiNroDecs));
        BigDecimal newValor = new BigDecimal(slConv);
        try {
            this.fireVetoableChange("valor", this.oiValor, newValor);
            BigDecimal oldValue = this.oiValor;
            this.oiValor = newValor;
            ilC = ilPosD - 1;
            while (ilC > 3) {
                slTrat = String.valueOf(slTrat.substring(0, ilC -= 3)) + "." + slTrat.substring(ilC);
                if (ilPosC > ilC) {
                    ++ilPosC;
                }
                ++ilPosD;
            }
            this.siFmtVle = slTrat = String.valueOf(blNeg ? "-" : "") + slTrat.substring(0, ilPosD - 1) + (this.iiNroDecs <= 0 ? "" : "," + slTrat.substring(ilPosD, ilPosD + this.iiNroDecs));
            super.setText(slTrat);
            if (ilPosC > slTrat.length()) {
                ilPosC = slTrat.length();
            }
            this.setSelectionStart(ilPosC);
            this.setSelectionEnd(ilPosC);
            this.firePropertyChange("valor", oldValue, newValor);
        }
        catch (PropertyVetoException ex) {
            UtilLog.getLog().debug(ex);
            this.apresentValor2();
            return;
        }
    }
}

