/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.util.swing.componente;

import br.com.bb.plugins.gac.util.swing.componente.BBJEstilos;
import br.com.bb.plugins.gac.util.swing.menu.BBJAbaServico;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BBJTabbedPane
extends JPanel {
    private List<BBJAbaServico> abas = null;
    private JPanel panelMain = null;
    private JPanel barraAbas = null;
    private ActionListener listener = null;
    private BBJAbaServico objAtivo = null;
    private BBJEstilos estilo;

    public BBJTabbedPane() {
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        this.setBackground(Color.WHITE);
        this.add((Component)this.getPanelMain(), "North");
        this.estilo = BBJEstilos.BARRASERVICOS;
        this.setPreferredSize(new Dimension(150, 55));
        this.setMaximumSize(new Dimension(3500, 55));
    }

    public void LoadAbas() {
        this.LoadAbas(this.abas);
    }

    public void LoadAbas(List<BBJAbaServico> abas) {
        if (abas == null) {
            return;
        }
        Iterator<BBJAbaServico> iter = abas.iterator();
        this.getBarraAbas().removeAll();
        this.getBarraAbas().add(Box.createHorizontalStrut(5), 0);
        while (iter.hasNext()) {
            BBJAbaServico abaserv = iter.next();
            abaserv.setSize();
            if (abaserv.isAtivado()) {
                this.InativaBotaoAtivo();
                this.objAtivo = abaserv;
            }
            abaserv.addFocusListener(new FocusListener(){

                public void focusGained(FocusEvent e) {
                }

                public void focusLost(FocusEvent e) {
                    BBJTabbedPane.this.Refresh();
                }
            });
            abaserv.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    BBJAbaServico obj = (BBJAbaServico)e.getSource();
                    if (obj == BBJTabbedPane.this.objAtivo) {
                        return;
                    }
                    obj.setAtivado(true);
                    BBJTabbedPane.this.InativaBotaoAtivo();
                    BBJTabbedPane.this.objAtivo = obj;
                    BBJTabbedPane.this.Refresh(e);
                }
            });
            this.getBarraAbas().add(abaserv);
        }
        this.updateUI();
    }

    private void InativaBotaoAtivo() {
        if (this.objAtivo != null) {
            this.objAtivo.setAtivado(false);
        }
    }

    protected void Refresh() {
        this.updateUI();
    }

    protected void Refresh(ActionEvent e) {
        this.updateUI();
        this.fireAction(e);
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        super.paintChildren(g);
        int posicy = 32;
        g.setColor(this.estilo.getBackcolor());
        g.fillRect(0, posicy, this.getPosicaoLinhaEsq() + 1, 1);
        g.fillRect(this.getPosicaoLinhaDir() - 2, posicy, (int)this.getSize().getWidth(), 1);
    }

    private int getPosicaoLinhaDir() {
        double d_tam = 0.0;
        int icnt = 0;
        while (icnt < this.getBarraAbas().getComponentCount()) {
            Component cmp = this.getBarraAbas().getComponent(icnt);
            d_tam += (double)cmp.getWidth();
            if (cmp == this.objAtivo) break;
            ++icnt;
        }
        return (int)d_tam;
    }

    private int getPosicaoLinhaEsq() {
        double d_tam = 0.0;
        int icnt = 0;
        while (icnt < this.getBarraAbas().getComponentCount()) {
            Component cmp = this.getBarraAbas().getComponent(icnt);
            if (cmp == this.objAtivo) break;
            d_tam += (double)cmp.getWidth();
            ++icnt;
        }
        return (int)d_tam;
    }

    public List<BBJAbaServico> getAbas() {
        return this.abas;
    }

    public void setAbas(List<BBJAbaServico> abas) {
        this.abas = abas;
    }

    public static void main(String[] args) {
        JFrame frm = new JFrame();
        BBJTabbedPane bbjtab = new BBJTabbedPane();
        ArrayList<BBJAbaServico> abasPanel = new ArrayList<BBJAbaServico>();
        BBJAbaServico abarec = new BBJAbaServico("Recebimentos");
        abarec.setAtivado(true);
        abasPanel.add(abarec);
        abasPanel.add(new BBJAbaServico("Servi\u00e7os"));
        abasPanel.add(new BBJAbaServico("Cadastro"));
        abasPanel.add(new BBJAbaServico("Imprimir"));
        abasPanel.add(new BBJAbaServico("Cadastro"));
        bbjtab.setAbas(abasPanel);
        bbjtab.LoadAbas();
        bbjtab.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BBJAbaServico aba = (BBJAbaServico)e.getSource();
                System.out.println("Aba Selecionada: " + aba.getTexto());
            }
        });
        frm.setPreferredSize(new Dimension(600, 500));
        frm.setContentPane(bbjtab);
        frm.setDefaultCloseOperation(2);
        frm.setVisible(true);
        frm.pack();
    }

    public JPanel getPanelMain() {
        if (this.panelMain == null) {
            this.panelMain = new JPanel();
            this.panelMain.setLayout(new BorderLayout());
            this.panelMain.add((Component)this.getBarraAbas(), "West");
            this.panelMain.setPreferredSize(new Dimension(0, 35));
            this.panelMain.setMaximumSize(new Dimension(1500, 35));
            this.panelMain.setOpaque(false);
        }
        return this.panelMain;
    }

    public JPanel getBarraAbas() {
        if (this.barraAbas == null) {
            this.barraAbas = new JPanel();
            this.barraAbas.setLayout(new BoxLayout(this.barraAbas, 0));
            this.barraAbas.setAlignmentY(1.0f);
            this.barraAbas.setOpaque(false);
        }
        return this.barraAbas;
    }

    public void fireAction(String command) {
        ActionEvent evt = new ActionEvent(this, 2008, command);
        this.fireAction(evt);
    }

    public void fireAction(ActionEvent event) {
        if (this.listener != null) {
            this.listener.actionPerformed(event);
        }
    }

    public void addActionListener(ActionListener listener) {
        this.listener = listener;
    }
}

