/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.util.swing.componente;

import br.com.bb.plugins.gac.apresentacao.action.PluginActionAbstrato;
import br.com.bb.plugins.gac.util.swing.IAcao;
import br.com.bb.plugins.gac.util.swing.componente.BBJTextFieldDesabilitado;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JTextField;

public class BBJText
extends JTextField
implements KeyListener,
IAcao {
    private int maxChars = 30;
    private Object object = null;
    private boolean upperCase = true;
    private boolean allChars = false;
    private String hint = "";
    public static final int SO_CHARACTER = 0;
    public static final int SO_NUMER0 = 1;
    public static final int SO_NUMERO_E_CARACTER = 2;
    public static final int SO_NUMERO_E_CARACTER_SEM_ESPACO = 3;
    public static final int ESPECIAL_PARA_EMAIL = 4;
    public static final int ESPECIAL_PARA_ARQUIVOS = 5;
    public static final int ESPECIAL_PARA_FORMATO = 6;
    public static final int NULO = 7;
    public static final int SO_CERQUILHA = 8;
    public static final int SO_ARROBA = 9;
    public static final int ESPECIAL_PARA_CONTATO = 10;
    private FocusListener fl = null;
    private PluginActionAbstrato acao;
    private int tipoEntrada = -1;
    private ActionListener listenerEspaco;

    public BBJText() {
        this.initComponents();
    }

    public BBJText(int tamanho) {
        super(tamanho);
        this.initComponents();
    }

    private void initComponents() {
        this.setHorizontalAlignment(2);
        this.addKeyListener(this);
        this.tratarFormato();
        BBJTextFieldDesabilitado.definaCorDaFonteDesabilitado(this);
        this.fl = new FocusListener(){

            public void focusGained(FocusEvent arg0) {
                if (BBJText.this.isEditable()) {
                    BBJText.this.selectAll();
                } else {
                    BBJText.this.transferFocus();
                }
            }

            public void focusLost(FocusEvent arg0) {
            }
        };
        this.addFocusListener(this.fl);
        Dimension dim = new Dimension(0, 19);
        this.setMinimumSize(dim);
        this.setSize(dim);
        this.setPreferredSize(dim);
    }

    public void setUpperCase(boolean b) {
        this.upperCase = b;
    }

    public boolean ENumero(char c) {
        String allNumbers = "0123456789";
        int i = 0;
        while (i < allNumbers.length()) {
            if (allNumbers.charAt(i) == c) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean ECaracter(char c) {
        return !this.ENumero(c);
    }

    public int getMaxChar() {
        return this.maxChars;
    }

    public void keyPressed(KeyEvent evento) {
        if (evento.getKeyCode() == 10) {
            KeyboardFocusManager.getCurrentKeyboardFocusManager().focusNextComponent();
            this.fireAction(evento.getKeyCode());
            evento.consume();
        } else if (evento.getKeyCode() == 32 || evento.getKeyCode() == 9 || evento.getKeyCode() == 38 || evento.getKeyCode() == 40) {
            this.fireAction(evento.getKeyCode());
        }
    }

    public void copy() {
        if (this.isNumerico()) {
            return;
        }
        super.copy();
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
        if (!this.isCharValidado(e.getKeyChar())) {
            e.consume();
        }
    }

    private boolean isCharValidado(char charValue) {
        switch (this.getTipoEntrada()) {
            case 1: {
                if (this.ENumero(charValue)) break;
                return false;
            }
            case 0: {
                if (this.ECaracter(charValue)) break;
                return false;
            }
            case 2: {
                if (this.ENumero(charValue) || this.ECaracter(charValue)) break;
                return false;
            }
            case 4: {
                if (this.ValidoParaEmail(charValue)) break;
                return false;
            }
            case 5: {
                if (this.ValidoParaArquivosEPastas(charValue)) break;
                return false;
            }
            case 3: {
                if (!this.EEspaco(charValue) && (this.ENumero(charValue) || this.ECaracter(charValue))) break;
                return false;
            }
            case 6: {
                return this.ValidoParaFormato(charValue);
            }
            case 7: {
                return this.NenhumCaractere(charValue);
            }
            case 8: {
                return this.ValidoParaCerquiha(charValue);
            }
            case 9: {
                return this.ValidoParaArroba(charValue);
            }
            case 10: {
                return this.ValidoParaContato(charValue);
            }
        }
        return true;
    }

    private boolean ValidoParaArquivosEPastas(char charValue) {
        String invalidChars = "*?\"<>|";
        int i = 0;
        while (i < invalidChars.length()) {
            if (invalidChars.charAt(i) == charValue) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean ValidoParaFormato(char charValue) {
        String all = "@#";
        int i = 0;
        while (i < all.length()) {
            if (all.charAt(i) == charValue) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean ValidoParaCerquiha(char charValue) {
        String all = "#";
        int i = 0;
        while (i < all.length()) {
            if (all.charAt(i) == charValue) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean ValidoParaArroba(char charValue) {
        String all = "@";
        int i = 0;
        while (i < all.length()) {
            if (all.charAt(i) == charValue) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean NenhumCaractere(char charValue) {
        String all = "";
        int i = 0;
        while (i < all.length()) {
            if (all.charAt(i) == charValue) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean ValidoParaEmail(char charValue) {
        if (this.ENumero(charValue) || this.ECaracter(charValue)) {
            return true;
        }
        String eMailChars = "@.-_";
        int i = 0;
        while (i < eMailChars.length()) {
            if (eMailChars.charAt(i) == charValue) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean ValidoParaContato(char charValue) {
        boolean valido = this.ENumero(charValue) || this.ECaracter(charValue);
        String chars = "()@.-_";
        int i = 0;
        while (i < chars.length() && !valido) {
            valido = chars.charAt(i) == charValue;
            ++i;
        }
        return valido;
    }

    private boolean EEspaco(char keyChar) {
        return keyChar == ' ';
    }

    public void paste() {
        super.paste();
    }

    private boolean isNumerico() {
        return this.getTipoEntrada() == 1;
    }

    protected void processKeyEvent(KeyEvent e) {
        super.processKeyEvent(e);
        this.tratarFormato();
    }

    public void setMaxChar(int maxChar) {
        if (maxChar < 0) {
            maxChar = 0;
        }
        this.maxChars = maxChar;
        this.updateUI();
    }

    public void setText(String t) {
        super.setText(t == null ? "" : t.trim());
        this.setSelectionStart(0);
        this.setSelectionEnd(0);
        this.tratarFormato();
    }

    protected void tratarFormato() {
        int posStart = this.getSelectionStart();
        if (posStart != this.getSelectionEnd()) {
            return;
        }
        char[] charStr = this.getText().toCharArray();
        String texto = this.getText();
        StringBuffer stringBuffer = new StringBuffer();
        int i = 0;
        while (i < charStr.length) {
            if (this.isCharValidado(charStr[i])) {
                stringBuffer.append(charStr[i]);
            }
            ++i;
        }
        int len = stringBuffer.length();
        if (this.maxChars > 0 && this.maxChars < len) {
            len = this.maxChars;
        }
        String str = stringBuffer.substring(0, len);
        if (this.upperCase) {
            str = str.toUpperCase();
        }
        if (!str.equals(texto)) {
            super.setText(str);
            this.setSelectionStart(posStart);
            this.setSelectionEnd(posStart);
        }
    }

    public Object getObject() {
        return this.object;
    }

    public void setObject(Object object) {
        if (object == null) {
            this.clear();
        } else {
            this.object = object;
            this.setText(this.getObject().toString());
        }
    }

    public void setHint(String text) {
        this.hint = text;
        super.setToolTipText(text);
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        super.setToolTipText(enabled ? this.hint : null);
    }

    public void setEditable(boolean b, Color cor) {
        this.setEditable(b);
        this.setBackground(cor);
    }

    public void clear() {
        this.object = null;
        this.setText("");
    }

    public boolean isAllChars() {
        return this.allChars;
    }

    public void setAllChars(boolean b) {
        this.allChars = b;
    }

    public int getTipoEntrada() {
        return this.tipoEntrada;
    }

    public void setTipoEntrada(int tipo) {
        this.tipoEntrada = tipo;
    }

    public PluginActionAbstrato getAcao() {
        return this.acao;
    }

    public void setAcao(PluginActionAbstrato acao) {
        this.acao = acao;
    }

    public synchronized void addActionListener(ActionListener listener) {
        this.listenerEspaco = listener;
    }

    private void fireAction(int keyCode) {
        ActionEvent event = new ActionEvent(this, 1, "" + keyCode);
        if (this.listenerEspaco != null) {
            this.listenerEspaco.actionPerformed(event);
        }
    }
}

