/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.util.swing.componente;

import br.com.bb.plugins.gac.util.swing.componente.BBPlainDocument;
import br.com.politec.infra.util.UtilLog;
import java.awt.Font;
import java.awt.KeyboardFocusManager;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JTextArea;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;

public class BBJTextArea
extends JTextArea
implements KeyListener {
    protected LinedDocument _db2Document = new LinedDocument();
    protected int _maxLineChar = -1;
    protected int _qtdeLine = -1;
    protected boolean _convertBreakToNewLine = false;
    private int tipo = -1;
    public static final int SO_CHARACTER = 0;
    public static final int SO_NUMER0 = 1;
    public static final int SO_NUMERO_E_CARACTER = 2;
    private boolean upperCase = true;
    private boolean allChars = false;

    public BBJTextArea() {
        this.setFont(new Font("monospaced", 0, 12));
        this.addKeyListener(this);
        this.setDocument(this._db2Document);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String adjustLinesChars(String texto, int qtdeMaxLinha) {
        StringBuffer ret = new StringBuffer();
        int tamTexto = texto.length();
        if (tamTexto > this._maxLineChar) {
            String restante = texto;
            int ini = 0;
            int fim = tamTexto > this._maxLineChar ? this._maxLineChar : tamTexto;
            boolean truncar = qtdeMaxLinha > 0;
            int contador = 1;
            do {
                String linhaOk = restante.substring(ini, fim);
                ret.append(linhaOk);
                if (truncar && contador > qtdeMaxLinha) return ret.toString();
                ++contador;
                int tam = restante.length();
                if (tam <= fim) return ret.toString();
                if (!restante.substring(fim - 1, fim).equals("\n")) {
                    ret.append('\n');
                }
                restante = restante.substring(fim, tam);
                tam = restante.length();
                ini = 0;
                int n = fim = tam > this._maxLineChar ? this._maxLineChar : tam;
            } while (restante != null);
            return ret.toString();
        } else {
            ret.append(texto);
        }
        return ret.toString();
    }

    private String adjustText(String texto) {
        int limiteLinhas = -1;
        if (this._qtdeLine > 0) {
            limiteLinhas = this._qtdeLine - this.internalGetNewLineCount(texto);
        }
        texto = this.adjustLinesChars(texto, limiteLinhas);
        texto = this.adjustTextLines(texto, limiteLinhas);
        return texto;
    }

    private String adjustTextLines(String texto, int qtde) {
        StringBuffer ret = new StringBuffer();
        int i = 1;
        while (i <= qtde) {
            ret.append(this.internalGetLine(texto, i));
            if (i < qtde) {
                ret.append('\n');
            }
            ++i;
        }
        return ret.toString();
    }

    public void appendLine(String texto) throws IllegalArgumentException {
        String textoOriginal = this.getText();
        int numLinha = this.internalGetNewLineCount(textoOriginal);
        if (textoOriginal.length() > 0 && !textoOriginal.substring(textoOriginal.length() - 1, textoOriginal.length()).equals("\n")) {
            ++numLinha;
        }
        this.checkLine(numLinha);
        this.fixLine(numLinha, true);
        this.internalSetLine(this.getText(), numLinha, texto);
    }

    private void checkLine(int numLinha) throws IllegalArgumentException {
        if (numLinha < 1) {
            throw new IllegalArgumentException("O numero da linha especificado \u00e9 inv\u00e1lido.");
        }
        if (this._qtdeLine > 0 && numLinha > this._qtdeLine) {
            throw new IllegalArgumentException("O numero da linha especificado excede a quantidade de linhas.");
        }
    }

    public void convertLineBreaksToNewLine() {
        if (this.getColumns() < 1) {
            return;
        }
        String texto = this.getText();
        boolean convertLN = this._convertBreakToNewLine;
        this._convertBreakToNewLine = false;
        texto = this.internalConvertLineBreaksToNewLine(texto, this.getColumns());
        this.setText(texto);
        this._convertBreakToNewLine = convertLN;
    }

    public void cut() {
        super.cut();
    }

    private void fixLine(int qtde, boolean isAppend) {
        String texto = null;
        texto = isAppend ? this.fixTextLinesForInsert(this.getText(), qtde) : this.fixTextLines(this.getText(), qtde);
        this.setText(texto);
    }

    private String fixTextLines(String texto, int qtde) {
        if (this.internalGetNewLineCount(texto) < qtde) {
            texto = this.adjustTextLines(texto, qtde);
        }
        return texto;
    }

    private String fixTextLinesForInsert(String texto, int qtde) {
        if (this.internalGetNewLineCount(texto) < qtde) {
            texto = this.adjustTextLines(texto, qtde - 1);
            texto = String.valueOf(texto) + "\n";
        }
        return texto;
    }

    public boolean getConvertBreakLineEnabled() {
        return this._convertBreakToNewLine;
    }

    public int getLineCount() {
        return super.getLineCount();
    }

    public int getMaxChar() {
        return this._db2Document.getMaxChar();
    }

    public int getMaxLineChar() {
        return this._maxLineChar;
    }

    public String getTextLine(int numLinha) throws IllegalArgumentException {
        this.checkLine(numLinha);
        this.fixLine(numLinha, false);
        return this.internalGetLine(this.getText(), numLinha);
    }

    public int getTextLineCount() {
        if (this._qtdeLine > 0) {
            return this._qtdeLine;
        }
        return this.internalGetUsedLineCount(this.getText());
    }

    public int getTextLineLength(int numLinha) throws IllegalArgumentException {
        this.checkLine(numLinha);
        this.fixLine(numLinha, false);
        String textoOriginal = this.getText();
        String texto = this.fixTextLines(textoOriginal, this._qtdeLine);
        if (!texto.equals(textoOriginal)) {
            this.setText(texto);
        }
        return this.internalGetLineLength(this.getText(), numLinha);
    }

    public int getTextLineOffset(int numLinha) throws IllegalArgumentException {
        this.checkLine(numLinha);
        this.fixLine(numLinha, false);
        String textoOriginal = this.getText();
        String texto = this.fixTextLines(textoOriginal, this._qtdeLine);
        if (!texto.equals(textoOriginal)) {
            this.setText(texto);
        }
        return this.internalGetLineOffset(this.getText(), numLinha);
    }

    private String insertString(int offs, String str, AttributeSet a) throws BadLocationException {
        String texto = "";
        if (offs > 0) {
            texto = this.getText(0, offs);
        }
        texto = String.valueOf(texto) + str;
        int tam = this.getText().length();
        if (tam > offs) {
            texto = String.valueOf(texto) + this.getText(offs, tam - offs);
        }
        int qtde = this.internalGetNewLineCount(texto);
        if (this._qtdeLine > 0 && qtde > this._qtdeLine) {
            return null;
        }
        if (this._maxLineChar > 0) {
            int i = 1;
            while (i <= qtde) {
                if (this.internalGetLine(texto, i).length() > this._maxLineChar) {
                    return null;
                }
                ++i;
            }
        }
        return str;
    }

    private String insertString2(int offs, String str, AttributeSet a) throws BadLocationException {
        String texto = "";
        if (offs > 0) {
            texto = this.getText(0, offs);
        }
        texto = String.valueOf(texto) + str;
        int tam = this.getText().length();
        if (tam > offs) {
            texto = String.valueOf(texto) + this.getText(offs, tam - offs);
        }
        int qtde = -1;
        qtde = this.internalGetNewLineCount(texto);
        if (this._qtdeLine > 0 && qtde > this._qtdeLine) {
            return null;
        }
        String textoF = this.internalConvertLineBreaksToNewLine(texto, this.getColumns());
        qtde = this.internalGetNewLineCount(textoF);
        if (this._qtdeLine > 0 && qtde > this._qtdeLine) {
            return null;
        }
        boolean convertLN = this._convertBreakToNewLine;
        this._convertBreakToNewLine = false;
        int caretPos = this.getCaretPosition();
        super.setText(textoF);
        try {
            if (qtde > this.internalGetNewLineCount(textoF)) {
                ++caretPos;
            }
            this.setCaretPosition(caretPos + str.length());
        }
        catch (Exception e) {
            UtilLog.getLog().debug(e);
        }
        this._convertBreakToNewLine = convertLN;
        return null;
    }

    private String internalConvertLineBreaksToNewLine(String texto, int cols) {
        if (texto == null || texto.length() < 1) {
            return texto;
        }
        StringBuffer ret = new StringBuffer();
        int qtde = this.internalGetNewLineCount(texto);
        boolean isWWord = this.getWrapStyleWord();
        int pos = -1;
        int posAnt = -1;
        String antes = null;
        int i = 0;
        while (i < qtde) {
            String linha = this.internalGetLine(texto, i + 1);
            while (linha.length() > cols) {
                if (linha.substring(cols, cols + 1).equals("\n")) continue;
                if (isWWord) {
                    boolean quebraOk = false;
                    int max = Math.min(linha.length(), cols);
                    int j = 0;
                    while (j < max) {
                        if (linha.substring(j, j + 1).equals(" ")) {
                            pos = j;
                            quebraOk = true;
                        }
                        ++j;
                    }
                    if (quebraOk) {
                        antes = linha.substring(0, pos);
                        linha = linha.substring(pos + 1, linha.length());
                    } else {
                        antes = linha.substring(0, cols);
                        linha = linha.substring(cols, linha.length());
                    }
                } else {
                    antes = linha.substring(0, cols);
                    linha = linha.substring(cols, linha.length());
                }
                ret.append(antes);
                ret.append("\n");
            }
            ret.append(linha);
            if (i < qtde - 1) {
                ret.append("\n");
            }
            ++i;
        }
        return ret.toString();
    }

    private String internalGetLine(String texto, int numLin) {
        int offsetProximo;
        if (texto == null || texto.length() == 0) {
            return "";
        }
        String ret = "";
        int offset = this.internalGetLineOffset(texto, numLin);
        if (offset < 0) {
            return ret;
        }
        int len = -1;
        len = numLin == this._qtdeLine ? texto.length() - offset : ((offsetProximo = this.internalGetLineOffset(texto, numLin + 1)) < 0 ? texto.length() - offset : offsetProximo - 1 - offset);
        if (offset + len > offset) {
            ret = texto.substring(offset, offset + len);
        }
        return ret;
    }

    private int internalGetLineLength(String texto, int numLinha) {
        int len = -1;
        int offset = this.internalGetLineOffset(texto, numLinha);
        if (numLinha == this._qtdeLine) {
            len = texto.length() - offset;
        } else {
            int offsetProximo = this.internalGetLineOffset(texto, numLinha + 1);
            if (offsetProximo < 0) {
                len = texto.length() - offset;
                return len;
            }
            len = offsetProximo - 1 - offset;
        }
        return len;
    }

    private int internalGetLineOffset(String texto, int numLinha) {
        int offset = 0;
        int offsetAnt = 0;
        if (numLinha > 1) {
            int contador = numLinha;
            while (contador > 1) {
                offsetAnt = offset;
                offset = texto.indexOf("\n", offsetAnt + 1);
                --contador;
            }
            if (offset < 0) {
                return -1;
            }
            offsetAnt = offset;
            ++offsetAnt;
        }
        return offsetAnt;
    }

    private int internalGetNewLineCount(String texto) {
        int contador = 1;
        if (texto == null) {
            return -1;
        }
        int pos = -1;
        while ((pos = texto.indexOf("\n", pos + 1)) >= 0) {
            ++contador;
        }
        return contador;
    }

    private int internalGetUsedLineCount(String texto) {
        int contador = 0;
        if (texto != null && texto.length() > 0) {
            int pos = -1;
            while ((pos = texto.indexOf("\n", pos + 1)) >= 0) {
                if (pos <= 0 || texto.substring(pos - 1, pos).equals("\n")) continue;
                ++contador;
            }
        }
        return contador;
    }

    private void internalSetLine(String texto, int numLin, String linha) {
        int linhaQtde;
        int limiteLinhas = -1;
        int linUsadas = this.internalGetNewLineCount(texto);
        limiteLinhas = this._qtdeLine > 0 ? this._qtdeLine - linUsadas : 0x7FFFFFFE;
        if (this._maxLineChar > 0 && (linhaQtde = this.internalGetNewLineCount(linha = this.adjustLinesChars(linha, limiteLinhas))) < limiteLinhas && numLin < linUsadas) {
            linha = String.valueOf(linha) + "\n";
        }
        String txtAntes = "";
        String txtDepois = "";
        int offset = this.internalGetLineOffset(texto, numLin);
        int len = this.internalGetLineLength(texto, numLin);
        if (offset > 0) {
            txtAntes = texto.substring(0, offset);
        }
        txtDepois = texto.substring(offset + len, texto.length());
        this.setText(String.valueOf(txtAntes) + linha + txtDepois);
    }

    public void keyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 9) {
            if (evt.isShiftDown()) {
                KeyboardFocusManager.getCurrentKeyboardFocusManager().focusPreviousComponent();
            } else {
                KeyboardFocusManager.getCurrentKeyboardFocusManager().focusNextComponent();
            }
            evt.consume();
        }
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
        switch (this.getTipo()) {
            case 1: {
                if (!this.ENumero(e.getKeyChar())) {
                    e.consume();
                }
            }
            case 0: {
                if (this.ECaracter(e.getKeyChar())) break;
                e.consume();
                break;
            }
            case 2: {
                if (this.ENumero(e.getKeyChar()) || this.ECaracter(e.getKeyChar())) break;
                e.consume();
            }
        }
        e.setKeyChar(this.getDB2Char(e.getKeyChar()));
    }

    private char getDB2Char(char c) {
        if (this.isAllChars()) {
            return c;
        }
        String allChars = "\u00e7\u00c7\u00f1\u00d1\u00c1\u00e1\u00e0\u00c0\u00c2\u00e2\u00e3\u00c3\u00c9\u00c8\u00ca\u00e9\u00e8\u00ea\u00d2\u00d3\u00d4\u00d5\u00f3\u00f2\u00f5\u00f4\u00cd\u00cc\u00ce\u00ed\u00ec\u00ee\u00d9\u00da\u00db\u00dc\u00fa\u00f9\u00fb\u00fc";
        String uppers = "CCNNAAAAAAAAEEEEEEOOOOOOOOIIIIIIUUUUUUUU";
        String normal = "cCnNAaaAAaaAEEEeeeOOOOooooIIIiiiUUUUuuuu";
        int i = 0;
        while (i < allChars.length()) {
            if (allChars.charAt(i) == c) {
                if (this.upperCase) {
                    return uppers.charAt(i);
                }
                return normal.charAt(i);
            }
            ++i;
        }
        return c;
    }

    public boolean ENumero(char c) {
        String allNumbers = "0123456789";
        int i = 0;
        while (i < allNumbers.length()) {
            if (allNumbers.charAt(i) == c) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean ECaracter(char c) {
        String allUpperChars = " ABCDEFGHIJKLMNOPQRSTUVWYXZ";
        String allLowerChars = " abcdefghijklmnopqrstuvwyxz";
        int i = 0;
        while (i < allUpperChars.length()) {
            if (allUpperChars.charAt(i) == c) {
                return true;
            }
            ++i;
        }
        i = 0;
        while (i < allLowerChars.length()) {
            if (allLowerChars.charAt(i) == c) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void packLines() {
        String texto = this.getText();
        if (texto == null || texto.length() == 0) {
            return;
        }
        int ind = 0;
        int i = texto.length() - 1;
        while (i >= 0) {
            if (texto.charAt(i) != '\n') {
                ind = i + 1;
                break;
            }
            --i;
        }
        this.setText(texto.substring(0, ind));
    }

    public void paste() {
        super.paste();
    }

    protected void processKeyEvent(KeyEvent e) {
        super.processKeyEvent(e);
    }

    public void setConvertBreakLineEnabled(boolean valor) {
        this._convertBreakToNewLine = valor;
        if (this._convertBreakToNewLine && this.getText() != null && this.getText().length() > 0) {
            this.convertLineBreaksToNewLine();
        }
    }

    public void setMaxChar(int maxChar) {
        this._db2Document.setMaxChar(maxChar);
    }

    public void setMaxLineChar(int maxChar) {
        this._maxLineChar = maxChar;
        String texto = this.getText();
        texto = this.adjustText(texto);
        this.setText(texto);
    }

    public void setText(String t) {
        String texto = t;
        if (texto == null) {
            texto = "";
        }
        super.setText(texto);
    }

    public void setTextLine(int numLinha, String texto) throws IllegalArgumentException {
        this.checkLine(numLinha);
        this.fixLine(numLinha, false);
        this.internalSetLine(this.getText(), numLinha, texto);
    }

    public void setTextLineCount(int qtde) {
        this._qtdeLine = qtde;
    }

    public int getTipo() {
        return this.tipo;
    }

    public void setTipo(int tipo) {
        this.tipo = tipo;
    }

    public boolean isAllChars() {
        return this.allChars;
    }

    public void setAllChars(boolean allChars) {
        this.allChars = allChars;
    }

    public boolean isUpperCase() {
        return this.upperCase;
    }

    public void setUpperCase(boolean upperCase) {
        this.upperCase = upperCase;
    }

    class LinedDocument
    extends BBPlainDocument {
        LinedDocument() {
        }

        public void setContent(int offs, String str) throws BadLocationException {
            super.remove(offs, BBJTextArea.this.getText().length());
            super.insertString(offs, str, null);
        }

        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            if (BBJTextArea.this._convertBreakToNewLine) {
                String texto = BBJTextArea.this.insertString2(offs, str, a);
                if (texto != null) {
                    super.insertString(offs, texto, a);
                }
            } else if (BBJTextArea.this._qtdeLine > 0 || BBJTextArea.this._maxLineChar > 0) {
                String texto = BBJTextArea.this.insertString(offs, str, a);
                if (texto != null) {
                    super.insertString(offs, texto, a);
                }
            } else {
                super.insertString(offs, str, a);
            }
        }

        public void remove(int offs, int len) throws BadLocationException {
            super.remove(offs, len);
            if (BBJTextArea.this.getText().length() > 0) {
                this.insertString(offs, "", null);
            }
        }
    }
}

