/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.util.swing.componente;

import br.com.bb.plugins.gac.util.swing.componente.IObjectTableModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BBTableModelByObject<T extends IObjectTableModel>
extends AbstractTableModel {
    private JTable table = null;
    protected String[] columnNames = null;
    protected int[] columnSizes = null;
    protected int[] columnAlignment = null;
    protected Vector<T> dataVector = null;

    public BBTableModelByObject(String[] columnNames) {
        this(columnNames, null);
    }

    public BBTableModelByObject(String[] columnNames, int[] columnSizes) {
        this(columnNames, columnSizes, null);
    }

    public BBTableModelByObject(String[] columnNames, int[] columnSizes, int[] columnAlignment) {
        this.columnNames = columnNames;
        this.columnSizes = columnSizes;
        this.columnAlignment = columnAlignment;
        this.dataVector = new Vector();
    }

    public void setTableProps(JTable table) {
        this.table = table;
        table.setAutoResizeMode(3);
        table.setSurrendersFocusOnKeystroke(true);
        if (this.columnNames == null || this.columnSizes == null) {
            return;
        }
        table.getTableHeader().setDefaultRenderer(new MyTableHeaderRenderer());
        TableColumn column = null;
        int icnt = 0;
        while (icnt < this.columnNames.length) {
            column = table.getColumnModel().getColumn(icnt);
            if (icnt < this.columnSizes.length - 1) {
                column.setMaxWidth(this.columnSizes[icnt]);
                column.setPreferredWidth(this.columnSizes[icnt]);
                column.setWidth(this.columnSizes[icnt]);
            }
            if (this.columnAlignment != null && icnt < this.columnAlignment.length) {
                MyTableCellRenderer tcrColumn = new MyTableCellRenderer();
                tcrColumn.setAlignmentX(this.columnAlignment[icnt]);
                column.setCellRenderer(tcrColumn);
            }
            ++icnt;
        }
        table.getTableHeader().updateUI();
        table.updateUI();
    }

    public void excluiObjetoSelecionado() {
        this.excluiObjeto(this.getObjetoSelecionado());
    }

    public void excluiObjeto(T posicao) {
        this.dataVector.remove(posicao);
    }

    public T getObjetoSelecionado() {
        ArrayList<T> list = new ArrayList<T>();
        list.addAll(this.dataVector);
        return (T)((IObjectTableModel)list.get(this.table.getSelectedRow()));
    }

    @Override
    public String getColumnName(int column) {
        return this.columnNames[column];
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return false;
    }

    public Class getColumnClass(int column) {
        return this.getValueAt(0, column).getClass();
    }

    @Override
    public int getRowCount() {
        return this.dataVector.size();
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public Object getValueAt(int row, int column) {
        IObjectTableModel record = (IObjectTableModel)this.dataVector.get(row);
        return record.getColumn(column);
    }

    public Vector<T> getDataVector() {
        return this.dataVector;
    }

    public void setDataVector(Vector<T> dataVector) {
        this.dataVector = dataVector;
    }

    private class MyTableCellRenderer
    extends DefaultTableCellRenderer
    implements TableCellRenderer {
        private static final long serialVersionUID = 1L;

        public Component getTableCellRendererComponent(JTable jtable, Object obj, boolean isSelected, boolean hasFocus, int i, int j) {
            if (i % 2 == 0 && !isSelected) {
                this.setBackground(new Color(253, 254, 240));
                this.setForeground(Color.BLACK);
            } else if (isSelected) {
                this.setBackground(Color.LIGHT_GRAY);
                this.setForeground(Color.BLUE);
            } else {
                this.setBackground(Color.WHITE);
                this.setForeground(Color.BLACK);
            }
            if (obj != null) {
                this.setValue(" " + obj.toString());
            }
            return this;
        }
    }

    private class MyTableHeaderRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 35L;

        private MyTableHeaderRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (BBTableModelByObject.this.columnAlignment != null && column < BBTableModelByObject.this.columnAlignment.length) {
                this.setAlignmentX(BBTableModelByObject.this.columnAlignment[column]);
            }
            this.setValue(" " + value.toString());
            Font defont = UIManager.getDefaults().getFont("Button.font");
            this.setFont(new Font(defont.getFamily(), 1, 12));
            this.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY, 1));
            this.setBackground(Color.GRAY);
            this.setForeground(Color.WHITE);
            return this;
        }
    }
}

