/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.util.swing.componente;

import br.com.bb.plugins.gac.util.swing.componente.BBJEstilos;
import br.com.bb.plugins.gac.util.swing.componente.BBJPaginacao;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.util.LinkedList;
import javax.swing.JLabel;

public class Hyperlink
extends JLabel
implements FocusListener,
KeyListener {
    private BBJPaginacao paginacao;
    protected final Color LINK_COLOR = BBJEstilos.LABELTEXTO.getColor();
    protected LinkedList<ActionListener> actionListenerList = new LinkedList();
    protected boolean underline = false;

    public Hyperlink(BBJPaginacao paginacao) {
        this("", paginacao);
    }

    public Hyperlink(String text, BBJPaginacao paginacao) {
        super(text);
        this.paginacao = paginacao;
        this.setCursor(Cursor.getPredefinedCursor(12));
        this.setForeground(BBJEstilos.LABELTEXTO.getColor());
        this.setBackground(BBJEstilos.LABELTEXTO.getBackcolor());
        this.setFont(BBJEstilos.LABELTEXTO.getFont());
        this.addMouseListener(new HyperlinkListener());
        this.addFocusListener(this);
        this.addKeyListener(this);
    }

    public void addActionListener(ActionListener l) {
        if (!this.actionListenerList.contains(l)) {
            this.actionListenerList.add(l);
        }
    }

    public void removeActionListener(ActionListener l) {
        this.actionListenerList.remove(l);
    }

    protected void fireActionEvent() {
        ActionEvent e = new ActionEvent(this, 1001, this.getText());
        for (ActionListener l : this.actionListenerList) {
            l.actionPerformed(e);
            this.repaint();
        }
    }

    public void paint(Graphics g) {
        super.paint(g);
        if (this.underline) {
            Rectangle2D textBounds = this.getFontMetrics(this.getFont()).getStringBounds(this.getText(), g);
            int posicYLine = this.getHeight() / 2 + (int)(textBounds.getHeight() / 2.0);
            int w = (int)textBounds.getWidth();
            int x = this.getIcon() == null ? 0 : this.getIcon().getIconWidth() + this.getIconTextGap();
            g.setFont(BBJEstilos.LABELTEXTO.getFont());
            g.setColor(BBJEstilos.LABELTEXTO.getColor());
            g.drawLine(0, posicYLine, x + w, posicYLine);
        }
    }

    public void focusGained(FocusEvent e) {
        this.setForeground(new Color(32, 71, 164));
        this.repaint();
    }

    public void focusLost(FocusEvent e) {
        this.setForeground(BBJEstilos.LABELTEXTO.getColor());
        this.repaint();
    }

    public void keyPressed(KeyEvent evento) {
        if (evento.getKeyCode() == 10) {
            MouseEvent evt = new MouseEvent(this, 501, 0L, 0, 0, 0, 0, false);
            if (this.getMouseListeners() != null && this.getMouseListeners().length > 0) {
                this.getMouseListeners()[0].mouseClicked(evt);
            }
        }
    }

    public void keyReleased(KeyEvent evento) {
    }

    public void keyTyped(KeyEvent e) {
    }

    private class HyperlinkListener
    extends MouseAdapter {
        private HyperlinkListener() {
        }

        public void mouseClicked(MouseEvent me) {
            Component componente = (Component)me.getSource();
            int valor = Hyperlink.this.paginacao.getValorIncremento();
            if (componente == null || componente.getName() == null) {
                return;
            }
            if (componente.getName().trim().equals("pr\u00f3xima") || componente.getName().trim().equals(">>")) {
                if (Hyperlink.this.paginacao.getValorPos() < Hyperlink.this.paginacao.getValorMaximo()) {
                    Hyperlink.this.paginacao.setValorPos(Hyperlink.this.paginacao.getValorPos() + valor);
                }
            } else if (componente.getName().trim().equals("\u00faltima") || componente.getName().trim().equals(">")) {
                Hyperlink.this.paginacao.setValorPos(Hyperlink.this.paginacao.getValorMaximo());
            } else if (componente.getName().trim().equals("primeira") || componente.getName().trim().equals("<")) {
                Hyperlink.this.paginacao.setValorPos(1);
            } else if (componente.getName().trim().equals("anterior") || componente.getName().trim().equals("<<")) {
                if (Hyperlink.this.paginacao.getValorPos() != 1) {
                    Hyperlink.this.paginacao.setValorPos(Hyperlink.this.paginacao.getValorPos() - valor);
                }
            } else {
                return;
            }
            System.out.println(componente.getName());
            System.out.println(" M\u00e1ximo     : " + Hyperlink.this.paginacao.getValorMaximo());
            System.out.println(" Posi\u00e7\u00e3o    : " + Hyperlink.this.paginacao.getValorPos());
            System.out.println(" Incremento : " + Hyperlink.this.paginacao.getValorIncremento());
            System.out.println("------------------");
            Hyperlink.this.paginacao.atualiza();
        }
    }
}

