/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.util.swing.componente;

import br.com.bb.plugins.gac.util.swing.componente.Mask;
import java.util.Enumeration;
import java.util.Hashtable;

public final class MaskDefinition
extends Hashtable {
    private static MaskDefinition maskType_;
    public static final char DIGIT = '#';
    public static final char DIGIT_ESPACO = '*';
    public static final char CARACTER = '&';
    public static final char ALFA = 'A';
    public static final char ALFA_ESPACO = '@';
    public static final char LETTER = '?';
    public static final char MAIUSCULA = 'U';
    public static final char MINUSCULA = 'L';
    public static final char ALFA_TRACO = '^';
    public static final char DIGIT_TRACO = '+';
    public static final char DIA = 'd';
    public static final char MES = 'm';
    public static final char ANO = 'a';

    public MaskDefinition() {
        this.put("#", new Mask('#'){

            public boolean isPermitted(char c) {
                return Character.isDigit(c);
            }
        });
        this.put("*", new Mask('*'){

            public boolean isPermitted(char c) {
                return Character.isDigit(c) || Character.isSpaceChar(c);
            }
        });
        this.put("&", new Mask('&'){

            public boolean isPermitted(char c) {
                return true;
            }
        });
        this.put("A", new Mask('A'){

            public boolean isPermitted(char c) {
                return Character.isLetterOrDigit(c);
            }
        });
        this.put("@", new Mask('@'){

            public boolean isPermitted(char c) {
                return Character.isLetterOrDigit(c) || Character.isSpaceChar(c);
            }
        });
        this.put("?", new Mask('?'){

            public boolean isPermitted(char c) {
                return Character.isLetter(c);
            }
        });
        this.put("U", new Mask('U'){

            public boolean isPermitted(char c) {
                return Character.isUpperCase(c);
            }
        });
        this.put("L", new Mask('L'){

            public boolean isPermitted(char c) {
                return Character.isLowerCase(c);
            }
        });
        this.put("^", new Mask('^'){

            public boolean isPermitted(char c) {
                return Character.isLetterOrDigit(c) || c == '-';
            }
        });
        this.put("+", new Mask('+'){

            public boolean isPermitted(char c) {
                return Character.isDigit(c) || c == '-';
            }
        });
        this.put("a", new Mask('a'){

            public boolean isPermitted(char c) {
                return Character.isDigit(c);
            }
        });
        this.put("d", new Mask('d'){

            public boolean isPermitted(char c) {
                return Character.isDigit(c);
            }
        });
        this.put("m", new Mask('m'){

            public boolean isPermitted(char c) {
                return Character.isDigit(c);
            }
        });
    }

    public char[] getDefinitions() {
        char[] def = new char[this.size()];
        int i = 0;
        Enumeration e = this.keys();
        while (e.hasMoreElements()) {
            def[i++] = ((String)e.nextElement()).charAt(0);
        }
        return def;
    }

    public Mask getMask(char c) {
        return (Mask)this.get("" + c);
    }

    public static MaskDefinition getMaskDefinition() {
        if (maskType_ == null) {
            maskType_ = new MaskDefinition();
        }
        return maskType_;
    }
}

