/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.util.swing.componente.comboBox;

import br.com.bb.plugins.gac.apresentacao.dominio.action.ConsultarListaConvenioAction;
import br.com.bb.plugins.gac.apresentacao.dominio.action.ConsultarListaConvenioPessoaConvenenteAction;
import br.com.bb.plugins.gac.apresentacao.dominio.form.DominioForm;
import br.com.bb.plugins.gac.factory.FormFactory;
import br.com.bb.plugins.gac.factory.TOFactory;
import br.com.bb.plugins.gac.negocio.to.ConvenenteTO;
import br.com.bb.plugins.gac.negocio.to.ConvenioTO;
import br.com.bb.plugins.gac.util.swing.componente.BBJComboBox;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.DefaultComboBoxModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BBJComboBoxConvenio
extends BBJComboBox {
    private final String selecione = "Selecione";
    private boolean inseriuSelecione = false;

    public void carregar() {
        DominioForm dominioForm = this.getDominioForm();
        this.getConsultarListaConvenioAction().executar(dominioForm);
        this.preencherCombo(dominioForm.getListaConvenio(), true);
    }

    public void carregarComFiltro() {
        this.carregarComFiltro(true);
    }

    public void carregarComFiltro(boolean inserirElementoVazio) {
        DominioForm dominioForm = this.getDominioForm();
        this.getConsultarListaConvenioPessoaConvenenteAction().executar(dominioForm);
        this.preencherCombo(dominioForm.getListaConvenio(), inserirElementoVazio);
    }

    public void carregarComFiltroConvenenteServico(ConvenenteTO convenenteTO, String textoIdentificadorServico) {
        DominioForm dominioForm = this.getDominioForm();
        ConvenioTO convenioTO = TOFactory.getInstancia().novoConvenioTO();
        convenioTO.setConvenenteTO(convenenteTO);
        convenioTO.getServicoTO().setTextoIdentificadorServico(textoIdentificadorServico);
        dominioForm.setConvenioTO(convenioTO);
        dominioForm.setConsultarTodos(true);
        this.getConsultarListaConvenioPessoaConvenenteAction().executar(dominioForm);
        this.preencherCombo(dominioForm.getListaConvenio(), true);
    }

    public void carregarQuantoPessoaConvenente(Integer codigoPessoaConvenente) {
        this.carregarQuantoPessoaConvenente(codigoPessoaConvenente, true);
    }

    public void carregarQuantoPessoaConvenente(Integer codigoPessoaConvenente, boolean inserirElementoVazio) {
        DominioForm dominioForm = this.getDominioForm();
        dominioForm.getConvenioTO().getConvenenteTO().setCodigoPessoaConvenente(codigoPessoaConvenente);
        dominioForm.getConvenioTO().getServicoTO().setTextoIdentificadorServico("DBT");
        this.getConsultarListaConvenioPessoaConvenenteAction().executar(dominioForm);
        this.preencherCombo(dominioForm.getListaConvenio(), inserirElementoVazio);
    }

    private void preencherCombo(Collection<ConvenioTO> listaConvenio, boolean inserirElementoVazio) {
        Collections.sort((ArrayList)listaConvenio, new Comparator<ConvenioTO>(){

            @Override
            public int compare(ConvenioTO o1, ConvenioTO o2) {
                return o1.getNumeroConvenio().compareTo(o2.getNumeroConvenio());
            }
        });
        this.setModel(this.getDefaultComboBoxModel(listaConvenio, inserirElementoVazio));
    }

    private DefaultComboBoxModel getDefaultComboBoxModel(Collection<ConvenioTO> listaConvenio, boolean inserirElementoVazio) {
        DefaultComboBoxModel defaultComboBoxModel = this.getComboBoxModelPopulada(listaConvenio);
        if (inserirElementoVazio) {
            this.inserirElementoVazio(defaultComboBoxModel);
        }
        this.selecionaPrimeiroItemCombo(defaultComboBoxModel);
        return defaultComboBoxModel;
    }

    private DefaultComboBoxModel getComboBoxModelPopulada(Collection<ConvenioTO> listaConvenio) {
        return new DefaultComboBoxModel<Object>(listaConvenio.toArray());
    }

    private void selecionaPrimeiroItemCombo(DefaultComboBoxModel defaultComboBoxModel) {
        defaultComboBoxModel.setSelectedItem(defaultComboBoxModel.getElementAt(0));
    }

    public void selecionaPrimeiroItemCombo() {
        this.getModel().setSelectedItem(this.getModel().getElementAt(0));
    }

    private void inserirElementoVazio(DefaultComboBoxModel defaultComboBoxModel) {
        this.inseriuSelecione = true;
        defaultComboBoxModel.insertElementAt("Selecione", 0);
    }

    @Override
    public void setSelectedItem(Object anObject) {
        if (anObject == null && this.inseriuSelecione) {
            super.setSelectedItem("Selecione");
        } else {
            super.setSelectedItem(anObject);
        }
    }

    private DominioForm getDominioForm() {
        return FormFactory.getInstancia().novoDominioForm();
    }

    private ConsultarListaConvenioAction getConsultarListaConvenioAction() {
        return this.getActionFactory().novoConsultarListaConvenioAction();
    }

    private ConsultarListaConvenioPessoaConvenenteAction getConsultarListaConvenioPessoaConvenenteAction() {
        return this.getActionFactory().novoConsultarListaConvenioPessoaConvenenteAction();
    }
}

