/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.util.swing.listener;

import br.com.bb.plugins.gac.apresentacao.action.PluginActionAbstrato;
import br.com.bb.plugins.gac.apresentacao.form.PluginFormAbstrato;
import br.com.bb.plugins.gac.excecao.BBException;
import br.com.bb.plugins.gac.factory.PluginFormularioEstrategiaSwingFactory;
import br.com.bb.plugins.gac.util.Log;
import br.com.bb.plugins.gac.util.UtilMensagem;
import br.com.bb.plugins.gac.util.bean.ValidacaoBean;
import br.com.bb.plugins.gac.util.controller.view.ControlableView;
import br.com.bb.plugins.gac.util.swing.IAcao;
import br.com.bb.plugins.gac.util.swing.IFormulario;
import br.com.bb.plugins.gac.util.swing.componente.BBJComboBoxImpl;
import br.com.bb.plugins.gac.util.swing.componente.BBJPopupMensagem;
import br.com.politec.estrategiaswing.IFormularioEstrategiaSwing;
import br.com.politec.estrategiaswing.IFormularioEstrategiaSwingFactory;
import br.com.politec.generico.colecao.UtilColecao;
import br.com.politec.generico.excecao.UtilExcecao;
import br.com.politec.generico.fabrica.ColecaoFactory;
import br.com.politec.generico.objeto.UtilObjeto;
import br.com.politec.generico.string.UtilString;
import br.com.politec.reflexao.UtilReflexaoInvocarMetodo;
import br.com.politec.reflexao.UtilReflexaoMetodo;
import br.com.politec.reflexao.UtilReflexaoSet;
import br.com.politec.reflexao.exception.ReflexaoException;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.accessibility.AccessibleContext;
import javax.swing.JComboBox;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComboBoxListener
implements ActionListener,
KeyListener,
ItemListener,
FocusListener {
    private Map contexto;
    private ControlableView visao;
    private boolean upperCase = true;
    private boolean allChars = false;
    private int maxChars = 40;
    private JComboBox comboBox = null;
    public static final int SO_CHARACTER = 0;
    public static final int SO_NUMER0 = 1;
    public static final int SO_NUMERO_E_CARACTER = 2;
    private int tipo = 2;

    public ComboBoxListener(int maxChars, JComboBox comboBox) {
        this.setMaxChars(maxChars);
        this.comboBox = comboBox;
    }

    @Override
    public void keyPressed(KeyEvent evento) {
        if (this.maxCharsReached(evento.getSource()) && !this.ETeclaDeControle(evento.getKeyCode())) {
            evento.consume();
            return;
        }
        if (evento.getKeyCode() == 10) {
            KeyboardFocusManager.getCurrentKeyboardFocusManager().focusNextComponent();
            evento.consume();
            ActionEvent actionEvent = new ActionEvent(this.comboBox, 7714, "SELECTED");
            this.comboBox.actionPerformed(actionEvent);
            return;
        }
        if (evento.getKeyCode() == 32 || evento.getKeyCode() == 9) {
            this.processarEvento(evento);
        } else if ((evento.getKeyCode() == 38 || evento.getKeyCode() == 40) && this.comboBox != null) {
            evento.consume();
            ActionEvent actionEvent = new ActionEvent(this.comboBox, 7714, evento.getKeyCode() == 38 ? "SETA_ACIMA" : "SETA_ABAIXO");
            this.comboBox.actionPerformed(actionEvent);
        }
    }

    private boolean ETeclaDeControle(int keyCode) {
        switch (keyCode) {
            case 8: {
                break;
            }
            case 127: {
                break;
            }
            case 16: {
                break;
            }
            case 37: {
                break;
            }
            case 36: {
                break;
            }
            case 35: {
                break;
            }
            case 39: {
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    private void processarEvento(KeyEvent evento) {
        Component componente = this.getComponente(evento);
        IFormulario frame = this.getIFormulario(componente);
        PluginActionAbstrato action = this.getAction(componente);
        PluginFormAbstrato form = this.getForm(frame);
        this.fireAction(componente);
        this.processarCarregarForm(frame, form);
        this.processarPreExecucaoDaAcao(action, form);
        String visao = null;
        try {
            visao = this.processarExecutarAcao(componente, form);
            this.processarExecutarAcaoNaVisao(frame, componente);
        }
        catch (BBException e) {
            this.processarMensagemDeErro(frame, e);
            e.printStackTrace();
        }
        catch (Throwable e) {
            this.processarMensagemDeErro(frame, e);
            e.printStackTrace();
        }
    }

    private char getDB2Char(char c) {
        if (this.isAllChars()) {
            return c;
        }
        String allChars = "\u00e7\u00c7\u00f1\u00d1\u00c1\u00e1\u00e0\u00c0\u00c2\u00e2\u00e3\u00c3\u00c9\u00c8\u00ca\u00e9\u00e8\u00ea\u00d2\u00d3\u00d4\u00d5\u00f3\u00f2\u00f5\u00f4\u00cd\u00cc\u00ce\u00ed\u00ec\u00ee\u00d9\u00da\u00db\u00dc\u00fa\u00f9\u00fb\u00fc";
        String uppers = "CCNNAAAAAAAAEEEEEEOOOOOOOOIIIIIIUUUUUUUU";
        String normal = "cCnNAaaAAaaAEEEeeeOOOOooooIIIiiiUUUUuuuu";
        int i = 0;
        while (i < allChars.length()) {
            if (allChars.charAt(i) == c) {
                if (this.upperCase) {
                    return uppers.charAt(i);
                }
                return normal.charAt(i);
            }
            ++i;
        }
        if (this.upperCase) {
            return String.valueOf(c).toUpperCase().charAt(0);
        }
        return c;
    }

    private boolean maxCharsReached(Object obj) {
        if (obj instanceof Component) {
            BBJComboBoxImpl combo = (BBJComboBoxImpl)((Component)obj).getParent();
            return combo.getEditor().getItem().toString().length() >= combo.getMaxChars() + 1;
        }
        return false;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    private void fireAction(Component componente) {
        ActionEvent event = new ActionEvent(componente, 1, "ATUALIZANDO");
        ActionListener[] actionListenerArray = (ActionListener[])componente.getListeners(ActionListener.class);
        int n = actionListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            ActionListener listener = actionListenerArray[n2];
            listener.actionPerformed(event);
            ++n2;
        }
    }

    @Override
    public void itemStateChanged(ItemEvent evt) {
        block3: {
            block2: {
                if (evt.getStateChange() != 1) break block2;
                ActionEvent event = new ActionEvent(evt.getSource(), 1, "SELECTED");
                ActionListener[] actionListenerArray = (ActionListener[])((JComboBox)evt.getSource()).getListeners(ActionListener.class);
                int n = actionListenerArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ActionListener listener = actionListenerArray[n2];
                    listener.actionPerformed(event);
                    ++n2;
                }
                break block3;
            }
            if (evt.getStateChange() != 2) break block3;
            ActionEvent event = new ActionEvent(evt.getSource(), 1, "DESELECTED");
            ActionListener[] actionListenerArray = (ActionListener[])((JComboBox)evt.getSource()).getListeners(ActionListener.class);
            int n = actionListenerArray.length;
            int n3 = 0;
            while (n3 < n) {
                ActionListener listener = actionListenerArray[n3];
                listener.actionPerformed(event);
                ++n3;
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent evento) {
    }

    @Override
    public void keyTyped(KeyEvent evento) {
        if (this.maxCharsReached(evento.getSource())) {
            evento.consume();
            return;
        }
        switch (this.getTipo()) {
            case 1: {
                if (!this.ENumero(evento.getKeyChar())) {
                    evento.consume();
                }
            }
            case 0: {
                if (this.ECaracter(evento.getKeyChar())) break;
                evento.consume();
                break;
            }
            case 2: {
                if (this.ENumero(evento.getKeyChar()) || this.ECaracter(evento.getKeyChar())) break;
                evento.consume();
            }
        }
        evento.setKeyChar(this.getDB2Char(evento.getKeyChar()));
        this.tratarFormato(evento);
    }

    public boolean ENumero(char c) {
        String allNumbers = "0123456789";
        int i = 0;
        while (i < allNumbers.length()) {
            if (allNumbers.charAt(i) == c) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean ECaracter(char c) {
        String allUpperChars = " ABCDEFGHIJKLMNOPQRSTUVWYXZ";
        String allLowerChars = " abcdefghijklmnopqrstuvwyxz";
        int i = 0;
        while (i < allUpperChars.length()) {
            if (allUpperChars.charAt(i) == c) {
                return true;
            }
            ++i;
        }
        i = 0;
        while (i < allLowerChars.length()) {
            if (allLowerChars.charAt(i) == c) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected void tratarFormato(KeyEvent evento) {
        BBJComboBoxImpl combo = (BBJComboBoxImpl)((Component)evento.getSource()).getParent();
        if (combo.getEditor().getItem() instanceof String) {
            char[] charStr = ((String)combo.getEditor().getItem()).toCharArray();
            int len = charStr.length;
            if (this.maxChars > 0 && this.maxChars < len) {
                len = this.maxChars;
            }
            String str = new String(charStr, 0, len);
            if (this.upperCase) {
                str = str.toUpperCase();
            }
            combo.getEditor().setItem(str);
        }
    }

    protected void processarMensagemDeErro(IFormulario frame, BBException e) {
        BBJPopupMensagem.exibirMensagem(e.getMessage());
    }

    protected void processarMensagemDeErro(IFormulario frame, Throwable e) {
        String erro = UtilExcecao.getMensagem(e);
        String mensagem = UtilMensagem.getInstancia().getErroDeSistema(erro);
        BBJPopupMensagem.exibirMensagem(mensagem);
    }

    protected void processarExecutarAcaoNaVisao(IFormulario frame, Component componente) {
        PluginActionAbstrato action = this.getAction(componente);
        if (UtilObjeto.isReferencia(action)) {
            String metodo = this.getNomeDoMetodoDeAtualizacao(action);
            Class<?> classe = frame.getClass();
            try {
                if (UtilReflexaoMetodo.isExisteMetodo(classe, metodo)) {
                    UtilReflexaoInvocarMetodo.invocar((Object)frame, metodo);
                }
            }
            catch (ReflexaoException e) {
                Log.getInstance().logMsg(e);
            }
        }
    }

    protected String processarExecutarAcao(Component componente, PluginFormAbstrato form) throws BBException {
        String resultado = null;
        PluginActionAbstrato action = this.getAction(componente);
        if (UtilObjeto.isReferencia(action)) {
            resultado = action.executar(form);
        }
        return resultado;
    }

    protected void processarPreExecucaoDaAcao(PluginActionAbstrato action, PluginFormAbstrato form) {
        if (UtilObjeto.isReferencia(action)) {
            action.preExecutar(form);
        }
    }

    protected PluginActionAbstrato getAction(Component componente) {
        IAcao botao = (IAcao)((Object)componente.getParent());
        return botao.getAcao();
    }

    protected void processarCarregarForm(IFormulario frame, PluginFormAbstrato form) {
        Collection<Component> componentes = this.getComponentes((Component)((Object)frame));
        IFormularioEstrategiaSwingFactory factory = this.getFormularioEstrategiaSwingFactory();
        for (Component componente : componentes) {
            IFormularioEstrategiaSwing estrategia = factory.getEstrategia(componente);
            Object valor = estrategia.getValor(componente);
            try {
                String nome = componente.getName();
                if (UtilString.isVazio(nome)) continue;
                UtilReflexaoSet.set(form, nome, valor);
            }
            catch (ReflexaoException e) {
                Log.getInstance().logMsg(e);
            }
        }
    }

    protected PluginFormAbstrato getForm(IFormulario frame) {
        return frame.getForm();
    }

    protected IFormulario getIFormulario(Component componente) {
        Component resultado = null;
        if (this.isReferencia(componente)) {
            AccessibleContext ac = componente.getAccessibleContext();
            resultado = (Component)((Object)ac.getAccessibleParent());
            while (!UtilObjeto.isObjetoDoTipo(resultado, IFormulario.class)) {
                ac = resultado.getAccessibleContext();
                resultado = (Component)((Object)ac.getAccessibleParent());
            }
        }
        return (IFormulario)((Object)resultado);
    }

    protected Component getComponente(KeyEvent evento) {
        return (Component)evento.getSource();
    }

    protected Component getComponente(FocusEvent evento) {
        return (Component)evento.getSource();
    }

    protected Collection<Component> getComponentes(Component componente) {
        List colecao = this.getColecaoFactory().novoArrayList();
        if (this.isReferencia(componente)) {
            AccessibleContext ac = componente.getAccessibleContext();
            int i = 0;
            while (i < ac.getAccessibleChildrenCount() && this.isComponente(ac.getAccessibleChild(i))) {
                Component c = (Component)((Object)ac.getAccessibleChild(i));
                if (this.isObjetoDeFormulario(c)) {
                    colecao.add(c);
                } else {
                    colecao.addAll(this.getComponentes(c));
                }
                ++i;
            }
        }
        return colecao;
    }

    private boolean isComponente(Object objeto) {
        return UtilObjeto.isObjetoDoTipo(objeto, Component.class);
    }

    protected String getMensagensDaValidacao(PluginFormAbstrato form) {
        StringBuffer mensagem = new StringBuffer();
        if (UtilObjeto.isReferencia(form)) {
            Collection<ValidacaoBean> c = form.getColecaoMensagensDeValidacao();
            ValidacaoBean vb = (ValidacaoBean)UtilColecao.getElementoDoIndice(c, 0);
            mensagem.append(vb.getMensagem());
        }
        return mensagem.toString();
    }

    protected String getNomeDoMetodoDeAtualizacao(PluginActionAbstrato action) {
        StringBuffer metodo = new StringBuffer();
        metodo.append(this.getPrefixoNomeDoMetodoDeAtualizacao());
        metodo.append(UtilObjeto.getNomeSemPacote(action));
        return metodo.toString();
    }

    protected String getPrefixoNomeDoMetodoDeAtualizacao() {
        return "posExecucao";
    }

    protected boolean isValidado(PluginFormAbstrato form) {
        boolean validacao = true;
        if (this.isPermitirValidacaoDoFormulario(form)) {
            validacao = form.isValidado();
        }
        return validacao;
    }

    protected boolean isReferencia(Object objeto) {
        return UtilObjeto.isReferencia(objeto);
    }

    protected boolean isObjetoDeFormulario(Component componente) {
        return this.getFormularioEstrategiaSwingFactory().isExisteEstrategia(componente);
    }

    protected ColecaoFactory getColecaoFactory() {
        return ColecaoFactory.getInstance();
    }

    protected IFormularioEstrategiaSwingFactory getFormularioEstrategiaSwingFactory() {
        return PluginFormularioEstrategiaSwingFactory.getInstancia();
    }

    public void inicialize(Map context) {
        this.setContexto(context);
    }

    public void setControlableView(ControlableView visao) {
        this.setVisao(visao);
    }

    public Map getContexto() {
        return this.contexto;
    }

    public void setContexto(Map contexto) {
        this.contexto = contexto;
    }

    public ControlableView getVisao() {
        return this.visao;
    }

    public void setVisao(ControlableView visao) {
        this.visao = visao;
    }

    private boolean isPermitirValidacaoDoFormulario(PluginFormAbstrato form) {
        boolean permissao = false;
        if (this.isReferencia(form)) {
            permissao = form.isPermitirValidacao();
        }
        return permissao;
    }

    public boolean isAllChars() {
        return this.allChars;
    }

    public void setAllChars(boolean allChars) {
        this.allChars = allChars;
    }

    public boolean isUpperCase() {
        return this.upperCase;
    }

    public void setUpperCase(boolean upperCase) {
        this.upperCase = upperCase;
    }

    public int getMaxChars() {
        return this.maxChars;
    }

    public void setMaxChars(int maxChars) {
        this.maxChars = maxChars;
    }

    public int getTipo() {
        return this.tipo;
    }

    public void setTipo(int tipo) {
        this.tipo = tipo;
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent evento) {
        Component componente = this.getComponente(evento);
        IFormulario frame = this.getIFormulario(componente);
        PluginActionAbstrato action = this.getAction(componente);
        PluginFormAbstrato form = this.getForm(frame);
        this.fireAction(componente);
        this.processarCarregarForm(frame, form);
        this.processarPreExecucaoDaAcao(action, form);
        String visao = null;
        try {
            visao = this.processarExecutarAcao(componente, form);
            this.processarExecutarAcaoNaVisao(frame, componente);
        }
        catch (BBException e) {
            this.processarMensagemDeErro(frame, e);
            e.printStackTrace();
        }
        catch (Throwable e) {
            this.processarMensagemDeErro(frame, e);
            e.printStackTrace();
        }
    }
}

