/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.util.swing.menu;

import br.com.bb.plugins.gac.util.interceptor.ConfiguracaoDaAuditoria;
import br.com.bb.plugins.gac.util.swing.componente.BBJEstilos;
import br.com.bb.plugins.gac.util.swing.componente.BBJHyperLink;
import br.com.bb.plugins.gac.util.swing.menu.BBJMenu;
import br.com.bb.plugins.gac.util.swing.menu.BBJMenuBar;
import br.com.bb.plugins.gac.util.swing.menu.BBJMenuItem;
import br.com.politec.generico.colecao.UtilColecao;
import br.com.politec.generico.objeto.UtilObjeto;
import br.com.politec.generico.string.UtilString;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BBJBarraMenu
extends JPanel {
    private ActionListener listener;
    private String imageFundoMenu = null;
    private String imageFundoDivisoria = null;
    private String imageFundoMenuSair = null;
    private BBJMenuBar mBar = null;
    private ImageIcon imgFundo = null;
    private ImageIcon imgDivisoria = null;
    private ImageIcon imgFundoMenuSair = null;
    private Map<String, BBJMenuItem> itensmenu = null;
    private BBJHyperLink lblSair = null;
    private int tamanhomenu = 750;

    public Map<String, BBJMenuItem> getItensmenu() {
        return this.itensmenu;
    }

    public void setItensmenu(Map<String, BBJMenuItem> itensmenu) {
        this.itensmenu = itensmenu;
        this.tamanhomenu = this.getTamanhoBarraMenu();
        this.setMenuSize();
    }

    public BBJBarraMenu() {
        this("/images/fundoAzulTesteira.jpg", "/images/img_linha_top_curva_menu.gif", "/images/fundoAzulClaroTesteira.jpg");
    }

    public BBJBarraMenu(String imageFundoMenu, String imageFundoDivisoria, String imageFundoMenuSair) {
        this.imageFundoMenu = imageFundoMenu;
        this.imageFundoDivisoria = imageFundoDivisoria;
        this.imageFundoMenuSair = imageFundoMenuSair;
        this.imgFundo = this.getImageIcon(this.imageFundoMenu);
        this.imgDivisoria = this.getImageIcon(this.imageFundoDivisoria);
        this.imgFundoMenuSair = this.getImageIcon(this.imageFundoMenuSair);
        this.setPreferredSize(new Dimension(150, 27));
        this.setMaximumSize(new Dimension(10000, 27));
        this.setLayout(new BoxLayout(this, 0));
        this.add(Box.createHorizontalStrut(120), 0);
        this.tamanhomenu = this.getTamanhoBarraMenu();
        this.add(this.getMBar());
        this.add(Box.createRigidArea(new Dimension(35, 5)));
        this.add(this.getBBHSair());
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        Dimension dim = this.getSize();
        int icnt = 0;
        if (this.imgFundo != null && this.imgFundo.getIconWidth() > 0) {
            while (icnt < this.tamanhomenu) {
                g.drawImage(this.imgFundo.getImage(), icnt, 0, null, null);
                icnt += this.imgFundo.getIconWidth();
            }
        }
        if (this.imgDivisoria != null && this.imgDivisoria.getIconWidth() > 0) {
            g.drawImage(this.imgDivisoria.getImage(), icnt, 0, null, null);
            icnt += this.imgDivisoria.getIconWidth();
        }
        if (this.imgFundoMenuSair != null && this.imgFundoMenuSair.getIconWidth() > 0) {
            while (icnt < dim.width) {
                g.drawImage(this.imgFundoMenuSair.getImage(), icnt, 0, null, null);
                icnt += this.imgFundoMenuSair.getIconWidth();
            }
        }
        super.paintChildren(g);
    }

    private void setMenuSize() {
        this.getMBar().setSize(this.tamanhomenu - 130);
    }

    private int getTamanhoBarraMenu() {
        Iterator<BBJMenuItem> itr;
        int icnt = 750;
        if (this.itensmenu != null && (itr = this.itensmenu.values().iterator()) != null) {
            icnt = 0;
            while (itr.hasNext()) {
                BBJMenuItem mnu = itr.next();
                icnt += this.getTextWidth(BBJEstilos.TEXTOMENUPRINCIPAL.getFont(), mnu.getTexto());
                icnt += 37;
            }
        }
        return icnt;
    }

    private int getTextWidth(Font fnt, String texto) {
        FontRenderContext frc = new FontRenderContext(null, true, false);
        Rectangle2D bounds = fnt.getStringBounds(texto, frc);
        return (int)bounds.getWidth();
    }

    public void LoadMenus() {
        Iterator<BBJMenuItem> itr = this.itensmenu.values().iterator();
        this.MontaMenu(this.getMBar(), null, itr);
    }

    public String getImageFundoMenu() {
        return this.imageFundoMenu;
    }

    public void setImageFundoMenu(String imageFundoMenu) {
        this.imageFundoMenu = imageFundoMenu;
    }

    public String getImageFundoMenuSair() {
        return this.imageFundoMenuSair;
    }

    public void setImageFundoMenuSair(String imageFundoMenuSair) {
        this.imageFundoMenuSair = imageFundoMenuSair;
    }

    public String getImageFundoDivisoria() {
        return this.imageFundoDivisoria;
    }

    public void setImageFundoDivisoria(String imageFundoDivisoria) {
        this.imageFundoDivisoria = imageFundoDivisoria;
    }

    private BBJMenuBar getMBar() {
        if (this.mBar == null) {
            this.mBar = new BBJMenuBar();
        }
        return this.mBar;
    }

    private BBJHyperLink getBBHSair() {
        if (this.lblSair == null) {
            this.lblSair = new BBJHyperLink("Sair");
            this.lblSair.setName("BOTAOSAIR");
            this.lblSair.setFont(BBJEstilos.TEXTOBOTAOSAIR.getFont());
            this.lblSair.setForeground(BBJEstilos.TEXTOBOTAOSAIR.getColor());
            this.lblSair.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    BBJBarraMenu.this.fireAction(e);
                }
            });
        }
        return this.lblSair;
    }

    private void MontaMenu(BBJMenuBar barraMenu, BBJMenu bbmenu, Iterator<BBJMenuItem> itr) {
        if (itr == null) {
            return;
        }
        int icntmnu = 0;
        while (itr.hasNext()) {
            BBJMenuItem mnu = itr.next();
            mnu.setBackground(this.getMBar().getBackground());
            if (mnu.getSubmenus() != null && !mnu.getSubmenus().isEmpty()) {
                BBJMenu menu = new BBJMenu(mnu.getTexto(), bbmenu == null);
                menu.setBackground(this.getMBar().getBackground());
                if (bbmenu == null) {
                    if (icntmnu > 0) {
                        JPanel sep = new JPanel();
                        sep.setBackground(Color.WHITE);
                        sep.setMaximumSize(new Dimension(1, 10));
                        sep.setPreferredSize(new Dimension(1, 10));
                        barraMenu.add(sep);
                    }
                    menu.setMenuprincipal(true);
                    barraMenu.add(menu);
                    ++icntmnu;
                } else {
                    menu.setFocusable(false);
                    menu.setCursor(Cursor.getPredefinedCursor(12));
                    bbmenu.add(menu);
                }
                this.MontaMenu(barraMenu, menu, mnu.getSubmenus().values().iterator());
                continue;
            }
            if (mnu.isSeparator()) {
                if (bbmenu == null) continue;
                bbmenu.addSeparator();
                continue;
            }
            mnu.setFocusable(false);
            mnu.setCursor(Cursor.getPredefinedCursor(12));
            mnu.setBackground(this.getMBar().getBackground());
            mnu.setMenuText();
            mnu.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    BBJBarraMenu.this.fireAction(e);
                }
            });
            if (bbmenu == null) {
                barraMenu.add(mnu);
                continue;
            }
            bbmenu.add(mnu);
        }
    }

    public void addActionListener(ActionListener listener) {
        this.listener = listener;
    }

    public void fireAction(ActionEvent event) {
        if (this.listener != null) {
            this.adicionarCodigoParaAuditoria(event.getSource());
            this.listener.actionPerformed(event);
        }
    }

    private void adicionarCodigoParaAuditoria(Object objeto) {
        if (UtilObjeto.isObjetoDoTipo(objeto, BBJMenuItem.class)) {
            BBJMenuItem menu = (BBJMenuItem)objeto;
            String codigo = menu.getCodigoAuditoria();
            if (UtilString.isTemString(codigo, "#")) {
                List lista = UtilString.split(codigo, "#");
                String servico = (String)UtilColecao.getElementoDoIndice(lista, 0);
                String itemMenu = (String)UtilColecao.getElementoDoIndice(lista, 1);
                this.getConfiguracaoDaAuditoria().setTextoIdentificadorServico(servico);
                this.getConfiguracaoDaAuditoria().setTextoCodigoOpcaoMenu(itemMenu);
            } else {
                this.getConfiguracaoDaAuditoria().setTextoCodigoOpcaoMenu(codigo);
            }
        }
    }

    private ConfiguracaoDaAuditoria getConfiguracaoDaAuditoria() {
        return ConfiguracaoDaAuditoria.getInstancia();
    }

    private ImageIcon getImageIcon(String image) {
        if (image == null || image.trim().length() == 0) {
            return null;
        }
        return new ImageIcon(this.getClass().getResource(image));
    }
}

