/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.util.swing.menu;

import br.com.bb.plugins.gac.util.interceptor.ConfiguracaoDaAuditoria;
import br.com.bb.plugins.gac.util.swing.BBJBordaOval;
import br.com.bb.plugins.gac.util.swing.menu.ItemMenuServicoBean;
import br.com.bb.plugins.gac.util.view.UtilPluginEmbutido;
import br.com.politec.generico.objeto.UtilObjeto;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.BoxLayout;
import javax.swing.JPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BBJMenuLateral
extends JPanel
implements ActionListener {
    private JPanel jpbotoes = null;
    private Map<String, ItemMenuServicoBean> servicos;
    private ActionListener listener = null;
    private String aplicacao;
    private ItemMenuServicoBean objAtivo = null;
    private ItemMenuServicoBean objAtivoAnterior = null;

    public Map<String, ItemMenuServicoBean> getServicos() {
        return this.servicos;
    }

    public void setServicos(Map<String, ItemMenuServicoBean> servicos) {
        this.servicos = servicos;
    }

    public BBJMenuLateral() {
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.setBackground(Color.WHITE);
        JPanel panel = new JPanel();
        panel.setBackground(Color.WHITE);
        panel.setLayout(new BorderLayout());
        panel.add((Component)this.getPainelBotoes(), "North");
        this.add((Component)panel, "North");
        panel.setBorder(BBJBordaOval.createOvalBorder());
    }

    public JPanel getPainelBotoes() {
        if (this.jpbotoes == null) {
            this.jpbotoes = new JPanel();
            this.jpbotoes.setLayout(new BoxLayout(this.jpbotoes, 3));
            this.jpbotoes.setBackground(Color.WHITE);
        }
        return this.jpbotoes;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object obj = e.getSource();
        if (obj instanceof ItemMenuServicoBean) {
            ItemMenuServicoBean defserv = (ItemMenuServicoBean)obj;
            if (defserv.hasChildren()) {
                this.fechaMenusBaseExcetoOSelecionado(defserv, this.servicos.values().iterator());
                defserv.ShowOrHide();
                this.ResizeParent();
            } else {
                if (this.objAtivo == defserv) {
                    return;
                }
                if (this.objAtivo != null) {
                    this.objAtivo.setClicado(false);
                }
                this.objAtivoAnterior = this.objAtivo;
                this.objAtivo = defserv;
                if (this.objAtivo != null && !this.objAtivo.hasChildren()) {
                    this.objAtivo.setClicado(true);
                    this.fireAction(defserv.getBeanid());
                }
            }
        }
    }

    private void fechaMenusBaseExcetoOSelecionado(ItemMenuServicoBean defserv, Iterator<ItemMenuServicoBean> iterator) {
        while (iterator.hasNext()) {
            ItemMenuServicoBean itemMenuServicoBean = iterator.next();
            if (defserv.getTxIdfrSrvc().equals(itemMenuServicoBean.getTxIdfrSrvc()) || !itemMenuServicoBean.hasChildren()) continue;
            itemMenuServicoBean.setExpanded(false);
            itemMenuServicoBean.HideChildren();
        }
    }

    public void ResizeParent() {
        if (this.getParent() instanceof JPanel) {
            JPanel parent = (JPanel)this.getParent();
            Dimension size = new Dimension((int)parent.getPreferredSize().getWidth(), this.getAlturaVisible() + 22);
            parent.setPreferredSize(size);
        }
    }

    private int getAlturaVisible() {
        return this.getAlturaVisible(this.servicos.values().iterator());
    }

    private int getAlturaVisible(Iterator<ItemMenuServicoBean> itr) {
        int i_altura = 0;
        while (itr.hasNext()) {
            ItemMenuServicoBean defserv = itr.next();
            if (!defserv.isVisible()) continue;
            if (defserv.hasChildren()) {
                i_altura += this.getAlturaVisible(defserv.getChildren().values().iterator());
            }
            i_altura += this.getAlturaMenu(defserv.getTxDcr()) + 1;
        }
        return i_altura;
    }

    public void RemoveClicado() {
        if (this.objAtivo != null) {
            this.objAtivo.setClicado(false);
            this.objAtivo.repaint();
            this.objAtivo = null;
        }
    }

    public void SelecionaItemMenu(String viewName) {
        if (this.servicos == null || this.servicos.values() == null) {
            return;
        }
        ItemMenuServicoBean itemserv = this.getMenuByName(viewName, this.servicos.values().iterator());
        if (itemserv != null) {
            this.objAtivo = itemserv;
            this.objAtivo.setClicado(true);
            this.objAtivo.repaint();
        }
    }

    private ItemMenuServicoBean getMenuByName(String viewName, Iterator<ItemMenuServicoBean> itr) {
        while (itr.hasNext()) {
            ItemMenuServicoBean defserv = itr.next();
            if (defserv.hasChildren()) {
                ItemMenuServicoBean itemserv = this.getMenuByName(viewName, defserv.getChildren().values().iterator());
                if (itemserv == null) continue;
                return itemserv;
            }
            if (!defserv.getBeanid().equals(viewName)) continue;
            return defserv;
        }
        return null;
    }

    public void VoltaClicadoAnterior() {
        this.RemoveClicado();
        if (this.objAtivoAnterior != null) {
            this.objAtivo = this.objAtivoAnterior;
            this.objAtivo.setClicado(true);
            this.objAtivo.repaint();
            this.objAtivoAnterior = null;
        }
    }

    public void LoadServicos() {
        this.getPainelBotoes().removeAll();
        this.objAtivo = null;
        this.MontaBarra(1, this.servicos.values().iterator());
        this.fechaMenusBase(this.servicos.values().iterator());
        this.getPainelBotoes().updateUI();
    }

    private void MontaBarra(int nivel, Iterator<ItemMenuServicoBean> itr) {
        while (itr.hasNext()) {
            ItemMenuServicoBean defserv = itr.next();
            if (defserv.getNomeDoPluginEmbutido() == null) {
                this.montaMenuLateral(nivel, defserv);
                continue;
            }
            if (defserv.getNomeDoPluginEmbutido().equalsIgnoreCase(UtilPluginEmbutido.busca(this.getAplicacao()))) {
                this.montaMenuLateral(nivel, defserv);
                continue;
            }
            if (UtilPluginEmbutido.busca(this.getAplicacao()) != null || !defserv.getNomeDoPluginEmbutido().equalsIgnoreCase(this.getAplicacao())) continue;
            this.montaMenuLateral(nivel, defserv);
        }
    }

    private void montaMenuLateral(int nivel, ItemMenuServicoBean defserv) {
        defserv.setExpanded(true);
        if (defserv.getNivel() != nivel) {
            defserv.setNivel(nivel, defserv.hasChildren());
        }
        defserv.setSize(new Dimension(500, this.getAlturaMenu(defserv.getTxDcr())));
        defserv.setVisible(nivel == 1);
        defserv.setClicado(false);
        if (!defserv.isAddlistener()) {
            defserv.addActionListener(this);
            defserv.setAddlistener(true);
        }
        this.getPainelBotoes().add(defserv);
        if (defserv.hasChildren()) {
            this.MontaBarra(nivel + 1, defserv.getChildren().values().iterator());
        }
    }

    public int getAlturaMenu(String titulo) {
        int altura = 22;
        StringTokenizer tkn = new StringTokenizer(titulo, "|");
        String texot = tkn.nextToken();
        while (tkn.hasMoreTokens() && (texot = tkn.nextToken()) != null) {
            altura += 15;
        }
        return altura;
    }

    private void AbreMenusBase(Iterator<ItemMenuServicoBean> itr) {
        while (itr.hasNext()) {
            ItemMenuServicoBean defserv = itr.next();
            if (!defserv.hasChildren()) continue;
            defserv.setExpanded(true);
            defserv.ShowChildren();
        }
    }

    private void fechaMenusBase(Iterator<ItemMenuServicoBean> itr) {
        while (itr.hasNext()) {
            ItemMenuServicoBean defserv = itr.next();
            if (!defserv.hasChildren()) continue;
            defserv.setExpanded(false);
            defserv.HideChildren();
        }
    }

    public void addActionListener(ActionListener listener) {
        this.listener = listener;
    }

    public void fireAction(String command) {
        ActionEvent evt = new ActionEvent(this, 1025, command);
        this.fireAction(evt);
    }

    public void fireAction(ActionEvent event) {
        if (this.listener != null) {
            this.listener.actionPerformed(event);
            this.adicionarCodigoParaAuditoria(event.getSource());
        }
    }

    private void adicionarCodigoParaAuditoria(Object objeto) {
        if (UtilObjeto.isObjetoDoTipo(objeto, BBJMenuLateral.class)) {
            BBJMenuLateral aba = (BBJMenuLateral)objeto;
            ItemMenuServicoBean item = aba.objAtivo;
            String codigo = item != null ? item.getCodigoAuditoria() : null;
            this.getConfiguracaoDaAuditoria().setTextoCodigoOpcaoMenu(codigo);
        }
    }

    private ConfiguracaoDaAuditoria getConfiguracaoDaAuditoria() {
        return ConfiguracaoDaAuditoria.getInstancia();
    }

    public String getAplicacao() {
        if (this.aplicacao == null) {
            return "";
        }
        return this.aplicacao;
    }

    public void setAplicacao(String aplicacao) {
        this.aplicacao = aplicacao;
    }

    public ItemMenuServicoBean getObjAtivo() {
        return this.objAtivo;
    }
}

