/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.util.swing.menu;

import br.com.bb.plugins.gac.util.swing.componente.BBJEstilos;
import br.com.bb.plugins.gac.util.swing.componente.BBJHyperLink;
import br.com.bb.plugins.gac.util.swing.menu.Pilha;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class BBJMigalha
extends JPanel
implements Pilha,
ActionListener {
    private BBJHyperLink[] objPilha;
    private int topo = -1;
    private ActionListener listener = null;
    private JLabel nomeAplicacao = null;
    private String tituloAplicacao = "";
    private String _auxTituloAplicacao = "";
    private static BBJMigalha instance = null;
    public static String BBGAC = "BB Gest\u00e3oMax";
    private MyLabel labelSep = null;

    public static BBJMigalha getInstance() {
        if (instance == null) {
            instance = new BBJMigalha(20);
        }
        return instance;
    }

    private BBJMigalha(int tam) {
        this.objPilha = new BBJHyperLink[tam];
        this.initComponents();
    }

    private void initComponents() {
        BoxLayout layout = new BoxLayout(this, 0);
        this.setLayout(layout);
        this.setForeground(BBJEstilos.TEXTOMIGALHA.getColor());
        this.setBackground(BBJEstilos.TEXTOMIGALHA.getBackcolor());
        this.setFont(BBJEstilos.TEXTOMIGALHA.getFont());
        this.add(Box.createHorizontalStrut(15), 0);
        JLabel nomeGAC = new JLabel(BBGAC);
        nomeGAC.setFont(BBJEstilos.TEXTOMIGALHA.getFont());
        nomeGAC.setForeground(BBJEstilos.TEXTOMIGALHA.getColor());
        nomeGAC.setBackground(BBJEstilos.TEXTOMIGALHA.getBackcolor());
        this.add(nomeGAC);
        this.add(this.getLbelSep());
        this.add(this.getNomeAplicacao());
    }

    private MyLabel getLbelSep() {
        if (this.labelSep == null) {
            this.labelSep = new MyLabel();
            this.labelSep.setVisible(false);
        }
        return this.labelSep;
    }

    public JLabel getNomeAplicacao() {
        if (this.nomeAplicacao == null) {
            this.nomeAplicacao = new JLabel(this.removerQuebraLinha(this.tituloAplicacao));
            this.nomeAplicacao.setFont(BBJEstilos.TEXTOMIGALHA.getFont());
            this.nomeAplicacao.setForeground(BBJEstilos.TEXTOMIGALHA.getColor());
            this.nomeAplicacao.setBackground(BBJEstilos.TEXTOMIGALHA.getBackcolor());
            this.nomeAplicacao.setVisible(false);
        }
        return this.nomeAplicacao;
    }

    private String removerQuebraLinha(String tituloAplicacao) {
        if (tituloAplicacao == null || tituloAplicacao.length() == 0) {
            return tituloAplicacao;
        }
        String retorno = tituloAplicacao;
        int posicChar = retorno.indexOf("|");
        while (posicChar > -1) {
            retorno = String.valueOf(retorno.substring(0, posicChar)) + retorno.substring(posicChar + 1);
            posicChar = retorno.indexOf("|");
        }
        return retorno;
    }

    public void setNomeAplicacao(String tituloapp) {
        this.tituloAplicacao = tituloapp;
        this.getLbelSep().setVisible(tituloapp != null && tituloapp.length() > 0 && !tituloapp.equals(BBGAC));
        this.getLbelSep().updateUI();
        if (this.tituloAplicacao.equals(BBGAC)) {
            this.getNomeAplicacao().setText("");
        } else {
            this.getNomeAplicacao().setText(tituloapp);
        }
        this.getNomeAplicacao().setVisible(tituloapp != null && tituloapp.length() > 0);
        this.getNomeAplicacao().updateUI();
    }

    public void MontarLinks() {
        this.MontarLinks(this);
    }

    private void MontarLinks(JPanel pnl) {
        this.removeAll();
        if (this.topo >= 0) {
            pnl.add(new MyLabel());
        }
        int icnt = 0;
        while (icnt <= this.topo && icnt < 20) {
            boolean ativo;
            boolean bl = ativo = icnt != this.topo && this.objPilha[icnt].getViewName().length() > 0;
            if (ativo) {
                this.objPilha[icnt].addActionListener(this);
            } else {
                this.objPilha[icnt].addActionListener(null);
            }
            this.objPilha[icnt].setFont(this.getFont());
            this.objPilha[icnt].setForeground(this.getForeground());
            this.objPilha[icnt].setBackground(this.getBackground());
            this.objPilha[icnt].setAtivo(ativo);
            this.objPilha[icnt].setSublinhado(ativo);
            this.objPilha[icnt].validate();
            this.objPilha[icnt].updateUI();
            pnl.add(this.objPilha[icnt]);
            if (icnt != this.topo) {
                pnl.add(new MyLabel());
            }
            ++icnt;
        }
        this.updateUI();
        this.validate();
    }

    public void trocarLabelTopo(String titulo) {
        try {
            if (this.Topo() != null) {
                this.Topo().setViewText(this.removerQuebraLinha(titulo));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.MontarLinks();
    }

    public void limparPilha() {
        try {
            while (!this.EstaVazia()) {
                this.Retirar();
            }
        }
        catch (Exception e) {
            System.out.println("Erro (BBMigalha.limparPilha): " + e.getMessage());
        }
        this.updateUI();
    }

    public BBJHyperLink Retirar() throws Exception {
        if (this.EstaVazia()) {
            throw new Exception(" Pilha vazia ");
        }
        BBJHyperLink temp = this.objPilha[this.topo];
        this.objPilha[this.topo] = null;
        --this.topo;
        this.MontarLinks(this);
        return temp;
    }

    public void Colocar(BBJHyperLink o) throws Exception {
        if (o.getViewText() == null) {
            return;
        }
        if (this.topo >= this.objPilha.length - 1) {
            throw new Exception(" Topo da pilha alcan\u00e7ado ");
        }
        ++this.topo;
        this.objPilha[this.topo] = o;
        this.MontarLinks(this);
    }

    public void removeAll() {
        int icnt = this.getComponentCount() - 1;
        while (icnt >= 4) {
            this.remove(this.getComponent(icnt));
            --icnt;
        }
    }

    public boolean EstaVazia() {
        return this.topo < 0;
    }

    public int Tamanho() {
        return this.topo + 1;
    }

    public BBJHyperLink Topo() throws Exception {
        if (this.EstaVazia()) {
            return null;
        }
        this.MontarLinks(this);
        return this.objPilha[this.topo];
    }

    public void Empilhar(String viewName, String viewTitulo) {
        try {
            this.Colocar(new BBJHyperLink(this.removerQuebraLinha(viewTitulo), viewName));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void Desempilhar() {
        try {
            if (this.topo >= 0) {
                this.Retirar();
                while (this.topo >= 0 && this.objPilha[this.topo] != null && this.objPilha[this.topo].getViewName().trim().length() == 0) {
                    this.Retirar();
                }
            }
            if (this.topo >= 0) {
                if (this.objPilha[this.topo] != null) {
                    this.fireAction("GOTOVIEW:" + this.objPilha[this.topo].getViewName());
                }
            } else {
                this.fireAction("GOTOPRINCIPAL:");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void Esvaziar() {
        this.Esvaziar(0);
    }

    public void Esvaziar(int iposini) {
        int icnt = iposini;
        while (icnt <= this.topo && icnt < 20) {
            this.objPilha[icnt] = null;
            ++icnt;
        }
        this.topo = iposini - 1;
    }

    public void actionPerformed(ActionEvent e) {
        Object obj = e.getSource();
        if (obj instanceof BBJHyperLink) {
            this.DesempilhaApos(((BBJHyperLink)obj).getViewName());
        }
    }

    public boolean LinkAberto(String s_id) {
        return false;
    }

    private void DesempilhaApos(String s_id) {
        try {
            while (this.topo >= 0) {
                if (s_id.equals(this.objPilha[this.topo].getViewName())) break;
                this.Retirar();
            }
            this.MontarLinks();
            this.fireAction("GOTOLINK:" + s_id);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void DesempilhaTodos() {
        this.topo = -1;
    }

    public void addActionListener(ActionListener listener) {
        this.listener = listener;
    }

    public void fireAction(String command) {
        ActionEvent evt = new ActionEvent(this, 2008, command);
        this.fireAction(evt);
    }

    public void fireAction(ActionEvent event) {
        if (this.listener != null && event != null) {
            this.listener.actionPerformed(event);
        }
    }

    class MyLabel
    extends JComponent {
        private ImageIcon imgSeta = new ImageIcon(this.getClass().getResource("/images/imgSetaLocalizacao.gif"));

        public MyLabel() {
            this.setPreferredSize(new Dimension(18, 14));
        }

        public void paint(Graphics g) {
            super.paint(g);
            g.drawImage(this.imgSeta.getImage(), 5, (int)(this.getSize().getHeight() - 16.0), null, null);
        }
    }
}

