/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.util.view;

import br.com.bb.plugins.gac.negocio.to.PluginTOAbstrato;
import br.com.bb.plugins.gac.util.swing.componente.BBJEstilos;
import br.com.bb.plugins.gac.util.view.ItemPermissao;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JButton;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BBJBarraItemPermissao
extends JButton
implements MouseListener,
ItemPermissao,
FocusListener,
KeyListener {
    private String id;
    private String texto;
    private String beanid;
    private String tipo;
    private boolean expanded = false;
    private boolean addlistener = false;
    private boolean marcado = false;
    private int nivel;
    private BBJEstilos estilo;
    private Map<String, ItemPermissao> children;
    private ImageIcon imgIconeDesabilitado = null;
    private ImageIcon imgIconeNormal = null;
    private ImageIcon imgIconeNormalComFoco = null;
    private ImageIcon imgIconeExpandido = null;
    private ImageIcon imgIconeExpandidoComFoco = null;
    private boolean focoNoObjeto = false;

    public BBJBarraItemPermissao() {
        this.initialize();
    }

    public BBJBarraItemPermissao(String codigo, String descricao) {
        this.id = codigo;
        this.texto = descricao;
        this.initialize();
    }

    private void initialize() {
        this.estilo = BBJEstilos.TEXTOBARRALATERAL;
        this.setFocusable(true);
        this.setVisible(true);
        this.setRolloverEnabled(false);
        this.setAlignmentX(8.0f);
        this.setCursor(Cursor.getPredefinedCursor(12));
        this.setHorizontalAlignment(2);
        this.setBorder(null);
        this.imgIconeDesabilitado = this.getImageIcon("/images/btDesabilitado.gif");
        this.imgIconeNormal = this.getImageIcon("/images/btMais.gif");
        this.imgIconeNormalComFoco = this.getImageIcon("/images/btMais_Focus.gif");
        this.imgIconeExpandido = this.getImageIcon("/images/btMenos.gif");
        this.imgIconeExpandidoComFoco = this.getImageIcon("/images/btMenos_Focus.gif");
        this.addMouseListener(this);
        this.setFocusPainted(true);
        this.addKeyListener(this);
        this.addFocusListener(this);
    }

    @Override
    public void setSize(Dimension dim) {
        this.setMinimumSize(dim);
        this.setMaximumSize(dim);
        this.setPreferredSize(dim);
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        Font fnt = this.estilo.getFont();
        g.setColor(new Color(225, 225, 225));
        if (this.isEnabled()) {
            ImageIcon icone;
            ImageIcon imageIcon = icone = this.isExpanded() ? this.imgIconeExpandido : this.imgIconeNormal;
            if (this.focoNoObjeto) {
                icone = this.isExpanded() ? this.imgIconeExpandidoComFoco : this.imgIconeNormalComFoco;
            }
            g.drawImage(icone.getImage(), 1 + 7 * this.nivel, 1, null, null);
        } else {
            g.drawImage(this.imgIconeDesabilitado.getImage(), 1 + 7 * this.nivel, 1, null, null);
        }
        g.setColor(this.estilo.getColor());
        g.setFont(fnt);
        int posicx = 20 + this.nivel * 7;
        g.drawString(this.texto, posicx, 15);
    }

    @Override
    public void addChild(ItemPermissao child) {
        if (this.children == null) {
            this.children = new LinkedHashMap<String, ItemPermissao>();
        }
        this.children.put(child.getId(), child);
    }

    @Override
    public void HideChildren() {
        if (this.children != null) {
            this.HideChildren(this.children.values().iterator());
        }
    }

    private void HideChildren(Iterator<ItemPermissao> itr) {
        while (itr.hasNext()) {
            ItemPermissao imsbean = itr.next();
            imsbean.setVisible(false);
            if (!imsbean.hasChildren()) continue;
            if (imsbean.getNivel() > 1) {
                imsbean.setExpanded(false);
            }
            this.HideChildren(imsbean.getChildren().values().iterator());
        }
    }

    @Override
    public void ShowChildren() {
        if (this.children != null) {
            this.ShowChildren(this.children.values().iterator());
        }
    }

    private void ShowChildren(Iterator<ItemPermissao> itr) {
        while (itr.hasNext()) {
            ItemPermissao imsbean = itr.next();
            imsbean.setVisible(true);
            imsbean.validate();
        }
    }

    @Override
    public void ShowOrHide() {
        if (this.expanded) {
            this.HideChildren();
        } else {
            this.ShowChildren();
        }
        this.expanded = !this.expanded;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String codigo) {
        this.id = codigo;
    }

    @Override
    public String getTexto() {
        return this.texto;
    }

    @Override
    public void setTexto(String descricao) {
        this.texto = descricao;
    }

    @Override
    public Map<String, ItemPermissao> getChildren() {
        if (this.children == null) {
            this.children = new LinkedHashMap<String, ItemPermissao>();
        }
        return this.children;
    }

    public void setChildren(Map<String, ItemPermissao> children) {
        this.children = children;
    }

    @Override
    public boolean hasChildren() {
        return this.children != null && this.children.size() > 0;
    }

    public String getBeanid() {
        if (this.beanid == null) {
            return this.texto;
        }
        return this.beanid;
    }

    public void setBeanid(String beanid) {
        this.beanid = beanid;
    }

    public String getTipo() {
        return this.tipo;
    }

    public void setTipo(String tipo) {
        this.tipo = tipo;
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    @Override
    public void setExpanded(boolean expanded) {
        this.expanded = expanded;
    }

    public boolean isAddlistener() {
        return this.addlistener;
    }

    public void setAddlistener(boolean addlistener) {
        this.addlistener = addlistener;
    }

    @Override
    public int getNivel() {
        return this.nivel;
    }

    @Override
    public void setNivel(int nivel) {
        this.setNivel(nivel, false);
    }

    @Override
    public void setNivel(int nivel, boolean haschild) {
        this.nivel = nivel;
        switch (this.nivel) {
            case 1: {
                this.setBackground(this.hasChildren() ? new Color(215, 229, 238) : new Color(245, 245, 245));
                break;
            }
            default: {
                this.setBackground(new Color(235, 248, 255));
            }
        }
    }

    public BBJEstilos getEstilo() {
        return this.estilo;
    }

    public void setEstilo(BBJEstilos estilo) {
        this.estilo = estilo;
    }

    private ImageIcon getImageIcon(String image) {
        if (image == null || image.trim().length() == 0) {
            return null;
        }
        return new ImageIcon(this.getClass().getResource(image));
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public PluginTOAbstrato getPluginTOAbstrato() {
        return null;
    }

    @Override
    public boolean isMarcado() {
        return this.marcado;
    }

    @Override
    public void setMarcado(boolean marcado) {
        this.marcado = marcado;
    }

    @Override
    public boolean isInativo() {
        return false;
    }

    @Override
    public void setInativo(boolean inativo) {
    }

    @Override
    public void focusGained(FocusEvent e) {
        this.focoNoObjeto = true;
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.focoNoObjeto = false;
    }

    @Override
    public void keyPressed(KeyEvent evento) {
        if (evento.getKeyCode() == 10) {
            ActionEvent evt = new ActionEvent(evento.getSource(), 2008, "");
            if (this.getActionListeners() != null && this.getActionListeners().length > 0) {
                this.getActionListeners()[0].actionPerformed(evt);
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent evento) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public boolean hasChildrenComTexto() {
        if (this.children == null || this.children.size() == 0) {
            return false;
        }
        for (ItemPermissao itemPermissao : this.children.values()) {
            if (itemPermissao.getTexto() == null || itemPermissao.getTexto().trim().length() <= 0) continue;
            return true;
        }
        return false;
    }
}

