/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.util.view;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;

public class ScrollablePanel
extends JPanel
implements Scrollable {
    private static JScrollPane scroller;
    private static ScrollablePanel sp;

    public ScrollablePanel() {
        this(0);
    }

    public ScrollablePanel(int flowLayoutType) {
        super(new FlowLayout(flowLayoutType));
    }

    public ScrollablePanel(int flowLayoutType, int hgap, int vgap) {
        super(new FlowLayout(flowLayoutType, hgap, vgap));
    }

    public Dimension getPreferredSize() {
        if (this.getParent() == null) {
            return this.getPreferredSize();
        }
        FlowLayout flow = (FlowLayout)this.getLayout();
        int w = this.getParent().getWidth();
        int h = flow.getVgap();
        int x = flow.getHgap();
        int rowH = 0;
        Component[] comps = this.getComponents();
        int i = 0;
        while (i < comps.length) {
            if (comps[i].isVisible()) {
                Dimension d = comps[i].getPreferredSize();
                if (x + d.width > w && x > flow.getHgap()) {
                    x = flow.getHgap();
                    h += rowH;
                    rowH = 0;
                    h += flow.getVgap();
                }
                rowH = Math.max(d.height, rowH);
                x += d.width + flow.getHgap();
            }
            ++i;
        }
        return new Dimension(w, h += rowH);
    }

    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        if (orientation == 0) {
            return visibleRect.width;
        }
        return visibleRect.height;
    }

    public boolean getScrollableTracksViewportHeight() {
        return this.getPreferredSize().height < this.getParent().getHeight();
    }

    public boolean getScrollableTracksViewportWidth() {
        return true;
    }

    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 10;
    }

    public static void main(String[] args) {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    sp = new ScrollablePanel(0, 20, 20);
                    scroller = new JScrollPane(sp);
                    JButton button = new JButton("Add Label");
                    button.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent e) {
                            sp.add(new JLabel("HELLO"));
                            scroller.validate();
                        }
                    });
                    JPanel content = new JPanel(new BorderLayout());
                    content.add((Component)button, "North");
                    content.add(scroller);
                    JFrame f = new JFrame("Test");
                    f.setContentPane(content);
                    f.setDefaultCloseOperation(3);
                    f.setSize(600, 400);
                    f.setLocationRelativeTo(null);
                    f.setVisible(true);
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

