/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.util.view;

import br.com.bb.plugins.gac.apresentacao.BasicInternalFrame;
import br.com.bb.plugins.gac.apresentacao.exportarcadastro.action.CarregarExportarCadastroAction;
import br.com.bb.plugins.gac.apresentacao.exportarcadastro.action.ConfirmarExportarCadastroAction;
import br.com.bb.plugins.gac.apresentacao.exportarcadastro.form.ExportarCadastroForm;
import br.com.bb.plugins.gac.apresentacao.form.PluginFormAbstrato;
import br.com.bb.plugins.gac.excecao.BBException;
import br.com.bb.plugins.gac.negocio.to.LeiauteTO;
import br.com.bb.plugins.gac.negocio.to.TipoLeiauteTO;
import br.com.bb.plugins.gac.util.ConfiguracaoProperties;
import br.com.bb.plugins.gac.util.swing.BBJBordaOval;
import br.com.bb.plugins.gac.util.swing.componente.BBJButton;
import br.com.bb.plugins.gac.util.swing.componente.BBJComboBoxLabel;
import br.com.bb.plugins.gac.util.swing.componente.BBJFileChooser;
import br.com.bb.plugins.gac.util.swing.componente.BBJPopupMensagem;
import br.com.bb.plugins.gac.util.swing.componente.BBJProgressBar;
import br.com.politec.generico.colecao.UtilColecao;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViewExportarDados
extends BasicInternalFrame
implements Observer {
    private BBJComboBoxLabel cmbTipoExportacao = null;
    private BBJComboBoxLabel<LeiauteTO> cmbLayout;
    private BBJFileChooser destinoArquivoGerado = null;
    private JPanel panelPrincipal = null;
    private JPanel panelDados = null;
    private JPanel panelBotoes = null;
    private BBJProgressBar bbprogress;
    private JPanel panelProgresso = null;
    private final int LARGURALABEL = 205;
    private Collection<TipoLeiauteTO> colecaoTipoLeiauteTO;
    private BBJButton jbConfirmar = null;
    private BBJButton bntVoltar = null;
    private static final String CAMINHO_RELATORIO = "";
    private Collection<LeiauteTO> colecaoLeiauteTO;
    private Collection<LeiauteTO> colecaoLeiauteFiltrado;

    public ViewExportarDados() {
        super("Exporta\u00e7\u00e3o de Dados", false, false);
        this.initialize();
    }

    private void initialize() {
        this.add(this.getPanelPrincipal());
    }

    public JPanel getPanelPrincipal() {
        if (this.panelPrincipal == null) {
            this.panelPrincipal = new JPanel();
            this.panelPrincipal.setLayout(new BorderLayout());
            this.panelPrincipal.setBackground(Color.WHITE);
            this.panelPrincipal.add((Component)this.getPanelDados(), "North");
            this.panelPrincipal.add((Component)this.getPanelBotoes(), "Center");
        }
        return this.panelPrincipal;
    }

    public JPanel getPanelDados() {
        if (this.panelDados == null) {
            this.panelDados = new JPanel();
            this.panelDados.setLayout(new GridBagLayout());
            this.panelDados.setBorder(BBJBordaOval.createOvalBorder("Selecione o Leiaute para Exporta\u00e7\u00e3o", 15));
            this.panelDados.setOpaque(false);
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.fill = 2;
            gbc.insets = new Insets(4, 4, 4, 4);
            gbc.anchor = 17;
            gbc.weightx = 0.99;
            gbc.gridx = 0;
            gbc.gridy = 0;
            this.panelDados.add(this.getCmbTipoExportacao(), gbc);
            ++gbc.gridy;
            this.panelDados.add(this.getCmbLayout(), gbc);
            ++gbc.gridy;
            this.panelDados.add((Component)this.getDestinoArquivoGerado(), gbc);
            ++gbc.gridy;
            this.panelDados.add((Component)this.getPanelProgresso(), gbc);
        }
        return this.panelDados;
    }

    public BBJComboBoxLabel<TipoLeiauteTO> getCmbTipoExportacao() {
        if (this.cmbTipoExportacao == null) {
            this.cmbTipoExportacao = new BBJComboBoxLabel("Tipo Exporta\u00e7\u00e3o:", false, 0, null, 205);
            this.cmbTipoExportacao.setToolTipText(this.getMensagem("MH068"));
            this.cmbTipoExportacao.setName("tipoLeiauteTO");
        }
        return this.cmbTipoExportacao;
    }

    public BBJComboBoxLabel<LeiauteTO> getCmbLayout() {
        if (this.cmbLayout == null) {
            this.cmbLayout = new BBJComboBoxLabel("Leiaute do arquivo a ser importado:", false, 0, null, 205);
            this.cmbLayout.setName("leiauteTO");
            this.cmbLayout.setToolTipText(this.getMensagem("MH038"));
        }
        return this.cmbLayout;
    }

    public JPanel getPanelBotoes() {
        if (this.panelBotoes == null) {
            this.panelBotoes = new JPanel();
            this.panelBotoes.setOpaque(false);
            this.panelBotoes.setPreferredSize(new Dimension(0, 40));
            FlowLayout layout = new FlowLayout();
            layout.setAlignment(2);
            this.panelBotoes.setLayout(layout);
            this.panelBotoes.add(this.getBotaoConfirmar());
            this.panelBotoes.add(this.getBntVoltar());
        }
        return this.panelBotoes;
    }

    public BBJButton getBotaoConfirmar() {
        if (this.jbConfirmar == null) {
            ConfirmarExportarCadastroAction action = this.getActionFactory().novoConfirmarExportarCadastroAction();
            this.jbConfirmar = this.getBotaoFactory().novoConfirmar(action);
        }
        return this.jbConfirmar;
    }

    public BBJButton getBntVoltar() {
        if (!this.isReferencia(this.bntVoltar)) {
            this.bntVoltar = this.getBotaoFactory().novoVoltar();
        }
        return this.bntVoltar;
    }

    @Override
    public void posExecucaoFecharAction() {
        this.doClose(null);
    }

    public BBJFileChooser getDestinoArquivoGerado() {
        if (this.destinoArquivoGerado == null) {
            this.destinoArquivoGerado = new BBJFileChooser("Destino do Arquivo Gerado:", "destinoArquivoGerado", 5000, true, 0, 10, 205){

                public void definaDiretorioCorrente() {
                    this.getFilechooser().setCurrentDirectory(ViewExportarDados.this.getDiretorioRemessa());
                }
            };
            this.destinoArquivoGerado.setSomenteDiretorio(true);
            this.destinoArquivoGerado.setToolTipText(this.getMensagem("MH073"));
            this.destinoArquivoGerado.setButtonToolTipText(this.getMensagem("MH069"));
            this.destinoArquivoGerado.getJtfCampo().setName("arquivoD");
        }
        return this.destinoArquivoGerado;
    }

    private File getDiretorioRemessa() {
        String dirRemessa = ConfiguracaoProperties.getConfiguracaoProperties().getDirRemessa();
        return new File(dirRemessa);
    }

    public JPanel getPanelProgresso() {
        if (this.panelProgresso == null) {
            this.panelProgresso = new JPanel();
            this.panelProgresso.setLayout(new BorderLayout());
            this.panelProgresso.setOpaque(false);
            this.panelProgresso.setBorder(BBJBordaOval.createOvalBorder("Progresso", 10));
            JPanel panel = new JPanel();
            panel.setLayout(new BorderLayout());
            panel.setOpaque(false);
            panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            panel.add((Component)this.getBbprogress(), "North");
            this.panelProgresso.add((Component)panel, "Center");
            this.panelProgresso.setVisible(false);
        }
        return this.panelProgresso;
    }

    public BBJProgressBar getBbprogress() {
        if (this.bbprogress == null) {
            this.bbprogress = new BBJProgressBar(100L);
        }
        return this.bbprogress;
    }

    @Override
    public void doShow(Map context) {
        this.inicializaTela();
        this.setVisible(true);
        this.exibirBarraProgresso(false);
        this.getBbprogress().setValoratual(0L);
        this.getDestinoArquivoGerado().setTexto(CAMINHO_RELATORIO);
        this.getDestinoArquivoGerado().requestFocus();
        this.ativarPainel();
    }

    @Override
    public void inicializaTela() {
        this.getCmbTipoExportacao().setEnabled(false);
        this.setForm(null);
        this.getDestinoArquivoGerado().getFilechooser().setSelectedFile(null);
        this.getDestinoArquivoGerado().getJtfCampo().setText(null);
        CarregarExportarCadastroAction action = this.getActionFactory().novoCarregarExportarCadastroAction();
        try {
            action.executar(this.getForm());
            this.setColecaoTipoLeiauteTO(this.getExportarCadastroForm().getColecaoTipoLeiauteTO());
            this.setColecaoLeiauteTO(this.getExportarCadastroForm().getColecaoLeiauteTO());
            this.preencheComboTipoExporta\u00e7\u00e3o();
            this.preencheComboLeiaute();
        }
        catch (BBException e) {
            this.processarMensagemDeErro(this, e);
        }
        this.getExportarCadastroForm().getNotificaExportacao().addObserver(this);
    }

    protected ExportarCadastroForm getExportarCadastroForm() {
        return (ExportarCadastroForm)this.getForm();
    }

    @Override
    protected PluginFormAbstrato novoForm() {
        ExportarCadastroForm form = this.getFormFactory().novoExportarCadastroForm();
        return form;
    }

    public Collection<TipoLeiauteTO> getColecaoTipoLeiauteTO() {
        return this.colecaoTipoLeiauteTO;
    }

    public void setColecaoTipoLeiauteTO(Collection<TipoLeiauteTO> colecaoTipoLeiauteTO) {
        this.colecaoTipoLeiauteTO = colecaoTipoLeiauteTO;
    }

    private void preencheComboTipoExporta\u00e7\u00e3o() {
        this.getCmbTipoExportacao().loadCombo(this.getColecaoTipoLeiauteTO());
    }

    public void preExecucaoConfirmarExportarCadastroAction() {
        this.exibirBarraProgresso(true);
        this.getExportarCadastroForm().setArquivo(this.getDestinoArquivoGerado().getArquivo());
    }

    private void exibirBarraProgresso(boolean ativar) {
        this.panelProgresso.setVisible(ativar);
        this.getBotaoConfirmar().setEnabled(!ativar);
        this.getBntVoltar().setEnabled(!ativar);
    }

    public void posExecucaoConfirmarExportarCadastroAction() {
        if (!this.getExportarCadastroForm().isRetorno()) {
            this.getExportarCadastroForm().setMensagem(this.getUtilMensagem().getMensagem("MN068"));
            BBJPopupMensagem.exibirMensagem(this.getExportarCadastroForm().getMensagem());
            this.getDestinoArquivoGerado().requestFocus();
        } else {
            BBJPopupMensagem.exibirMensagem(String.valueOf(this.getUtilMensagem().getMensagem("MN037")) + this.getExportarCadastroForm().getExportarDadosExternoTODecorator().getNomeArquivoGerado());
        }
    }

    public void posExecucaoFinalConfirmarExportarCadastroAction() {
        this.exibirBarraProgresso(false);
    }

    @Override
    public void doClose(Map context) {
        this.setVisible(false);
        super.doClose(context);
    }

    private void atualizaProgressBar(Integer porcentagem) {
        this.getBbprogress().setValoratual(porcentagem.intValue());
        this.getBbprogress().updateUI();
    }

    @Override
    public void update(Observable o, Object arg) {
        Integer porcentagem = (Integer)arg;
        this.atualizaProgressBar(porcentagem);
    }

    public void setDestinoArquivoGerado(BBJFileChooser destinoArquivoGerado) {
        this.destinoArquivoGerado = destinoArquivoGerado;
    }

    private void preencheComboLeiaute() {
        Collection<LeiauteTO> colecaoLeiaute = this.getColecaoLeiauteTO();
        ArrayList<LeiauteTO> colecaoFiltrada = new ArrayList<LeiauteTO>();
        if (!UtilColecao.isVazio(colecaoLeiaute)) {
            for (LeiauteTO leiauteTO : colecaoLeiaute) {
                TipoLeiauteTO tipoLeiauteTO = this.getTipoLeiauteSelecionado();
                if (!this.isReferencia(tipoLeiauteTO) || !this.isReferencia(leiauteTO) || !this.isReferencia(leiauteTO.getTipoLeiauteTO()) || !leiauteTO.getTipoLeiauteTO().getCodigoTipoLeiaute().equals(this.getTipoLeiauteSelecionado().getCodigoTipoLeiaute())) continue;
                colecaoFiltrada.add(leiauteTO);
            }
            this.setColecaoLeiauteFiltrado(colecaoFiltrada);
        }
        this.getCmbLayout().loadCombo(colecaoFiltrada);
        ((DefaultComboBoxModel)this.getCmbLayout().getComboBox().getModel()).insertElementAt("Selecione", 0);
        this.getCmbLayout().getComboBox().setSelectedIndex(0);
    }

    public Collection<LeiauteTO> getColecaoLeiauteTO() {
        return this.colecaoLeiauteTO;
    }

    public void setColecaoLeiauteTO(Collection<LeiauteTO> colecaoLeiauteTO) {
        this.colecaoLeiauteTO = colecaoLeiauteTO;
    }

    private TipoLeiauteTO getTipoLeiauteSelecionado() {
        Object objeto = this.getCmbTipoExportacao().getComboBox().getSelectedItem();
        if (objeto instanceof TipoLeiauteTO) {
            TipoLeiauteTO tipoLeiauteTO = (TipoLeiauteTO)objeto;
            return tipoLeiauteTO;
        }
        return null;
    }

    public Collection<LeiauteTO> getColecaoLeiauteFiltrado() {
        return this.colecaoLeiauteFiltrado;
    }

    public void setColecaoLeiauteFiltrado(Collection<LeiauteTO> colecaoLeiauteFiltrado) {
        this.colecaoLeiauteFiltrado = colecaoLeiauteFiltrado;
    }

    private void ativarPainel() {
        if (this.getColecaoLeiauteFiltrado() == null || this.getColecaoLeiauteFiltrado().size() == 0) {
            this.getCmbLayout().setEnabled(false);
            this.getBotaoConfirmar().setEnabled(false);
            this.getDestinoArquivoGerado().setEnabled(false);
            BBJPopupMensagem.exibirMensagem("N\u00e3o existe leiaute cadastrado.");
        } else {
            this.getCmbLayout().setEnabled(true);
            this.getBotaoConfirmar().setEnabled(true);
            this.getDestinoArquivoGerado().setEnabled(true);
        }
    }
}

