/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.util.view;

import br.com.bb.plugins.gac.apresentacao.BasicInternalFrame;
import br.com.bb.plugins.gac.apresentacao.form.PluginFormAbstrato;
import br.com.bb.plugins.gac.apresentacao.importarcadastro.action.AvancarImportarDadosExternoAction;
import br.com.bb.plugins.gac.apresentacao.importarcadastro.action.CarregarImportarDadosExternoAction;
import br.com.bb.plugins.gac.apresentacao.importarcadastro.form.ImportarDadosExternoForm;
import br.com.bb.plugins.gac.apresentacao.manterleiautearquivoimportacao.action.ImprimirLeiauteArquivoImportacaoAction;
import br.com.bb.plugins.gac.excecao.BBException;
import br.com.bb.plugins.gac.negocio.to.LeiauteTO;
import br.com.bb.plugins.gac.negocio.to.TipoLeiauteTO;
import br.com.bb.plugins.gac.relatorio.RelatorioDataSource;
import br.com.bb.plugins.gac.util.ConfiguracaoProperties;
import br.com.bb.plugins.gac.util.controller.view.ViewController;
import br.com.bb.plugins.gac.util.swing.BBJBordaOval;
import br.com.bb.plugins.gac.util.swing.componente.BBJButton;
import br.com.bb.plugins.gac.util.swing.componente.BBJComboBoxLabel;
import br.com.bb.plugins.gac.util.swing.componente.BBJFileChooser;
import br.com.bb.plugins.gac.util.swing.componente.BBJPopupMensagem;
import br.com.bb.plugins.gac.util.view.BBJPanelBotoesManut;
import br.com.politec.generico.arquivo.UtilArquivo;
import br.com.politec.generico.colecao.UtilColecao;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JPanel;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.view.JasperViewer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViewImportarDadosExterno
extends BasicInternalFrame {
    private Collection<LeiauteTO> colecaoLeiauteFiltrado;
    private JPanel panelDados = null;
    private JPanel panelInicial = null;
    private BBJPanelBotoesManut panelBotoes = null;
    private BBJComboBoxLabel<TipoLeiauteTO> cmbTipoImportacao;
    private BBJComboBoxLabel<LeiauteTO> cmbLayout;
    private BBJFileChooser localizacaoArquivoImportar;
    private final int LARGURALABEL = 205;
    private BBJButton avancarBotao = null;
    private BBJButton imprimirBotao = null;
    private BBJButton voltarBotao = null;
    private Collection<TipoLeiauteTO> colecaoTipoLeiauteTO;
    private Collection<LeiauteTO> colecaoLeiauteTO;
    private static final String CAMINHO_RELATORIO = "/relatorios/relatorio_dados_leiaute.jasper";
    private static final String CAMINHO_IMAGEM = "/images/logoGeral_PB.jpg";

    public Collection<TipoLeiauteTO> getColecaoTipoLeiauteTO() {
        return this.colecaoTipoLeiauteTO;
    }

    public void setColecaoTipoLeiauteTO(Collection<TipoLeiauteTO> colecaoTipoLeiauteTO) {
        this.colecaoTipoLeiauteTO = colecaoTipoLeiauteTO;
    }

    public ViewImportarDadosExterno() {
        super("Importa\u00e7\u00e3o de dados externos", false, false);
        this.initialize();
    }

    @Override
    public void inicializaTela() {
        this.setForm(null);
        this.getImportarDadosExternoForm().setServico(this.getServicoAtual());
        if (this.getImportarDadosExternoForm().getServico() == null || this.getImportarDadosExternoForm().getServico().trim().length() == 0) {
            this.getImportarDadosExternoForm().setServico("GAC");
        }
        if ("DBT".equals(this.getImportarDadosExternoForm().getServico())) {
            this.getCmbTipoImportacao().requestFocus();
        } else {
            this.getCmbTipoImportacao().setEnabled(false);
            this.getCmbLayout().requestFocus();
        }
        this.getLocalizacaoArquivoImportar().getFilechooser().setSelectedFile(null);
        this.getLocalizacaoArquivoImportar().getJtfCampo().setText(null);
        CarregarImportarDadosExternoAction action = this.getActionFactory().novoCarregarImportarDadosExternoAction();
        this.getLocalizacaoArquivoImportar().getJtfCampo().addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                ViewImportarDadosExterno.this.getLocalizacaoArquivoImportar().getBotaoExecutar().requestFocus();
            }
        });
        try {
            action.executar(this.getForm());
            this.setColecaoTipoLeiauteTO(this.getImportarDadosExternoForm().getColecaoTipoLeiauteTO());
            this.setColecaoLeiauteTO(this.getImportarDadosExternoForm().getColecaoLeiauteTO());
            this.preencheComboTipoImportacao();
            if ("GAC".equals(this.getImportarDadosExternoForm().getServico())) {
                this.getCmbTipoImportacao().getComboBox().setSelectedIndex(1);
            }
            this.preencheComboLeiaute();
        }
        catch (BBException e) {
            this.processarMensagemDeErro(this, e);
        }
        if (this.getColecaoLeiauteFiltrado() == null || this.getColecaoLeiauteFiltrado().size() == 0) {
            this.getCmbLayout().setEnabled(false);
            this.getAvancarBotao().setEnabled(false);
            this.getLocalizacaoArquivoImportar().setEnabled(false);
            BBJPopupMensagem.exibirMensagem("N\u00e3o existe leiaute cadastrado.");
        } else {
            this.getCmbLayout().setEnabled(true);
            this.getAvancarBotao().setEnabled(true);
            this.getLocalizacaoArquivoImportar().setEnabled(true);
        }
    }

    private void initialize() {
        this.add(this.getPanelDados());
        this.carregaDados();
    }

    private void carregaDados() {
        this.getPanelBotoes().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HashMap context = new HashMap();
                if (e.getActionCommand().equalsIgnoreCase("AVAN\u00c7AR")) {
                    ViewController.getInstance().goToView("GACIMPORTDADOSEXTCONF", context);
                } else if (e.getActionCommand().equalsIgnoreCase("VOLTAR")) {
                    ViewImportarDadosExterno.this.doClose(null);
                }
            }
        });
    }

    public JPanel getPanelDados() {
        if (this.panelDados == null) {
            this.panelDados = new JPanel();
            this.panelDados.setOpaque(false);
            this.panelDados.setLayout(new BorderLayout());
            this.panelDados.add((Component)this.getPanelInicial(), "North");
            this.panelDados.add((Component)this.getPanelBotoes(), "Center");
        }
        return this.panelDados;
    }

    public JPanel getPanelInicial() {
        if (this.panelInicial == null) {
            this.panelInicial = new JPanel();
            this.panelInicial.setOpaque(false);
            this.panelInicial.setLayout(new GridBagLayout());
            this.panelInicial.setBorder(BBJBordaOval.createOvalBorder());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.anchor = 17;
            gbc.insets = new Insets(4, 4, 4, 4);
            gbc.fill = 2;
            gbc.weightx = 0.95;
            gbc.gridx = 0;
            gbc.gridy = 0;
            this.panelInicial.add(this.getCmbTipoImportacao(), gbc);
            ++gbc.gridy;
            this.panelInicial.add(this.getCmbLayout(), gbc);
            ++gbc.gridy;
            this.panelInicial.add((Component)this.getLocalizacaoArquivoImportar(), gbc);
        }
        return this.panelInicial;
    }

    public BBJComboBoxLabel<TipoLeiauteTO> getCmbTipoImportacao() {
        if (this.cmbTipoImportacao == null) {
            this.cmbTipoImportacao = new BBJComboBoxLabel("Tipo de Importa\u00e7\u00e3o:", false, 0, null, 205);
            this.cmbTipoImportacao.setName("tipoLeiauteTO");
            this.cmbTipoImportacao.setToolTipText(this.getMensagem("MH071"));
            this.cmbTipoImportacao.getComboBox().addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ViewImportarDadosExterno.this.filtrarComboLeiaute();
                }
            });
        }
        return this.cmbTipoImportacao;
    }

    protected void filtrarComboLeiaute() {
        this.preencheComboLeiaute();
    }

    public BBJComboBoxLabel<LeiauteTO> getCmbLayout() {
        if (this.cmbLayout == null) {
            this.cmbLayout = new BBJComboBoxLabel("Leiaute do arquivo a ser importado:", false, 0, null, 205);
            this.cmbLayout.setName("leiauteTO");
            this.cmbLayout.setToolTipText(this.getMensagem("MH038"));
        }
        return this.cmbLayout;
    }

    public BBJFileChooser getLocalizacaoArquivoImportar() {
        if (this.localizacaoArquivoImportar == null) {
            this.localizacaoArquivoImportar = new BBJFileChooser("Localiza\u00e7\u00e3o do Arquivo:", "ABRIR", 20000, true, 0, 0, 205){

                public void definaDiretorioCorrente() {
                    this.getFilechooser().setCurrentDirectory(ViewImportarDadosExterno.this.getDiretorioRetorno());
                }
            };
            this.localizacaoArquivoImportar.getJtfCampo().setToolTipText(this.getMensagem("MH072"));
            this.localizacaoArquivoImportar.setName("localizacaoArquivoImportar");
        }
        return this.localizacaoArquivoImportar;
    }

    public BBJPanelBotoesManut getPanelBotoes() {
        if (this.panelBotoes == null) {
            this.panelBotoes = new BBJPanelBotoesManut(-1);
            this.panelBotoes.removeAll();
            this.panelBotoes.add(this.getAvancarBotao());
            this.panelBotoes.add(this.getImprimirBotao());
            this.panelBotoes.add(this.getVoltarBotao());
            this.panelBotoes.setVisible(true);
        }
        return this.panelBotoes;
    }

    @Override
    public void doShow(Map context) {
        this.setVisible(true);
        this.inicializaTela();
    }

    private void preencheComboTipoImportacao() {
        ArrayList<TipoLeiauteTO> lista = new ArrayList<TipoLeiauteTO>(this.getColecaoTipoLeiauteTO());
        this.getCmbTipoImportacao().loadCombo(lista);
        ((DefaultComboBoxModel)this.getCmbTipoImportacao().getComboBox().getModel()).insertElementAt("Selecione", 0);
        this.getCmbTipoImportacao().getComboBox().setSelectedIndex(0);
    }

    private void preencheComboLeiaute() {
        Collection<LeiauteTO> colecaoLeiaute = this.getColecaoLeiauteTO();
        ArrayList<LeiauteTO> colecaoFiltrada = new ArrayList<LeiauteTO>();
        if (!UtilColecao.isVazio(colecaoLeiaute)) {
            for (LeiauteTO leiauteTO : colecaoLeiaute) {
                TipoLeiauteTO tipoLeiauteTO = this.getTipoLeiauteSelecionado();
                if (!this.isReferencia(tipoLeiauteTO) || !this.isReferencia(leiauteTO) || !this.isReferencia(leiauteTO.getTipoLeiauteTO()) || !leiauteTO.getTipoLeiauteTO().getCodigoTipoLeiaute().equals(this.getTipoLeiauteSelecionado().getCodigoTipoLeiaute())) continue;
                colecaoFiltrada.add(leiauteTO);
            }
            this.setColecaoLeiauteFiltrado(colecaoFiltrada);
        }
        this.getCmbLayout().loadCombo(colecaoFiltrada);
        ((DefaultComboBoxModel)this.getCmbLayout().getComboBox().getModel()).insertElementAt("Selecione", 0);
        this.getCmbLayout().getComboBox().setSelectedIndex(0);
    }

    private TipoLeiauteTO getTipoLeiauteSelecionado() {
        Object objeto = this.getCmbTipoImportacao().getComboBox().getSelectedItem();
        if (objeto instanceof TipoLeiauteTO) {
            TipoLeiauteTO tipoLeiauteTO = (TipoLeiauteTO)objeto;
            return tipoLeiauteTO;
        }
        return null;
    }

    @Override
    public void doClose(Map context) {
        super.doClose(context);
    }

    public static void main(String[] args) {
        JFrame fra = new JFrame("Teste");
        fra.setDefaultCloseOperation(2);
        ViewImportarDadosExterno procret = new ViewImportarDadosExterno();
        procret.doShow(null);
        fra.add(procret);
        fra.setSize(new Dimension(800, 600));
        fra.setVisible(true);
    }

    public BBJButton getAvancarBotao() {
        if (this.avancarBotao == null) {
            AvancarImportarDadosExternoAction action = this.novoAvancarImportarDadosExternoAction();
            this.avancarBotao = this.getBotaoFactory().novoAvancar(action);
        }
        return this.avancarBotao;
    }

    protected AvancarImportarDadosExternoAction novoAvancarImportarDadosExternoAction() {
        return this.getActionFactory().novoAvancarImportarDadosExternoAction();
    }

    public void preExecucaoAvancarImportarDadosExternoAction() {
        this.getImportarDadosExternoForm().setArquivo(this.getLocalizacaoArquivoImportar().getArquivo());
    }

    public void preExecucaoImprimirLeiauteArquivoImportacaoAction() {
        this.getImportarDadosExternoForm().setArquivo(this.getLocalizacaoArquivoImportar().getArquivo());
    }

    public void setAvancarBotao(BBJButton avancarBotao) {
        this.avancarBotao = avancarBotao;
    }

    public BBJButton getVoltarBotao() {
        if (this.voltarBotao == null) {
            this.voltarBotao = this.getBotaoFactory().novoVoltar();
        }
        return this.voltarBotao;
    }

    @Override
    public void posExecucaoFecharAction() {
        this.doClose(null);
    }

    public void setVoltarBotao(BBJButton voltarBotao) {
        this.voltarBotao = voltarBotao;
    }

    protected ImportarDadosExternoForm getImportarDadosExternoForm() {
        return (ImportarDadosExternoForm)this.getForm();
    }

    @Override
    protected PluginFormAbstrato novoForm() {
        ImportarDadosExternoForm form = this.getFormFactory().novoImportarDadosExternoForm();
        return form;
    }

    public Collection<LeiauteTO> getColecaoLeiauteTO() {
        return this.colecaoLeiauteTO;
    }

    public void setColecaoLeiauteTO(Collection<LeiauteTO> colecaoLeiauteTO) {
        this.colecaoLeiauteTO = colecaoLeiauteTO;
    }

    private BBJButton getImprimirBotao() {
        if (this.imprimirBotao == null) {
            ImprimirLeiauteArquivoImportacaoAction importacaoAction = this.getActionFactory().novoImprimirLeiauteArquivoImportacaoAction();
            this.imprimirBotao = this.getBotaoFactory().novoImprimir(importacaoAction);
            this.imprimirBotao.setVisible(false);
        }
        return this.imprimirBotao;
    }

    public void posExecucaoImprimirLeiauteArquivoImportacaoAction() {
        this.imprimirDadosLeiaute();
    }

    private void imprimirDadosLeiaute() {
        try {
            InputStream inputStream = UtilArquivo.getInputStream(CAMINHO_RELATORIO);
            JasperPrint impressao = null;
            Map<String, Object> mapa = this.getMapaParametros();
            impressao = JasperFillManager.fillReport((InputStream)inputStream, mapa, (JRDataSource)new RelatorioDataSource(this.getImportarDadosExternoForm().getLeiauteTO().getCamposLeiauteTOs()));
            JasperViewer jrviewer = new JasperViewer(impressao, false);
            jrviewer.setIconImage(new ImageIcon(this.getClass().getResource("/images/BBRelatorio.gif")).getImage());
            jrviewer.setVisible(true);
        }
        catch (JRException e) {
            this.processarMensagemDeErro(this, e);
        }
    }

    private Map<String, Object> getMapaParametros() {
        HashMap<String, Object> mapa = new HashMap<String, Object>();
        LeiauteTO leiauteTOSelecionado = this.getImportarDadosExternoForm().getLeiauteTO();
        mapa.put("tamanhoRegistro", leiauteTOSelecionado.getNumeroTamanhoRegistro());
        mapa.put("descricaoLeiaute", leiauteTOSelecionado.getTextoDescricaoLeiaute());
        mapa.put("nomeLeiaute", leiauteTOSelecionado.getTextoDescricaoLeiaute());
        mapa.put("logoBB", UtilArquivo.getInputStream(CAMINHO_IMAGEM));
        mapa.put("tipoLeiaute", leiauteTOSelecionado.getTipoLeiauteTO().getTextoDescricaoTipoLeiaute());
        mapa.put("localizacaoDoArquivo", this.getImportarDadosExternoForm().getArquivo().getAbsolutePath());
        return mapa;
    }

    public void setColecaoLeiauteFiltrado(Collection<LeiauteTO> colecaoLeiauteFiltrado) {
        this.colecaoLeiauteFiltrado = colecaoLeiauteFiltrado;
    }

    public Collection<LeiauteTO> getColecaoLeiauteFiltrado() {
        return this.colecaoLeiauteFiltrado;
    }

    private File getDiretorioRetorno() {
        String dirRetorno = ConfiguracaoProperties.getConfiguracaoProperties().getDirRetorno();
        return new File(dirRetorno);
    }
}

