/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.util.view;

import br.com.bb.plugins.gac.apresentacao.BasicInternalFrame;
import br.com.bb.plugins.gac.apresentacao.form.PluginFormAbstrato;
import br.com.bb.plugins.gac.apresentacao.importarcadastro.action.ExecutarImportarDadosExternoAction;
import br.com.bb.plugins.gac.apresentacao.importarcadastro.form.ImportarDadosExternoForm;
import br.com.bb.plugins.gac.negocio.to.decorator.RegistroRejeitadoTODecorator;
import br.com.bb.plugins.gac.relatorio.RelatorioDataSource;
import br.com.bb.plugins.gac.util.swing.BBJBordaOval;
import br.com.bb.plugins.gac.util.swing.componente.BBJButton;
import br.com.bb.plugins.gac.util.swing.componente.BBJLabel;
import br.com.bb.plugins.gac.util.swing.componente.BBJProgressBar;
import br.com.bb.plugins.gac.util.view.BBJPanelBotoesManut;
import br.com.politec.generico.arquivo.UtilArquivo;
import br.com.politec.generico.colecao.UtilColecao;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.view.JasperViewer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViewImportarDadosExternoConfirmar
extends BasicInternalFrame
implements Observer {
    private JPanel panelMain = null;
    private JPanel panelConfirmar = null;
    private BBJPanelBotoesManut panelBotoesEditar = null;
    private BBJProgressBar bbprogress;
    private JPanel panelProgresso = null;
    private BBJLabel arquivoLabel = new BBJLabel("");
    private BBJLabel tipoLeiauteLabel = new BBJLabel("");
    private BBJLabel leiauteLabel = new BBJLabel("");
    private BBJButton confirmarBotao = null;
    private BBJButton voltarBotao = null;
    private static final String CAMINHO_RELATORIO = "/relatorios/relatorio_importacao_cadastro.jasper";
    private Map context;

    public ViewImportarDadosExternoConfirmar() {
        super("Executar Importa\u00e7\u00e3o", false, false);
        this.initComponents();
    }

    private void initComponents() {
        this.add(this.getPanelMain());
    }

    public JPanel getPanelMain() {
        if (this.panelMain == null) {
            this.panelMain = new JPanel();
            this.panelMain.setLayout(new BorderLayout());
            this.panelMain.setOpaque(false);
            this.panelMain.add((Component)this.getPanelConfirmar(), "North");
            this.panelMain.add((Component)this.getPanelBotoesEditar(), "Center");
        }
        return this.panelMain;
    }

    public JPanel getPanelConfirmar() {
        if (this.panelConfirmar == null) {
            this.panelConfirmar = new JPanel();
            this.panelConfirmar.setOpaque(false);
            this.panelConfirmar.setLayout(new GridBagLayout());
            this.panelConfirmar.setBorder(BBJBordaOval.createOvalBorder());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.anchor = 17;
            gbc.insets = new Insets(4, 4, 4, 4);
            gbc.fill = 2;
            gbc.weightx = 0.95;
            gbc.gridx = 0;
            gbc.gridy = 0;
            this.panelConfirmar.add((Component)this.tipoLeiauteLabel, gbc);
            ++gbc.gridy;
            this.panelConfirmar.add((Component)this.leiauteLabel, gbc);
            ++gbc.gridy;
            this.panelConfirmar.add((Component)this.arquivoLabel, gbc);
            ++gbc.gridy;
            this.panelConfirmar.add((Component)this.getPanelProgresso(), gbc);
        }
        return this.panelConfirmar;
    }

    @Override
    public void doShow(Map context) {
        this.setVisible(true);
        this.setContext(context);
        super.doShow(context);
        this.getConfirmarBotao().requestFocus();
    }

    @Override
    public void doClose(Map context) {
        this.setVisible(false);
        super.doClose(context);
    }

    public BBJPanelBotoesManut getPanelBotoesEditar() {
        if (this.panelBotoesEditar == null) {
            this.panelBotoesEditar = new BBJPanelBotoesManut(-1);
            this.panelBotoesEditar.removeAll();
            this.panelBotoesEditar.add(this.getConfirmarBotao());
            this.panelBotoesEditar.add(this.getVoltarBotao());
        }
        return this.panelBotoesEditar;
    }

    public JPanel getPanelProgresso() {
        if (this.panelProgresso == null) {
            this.panelProgresso = new JPanel();
            this.panelProgresso.setLayout(new BorderLayout());
            this.panelProgresso.setOpaque(false);
            this.panelProgresso.setBorder(BBJBordaOval.createOvalBorder("Progresso", 10));
            JPanel panel = new JPanel();
            panel.setLayout(new BorderLayout());
            panel.setOpaque(false);
            panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            panel.add((Component)this.getBbprogress(), "North");
            this.panelProgresso.add((Component)panel, "Center");
            this.panelProgresso.setVisible(false);
        }
        return this.panelProgresso;
    }

    public BBJProgressBar getBbprogress() {
        if (this.bbprogress == null) {
            this.bbprogress = new BBJProgressBar(100L);
        }
        return this.bbprogress;
    }

    @Override
    protected PluginFormAbstrato novoForm() {
        ImportarDadosExternoForm form = this.getFormFactory().novoImportarDadosExternoForm();
        return form;
    }

    @Override
    public void inicializaTela() {
        this.setForm(this.getFormAnterior());
        this.arquivoLabel.setText("Arquivo a ser importado: " + this.getImportarDadosExternoForm().getArquivo().getAbsolutePath());
        this.tipoLeiauteLabel.setText("Tipo de Importa\u00e7\u00e3o: " + this.getImportarDadosExternoForm().getTipoLeiauteTO().getTextoDescricaoTipoLeiaute());
        this.leiauteLabel.setText("Layout do Arquivo: " + this.getImportarDadosExternoForm().getLeiauteTO().getTextoDescricaoLeiaute());
        this.atualizaProgressBar(0);
        this.getImportarDadosExternoForm().getNotificaImportacao().deleteObservers();
        this.getImportarDadosExternoForm().getNotificaImportacao().addObserver(this);
    }

    protected ImportarDadosExternoForm getImportarDadosExternoForm() {
        return (ImportarDadosExternoForm)this.getForm();
    }

    public BBJButton getConfirmarBotao() {
        if (this.confirmarBotao == null) {
            this.confirmarBotao = this.getBotaoFactory().novoConfirmar(this.novaActionExecutarImportarDadosExternoAction());
        }
        return this.confirmarBotao;
    }

    protected ExecutarImportarDadosExternoAction novaActionExecutarImportarDadosExternoAction() {
        return this.getActionFactory().novoExecutarImportarDadosExternoAction();
    }

    public void setConfirmarBotao(BBJButton confirmarBotao) {
        this.confirmarBotao = confirmarBotao;
    }

    public BBJButton getVoltarBotao() {
        if (this.voltarBotao == null) {
            this.voltarBotao = this.getBotaoFactory().novoVoltar();
        }
        return this.voltarBotao;
    }

    @Override
    public void posExecucaoFecharAction() {
        this.doClose(this.getContext());
    }

    public void preExecucaoExecutarImportarDadosExternoAction() {
        this.getConfirmarBotao().setEnabled(false);
        this.getVoltarBotao().setEnabled(false);
        this.getPanelProgresso().setVisible(true);
    }

    public void posExecucaoExecutarImportarDadosExternoAction() {
        this.imprimirDadosImportacao();
    }

    public void posExecucaoFinalExecutarImportarDadosExternoAction() {
        this.getConfirmarBotao().setEnabled(true);
        this.getVoltarBotao().setEnabled(true);
        this.getPanelProgresso().setVisible(false);
    }

    public void setVoltarBotao(BBJButton voltarBotao) {
        this.voltarBotao = voltarBotao;
    }

    @Override
    public void update(Observable o, Object arg) {
        Integer porcentagem = (Integer)arg;
        this.atualizaProgressBar(porcentagem);
    }

    private void atualizaProgressBar(Integer porcentagem) {
        this.getBbprogress().setValoratual(porcentagem.intValue());
        this.getBbprogress().updateUI();
    }

    private void imprimirDadosImportacao() {
        try {
            JasperPrint impressao = null;
            InputStream inputStream = UtilArquivo.getInputStream(CAMINHO_RELATORIO);
            Map<String, Object> mapa = this.getMapaParametros();
            mapa.put("telefonesOuvidoria", "Suporte T\u00e9cnico: 4004-0001 (capitais e regi\u00f5es metropolitanas) e 0800-729-0001 (demais localidades) SAC: 0800729-0722 / Ouvidoria: 0800-729-5678");
            Collection<RegistroRejeitadoTODecorator> col = this.getImportarDadosExternoForm().getColecaoRegistroRejeitadoTODecorator();
            if (UtilColecao.isVazio(col)) {
                col.add(new RegistroRejeitadoTODecorator());
            }
            RelatorioDataSource dsrel = new RelatorioDataSource(col);
            impressao = JasperFillManager.fillReport((InputStream)inputStream, mapa, (JRDataSource)dsrel);
            JasperViewer jrviewer = new JasperViewer(impressao, false);
            jrviewer.setIconImage(new ImageIcon(this.getClass().getResource("/images/BBRelatorio.gif")).getImage());
            jrviewer.setVisible(true);
        }
        catch (JRException e) {
            this.processarMensagemDeErro(this, e);
        }
    }

    private Map<String, Object> getMapaParametros() {
        HashMap<String, Object> mapa = new HashMap<String, Object>();
        Integer registrosImportados = this.getImportarDadosExternoForm().getNumeroRegistrosImportados();
        Integer registrosRejeitados = this.getImportarDadosExternoForm().getNumeroRegistrosRejeitados();
        mapa.put("totalImportados", registrosImportados);
        mapa.put("totalRejeitados", registrosRejeitados);
        return mapa;
    }

    public Map getContext() {
        if (this.context == null) {
            this.context = new HashMap();
        }
        return this.context;
    }

    public void setContext(Map context) {
        this.context = context;
    }
}

