/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.util.view;

import br.com.bb.plugins.gac.apresentacao.BasicInternalFrame;
import br.com.bb.plugins.gac.apresentacao.form.PluginFormAbstrato;
import br.com.bb.plugins.gac.apresentacao.manteragenciainstituicaofinanceira.action.ExcluirAgenciaInsituicaoFinanceiraAction;
import br.com.bb.plugins.gac.apresentacao.manteragenciainstituicaofinanceira.action.ListarAgenciaInstituicaoFinanceiraAction;
import br.com.bb.plugins.gac.apresentacao.manteragenciainstituicaofinanceira.form.ManterAgenciaInstituicaoFinanceiraForm;
import br.com.bb.plugins.gac.negocio.to.AgenciaInstituicaoFinanceiraTO;
import br.com.bb.plugins.gac.util.objecttablemodel.IObjectAgenciaInstituicaoFinanceira;
import br.com.bb.plugins.gac.util.swing.BBJBordaOval;
import br.com.bb.plugins.gac.util.swing.componente.BBJButton;
import br.com.bb.plugins.gac.util.swing.componente.BBJPaginacao;
import br.com.bb.plugins.gac.util.swing.componente.BBJPopupMensagem;
import br.com.bb.plugins.gac.util.swing.componente.BBJTable;
import br.com.bb.plugins.gac.util.swing.componente.BBJTableImpl;
import br.com.bb.plugins.gac.util.view.ViewManterAgenciaPopup;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViewManterAgencia
extends BasicInternalFrame {
    private JPanel jpMain = null;
    private JPanel jpTabela = null;
    private JPanel jpSuperior = null;
    private JPanel jpBotoes = null;
    private BBJPaginacao paginacao = null;
    private JPanel panelTabelaAgencia;
    private BBJTableImpl<IObjectAgenciaInstituicaoFinanceira> tableModel;
    private BBJButton bbjbEditar = null;
    private BBJButton bbjbNovo = null;
    private BBJButton bbjbExcluir = null;
    private BBJButton bbjbVoltar = null;

    public ViewManterAgencia() {
        super(null, false, false);
        this.initialize();
        this.habilitaBotoes();
    }

    private void initialize() {
        this.add(this.getJPMain());
        this.setTitulo("Manuten\u00e7\u00e3o de Ag\u00eancias");
    }

    private void populaTabela() {
        this.tableModel.getBbtModel().setDataListTabela(this.apresentarTabela());
    }

    public JPanel getJPMain() {
        if (this.jpMain == null) {
            this.jpMain = new JPanel();
            this.jpMain.setLayout(new BorderLayout());
            this.jpMain.setBackground(Color.WHITE);
            this.jpMain.add((Component)this.getPainelSuperior(), "North");
        }
        return this.jpMain;
    }

    public JPanel getPainelSuperior() {
        if (this.jpSuperior == null) {
            this.jpSuperior = new JPanel();
            this.jpSuperior.setOpaque(false);
            this.jpSuperior.setLayout(new BorderLayout());
            this.jpSuperior.add((Component)this.getJpTabela(), "North");
            this.jpSuperior.add((Component)this.getJpBotoes(), "Center");
        }
        return this.jpSuperior;
    }

    public JPanel getJpTabela() {
        if (this.jpTabela == null) {
            this.jpTabela = new JPanel();
            this.jpTabela.setOpaque(false);
            this.jpTabela.setLayout(new BorderLayout());
            this.jpTabela.add((Component)this.getPanelTabelaAgencia(), "Center");
            this.jpTabela.add((Component)this.getPaginacao(), "South");
        }
        return this.jpTabela;
    }

    public JPanel getPanelTabelaAgencia() {
        if (this.panelTabelaAgencia == null) {
            this.panelTabelaAgencia = new JPanel();
            this.panelTabelaAgencia.setBorder(BBJBordaOval.createOvalBorder("Lista de Ag\u00eancias", 15));
            this.panelTabelaAgencia.setOpaque(false);
            this.panelTabelaAgencia.setLayout(new BorderLayout());
            this.panelTabelaAgencia.add((Component)this.getTableModel().getTableHeader(), "North");
            this.panelTabelaAgencia.add((Component)this.getTableModel(), "Center");
        }
        return this.panelTabelaAgencia;
    }

    private BBJTableImpl getTableModel() {
        if (this.tableModel == null) {
            String[] columnNames = new String[]{"C\u00f3digo Descri\u00e7\u00e3o IF", "C\u00f3digo da Ag\u00eancia", "Descri\u00e7\u00e3o da Ag\u00eancia"};
            int[] columnSizes = new int[]{220, 120, 260};
            int[] columnAligment = new int[]{2, 2, 2};
            this.tableModel = new BBJTableImpl(columnNames, columnSizes, columnAligment, 5);
            this.tableModel.setNomeColunas(new String[]{"codigoInstituicaoFinanceira", "codigoAgencia", "textoDescricao"});
            this.tableModel.setOrdenacaoAutomatica(false);
            this.tableModel.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (e.getActionCommand().equals("EVENTO_ORDENACAO")) {
                        ManterAgenciaInstituicaoFinanceiraForm form = (ManterAgenciaInstituicaoFinanceiraForm)ViewManterAgencia.this.getForm();
                        BBJTable model = ViewManterAgencia.this.tableModel.getBbtModel();
                        form.setTipoOrdenacao(model.getTipoordenacao());
                        form.setNomeColunaOrdenada(model.getNomeColunaOrdenada());
                        ViewManterAgencia.this.populaTabela();
                    } else if (e.getActionCommand().equalsIgnoreCase("NAOSELECIONADO")) {
                        ViewManterAgencia.this.habilitaBotoes();
                    } else if (e.getActionCommand().equals("SELECIONADO")) {
                        ViewManterAgencia.this.habilitaBotoes();
                    }
                }
            });
        }
        return this.tableModel;
    }

    private final void habilitaBotoes() {
        boolean habilitado = this.tableModel.getItensChecadosCheckBox().size() > 0;
        this.getBotaoEditar().setEnabled(habilitado);
        this.getBotaoExcluir().setEnabled(habilitado);
    }

    public void setDimension(JScrollPane jsp, Dimension dim) {
        jsp.setPreferredSize(dim);
        jsp.setSize(dim);
        jsp.setMaximumSize(dim);
        jsp.setMinimumSize(dim);
    }

    public void setDimension(BBJTableImpl tbl, Dimension dim) {
        tbl.setPreferredSize(dim);
        tbl.setSize(dim);
        tbl.setMaximumSize(dim);
        tbl.setMinimumSize(dim);
    }

    protected ArrayList<IObjectAgenciaInstituicaoFinanceira> apresentarTabela() {
        ListarAgenciaInstituicaoFinanceiraAction acao = this.getActionFactory().novoListarAgenciaInstituicaoFinanceiraAction();
        ManterAgenciaInstituicaoFinanceiraForm form = (ManterAgenciaInstituicaoFinanceiraForm)this.getForm();
        if (form.getAgenciaInstituicaoFinanceiraTODecorator().getPaginaAtual() == null) {
            form.getAgenciaInstituicaoFinanceiraTODecorator().setPaginaAtual(1);
        }
        acao.executar(form);
        return this.conversorDataVector(form.getColecao());
    }

    public void atualizarTabela() {
        ManterAgenciaInstituicaoFinanceiraForm form = (ManterAgenciaInstituicaoFinanceiraForm)this.getForm();
        this.tableModel.getBbtModel().setDataListTabela(this.conversorDataVector(form.getColecao()));
    }

    protected ArrayList<IObjectAgenciaInstituicaoFinanceira> conversorDataVector(Collection<AgenciaInstituicaoFinanceiraTO> colecaoA) {
        ArrayList<IObjectAgenciaInstituicaoFinanceira> lista = new ArrayList<IObjectAgenciaInstituicaoFinanceira>();
        for (AgenciaInstituicaoFinanceiraTO to : colecaoA) {
            IObjectAgenciaInstituicaoFinanceira obj = new IObjectAgenciaInstituicaoFinanceira(to);
            lista.add(obj);
        }
        return lista;
    }

    @Override
    protected PluginFormAbstrato novoForm() {
        return this.getFormFactory().novoManterAgenciaInstituicaoFinanceiraForm();
    }

    public static void main(String[] args) {
        JFrame fra = new JFrame("Testando Cadastro de Agencia");
        fra.setDefaultCloseOperation(2);
        ViewManterAgencia agc = new ViewManterAgencia();
        agc.setVisible(true);
        fra.add(agc);
        fra.setSize(new Dimension(800, 400));
        fra.setVisible(true);
    }

    public BBJPaginacao getPaginacao() {
        if (this.paginacao == null) {
            this.paginacao = new BBJPaginacao();
            this.paginacao.addPropertyChangeListener("paginacao", new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    ListarAgenciaInstituicaoFinanceiraAction action = ViewManterAgencia.this.getActionFactory().novoListarAgenciaInstituicaoFinanceiraAction();
                    ManterAgenciaInstituicaoFinanceiraForm form = (ManterAgenciaInstituicaoFinanceiraForm)ViewManterAgencia.this.getForm();
                    form.setPaginaAtual((Integer)evt.getNewValue());
                    try {
                        action.executar(form);
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                    ViewManterAgencia.this.atualizarTabela();
                }
            });
        }
        return this.paginacao;
    }

    private BBJButton getBotaoEditar() {
        if (this.bbjbEditar == null) {
            this.bbjbEditar = new BBJButton("EDITAR");
            this.bbjbEditar.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent arg0) {
                    if (ViewManterAgencia.this.tableModel.getItensChecadosCheckBox().size() > 0) {
                        ViewManterAgenciaPopup manterAgenciaPopup = new ViewManterAgenciaPopup("Editar Ag\u00eancia", "Edite os dados da Ag\u00eancia", new Dimension(350, 250), 2);
                        ViewManterAgencia.this.preencheCamposPopup(manterAgenciaPopup);
                        manterAgenciaPopup.doShow(null);
                        ViewManterAgencia.this.populaTabela();
                        ViewManterAgencia.this.getBotaoEditar().setEnabled(false);
                        ViewManterAgencia.this.getBotaoExcluir().setEnabled(false);
                    } else {
                        BBJPopupMensagem.exibirMensagem(ViewManterAgencia.this.getUtilMensagem().getMensagem("MN021"));
                    }
                }
            });
        }
        return this.bbjbEditar;
    }

    public BBJButton getBotaoNovo() {
        if (this.bbjbNovo == null) {
            this.bbjbNovo = new BBJButton("NOVO", true);
            this.bbjbNovo.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent arg0) {
                    ViewManterAgenciaPopup manterAgenciaPopup = new ViewManterAgenciaPopup("Incluir Ag\u00eancia", "Informe os dados da Ag\u00eancia", new Dimension(450, 300), 1);
                    manterAgenciaPopup.doShow(null);
                    ViewManterAgencia.this.populaTabela();
                    ViewManterAgencia.this.getBotaoEditar().setEnabled(false);
                    ViewManterAgencia.this.getBotaoExcluir().setEnabled(false);
                }
            });
        }
        return this.bbjbNovo;
    }

    public BBJButton getBotaoExcluir() {
        if (this.bbjbExcluir == null) {
            this.bbjbExcluir = new BBJButton("EXCLUIR", true);
            ExcluirAgenciaInsituicaoFinanceiraAction acao = this.getActionFactory().novoExcluirAgenciaInsituicaoFinanceiraAction();
            this.bbjbExcluir = this.getBotaoFactory().novoExcluir(acao);
        }
        return this.bbjbExcluir;
    }

    public void preExecucaoExcluirAgenciaInsituicaoFinanceiraAction() {
        IObjectAgenciaInstituicaoFinanceira iobj = this.getIObjectFromTable();
        ((ManterAgenciaInstituicaoFinanceiraForm)this.getForm()).setAgenciaTO(iobj.getAgenciaInstituicaoFinanceiraTO());
    }

    public void posExecucaoExcluirAgenciaInsituicaoFinanceiraAction() {
        this.getBotaoEditar().setEnabled(false);
        this.getBotaoExcluir().setEnabled(false);
        this.populaTabela();
    }

    public BBJButton getBotaoVoltar() {
        if (this.bbjbVoltar == null) {
            this.bbjbVoltar = new BBJButton("VOLTAR", true);
            this.bbjbVoltar.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent arg0) {
                    ViewManterAgencia.this.doClose(null);
                }
            });
        }
        return this.bbjbVoltar;
    }

    private void preencheCamposPopup(ViewManterAgenciaPopup pop) {
        IObjectAgenciaInstituicaoFinanceira iobj = this.getIObjectFromTable();
        pop.setAgenciaInstituicaoFinanceiraTO(iobj.getAgenciaInstituicaoFinanceiraTO());
        pop.setInstituicaoFinanceiraTO(iobj.getAgenciaInstituicaoFinanceiraTO().getInstituicaoFinanceiraTO());
        new String();
        String agencia = String.valueOf(iobj.getId().getCodigoAgencia());
        int intBanco = iobj.getId().getCodigoInstituicaoFinanceira();
        if (intBanco == 1) {
            new String();
            String agTemp = String.valueOf(iobj.getId().getCodigoAgencia());
            String dv = String.valueOf(iobj.getAgenciaInstituicaoFinanceiraTO().getDigitoVerificadorAgencia());
            if (dv.compareTo("") == 0) {
                dv = "0";
            } else if (agTemp.length() == 3) {
                agTemp = "0" + agTemp;
            } else if (agTemp.length() == 2) {
                agTemp = "00" + agTemp;
            } else if (agTemp.length() == 1) {
                agTemp = "000" + agTemp;
            }
            agencia = String.valueOf(agTemp) + "-" + dv;
        }
        if (intBanco == 1) {
            pop.getBbTCodigoAgencia().getJtfCampo().setText(agencia);
        } else {
            String digitoverificadorDeAgenciaDeOutraInstituicao = String.valueOf(iobj.getAgenciaInstituicaoFinanceiraTO().getDigitoVerificadorAgencia());
            pop.getBbTCodigoAgencia().getJtfCampo().setText(agencia);
            pop.getBbTDigitoAgenciaOutraInstituicao().getJtfCampo().setText(digitoverificadorDeAgenciaDeOutraInstituicao);
        }
        pop.getBbTNomeAgencia().setText(iobj.getTextoNomeAgenciaInstituicaoFinanceira());
    }

    public JPanel getJpBotoes() {
        if (this.jpBotoes == null) {
            this.jpBotoes = new JPanel();
            this.setDimension(this.jpBotoes, new Dimension(0, 35));
            this.jpBotoes.setOpaque(false);
            FlowLayout flw = new FlowLayout();
            flw.setAlignment(2);
            this.jpBotoes.setLayout(flw);
            this.jpBotoes.add(this.getBotaoNovo());
            this.jpBotoes.add(this.getBotaoEditar());
            this.jpBotoes.add(this.getBotaoExcluir());
            this.jpBotoes.add(this.getBotaoVoltar());
        }
        return this.jpBotoes;
    }

    private void setDimension(JPanel pnl, Dimension dim) {
        pnl.setSize(dim);
        pnl.setPreferredSize(dim);
        pnl.setMaximumSize(dim);
        pnl.setMinimumSize(dim);
    }

    protected IObjectAgenciaInstituicaoFinanceira getIObjectFromTable() {
        List<IObjectAgenciaInstituicaoFinanceira> lista0 = this.tableModel.getItensChecadosCheckBox();
        IObjectAgenciaInstituicaoFinanceira obj = lista0.get(0);
        return obj;
    }

    @Override
    public void doShow(Map context) {
        ManterAgenciaInstituicaoFinanceiraForm form = (ManterAgenciaInstituicaoFinanceiraForm)this.getForm();
        form.setPaginaAtual(1);
        this.getPaginacao().setValorPos(1);
        this.getPaginacao().atualiza();
        form.getAgenciaInstituicaoFinanceiraTODecorator().setNomeColunaOrdenada("codigoInstituicaoFinanceira");
        this.populaTabela();
        this.getPaginacao().setValorMaximo(this.getForm().getNumeroDePaginas());
        this.setVisible(true);
        this.bbjbNovo.requestFocus();
        super.doShow(context);
    }

    @Override
    public void doClose(Map context) {
        super.doClose(context);
    }
}

