/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.gac.util.view;

import br.com.bb.plugins.gac.apresentacao.BasicInternalFrame;
import br.com.bb.plugins.gac.apresentacao.form.PluginFormAbstrato;
import br.com.bb.plugins.gac.apresentacao.manterusuario.action.ListarUsuarioAction;
import br.com.bb.plugins.gac.apresentacao.manterusuario.form.ManterUsuarioForm;
import br.com.bb.plugins.gac.factory.FacadeFactory;
import br.com.bb.plugins.gac.negocio.facade.VerificarPermissaoFacade;
import br.com.bb.plugins.gac.negocio.to.UsuarioTO;
import br.com.bb.plugins.gac.util.controller.view.ViewController;
import br.com.bb.plugins.gac.util.objecttablemodel.IObjectUsuario;
import br.com.bb.plugins.gac.util.swing.BBJBordaOval;
import br.com.bb.plugins.gac.util.swing.componente.BBJButton;
import br.com.bb.plugins.gac.util.swing.componente.BBJPaginacao;
import br.com.bb.plugins.gac.util.swing.componente.BBJPopupMensagem;
import br.com.bb.plugins.gac.util.swing.componente.BBJTable;
import br.com.bb.plugins.gac.util.swing.componente.BBJTableImpl;
import br.com.bb.plugins.gac.util.swing.menu.BBJMigalha;
import br.com.politec.generico.objeto.UtilObjeto;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JFrame;
import javax.swing.JPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViewManterUsuario
extends BasicInternalFrame {
    private JPanel panelPrincipal = null;
    private JPanel panelBotoes = null;
    private final String[] columnNames = new String[]{"Nome", "Identificador", "Situa\u00e7\u00e3o", "Grupo"};
    private final int[] columnSizes = new int[]{250, 250, 100, 200};
    private final int[] columnAligment;
    private BBJTableImpl<IObjectUsuario> tableModel;
    private JPanel panelTabelaUsuario;
    private BBJButton jbNovo;
    private Map context;
    private BBJPaginacao paginacao;
    private JPanel jpSuperior;
    private BBJButton jbEditar;
    private BBJButton jbExcluir;
    private BBJButton jbAtivar;
    private BBJButton jbVincularPermissao;

    public ViewManterUsuario() {
        super("Gerenciar Usu\u00e1rios - Lista de Usu\u00e1rios", false, false);
        int[] nArray = new int[4];
        nArray[0] = 2;
        nArray[1] = 2;
        nArray[3] = 2;
        this.columnAligment = nArray;
        this.initialize();
    }

    private void initialize() {
        this.add(this.getJPMain());
    }

    public Map getContext() {
        if (!UtilObjeto.isReferencia(this.context)) {
            this.context = new HashMap();
        }
        return this.context;
    }

    public void setContext(Map context) {
        this.context = context;
    }

    public JPanel getJPMain() {
        if (this.panelPrincipal == null) {
            this.panelPrincipal = new JPanel();
            this.panelPrincipal.setOpaque(false);
            this.panelPrincipal.setLayout(new BorderLayout());
            this.panelPrincipal.add((Component)this.getJPSuperior(), "North");
        }
        return this.panelPrincipal;
    }

    public JPanel getJPSuperior() {
        if (this.jpSuperior == null) {
            this.jpSuperior = new JPanel();
            this.jpSuperior.setLayout(new BorderLayout());
            this.jpSuperior.setOpaque(false);
            this.jpSuperior.add((Component)this.getJTabUsuarios(), "North");
            this.jpSuperior.add((Component)this.getPaginacao(), "Center");
            this.jpSuperior.add((Component)this.getPanelBotoes(), "South");
        }
        return this.jpSuperior;
    }

    public BBJPaginacao getPaginacao() {
        if (this.paginacao == null) {
            this.paginacao = new BBJPaginacao();
            this.paginacao.addPropertyChangeListener("paginacao", new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    ListarUsuarioAction action = ViewManterUsuario.this.getActionFactory().novoListarUsuarioAction();
                    ManterUsuarioForm form = (ManterUsuarioForm)ViewManterUsuario.this.getForm();
                    form.setPaginaAtual((Integer)evt.getNewValue());
                    action.executar(form);
                    ViewManterUsuario.this.tableModel.getBbtModel().setDataListTabela(ViewManterUsuario.this.toIObjectUsuarioList(form.getColecaoUsuario()));
                }
            });
        }
        return this.paginacao;
    }

    public static void main(String[] args) {
        JFrame frm = new JFrame();
        ViewManterUsuario vadusu = new ViewManterUsuario();
        vadusu.doShow(null);
        frm.setPreferredSize(new Dimension(600, 500));
        frm.setContentPane(vadusu);
        frm.setDefaultCloseOperation(2);
        frm.setVisible(true);
        frm.pack();
    }

    public BBJTableImpl<IObjectUsuario> getTableModel() {
        if (this.tableModel == null) {
            this.tableModel = new BBJTableImpl(this.columnNames, this.columnSizes, this.columnAligment, 5);
            this.tableModel.getBbtModel().setNomeColunas(new String[]{"usuarioTO.textoNome", "usuarioTO.textoNomeUsuarioSistema", "estadoUsuarioTO.textoDescricao", "grupoUsuarioTO.nomeGrupoUsuario"});
            this.tableModel.getBbtModel().setOrdenacaoAutomatica(false);
            this.tableModel.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (e.getActionCommand().equalsIgnoreCase("SELECIONADO")) {
                        ViewManterUsuario.this.atualizarSelecionado();
                        ViewManterUsuario.this.habilitarBotoes();
                    } else if (e.getActionCommand().equalsIgnoreCase("NAOSELECIONADO")) {
                        ViewManterUsuario.this.atualizarSelecionado();
                        ViewManterUsuario.this.habilitarBotoes();
                    } else if (e.getActionCommand().equalsIgnoreCase("EVENTO_ORDENACAO")) {
                        ViewManterUsuario.this.ordenarTabela();
                    }
                }
            });
        }
        return this.tableModel;
    }

    public BBJTable<IObjectUsuario> getModel() {
        return this.getTableModel().getBbtModel();
    }

    public JPanel getJTabUsuarios() {
        if (this.panelTabelaUsuario == null) {
            this.panelTabelaUsuario = new JPanel();
            this.panelTabelaUsuario.setBorder(BBJBordaOval.createOvalBorder("Lista de Usu\u00e1rios", 15));
            this.panelTabelaUsuario.setPreferredSize(new Dimension(0, 400));
            this.panelTabelaUsuario.setOpaque(false);
            this.panelTabelaUsuario.setLayout(new BorderLayout());
            this.panelTabelaUsuario.add((Component)this.getTableModel().getTableHeader(), "North");
            this.panelTabelaUsuario.add(this.getTableModel(), "Center");
        }
        return this.panelTabelaUsuario;
    }

    private void ordenarTabela() {
        ManterUsuarioForm form = (ManterUsuarioForm)this.getForm();
        form.getUsuarioTODecorator().setNomeColunaOrdenada(this.getModel().getNomeColunaOrdenada());
        form.getUsuarioTODecorator().setTipoOrdenacao(this.getModel().getTipoordenacao());
        this.carregarTabela();
    }

    private void atualizarSelecionado() {
        ManterUsuarioForm form = (ManterUsuarioForm)this.getForm();
        UsuarioTO usuario = null;
        if (this.getModel().getItensChecadosCheckBox().size() > 0) {
            usuario = this.getIObjectFromTable().getUsuarioTO();
        }
        form.setUsuarioTO(usuario);
    }

    private void habilitarBotoes() {
        if (this.getModel().getItensChecadosCheckBox().size() > 0) {
            this.getBotaoAtivar().setEnabled(true);
            if (this.isAtivo(this.getIObjectFromTable())) {
                this.getBotaoAtivar().setTexto("INATIVAR");
            } else {
                this.getBotaoAtivar().setTexto("ATIVAR");
            }
            this.getBotaoAtivar().setSize();
            List<IObjectUsuario> items = this.getModel().getItensChecadosCheckBox();
            IObjectUsuario usuario = items.get(0);
            String estado = (String)usuario.getColumn(2);
            boolean bAtivar = estado.toUpperCase().equals("ATIVO");
            this.getBotaoVincularPermissao().setEnabled(bAtivar);
            this.getBotaoEditar().setEnabled(bAtivar);
            this.getBotaoExcluir().setEnabled(bAtivar);
            this.getBotaoAtivar().repaint();
        } else {
            this.getBotaoAtivar().setEnabled(false);
            this.getBotaoEditar().setEnabled(false);
            this.getBotaoExcluir().setEnabled(false);
            this.getBotaoVincularPermissao().setEnabled(false);
        }
    }

    protected void carregarTabela() {
        ListarUsuarioAction acao = this.getActionFactory().novoListarUsuarioAction();
        ManterUsuarioForm form = (ManterUsuarioForm)this.getForm();
        if (!this.isReferencia(form.getPaginaAtual())) {
            form.setPaginaAtual(1);
        }
        acao.executar(form);
        this.getPaginacao().setValorMaximo(form.getNumeroDePaginas());
        this.getModel().setDataListTabela(this.toIObjectUsuarioList(form.getColecaoUsuario()));
        this.habilitarBotoes();
    }

    private List<IObjectUsuario> toIObjectUsuarioList(Collection<UsuarioTO> colecaoUsuario) {
        ArrayList<IObjectUsuario> lista = new ArrayList<IObjectUsuario>();
        for (UsuarioTO to : colecaoUsuario) {
            IObjectUsuario obj = new IObjectUsuario(to);
            lista.add(obj);
        }
        return lista;
    }

    @Override
    protected PluginFormAbstrato novoForm() {
        return this.getFormFactory().novoManterUsuarioFrom();
    }

    public JPanel getPanelBotoes() {
        if (this.panelBotoes == null) {
            this.panelBotoes = new JPanel();
            this.panelBotoes.setOpaque(false);
            this.panelBotoes.setPreferredSize(new Dimension(0, 40));
            FlowLayout layout = new FlowLayout();
            layout.setAlignment(2);
            this.panelBotoes.setLayout(layout);
            this.adicionaBotoes(this.panelBotoes);
        }
        return this.panelBotoes;
    }

    private void adicionaBotoes(JPanel panelBotoes) {
        panelBotoes.add(this.getBotaoNovo());
        panelBotoes.add(this.getBotaoEditar());
        panelBotoes.add(this.getBotaoExcluir());
        panelBotoes.add(this.getBotaoAtivar());
        panelBotoes.add(this.getBotaoVincularPermissao());
        panelBotoes.add(this.getBotaoFactory().novoVoltar());
    }

    @Override
    public void posExecucaoFecharAction() {
        this.doClose(this.getContext());
    }

    public void posExecucaoExcluirUsuarioAction() {
        ManterUsuarioForm form = (ManterUsuarioForm)this.getForm();
        BBJPopupMensagem.exibirMensagem(form.getMensagem());
        this.carregarTabela();
    }

    protected BBJButton getBotaoVincularPermissao() {
        if (!UtilObjeto.isReferencia(this.jbVincularPermissao)) {
            this.jbVincularPermissao = new BBJButton("VINCULAR PERMISS\u00c3O", true);
            this.jbVincularPermissao.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (ViewManterUsuario.this.getModel().getItensChecadosCheckBox().size() > 0) {
                        VerificarPermissaoFacade facade = FacadeFactory.getInstancia().novoVerificarPermissaoFacade();
                        if (facade.EUsuarioAdministrador(ViewManterUsuario.this.getIObjectFromTable().getUsuarioTO())) {
                            BBJPopupMensagem.exibirMensagem(ViewManterUsuario.this.getMensagem("MN052"));
                            return;
                        }
                        ViewManterUsuario.this.getContext().put("to", ViewManterUsuario.this.getIObjectFromTable().getUsuarioTO());
                        ViewController.getInstance().goToView("GACCONFIGPERMISSAOUSUARIO", ViewManterUsuario.this.getContext());
                    }
                }
            });
            this.jbVincularPermissao.setEnabled(false);
        }
        return this.jbVincularPermissao;
    }

    protected BBJButton getBotaoAtivar() {
        if (!UtilObjeto.isReferencia(this.jbAtivar)) {
            this.jbAtivar = this.getBotaoFactory().novoBotao("INATIVAR", this.getActionFactory().novoAtivarUsuarioAction());
            this.jbAtivar.setEnabled(false);
        }
        return this.jbAtivar;
    }

    public void posExecucaoAtivarUsuarioAction() {
        this.carregarTabela();
        ManterUsuarioForm form = (ManterUsuarioForm)this.getForm();
        BBJPopupMensagem.exibirMensagem(form.getMensagem());
    }

    private boolean isAtivo(IObjectUsuario obj) {
        Integer codigoEstado = obj.getUsuarioTO().getEstadoUsuarioTO().getCodigoEstadoUsuario();
        return codigoEstado.equals(1);
    }

    protected BBJButton getBotaoExcluir() {
        if (!UtilObjeto.isReferencia(this.jbExcluir)) {
            this.jbExcluir = this.getBotaoFactory().novoBotao("EXCLUIR", this.getActionFactory().novoExcluirUsuarioAction());
            this.jbExcluir.setEnabled(false);
        }
        return this.jbExcluir;
    }

    protected BBJButton getBotaoEditar() {
        if (!UtilObjeto.isReferencia(this.jbEditar)) {
            this.jbEditar = new BBJButton("EDITAR", true);
            this.jbEditar.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (ViewManterUsuario.this.getModel().getItensChecadosCheckBox().size() > 0) {
                        ViewManterUsuario.this.getContext().put("ACAO", 2);
                        ViewManterUsuario.this.getContext().put("to", ViewManterUsuario.this.getIObjectFromTable());
                        ViewController.getInstance().goToView("GACADDUSUARIO", ViewManterUsuario.this.getContext(), false);
                        BBJMigalha.getInstance().Empilhar("GACADDUSUARIO", "Editar Usu\u00e1rio");
                    }
                }
            });
            this.jbEditar.setEnabled(false);
        }
        return this.jbEditar;
    }

    private IObjectUsuario getIObjectFromTable() {
        List<IObjectUsuario> lista = this.tableModel.getBbtModel().getItensChecadosCheckBox();
        IObjectUsuario obj = lista.get(0);
        return obj;
    }

    protected BBJButton getBotaoNovo() {
        if (this.jbNovo == null) {
            this.jbNovo = new BBJButton("NOVO", true);
            this.jbNovo.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent arg0) {
                    ViewManterUsuario.this.getContext().put("ACAO", 1);
                    ViewController.getInstance().goToView("GACADDUSUARIO", ViewManterUsuario.this.getContext(), false);
                    BBJMigalha.getInstance().Empilhar("GACADDUSUARIO", "Novo Usu\u00e1rio");
                }
            });
        }
        return this.jbNovo;
    }

    @Override
    public void doShow(Map context) {
        this.context = context;
        this.setVisible(true);
        ManterUsuarioForm form = (ManterUsuarioForm)this.getForm();
        form.getUsuarioTODecorator().setNomeColunaOrdenada("usuarioTO.textoNome");
        form.getUsuarioTODecorator().setTipoOrdenacao("ASC");
        this.carregarTabela();
        this.getBotaoNovo().requestFocus();
    }

    @Override
    public void doClose(Map context) {
        super.doClose(context);
        this.getPaginacao().setValorPos(1);
        this.getPaginacao().atualiza();
    }
}

