/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.windows;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Window;
import java.awt.peer.ActiveEvent;
import java.awt.peer.ComponentPeer;
import java.awt.peer.LightweightPeer;
import java.awt.peer.WindowPeer;
import java.util.Vector;
import sun.awt.windows.WComponentPeer;
import sun.awt.windows.WObjectPeer;
import sun.awt.windows.WPanelPeer;
import sun.awt.windows.WToolkit;

class WWindowPeer
extends WPanelPeer
implements WindowPeer {
    private Vector pendingFocusEvents = new Vector();
    static Vector allWindows = new Vector();

    protected void disposeImpl() {
        this.pendingFocusEvents.removeAllElements();
        allWindows.removeElement(this);
        super.disposeImpl();
    }

    public native void toFront();

    public native void toBack();

    public void setTitle(String string) {
        if (string == null) {
            string = new String("");
        }
        this._setTitle(string);
    }

    native void _setTitle(String var1);

    public void setResizable(boolean bl) {
        this._setResizable(bl);
        ((Component)this.target).invalidate();
    }

    public native void _setResizable(boolean var1);

    WWindowPeer(Window window) {
        super(window);
    }

    void initialize() {
        super.initialize();
        this.updateInsets(this.insets_);
        allWindows.addElement(this);
        Font font = ((Window)this.target).getFont();
        if (font == null) {
            font = new Font("Dialog", 0, 12);
            ((Window)this.target).setFont(font);
            this.setFont(font);
        }
    }

    native void create(WComponentPeer var1);

    native void updateInsets(Insets var1);

    void postFocusOnActivate() {
        FocusOnActivate focusOnActivate = new FocusOnActivate();
        this.pendingFocusEvents.addElement(focusOnActivate);
        WToolkit.postEvent(focusOnActivate);
    }

    static void cancelFocusOnActivate(Component component) {
        Component component2 = null;
        while (component != null) {
            if (component instanceof Window) {
                component2 = (Window)component;
            }
            component = component.getParent();
        }
        if (component2 != null) {
            ((WWindowPeer)component2.getPeer()).pendingFocusEvents.removeAllElements();
        }
    }

    native void requestComponentFocusIfActive(WComponentPeer var1);

    WComponentPeer getFocusPeer() {
        Component component = ((Window)this.target).getFocusOwner();
        while (component != null) {
            ComponentPeer componentPeer = component.getPeer();
            if (componentPeer != null && componentPeer instanceof WComponentPeer) {
                return (WComponentPeer)componentPeer;
            }
            component = component.getParent();
        }
        return null;
    }

    WComponentPeer setDefaultFocus() {
        Object object;
        Object object2 = this.setDefaultFocus((Container)this.target);
        if (object2 == null) {
            object2 = (Component)this.target;
            while (object2 instanceof Container && ((Container)object2).getComponentCount() > 0 && ((Component)object2).getPeer() != null) {
                object = this.getContainerElement((Container)object2, 0);
                if (!((Component)object).isVisible() || !((Component)object).isEnabled()) break;
                object2 = object;
            }
        }
        if ((object = ((Component)object2).getPeer()) instanceof LightweightPeer) {
            return null;
        }
        return (WComponentPeer)object;
    }

    private Component setDefaultFocus(Container container) {
        int n = container.getComponentCount();
        int n2 = 0;
        while (n2 < n) {
            Component component;
            Component component2 = this.getContainerElement(container, n2);
            if (component2.isVisible() && component2.isEnabled() && component2.isFocusTraversable()) {
                return component2;
            }
            if (component2 instanceof Container && component2.isVisible() && component2.isEnabled() && (component = this.setDefaultFocus((Container)component2)) != null) {
                return component;
            }
            ++n2;
        }
        return null;
    }

    private native Component getContainerElement(Container var1, int var2);

    private static void disposeOfAllWindows() {
        if (allWindows != null) {
            Object[] objectArray;
            int n;
            Vector vector = allWindows;
            synchronized (vector) {
                n = allWindows.size();
                objectArray = new WWindowPeer[n];
                allWindows.copyInto(objectArray);
            }
            int n2 = n - 1;
            while (n2 >= 0) {
                Object object = objectArray[n2];
                if (object != null && ((WObjectPeer)object).target != null) {
                    ((Window)((WObjectPeer)object).target).dispose();
                }
                --n2;
            }
        }
    }

    class FocusOnActivate
    extends AWTEvent
    implements ActiveEvent {
        public FocusOnActivate() {
            super((Component)WWindowPeer.this.target, 0);
            WWindowPeer.this = WWindowPeer.this;
        }

        public void dispatch() {
            if (!WWindowPeer.this.pendingFocusEvents.contains(this)) {
                return;
            }
            WComponentPeer wComponentPeer = WWindowPeer.this.getFocusPeer();
            if (wComponentPeer == null) {
                wComponentPeer = WWindowPeer.this.setDefaultFocus();
            }
            if (wComponentPeer != null) {
                WWindowPeer.this.requestComponentFocusIfActive(wComponentPeer);
            }
            WWindowPeer.this.pendingFocusEvents.removeElement(this);
        }
    }
}

