/*
 * Decompiled with CFR 0.152.
 */
package sun.security.acl;

import java.security.Principal;
import java.security.acl.AclEntry;
import java.security.acl.Group;
import java.security.acl.Permission;
import java.util.Enumeration;
import java.util.Vector;

public class AclEntryImpl
implements AclEntry {
    private Principal user;
    private Vector permissionSet = new Vector(10, 10);
    private boolean negative = false;

    public AclEntryImpl(Principal principal) {
        this.user = principal;
    }

    public AclEntryImpl() {
    }

    public boolean setPrincipal(Principal principal) {
        if (this.user != null) {
            return false;
        }
        this.user = principal;
        return true;
    }

    public void setNegativePermissions() {
        this.negative = true;
    }

    public boolean isNegative() {
        return this.negative;
    }

    public boolean addPermission(Permission permission) {
        if (this.permissionSet.contains(permission)) {
            return false;
        }
        this.permissionSet.addElement(permission);
        return true;
    }

    public boolean removePermission(Permission permission) {
        return this.permissionSet.removeElement(permission);
    }

    public boolean checkPermission(Permission permission) {
        return this.permissionSet.contains(permission);
    }

    public Enumeration permissions() {
        return this.permissionSet.elements();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.negative) {
            stringBuffer.append("-");
        } else {
            stringBuffer.append("+");
        }
        if (this.user instanceof Group) {
            stringBuffer.append("Group.");
        } else {
            stringBuffer.append("User.");
        }
        stringBuffer.append(String.valueOf(this.user) + "=");
        Enumeration enumeration = this.permissions();
        while (enumeration.hasMoreElements()) {
            Permission permission = (Permission)enumeration.nextElement();
            stringBuffer.append(permission);
            if (!enumeration.hasMoreElements()) continue;
            stringBuffer.append(",");
        }
        return new String(stringBuffer);
    }

    public synchronized Object clone() {
        AclEntryImpl aclEntryImpl = new AclEntryImpl(this.user);
        aclEntryImpl.permissionSet = (Vector)this.permissionSet.clone();
        aclEntryImpl.negative = this.negative;
        return aclEntryImpl;
    }

    public Principal getPrincipal() {
        return this.user;
    }
}

