/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.dbt.apresentacao.consultararquivoretorno.action;

import br.com.bb.plugins.dbt.apresentacao.action.DBTPluginActionAbstrato;
import br.com.bb.plugins.dbt.apresentacao.consultararquivoretorno.form.ConsultarRetornoForm;
import br.com.bb.plugins.dbt.negocio.facade.ConsultarArquivoRetornoFacade;
import br.com.bb.plugins.dbt.util.objecttablemodel.IObjectRecebimentoRetorno;
import br.com.bb.plugins.gac.apresentacao.form.PluginFormAbstrato;
import br.com.bb.plugins.gac.excecao.BBException;
import br.com.bb.plugins.gac.negocio.to.PaginadorTO;
import br.com.bb.plugins.gac.negocio.to.RecebimentoDebitoTO;
import br.com.bb.plugins.gac.util.seguranca.PluginControladorDeAcesso;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConsultarRetornoAction
extends DBTPluginActionAbstrato {
    @Override
    public void preExecutar(PluginFormAbstrato form) {
        form.setPermitirValidacao(true);
    }

    @Override
    public String executar(PluginFormAbstrato form) throws BBException {
        ConsultarArquivoRetornoFacade fachada = this.getDBTFacadeFactory().novoConsultarArquivoRetornoFacade();
        ConsultarRetornoForm formulario = this.getConsultarRetornoForm(form);
        formulario.setCodigoPessoaConvenente(this.getCodigoConveneteTela());
        PaginadorTO retorno = fachada.consultarFiltroDiferenteG(formulario.getRecebimentoTO());
        formulario.setListaTabela(this.criarListaComTotalizadores(retorno.getColecaoDeRegistros()));
        formulario.setListaRecebimentos(retorno);
        formulario.setPaginaAtual(1);
        return null;
    }

    private List<IObjectRecebimentoRetorno> criarListaComTotalizadores(Collection<RecebimentoDebitoTO> recebimento) {
        List lista;
        HashMap<Date, List> grupoDatas = new HashMap<Date, List>();
        List retorno = this.getColecaoFactory().novoArrayList();
        for (RecebimentoDebitoTO recebimentoDebitoTO : recebimento) {
            lista = (List)grupoDatas.get(recebimentoDebitoTO.getDataDebito());
            if (!this.isReferencia(lista)) {
                lista = this.getColecaoFactory().novoArrayList();
                grupoDatas.put(recebimentoDebitoTO.getDataDebito(), lista);
            }
            lista.add(recebimentoDebitoTO);
        }
        for (Date data : grupoDatas.keySet()) {
            lista = (List)grupoDatas.get(data);
            BigDecimal total = new BigDecimal(0);
            for (RecebimentoDebitoTO recebimentoDebitoTO2 : lista) {
                retorno.add(new IObjectRecebimentoRetorno(recebimentoDebitoTO2));
                BigDecimal valor = recebimentoDebitoTO2.getValorRecebimento();
                if (!this.isReferencia(valor)) continue;
                total = total.add(recebimentoDebitoTO2.getValorRecebimento());
            }
            IObjectRecebimentoRetorno itemTotal = new IObjectRecebimentoRetorno(total);
            retorno.add(itemTotal);
        }
        return retorno;
    }

    private Integer getCodigoConveneteTela() {
        PluginControladorDeAcesso acesso = this.getFabricaDeControladorDeAcesso().novoPluginControladorDeAcesso();
        return acesso.getConvenenteTO().getCodigoPessoaConvenente();
    }

    public ConsultarRetornoForm getConsultarRetornoForm(PluginFormAbstrato form) {
        return (ConsultarRetornoForm)form;
    }
}

