/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.dbt.apresentacao.consultararquivoretorno.view;

import br.com.bb.plugins.dbt.apresentacao.DBTBasicInternalFrame;
import br.com.bb.plugins.dbt.apresentacao.consultararquivoretorno.action.ConsultarRetornoAction;
import br.com.bb.plugins.dbt.apresentacao.consultararquivoretorno.action.ImprimirArquivoRetornoAction;
import br.com.bb.plugins.dbt.apresentacao.consultararquivoretorno.form.ConsultarRetornoForm;
import br.com.bb.plugins.dbt.util.objecttablemodel.IObjectRecebimentoRetorno;
import br.com.bb.plugins.gac.apresentacao.action.PluginActionAbstrato;
import br.com.bb.plugins.gac.apresentacao.form.PluginFormAbstrato;
import br.com.bb.plugins.gac.excecao.BBException;
import br.com.bb.plugins.gac.factory.FabricaDeControladorDeAcesso;
import br.com.bb.plugins.gac.negocio.to.ConvenenteTO;
import br.com.bb.plugins.gac.negocio.to.RecebimentoDebitoTO;
import br.com.bb.plugins.gac.util.UtilRelatorioJasper;
import br.com.bb.plugins.gac.util.constante.Arquivo;
import br.com.bb.plugins.gac.util.swing.IFormulario;
import br.com.bb.plugins.gac.util.swing.componente.BBJButton;
import br.com.bb.plugins.gac.util.swing.componente.BBJPaginacao;
import br.com.bb.plugins.gac.util.swing.componente.BBJPopupMensagem;
import br.com.bb.plugins.gac.util.swing.componente.BBJTablePagina;
import br.com.bb.plugins.gac.util.view.BBJPanelBotoesManut;
import br.com.bb.plugins.gac.util.view.FramePrincipal;
import br.com.politec.generico.colecao.UtilColecao;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JPanel;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.view.JasperViewer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViewConsultarRetorno
extends DBTBasicInternalFrame {
    private JPanel panelPrincipal = null;
    private JPanel panelDados = null;
    private BBJPanelBotoesManut panelBotoes = null;
    private BBJTablePagina<IObjectRecebimentoRetorno> tabelaDados;
    private BBJButton bntVoltar;
    private BBJButton btnImprimir;
    String[] columnNames = new String[]{"Data", "N\u00ba Conv\u00eanio", "Cliente", "Ag\u00eancia", "Conta", "Valor", "Situa\u00e7\u00e3o"};
    int[] columnSizes = new int[]{100, 100, 200, 80, 90, 100, 100};
    int[] columnAligment;
    private BBJPaginacao paginacao;
    private Map context;

    public ViewConsultarRetorno() {
        super("Consulta de Retornos", false, false);
        int[] nArray = new int[7];
        nArray[0] = 2;
        nArray[1] = 2;
        nArray[2] = 2;
        nArray[3] = 2;
        nArray[4] = 2;
        nArray[5] = 4;
        this.columnAligment = nArray;
        this.paginacao = null;
        this.initialize();
    }

    private void initialize() {
        this.add(this.getJPMain());
        this.getTabelaDados().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (e.getActionCommand().equalsIgnoreCase("EVENTO_ORDENACAO")) {
                    ViewConsultarRetorno.this.ordenarTabela();
                }
            }
        });
    }

    public JPanel getJPMain() {
        if (!this.isReferencia(this.panelPrincipal)) {
            this.panelPrincipal = this.getPainelFactory().novoJPainel();
            this.panelPrincipal.setLayout(this.getLayoutFactory().novoBorderLayout());
            this.panelPrincipal.setBackground(Color.WHITE);
            this.panelPrincipal.add((Component)this.getPanelDados(), "North");
        }
        return this.panelPrincipal;
    }

    public JPanel getPanelDados() {
        if (!this.isReferencia(this.panelDados)) {
            this.panelDados = this.getPainelFactory().novoJPainel();
            this.panelDados.setOpaque(false);
            this.panelDados.setLayout(this.getLayoutFactory().novoBorderLayout());
            this.panelDados.add((Component)this.getTabelaDados(), "Center");
            this.panelDados.add((Component)this.getPanelBotoes(), "South");
        }
        return this.panelDados;
    }

    public BBJTablePagina getTabelaDados() {
        if (!this.isReferencia(this.tabelaDados)) {
            this.tabelaDados = new BBJTablePagina(this.columnNames, this.columnSizes, this.columnAligment, "Retornos", 15, 0, this.getPaginacao());
            this.tabelaDados.setOpaque(false);
            this.tabelaDados.getTable().getBbtModel().setOrdenacaoAutomatica(false);
            this.tabelaDados.getTable().getBbtModel().setNomeColunas(new String[]{"dataRecebimento", "convenioDebitoTO.identificadorClienteDebitoTOs.convenioDebitoTO.id", "identificadorClienteDebitoTO.contaCorrenteClienteTO.pessoaTO.textoNome", "identificadorClienteDebitoTO.contaCorrenteClienteTO.agenciaInstituicaoFinanceiraTO.id", "identificadorClienteDebitoTO.contaCorrenteClienteTO.id", "valorRecebimento", "situacaoRecebimentoTO.codigoSituacaoRecebimento"});
        }
        return this.tabelaDados;
    }

    private void ordenarTabela() {
        ConsultarRetornoForm form = (ConsultarRetornoForm)this.getForm();
        form.getRecebimentoTO().setNomeColunaOrdenada(this.getTabelaDados().getTable().getBbtModel().getNomeColunaOrdenada());
        form.getRecebimentoTO().setTipoOrdenacao(this.getTabelaDados().getTable().getBbtModel().getTipoordenacao());
        this.listarRecebimentos();
    }

    public BBJPaginacao getPaginacao() {
        if (this.paginacao == null) {
            this.paginacao = new BBJPaginacao();
            this.paginacao.addPropertyChangeListener("paginacao", new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    ConsultarRetornoAction action = ViewConsultarRetorno.this.getDBTActionFactory().novoConsultarRetornoAction();
                    ConsultarRetornoForm form = ViewConsultarRetorno.this.getConsultarRetornoForm();
                    form.setPaginaAtual((Integer)evt.getNewValue());
                    try {
                        action.executar(form);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    ViewConsultarRetorno.this.getTabelaDados().setDataListTabela(form.getListaTabela());
                }
            });
        }
        return this.paginacao;
    }

    public BBJPanelBotoesManut getPanelBotoes() {
        if (!this.isReferencia(this.panelBotoes)) {
            this.panelBotoes = this.getPainelFactory().novoBBJPanelBotoesManut(-1);
            this.panelBotoes.removeAll();
            this.panelBotoes.add((Component)this.getBtnImprimir());
            this.panelBotoes.add((Component)this.getBntVoltar());
        }
        return this.panelBotoes;
    }

    protected BBJButton getBtnImprimir() {
        if (this.btnImprimir == null) {
            ImprimirArquivoRetornoAction acao = this.getDBTActionFactory().novoImprimirArquivoRetornoAction();
            this.btnImprimir = this.getBotaoFactory().novoImprimir((PluginActionAbstrato)acao);
        }
        return this.btnImprimir;
    }

    public void posExecucaoImprimirArquivoRetornoAction() {
        this.imprimirArquivoRetorno();
    }

    private void imprimirArquivoRetorno() {
        JasperPrint impressao = null;
        try {
            impressao = UtilRelatorioJasper.imprimirRelatorio((String)Arquivo.JASPER_LISTA_CONSULTA_RETORNO, (Map)this.getMapaParametros(), this.getConsultarRetornoForm().getLista());
            JasperViewer jrviewer = new JasperViewer(impressao, false);
            jrviewer.setIconImage(new ImageIcon(((Object)((Object)this)).getClass().getResource("/images/BBRelatorio.gif")).getImage());
            jrviewer.setVisible(true);
        }
        catch (BBException e) {
            this.processarMensagemDeErro((IFormulario)this, e);
        }
        catch (JRException e) {
            this.processarMensagemDeErro((IFormulario)this, e);
        }
    }

    private Map getMapaParametros() {
        Map parametros = this.getColecaoFactory().novoHashMap();
        parametros.put("telefonesOuvidoria", "Suporte T\u00e9cnico: 4004-0001 (capitais e regi\u00f5es metropolitanas) e 0800-729-0001 (demais localidades) SAC: 0800729-0722 / Ouvidoria: 0800-729-5678");
        parametros.put("nomeDoConvenente", FramePrincipal.getInstance().getConvenente().getPessoaTO().getTextoNome());
        return parametros;
    }

    private String getNomeConvenente() {
        ConvenenteTO convenente = FabricaDeControladorDeAcesso.getInstancia().novoPluginControladorDeAcesso().getConvenenteTO();
        if (convenente == null || convenente.getPessoaTO() == null) {
            return "";
        }
        return convenente.getPessoaTO().getTextoNome();
    }

    protected BBJButton getBntVoltar() {
        if (!this.isReferencia(this.bntVoltar)) {
            this.bntVoltar = this.getPainelFactory().novoBBJButton("VOLTAR", true);
            this.bntVoltar.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ViewConsultarRetorno.this.novoForm();
                    ViewConsultarRetorno.this.doClose(null);
                }
            });
        }
        return this.bntVoltar;
    }

    public void doShow(Map context) {
        this.setVisible(true);
        this.setContext(context);
        Object form = this.getContext().get("FORM");
        if (form instanceof ConsultarRetornoForm) {
            this.setForm((ConsultarRetornoForm)((Object)form));
            this.getConsultarRetornoForm().setPaginaAtual(1);
            this.getConsultarRetornoForm().getRecebimentoTO().setNomeColunaOrdenada("dataRecebimento");
            this.getConsultarRetornoForm().getRecebimentoTO().setTipoOrdenacao("ASC");
            this.getPaginacao().setValorPos(1);
            this.getPaginacao().setValorMaximo(this.getConsultarRetornoForm().getNumeroDePaginas().intValue());
            this.getPaginacao().atualiza();
            this.listarRecebimentos();
        }
        this.getBtnImprimir().requestFocus();
    }

    public Map getContext() {
        if (this.context == null) {
            this.context = new HashMap();
        }
        return this.context;
    }

    public void setContext(Map context) {
        this.context = context;
    }

    public void doClose(Map context) {
        super.doClose(context);
    }

    private void listarRecebimentos() {
        ConsultarRetornoForm retornoForm = (ConsultarRetornoForm)this.getForm();
        if (!this.isReferencia(retornoForm.getPaginaAtual())) {
            retornoForm.setPaginaAtual(1);
        }
        ConsultarRetornoAction consultar = this.getDBTActionFactory().novoConsultarRetornoAction();
        try {
            consultar.executar(retornoForm);
        }
        catch (BBException e) {
            e.printStackTrace();
        }
        if (!UtilColecao.isVazio(retornoForm.getListaTabela())) {
            this.getPaginacao().setValorMaximo(retornoForm.getNumeroDePaginas().intValue());
            this.getTabelaDados().setDataListTabela(retornoForm.getListaTabela());
        } else {
            BBJPopupMensagem.exibirMensagem((String)this.getMensagem("MP004"));
        }
    }

    private List<IObjectRecebimentoRetorno> converteParaListaDeIObject(Collection<RecebimentoDebitoTO> colecaoRecebimentos) {
        List retorno = this.getColecaoFactory().novoArrayList();
        for (RecebimentoDebitoTO recebimentoDebitoTO : colecaoRecebimentos) {
            IObjectRecebimentoRetorno item = new IObjectRecebimentoRetorno();
            item.setRecebimento(recebimentoDebitoTO);
            retorno.add(item);
        }
        return retorno;
    }

    public static void main(String[] args) {
        JFrame fra = new JFrame("Testando Processamento de Retorno Debito");
        fra.setDefaultCloseOperation(3);
        ViewConsultarRetorno procret = new ViewConsultarRetorno();
        procret.setVisible(true);
        fra.add((Component)((Object)procret));
        fra.setSize(new Dimension(500, 350));
        fra.setVisible(true);
    }

    public ConsultarRetornoForm getConsultarRetornoFormAnterior() {
        return (ConsultarRetornoForm)this.getFormAnterior();
    }

    public void inicializaTela() {
        this.getConsultarRetornoForm().setRecebimentoTO(this.getConsultarRetornoFormAnterior().getRecebimentoTO());
        this.listarRecebimentos();
        super.inicializaTela();
    }

    public ConsultarRetornoForm getConsultarRetornoForm() {
        return (ConsultarRetornoForm)this.getForm();
    }

    protected PluginFormAbstrato novoForm() {
        return new ConsultarRetornoForm();
    }
}

