/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.dbt.apresentacao.mantercliente.dao;

import br.com.bb.plugins.dbt.apresentacao.mantercliente.dao.BancoAcessDAOAbstrato;
import br.com.bb.plugins.dbt.negocio.to.decorator.MigrarBaseDecorator;
import br.com.bb.plugins.dbt.util.UtilMigracaoException;
import br.com.bb.plugins.dbt.util.UtilValidaDadosMigracao;
import br.com.bb.plugins.gac.negocio.to.AgenciaInstituicaoFinanceiraTO;
import br.com.bb.plugins.gac.negocio.to.ContaCorrenteClienteTO;
import br.com.bb.plugins.gac.negocio.to.ContaCorrenteClienteTOId;
import br.com.bb.plugins.gac.negocio.to.ConvenenteTO;
import br.com.bb.plugins.gac.negocio.to.ConvenioDebitoTO;
import br.com.bb.plugins.gac.negocio.to.ConvenioTO;
import br.com.bb.plugins.gac.negocio.to.GrupoClienteRecebimentoTO;
import br.com.bb.plugins.gac.negocio.to.IdentificacaoTO;
import br.com.bb.plugins.gac.negocio.to.IdentificadorClienteDebitoTO;
import br.com.bb.plugins.gac.negocio.to.IdentificadorTO;
import br.com.bb.plugins.gac.negocio.to.IdentificadorTOId;
import br.com.bb.plugins.gac.negocio.to.InstituicaoFinanceiraTO;
import br.com.bb.plugins.gac.negocio.to.LogradouroTO;
import br.com.bb.plugins.gac.negocio.to.MembroGrupoClienteRecebimentoTO;
import br.com.bb.plugins.gac.negocio.to.PessoaTO;
import br.com.bb.plugins.gac.negocio.to.RecebimentoDebitoTO;
import br.com.bb.plugins.gac.negocio.to.RemessaTO;
import br.com.bb.plugins.gac.negocio.to.ServicoTO;
import br.com.bb.plugins.gac.negocio.to.SituacaoIdentificadorDebitoTO;
import br.com.bb.plugins.gac.negocio.to.SituacaoRecebimentoTO;
import br.com.bb.plugins.gac.negocio.to.TipoLogradouroTO;
import br.com.bb.plugins.gac.negocio.to.TipoOcorrenciaRecebimentoDebitoTO;
import br.com.bb.plugins.gac.negocio.to.TipoPessoaTO;
import br.com.bb.plugins.gac.negocio.to.UnidadeFederativaBrasilTO;
import br.com.bb.plugins.gac.negocio.to.decorator.ConvenioTODecorator;
import br.com.bb.plugins.gac.negocio.to.decorator.GrupoClienteRecebimentoTODecorator;
import br.com.bb.plugins.gac.negocio.to.decorator.MembroGrupoClienteRecebimentoTODecorator;
import br.com.bb.plugins.gac.negocio.to.decorator.PessoaTODecorator;
import br.com.politec.generico.conversor.UtilConversorDeString;
import br.com.politec.generico.fabrica.ColecaoFactory;
import br.com.politec.generico.string.UtilString;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MigrarDadosClienteDAO
extends BancoAcessDAOAbstrato {
    private static final String BASE_ANTIGA = "BBDBT";

    private Set<IdentificacaoTO> consultarDocumentosPessoa(String codigoPessoa) {
        String query = "SELECT * FROM identificacao WHERE codigoPessoaFK='" + codigoPessoa + "'";
        Set listaDocumentos = ColecaoFactory.getInstance().novoHashSet();
        try {
            Statement statement = this.getConexao().createStatement();
            ResultSet rs = statement.executeQuery(query);
            while (rs.next()) {
                IdentificacaoTO to = this.getTOFactory().novoIdentificacaoTO();
                to.setTextoIdentificacao(rs.getString("numeroIdentificador"));
                IdentificadorTO identificadorTO = this.getTOFactory().novoIdentificadorTO();
                identificadorTO.setNomeIdentificador(rs.getString("codigoIdentificadorFK"));
                to.setIdentificadorTO(identificadorTO);
                listaDocumentos.add(to);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return listaDocumentos;
    }

    private char retirarDigitoVerificador(String numeroContaCorrente) {
        if (numeroContaCorrente == null || numeroContaCorrente.trim().length() == 0) {
            return ' ';
        }
        char digitoVerificador = numeroContaCorrente.substring(numeroContaCorrente.length() - 1).charAt(0);
        return digitoVerificador;
    }

    /*
     * Unable to fully structure code
     */
    private Integer converterParaInteiro(String valorString) {
        if (valorString != null && !valorString.trim().equals("")) ** GOTO lbl4
        return 0;
lbl-1000:
        // 1 sources

        {
            valorString = valorString.substring(1);
lbl4:
            // 2 sources

            ** while (valorString.startsWith((String)"0"))
        }
lbl5:
        // 1 sources

        return UtilConversorDeString.converterParaInteger((String)valorString);
    }

    /*
     * Unable to fully structure code
     */
    private Long converterParaLong(String valorString) {
        if (valorString != null) ** GOTO lbl4
        return 0L;
lbl-1000:
        // 1 sources

        {
            valorString = valorString.substring(1);
lbl4:
            // 2 sources

            ** while (valorString.startsWith((String)"0"))
        }
lbl5:
        // 1 sources

        return UtilConversorDeString.converterParaLong((String)valorString);
    }

    public MigrarBaseDecorator<String, ConvenenteTO> consultarConvenente(String identificacaoConvenente) {
        StringBuffer query = new StringBuffer();
        query.append("SELECT DISTINCT Convenente.codigoPessoaFK AS codigoPessoaFK, ConvenenteDBT.codigoIdentificadorFK,");
        query.append(" Identificacao.codigoIdentificadorFK, Identificador.tamanhoIdentificador, Identificador.indicadorDominio, Identificacao.numeroIdentificador");
        query.append(" FROM ((Convenente LEFT JOIN Identificacao ON Convenente.codigoPessoaFK = Identificacao.codigoPessoaFK)");
        query.append(" LEFT JOIN ConvenenteDBT ON Convenente.codigoPessoaFK = ConvenenteDBT.codigoPessoaFK)");
        query.append(" LEFT JOIN Identificador ON (ConvenenteDBT.codigoIdentificadorFK = Identificador.codigoIdentificador)");
        query.append(" AND (ConvenenteDBT.codigoPessoaFK = Identificador.codigoPessoaFK)");
        query.append(" WHERE (((Identificacao.codigoIdentificadorFK)='");
        query.append(identificacaoConvenente.length() == 11 ? "CPF" : "CNPJ");
        query.append("')");
        query.append(" AND ((Identificacao.numeroIdentificador)='");
        query.append(identificacaoConvenente);
        query.append("'))");
        MigrarBaseDecorator<String, ConvenenteTO> decorator = new MigrarBaseDecorator<String, ConvenenteTO>();
        decorator.setObjeto(null);
        ArrayList<UtilMigracaoException> listaExceptions = new ArrayList<UtilMigracaoException>();
        String erroInserirConvenente = " - Erro ao inserir o Convenente Pessoa";
        String motivo = "";
        try {
            Statement statement = this.getConexao().createStatement();
            ResultSet rs = statement.executeQuery(query.toString());
            try {
                if (rs.next()) {
                    String codigoPessoa = rs.getString("codigoPessoaFK");
                    String tamanhoIdentificador = rs.getString("tamanhoIdentificador");
                    motivo = "CONVENENTE PESSOA N\u00c3O MIGRADO" + erroInserirConvenente;
                    UtilValidaDadosMigracao.validarStringQueViraNumerico(7, codigoPessoa, motivo, "codigoPessoaFK");
                    UtilValidaDadosMigracao.validarStringQueViraNumericoPermiteNull(7, tamanhoIdentificador, motivo, "tamanhoIdentificador");
                    ConvenenteTO convenenteTO = this.getTOFactory().novoConvenenteTO();
                    convenenteTO.setCodigoPessoaConvenente(Integer.valueOf(codigoPessoa));
                    if (tamanhoIdentificador != null) {
                        IdentificadorTO identificadorTO = this.getTOFactory().novoIdentificadorTO();
                        identificadorTO.setNumeroTamanhoIdentificador(Integer.valueOf(Integer.parseInt(tamanhoIdentificador)));
                        String indicadorDominio = rs.getString("indicadorDominio");
                        identificadorTO.setIndicadorDominio(indicadorDominio != null ? Character.valueOf(indicadorDominio.charAt(0)) : null);
                        convenenteTO.setIdentificadorTO(identificadorTO);
                    }
                    decorator.setObjeto(convenenteTO);
                    return decorator;
                }
            }
            catch (UtilMigracaoException e) {
                String nomeTabela = "";
                nomeTabela = e.getCampoComErro().equals("codigoPessoaFK") ? "Convenente" : "Identificador";
                e.setNomeBase(BASE_ANTIGA);
                e.setNomeTabela(nomeTabela);
                listaExceptions.add(e);
                decorator.setObjeto(null);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        decorator.setListaExceptions(listaExceptions);
        return decorator;
    }

    public Map<String, ConvenioTO> consultarConveniosConvenente(String codigoPessoaConvenente, ConvenenteTO convenenteTO, Map<String, ContaCorrenteClienteTO> listaContas) {
        HashMap<String, ConvenioTO> listaConvenios = new HashMap<String, ConvenioTO>();
        String query = "SELECT * FROM ConvenioDBT WHERE codigoPessoaFK='" + codigoPessoaConvenente + "'";
        try {
            Statement statement = this.getConexao().createStatement();
            ResultSet rs = statement.executeQuery(query);
            while (rs.next()) {
                ConvenioTO convenioTO = this.getTOFactory().novoConvenioTO();
                ServicoTO servicoTO = this.getTOFactory().novoServicoTO();
                servicoTO.setTextoIdentificadorServico("DBT");
                convenioTO.setServicoTO(servicoTO);
                convenioTO.setConvenenteTO(convenenteTO);
                String numeroConvenio = rs.getString("numeroConvenioDBT");
                convenioTO.setNumeroConvenio(this.converterParaInteiro(numeroConvenio));
                String codigoAgencia = rs.getString("codigoPrefixoAgenciaFK");
                String codigoConta = rs.getString("numeroContaCorrenteFK");
                convenioTO.setTextoDescricaoConvenio(rs.getString("textoDescricaoConvenio"));
                convenioTO.setValorLimite(new BigDecimal(0));
                ContaCorrenteClienteTO contaCorrenteClienteTO = listaContas.get(String.valueOf(codigoAgencia) + codigoConta);
                convenioTO.setAgenciaInstituicaoFinanceiraTO(contaCorrenteClienteTO.getAgenciaInstituicaoFinanceiraTO());
                convenioTO.setContaCorrenteClienteTO(contaCorrenteClienteTO);
                listaConvenios.put(numeroConvenio, convenioTO);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return listaConvenios;
    }

    public MigrarBaseDecorator<String, ConvenioTODecorator> consultarConveniosConvenente(String codigoPessoaConvenente, ConvenenteTO convenenteTO) {
        HashMap<String, ConvenioTODecorator> listaConvenios = new HashMap<String, ConvenioTODecorator>();
        StringBuffer query = new StringBuffer();
        query.append("SELECT ");
        query.append("ConvenioDBT.numeroConvenioDBT, ");
        query.append("ConvenioDBT.codigoPrefixoAgenciaFK, ");
        query.append("ConvenioDBT.numeroContaCorrenteFK, ");
        query.append("ConvenioDBT.textoDescricaoConvenio, ");
        query.append("ID.tamanhoIdentificador, ");
        query.append("ID.indicadorDominio ");
        query.append("FROM ConvenioDBT as ConvenioDBT ");
        query.append("INNER JOIN Identificador as ID on(ConvenioDBT.codigoIdentificadorFK = ID.codigoIdentificador) WHERE ConvenioDBT.codigoPessoaFK='").append(codigoPessoaConvenente).append("'");
        MigrarBaseDecorator<String, ConvenioTODecorator> decorator = new MigrarBaseDecorator<String, ConvenioTODecorator>();
        ArrayList<UtilMigracaoException> listaExceptions = new ArrayList<UtilMigracaoException>();
        String erroInserirConvenio = " - Erro ao inserir o Conv\u00eanio";
        String motivo = "";
        try {
            Statement statement = this.getConexao().createStatement();
            ResultSet rs = statement.executeQuery(query.toString());
            try {
                while (rs.next()) {
                    String numeroConvenio = rs.getString("numeroConvenioDBT");
                    String tamanhoIdentificador = rs.getString("tamanhoIdentificador");
                    motivo = "CONV\u00caNIO N\u00c3O MIGRADO" + erroInserirConvenio + (numeroConvenio != null ? ". Nr. do Conv\u00eanio: " + numeroConvenio : "");
                    UtilValidaDadosMigracao.validarStringQueViraNumericoPermiteNull(7, numeroConvenio, motivo, "numeroConvenioDBT");
                    UtilValidaDadosMigracao.validarStringQueViraNumericoPermiteNull(7, tamanhoIdentificador, motivo, "tamanhoIdentificador");
                    ConvenioTO convenioTO = this.getTOFactory().novoConvenioTO();
                    ServicoTO servicoTO = this.getTOFactory().novoServicoTO();
                    servicoTO.setTextoIdentificadorServico("DBT");
                    convenioTO.setServicoTO(servicoTO);
                    convenioTO.setConvenenteTO(convenenteTO);
                    convenioTO.setNumeroConvenio(this.converterParaInteiro(numeroConvenio));
                    convenioTO.setTextoDescricaoConvenio(rs.getString("textoDescricaoConvenio"));
                    convenioTO.setValorLimite(new BigDecimal(0));
                    ConvenioDebitoTO convenioDebitoTO = this.getTOFactory().novoConvenioDebitoTO();
                    convenioDebitoTO.setNumeroTamanhoIdentificadorDebito(this.converterParaInteiro(tamanhoIdentificador));
                    convenioDebitoTO.setTextoIdentificadorRegistroDebito(rs.getString("indicadorDominio"));
                    ConvenioTODecorator convenioTODecorator = this.getTOFactory().novoConvenioTODecorator();
                    convenioTODecorator.setConvenioTO(convenioTO);
                    convenioTODecorator.setConvenioDebitoTO(convenioDebitoTO);
                    listaConvenios.put(numeroConvenio, convenioTODecorator);
                }
            }
            catch (UtilMigracaoException e) {
                String nomeTabela = "";
                nomeTabela = e.getCampoComErro().equals("ConvenioDBT") ? "numeroConvenioDBT" : "Identificador";
                e.setNomeTabela(nomeTabela);
                e.setNomeBase(BASE_ANTIGA);
                listaExceptions.add(e);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        decorator.setListaExceptions(listaExceptions);
        decorator.setMapaDeObjetos(listaConvenios);
        return decorator;
    }

    public MigrarBaseDecorator<String, AgenciaInstituicaoFinanceiraTO> consultarAgencias(InstituicaoFinanceiraTO instituicaoFinanceiraTO) {
        HashMap<String, AgenciaInstituicaoFinanceiraTO> lista = new HashMap<String, AgenciaInstituicaoFinanceiraTO>();
        String query = "SELECT * FROM Agencia ";
        MigrarBaseDecorator<String, AgenciaInstituicaoFinanceiraTO> decorator = new MigrarBaseDecorator<String, AgenciaInstituicaoFinanceiraTO>();
        ArrayList<UtilMigracaoException> listaExceptions = new ArrayList<UtilMigracaoException>();
        String erroInserirAgencia = " - Erro ao inserir a Ag\u00eancia";
        String motivo = "";
        try {
            Statement statement = this.getConexao().createStatement();
            ResultSet rs = statement.executeQuery(query);
            try {
                while (rs.next()) {
                    String codigoPrefixoAgencia = rs.getString("codigoPrefixoAgencia");
                    motivo = "AG\u00caNCIA N\u00c3O MIGRADA" + erroInserirAgencia;
                    UtilValidaDadosMigracao.validarAgenciaOuConta(5, codigoPrefixoAgencia, motivo, "codigoPrefixoAgencia");
                    AgenciaInstituicaoFinanceiraTO to = this.getTOFactory().novoAgenciaInstituicaoFinanceiraTO();
                    char digitoVerificador = this.retirarDigitoVerificador(codigoPrefixoAgencia);
                    to.setInstituicaoFinanceiraTO(instituicaoFinanceiraTO);
                    to.setCodigoAgencia(this.converterParaInteiro(codigoPrefixoAgencia.substring(0, codigoPrefixoAgencia.length() - 1)));
                    to.setDigitoVerificadorAgencia(Character.valueOf(digitoVerificador));
                    to.setTextoDescricao(rs.getString("textoDescricao"));
                    to.setIndicadorTipoAgencia(Character.valueOf('A'));
                    lista.put(codigoPrefixoAgencia, to);
                }
            }
            catch (UtilMigracaoException e) {
                e.setNomeTabela("Agencia");
                e.setNomeBase(BASE_ANTIGA);
                listaExceptions.add(e);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        decorator.setListaExceptions(listaExceptions);
        decorator.setMapaDeObjetos(lista);
        return decorator;
    }

    public MigrarBaseDecorator<Integer, GrupoClienteRecebimentoTO> consultarGruposConvenente(String codigoPessoaConvenente, Map<String, ConvenioTO> listaConvenios) {
        StringBuilder query = new StringBuilder();
        query.append("SELECT * FROM GrupoClienteRecebimento WHERE codigoPessoaFK='");
        query.append(codigoPessoaConvenente);
        query.append("'");
        query.append(" AND numeroConvenioDBTFK IN ('");
        Iterator<ConvenioTO> iterator = listaConvenios.values().iterator();
        while (iterator.hasNext()) {
            ConvenioTO convenioTO = iterator.next();
            query.append(UtilString.completarAEsquerda((String)convenioTO.getId().getNumeroConvenio().toString(), (String)"0", (int)5));
            if (!iterator.hasNext()) continue;
            query.append("','");
        }
        query.append("')");
        HashMap<Integer, GrupoClienteRecebimentoTO> lista = new HashMap<Integer, GrupoClienteRecebimentoTO>();
        MigrarBaseDecorator<Integer, GrupoClienteRecebimentoTO> decorator = new MigrarBaseDecorator<Integer, GrupoClienteRecebimentoTO>();
        ArrayList<UtilMigracaoException> listaExceptions = new ArrayList<UtilMigracaoException>();
        String erroInserirGrupoRecebimentoConvenio = " - Erro ao inserir o Grupo de Recebimento do Conv\u00eanio";
        String motivo = "";
        try {
            Statement statement = this.getConexao().createStatement();
            ResultSet rs = statement.executeQuery(query.toString());
            try {
                while (rs.next()) {
                    GrupoClienteRecebimentoTO grupoRecebimentoTO = this.getTOFactory().novoGrupoClienteRecebimentoTO();
                    Integer codigoGrupo = rs.getInt("codigoGrupoClienteRecebimento");
                    String codigoConvenio = rs.getString("numeroConvenioDBTFK");
                    motivo = "GRUPO CLIENTE RECEBIMENTO N\u00c3O MIGRADO" + erroInserirGrupoRecebimentoConvenio + (codigoGrupo != null ? ". C\u00f3d. do Grupo: " + codigoGrupo : "");
                    UtilValidaDadosMigracao.validarNumeroNotNull(codigoGrupo, motivo, "codigoGrupoClienteRecebimento");
                    ConvenioTO convenioTO = listaConvenios.get(codigoConvenio);
                    grupoRecebimentoTO.setConvenioDebitoTO(this.getConvenioDebitoTO(convenioTO));
                    grupoRecebimentoTO.setCodigoGrupoClienteRecebimento(codigoGrupo);
                    grupoRecebimentoTO.setTextoDescricao(rs.getString("textoDescricao"));
                    lista.put(codigoGrupo, grupoRecebimentoTO);
                }
            }
            catch (UtilMigracaoException e) {
                e.setNomeTabela("GrupoClienteRecebimento");
                e.setNomeBase(BASE_ANTIGA);
                listaExceptions.add(e);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        decorator.setListaExceptions(listaExceptions);
        decorator.setMapaDeObjetos(lista);
        return decorator;
    }

    private ConvenioDebitoTO getConvenioDebitoTO(ConvenioTO convenioTO) {
        ConvenioDebitoTO convenioDebitoTO = this.getTOFactory().novoConvenioDebitoTO();
        convenioDebitoTO.setConvenioTO(convenioTO);
        return convenioDebitoTO;
    }

    public MigrarBaseDecorator<String, ContaCorrenteClienteTO> consultarContasCorrentes(Map<String, AgenciaInstituicaoFinanceiraTO> listaAgencias, Map<String, PessoaTODecorator> listaPessoas) {
        HashMap<String, ContaCorrenteClienteTO> lista = new HashMap<String, ContaCorrenteClienteTO>();
        String query = "SELECT * FROM ContaCorrente";
        MigrarBaseDecorator<String, ContaCorrenteClienteTO> decorator = new MigrarBaseDecorator<String, ContaCorrenteClienteTO>();
        ArrayList<UtilMigracaoException> listaExceptions = new ArrayList<UtilMigracaoException>();
        String erroInserirContaCorrente = " - Erro ao inserir a Conta Corrente";
        String motivo = "";
        String codigoPessoa = "";
        try {
            Statement statement = this.getConexao().createStatement();
            ResultSet rs = statement.executeQuery(query);
            try {
                while (rs.next()) {
                    String codigoAgencia = rs.getString("codigoPrefixoAgenciaFK");
                    String codigoConta = rs.getString("numeroContaCorrente");
                    codigoPessoa = rs.getString("codigoPessoaFK");
                    motivo = "AG\u00caNCIA N\u00c3O MIGRADA" + erroInserirContaCorrente;
                    UtilValidaDadosMigracao.validarAgenciaOuConta(5, codigoAgencia, motivo, "codigoPrefixoAgenciaFK");
                    motivo = "CONTA CORRENTE N\u00c3O MIGRADA" + erroInserirContaCorrente;
                    UtilValidaDadosMigracao.validarAgenciaOuConta(12, codigoConta, motivo, "numeroContaCorrente");
                    UtilValidaDadosMigracao.validarStringQueViraNumerico(7, codigoPessoa, motivo, "codigoPessoaFK");
                    ContaCorrenteClienteTO conta = this.getTOFactory().novoContaCorrenteClienteTO();
                    AgenciaInstituicaoFinanceiraTO agenciaTO = listaAgencias.get(codigoAgencia);
                    conta.setAgenciaInstituicaoFinanceiraTO(agenciaTO);
                    char digitoConta = this.retirarDigitoVerificador(codigoConta);
                    ContaCorrenteClienteTOId id = this.getTOFactory().novoContaCorrenteClienteTOId();
                    id.setCodigoInstituicaoFinanceira(Integer.valueOf(1));
                    id.setCodigoAgencia(agenciaTO.getCodigoAgencia());
                    id.setCodigoContaCorrente(this.converterParaLong(codigoConta.substring(0, codigoConta.length() - 1)));
                    conta.setId(id);
                    conta.setPessoaTO(listaPessoas.get(codigoPessoa) == null ? null : listaPessoas.get(codigoPessoa).getPessoaTO());
                    conta.setDigitoVerificadorContaCorrente(Character.valueOf(digitoConta));
                    conta.setTextoDescricaoContaCorrente(rs.getString("textoDescricaoContaCorrente"));
                    lista.put(String.valueOf(codigoAgencia) + codigoConta, conta);
                }
            }
            catch (UtilMigracaoException e) {
                e.setNomeTabela("ContaCorrente");
                e.setNomeBase(BASE_ANTIGA);
                e.setPessoaTO(listaPessoas.get(codigoPessoa) != null ? listaPessoas.get(codigoPessoa).getPessoaTO() : new PessoaTO());
                listaExceptions.add(e);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        decorator.setListaExceptions(listaExceptions);
        decorator.setMapaDeObjetos(lista);
        return decorator;
    }

    public MigrarBaseDecorator<String, PessoaTODecorator> consultarPessoasIncluir(String codigoPessoaConvenente, Map<String, TipoPessoaTO> listaTipoPessoas, String filtro) {
        String query = "SELECT Pessoa.* FROM relacaoPessoaPlugin INNER JOIN Pessoa ON relacaoPessoaPlugin.codigoPessoaFK=Pessoa.codigoPessoa WHERE codigoPessoaConvenenteFK='" + codigoPessoaConvenente + "'";
        if (filtro != null && filtro.trim().length() > 0) {
            query = String.valueOf(query) + " AND Pessoa.codigoPessoa IN (" + filtro + ")";
        }
        HashMap<String, PessoaTODecorator> lista = new HashMap<String, PessoaTODecorator>();
        MigrarBaseDecorator<String, PessoaTODecorator> decorator = new MigrarBaseDecorator<String, PessoaTODecorator>();
        ArrayList<UtilMigracaoException> listaExceptions = new ArrayList<UtilMigracaoException>();
        String erroInserirPessoa = " - Erro ao inserir a Pessoa";
        String motivo = "";
        String codigoPessoa = "";
        String textoSiglaUF = "";
        String textoNome = "";
        try {
            Statement statement = this.getConexao().createStatement();
            ResultSet rs = statement.executeQuery(query);
            try {
                while (rs.next()) {
                    PessoaTODecorator pessoaDBTTO = new PessoaTODecorator();
                    codigoPessoa = rs.getString("codigoPessoa");
                    textoSiglaUF = rs.getString("textoSiglaUFFK");
                    textoNome = rs.getString("textoNome");
                    motivo = "PESSOA N\u00c3O MIGRADA" + erroInserirPessoa;
                    UtilValidaDadosMigracao.validarStringQueViraNumerico(7, codigoPessoa, motivo, "codigoPessoa");
                    UtilValidaDadosMigracao.validarStringCompleto(2, textoSiglaUF, motivo, "textoSiglaUFFK");
                    pessoaDBTTO.setTextoNome(textoNome);
                    Integer codigoTipoPessoa = rs.getInt("codigoTipoPessoaFK");
                    if (codigoTipoPessoa == null || codigoTipoPessoa == 0) {
                        codigoTipoPessoa = 1;
                    }
                    pessoaDBTTO.setTipoPessoaTO(listaTipoPessoas.get("" + codigoTipoPessoa));
                    pessoaDBTTO.setDataUltimaOperacao(new java.util.Date());
                    LogradouroTO logradouroTO = this.getTOFactory().novoLogradouroTO();
                    logradouroTO.setTextoLogradouro(rs.getString("textoEndereco"));
                    logradouroTO.setTextoBairro(rs.getString("textoBairro"));
                    logradouroTO.setTextoCidade(rs.getString("textoCidade"));
                    logradouroTO.setTextoCep(rs.getString("codigoCep"));
                    UnidadeFederativaBrasilTO unidadeFederativaBrasilTO = this.getTOFactory().novoUnidadeFederativaBrasilTO();
                    unidadeFederativaBrasilTO.setTextoSiglaUf(textoSiglaUF);
                    logradouroTO.setUnidadeFederativaBrasilTO(unidadeFederativaBrasilTO);
                    TipoLogradouroTO tipoLogradouroTO = this.getTOFactory().novoTipoLogradouroTO();
                    tipoLogradouroTO.setCodigoTipoLogradouro(Integer.valueOf(1));
                    logradouroTO.setTipoLogradouroTO(tipoLogradouroTO);
                    logradouroTO.setNumeroLogradouro(Integer.valueOf(0));
                    logradouroTO.setPessoaTO(pessoaDBTTO.getPessoaTO());
                    Set logradouros = ColecaoFactory.getInstance().novoHashSet();
                    logradouros.add(logradouroTO);
                    pessoaDBTTO.setLogradouroTOs(logradouros);
                    lista.put(codigoPessoa, pessoaDBTTO);
                }
            }
            catch (UtilMigracaoException e) {
                PessoaTO pss = new PessoaTO();
                pss.setTextoNome(textoNome);
                if (textoNome != null && textoNome.equalsIgnoreCase("") || textoNome == null) {
                    e.setMotivo(String.valueOf(e.getMotivo()) + codigoPessoa != null ? ". C\u00f3d. da Pessoa: " + codigoPessoa : "");
                }
                e.setNomeTabela("Pessoa");
                e.setNomeBase(BASE_ANTIGA);
                e.setPessoaTO(pss);
                listaExceptions.add(e);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        decorator.setListaExceptions(listaExceptions);
        decorator.setMapaDeObjetos(lista);
        return decorator;
    }

    public MigrarBaseDecorator<String, TipoPessoaTO> consultarTipoPessoa() {
        HashMap<String, TipoPessoaTO> lista = new HashMap<String, TipoPessoaTO>();
        String query = "SELECT * FROM TipoPessoa";
        MigrarBaseDecorator<String, TipoPessoaTO> decorator = new MigrarBaseDecorator<String, TipoPessoaTO>();
        ArrayList<UtilMigracaoException> listaExceptions = new ArrayList<UtilMigracaoException>();
        String erroInserirTipoPessoa = " - Erro ao inserir o Tipo de Pessoa";
        String motivo = "";
        try {
            Statement statement = this.getConexao().createStatement();
            ResultSet rs = statement.executeQuery(query);
            try {
                while (rs.next()) {
                    Integer codigoTipoPessoa = rs.getInt("codigoTipoPessoa");
                    motivo = "TIPO PESSOA N\u00c3O MIGRADO" + erroInserirTipoPessoa + (codigoTipoPessoa != null ? ". C\u00f3d. do Tipo Pessoa: " + codigoTipoPessoa : "");
                    UtilValidaDadosMigracao.validarCampoDeIndicadorNumerico("0,1,2,3,4,5", codigoTipoPessoa, motivo, "codigoTipoPessoa");
                    TipoPessoaTO tipoPessoaTO = this.getTOFactory().novoTipoPessoaTO();
                    tipoPessoaTO.setCodigoTipoPessoa(codigoTipoPessoa);
                    tipoPessoaTO.setTextoDescricao(rs.getString("textoDescricao"));
                    lista.put("" + codigoTipoPessoa, tipoPessoaTO);
                }
            }
            catch (UtilMigracaoException e) {
                e.setNomeTabela("TipoPessoa");
                e.setNomeBase(BASE_ANTIGA);
                listaExceptions.add(e);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        decorator.setListaExceptions(listaExceptions);
        decorator.setMapaDeObjetos(lista);
        return decorator;
    }

    public MigrarBaseDecorator<String, IdentificacaoTO> consultarIdentificacoesClientes(Map<String, PessoaTODecorator> listaPessoas, String filtro, String filtroIdentificacaoPropriaConvenente, String textoIdentificacaoConvenenteGAC, Integer codigoIdentificacaoConvenenteGAC) {
        StringBuffer query = new StringBuffer();
        query.append("SELECT * FROM Identificacao");
        query.append(" WHERE codigoIdentificadorFK IN ('CNPJ','CPF'");
        if (filtroIdentificacaoPropriaConvenente != null) {
            query.append(",'").append(filtroIdentificacaoPropriaConvenente).append("'");
        }
        query.append(")");
        if (filtro != null && filtro.trim().length() > 0) {
            query.append(" AND codigoPessoaFK IN (").append(filtro).append(")");
        }
        query.append(" ORDER BY codigoPessoaFK");
        MigrarBaseDecorator<String, IdentificacaoTO> decorator = new MigrarBaseDecorator<String, IdentificacaoTO>();
        ArrayList<UtilMigracaoException> listaExceptions = new ArrayList<UtilMigracaoException>();
        String erroInserirIdentificacao = " - Erro ao inserir a Identifica\u00e7\u00e3o";
        String motivo = "";
        String codigoPessoa = "";
        try {
            Statement statement = this.getConexao().createStatement();
            ResultSet rs = statement.executeQuery(query.toString());
            String codigoAtual = null;
            HashSet<IdentificacaoTO> listaIdentificacao = new HashSet<IdentificacaoTO>();
            PessoaTODecorator pessoaTO = null;
            try {
                while (rs.next()) {
                    codigoPessoa = rs.getString("codigoPessoaFK");
                    motivo = "IDENTIFICA\u00c7\u00c3O N\u00c3O MIGRADA" + erroInserirIdentificacao;
                    UtilValidaDadosMigracao.validarStringQueViraNumerico(7, codigoPessoa, motivo, "codigoPessoaFK");
                    if (!codigoPessoa.equals(codigoAtual)) {
                        if (codigoAtual != null && pessoaTO != null) {
                            pessoaTO.setIdentificacaoTOs(listaIdentificacao);
                            listaIdentificacao = new HashSet();
                        }
                        codigoAtual = codigoPessoa;
                        pessoaTO = listaPessoas.get(codigoPessoa);
                    }
                    if (pessoaTO == null) continue;
                    String numeroIdentificador = rs.getString("numeroIdentificador");
                    String codigoIdentificador = rs.getString("codigoIdentificadorFK");
                    UtilValidaDadosMigracao.validarStringCompleto(30, numeroIdentificador, motivo, "numeroIdentificador");
                    IdentificacaoTO identificacaoTO = this.getTOFactory().novoIdentificacaoTO();
                    identificacaoTO.setTextoIdentificacao(numeroIdentificador);
                    identificacaoTO.setPessoaTO(pessoaTO.getPessoaTO());
                    IdentificadorTO identificadorTO = this.getTOFactory().novoIdentificadorTO();
                    identificadorTO.setTipoDocumentoTO(this.getTOFactory().novoTipoDocumentoTO());
                    IdentificadorTOId id = new IdentificadorTOId();
                    if ("CNPJ".equals(codigoIdentificador)) {
                        id.setCodigoTipoDocumento(Integer.valueOf(2));
                        id.setTextoIdentificador("2");
                    } else if ("CPF".equals(codigoIdentificador)) {
                        id.setCodigoTipoDocumento(Integer.valueOf(1));
                        id.setTextoIdentificador("1");
                    } else {
                        id.setCodigoTipoDocumento(codigoIdentificacaoConvenenteGAC);
                        id.setTextoIdentificador(textoIdentificacaoConvenenteGAC);
                    }
                    identificadorTO.setId(id);
                    identificadorTO.getTipoDocumentoTO().setCodigoTipoDocumento(id.getCodigoTipoDocumento());
                    identificacaoTO.setTipoDocumentoTO(identificadorTO.getTipoDocumentoTO());
                    identificacaoTO.setIdentificadorTO(identificadorTO);
                    listaIdentificacao.add(identificacaoTO);
                }
                if (codigoAtual != null) {
                    pessoaTO.setIdentificacaoTOs(listaIdentificacao);
                }
            }
            catch (UtilMigracaoException e) {
                e.setNomeTabela("Identificacao");
                e.setNomeBase(BASE_ANTIGA);
                e.setPessoaTO(listaPessoas.get(codigoPessoa) != null ? listaPessoas.get(codigoPessoa).getPessoaTO() : new PessoaTO());
                listaExceptions.add(e);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        decorator.setListaExceptions(listaExceptions);
        return decorator;
    }

    public MigrarBaseDecorator<String, MembroGrupoClienteRecebimentoTODecorator> consultarMembroGruposRecebimento(String codigoPessoaConvenente, Map<String, PessoaTODecorator> listaPessoas, Map<Integer, GrupoClienteRecebimentoTO> listaGruposBaseAntiga, Map<String, Set<IdentificadorClienteDebitoTO>> listaIdentDebito, String filtro, Map<String, ConvenioTO> listaConvenios) {
        StringBuffer query = new StringBuffer();
        query.append("SELECT * FROM MembroGrupoClienteRecebimento ");
        query.append("WHERE codigoPessoaIdentificadorFK='");
        query.append(String.valueOf(codigoPessoaConvenente) + "'");
        if (filtro != null && filtro.trim().length() > 0) {
            query.append(" AND codigoPessoaFK IN (");
            query.append(filtro);
            query.append(")");
        }
        query.append(" AND numeroConvenioDBTFK IN ('");
        Iterator<ConvenioTO> iterator = listaConvenios.values().iterator();
        while (iterator.hasNext()) {
            ConvenioTO convenioTO = iterator.next();
            query.append(UtilString.completarAEsquerda((String)convenioTO.getId().getNumeroConvenio().toString(), (String)"0", (int)5));
            if (!iterator.hasNext()) continue;
            query.append("','");
        }
        query.append("')");
        query.append(" ORDER BY codigoPessoaFK");
        MigrarBaseDecorator<String, MembroGrupoClienteRecebimentoTODecorator> decorator = new MigrarBaseDecorator<String, MembroGrupoClienteRecebimentoTODecorator>();
        ArrayList<UtilMigracaoException> listaExceptions = new ArrayList<UtilMigracaoException>();
        String erroInserirMembroGrupoClienteRecebimento = " - Erro ao inserir o Membro do Grupo Cliente Recebimento";
        String motivo = "";
        String codigoPessoa = "";
        try {
            Statement statement = this.getConexao().createStatement();
            ResultSet rs = statement.executeQuery(query.toString());
            String codigoAtual = null;
            HashSet<MembroGrupoClienteRecebimentoTODecorator> listaGruposClienteRecebimentoDecorators = null;
            PessoaTODecorator pessoaTO = null;
            try {
                while (rs.next()) {
                    codigoPessoa = rs.getString("codigoPessoaFK");
                    Integer codigoGrupo = rs.getInt("codigoGrupoClienteRecebimentoFK");
                    String numeroIdentificador = rs.getString("numeroIdentificadorFK");
                    String numeroConvenio = rs.getString("numeroConvenioDBTFK");
                    motivo = "MEMBRO GRUPO CLIENTE RECEBIMENTO N\u00c3O MIGRADO" + erroInserirMembroGrupoClienteRecebimento;
                    UtilValidaDadosMigracao.validarStringQueViraNumerico(7, codigoPessoa, motivo, "codigoPessoaFK");
                    UtilValidaDadosMigracao.validarNumeroNotNull(codigoGrupo, motivo, "codigoGrupoClienteRecebimentoFK");
                    UtilValidaDadosMigracao.validarStringSimples(25, numeroIdentificador, motivo, "numeroIdentificadorFK");
                    UtilValidaDadosMigracao.validarStringQueViraNumerico(7, numeroConvenio, motivo, "numeroConvenioDBTFK");
                    if (!codigoPessoa.equals(codigoAtual)) {
                        if (codigoAtual != null) {
                            pessoaTO.setMembroGrupoClienteRecebimentoTODecorators((Set)listaGruposClienteRecebimentoDecorators);
                        }
                        listaGruposClienteRecebimentoDecorators = new HashSet<MembroGrupoClienteRecebimentoTODecorator>();
                        codigoAtual = codigoPessoa;
                        pessoaTO = listaPessoas.get(codigoPessoa);
                    }
                    GrupoClienteRecebimentoTODecorator grupoClienteRecebimentoTODecorator = new GrupoClienteRecebimentoTODecorator();
                    grupoClienteRecebimentoTODecorator.setClienteRecebimentoTO(listaGruposBaseAntiga.get(codigoGrupo));
                    if (listaGruposBaseAntiga == null || listaGruposBaseAntiga.isEmpty()) continue;
                    MembroGrupoClienteRecebimentoTO membroGrupoClienteRecebimentoTO = this.getTOFactory().novoMembroGrupoClienteRecebimentoTO();
                    Set<IdentificadorClienteDebitoTO> listaIdentDebitoPessoa = listaIdentDebito.get(codigoPessoa);
                    for (IdentificadorClienteDebitoTO identificadorClienteDebitoTO : listaIdentDebitoPessoa) {
                        if (!identificadorClienteDebitoTO.getTextoIdentificadorDebito().equals(numeroIdentificador) || !identificadorClienteDebitoTO.getConvenioDebitoTO().getId().getNumeroConvenio().equals(this.converterParaInteiro(numeroConvenio))) continue;
                        membroGrupoClienteRecebimentoTO.setIdentificadorClienteDebitoTO(identificadorClienteDebitoTO);
                        break;
                    }
                    membroGrupoClienteRecebimentoTO.setPessoaTO(pessoaTO.getPessoaTO());
                    membroGrupoClienteRecebimentoTO.setGrupoClienteRecebimentoTO(grupoClienteRecebimentoTODecorator.getClienteRecebimentoTO());
                    if (grupoClienteRecebimentoTODecorator.getClienteRecebimentoTO() == null) continue;
                    MembroGrupoClienteRecebimentoTODecorator membroGrupoClienteRecebimentoTODecorator = new MembroGrupoClienteRecebimentoTODecorator();
                    membroGrupoClienteRecebimentoTODecorator.setMembroGrupoClienteRecebimentoTO(membroGrupoClienteRecebimentoTO);
                    membroGrupoClienteRecebimentoTODecorator.setGrupoClienteRecebimentoTODecorator(grupoClienteRecebimentoTODecorator);
                    listaGruposClienteRecebimentoDecorators.add(membroGrupoClienteRecebimentoTODecorator);
                }
                if (codigoAtual != null && listaGruposClienteRecebimentoDecorators != null && !listaGruposClienteRecebimentoDecorators.isEmpty()) {
                    pessoaTO.setMembroGrupoClienteRecebimentoTODecorators((Set)listaGruposClienteRecebimentoDecorators);
                }
            }
            catch (UtilMigracaoException e) {
                e.setNomeTabela("MembroGrupoClienteRecebimento");
                e.setNomeBase(BASE_ANTIGA);
                e.setPessoaTO(listaPessoas.get(codigoPessoa) != null ? listaPessoas.get(codigoPessoa).getPessoaTO() : new PessoaTO());
                listaExceptions.add(e);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        decorator.setListaExceptions(listaExceptions);
        return decorator;
    }

    public MigrarBaseDecorator<String, IdentificadorClienteDebitoTO> consultarIdentDebito(String codigoPessoaConvenente, Map<String, ConvenioTO> listaConvenios, Map<String, ContaCorrenteClienteTO> listaContas, Map<String, PessoaTODecorator> listaPessoas, Map<String, SituacaoIdentificadorDebitoTO> listaSituacaoIdentificador, String filtro) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("SELECT * FROM IdentificadorClienteDBT WHERE codigoPessoaIdentificadorFK='");
        buffer.append(codigoPessoaConvenente);
        buffer.append("'");
        buffer.append(" AND ").append(" numeroConvenioDBTFK ").append(" IN (");
        Iterator<String> iterator = listaConvenios.keySet().iterator();
        while (iterator.hasNext()) {
            buffer.append("'");
            String codigoConvenio = iterator.next();
            buffer.append(codigoConvenio).append("'");
            if (!iterator.hasNext()) continue;
            buffer.append(",");
        }
        buffer.append(")");
        if (filtro != null && filtro.trim().length() > 0) {
            buffer.append(" AND codigoPessoaFK IN (");
            buffer.append(filtro).append(")");
        }
        HashMap lista = new HashMap();
        String codigoTemp = null;
        MigrarBaseDecorator<String, IdentificadorClienteDebitoTO> decorator = new MigrarBaseDecorator<String, IdentificadorClienteDebitoTO>();
        ArrayList<UtilMigracaoException> listaExceptions = new ArrayList<UtilMigracaoException>();
        String erroInserirIdentDebito = " - Erro ao inserir o Identificador de D\u00e9bito do Cliente";
        String motivo = "";
        String codigoPessoa = "";
        try {
            Statement statement = this.getConexao().createStatement();
            ResultSet rs = statement.executeQuery(buffer.toString());
            try {
                while (rs.next()) {
                    codigoPessoa = rs.getString("codigoPessoaFK");
                    String nroIdentificador = rs.getString("numeroIdentificadorFK");
                    String nroIdentificadorAntigo = rs.getString("numeroIdentificadorAntigo");
                    motivo = "IDENTIFICA\u00c7\u00c3O D\u00c9BITO N\u00c3O MIGRADA" + erroInserirIdentDebito;
                    UtilValidaDadosMigracao.validarStringQueViraNumerico(7, codigoPessoa, motivo, "codigoPessoa");
                    UtilValidaDadosMigracao.validarStringSimples(25, nroIdentificador, motivo, "numeroIdentificadorFK");
                    UtilValidaDadosMigracao.validarStringSimples(25, nroIdentificadorAntigo, motivo, "numeroIdentificadorAntigo");
                    HashSet<IdentificadorClienteDebitoTO> listaIdent = (HashSet<IdentificadorClienteDebitoTO>)lista.get(codigoPessoa);
                    if (listaIdent == null || !codigoTemp.equals(codigoPessoa)) {
                        if (listaIdent == null) {
                            listaIdent = new HashSet<IdentificadorClienteDebitoTO>();
                        }
                        lista.put(codigoPessoa, listaIdent);
                    }
                    codigoTemp = codigoPessoa;
                    IdentificadorClienteDebitoTO identificadorDebito = this.getTOFactory().novoIdentificadorClienteDebitoTO();
                    identificadorDebito.setTextoIdentificadorDebito(nroIdentificador);
                    ConvenioDebitoTO convenioDebito = this.getConvenioDebitoTO(listaConvenios.get(rs.getString("numeroConvenioDBTFK")));
                    identificadorDebito.setConvenioDebitoTO(convenioDebito);
                    identificadorDebito.setPessoaTO(listaPessoas.get(codigoPessoa).getPessoaTO());
                    String codigoAgencia = rs.getString("codigoPrefixoAgenciaFK");
                    String codigoConta = rs.getString("numeroContaCorrenteFK");
                    identificadorDebito.setSituacaoIdentificadorDebitoTO(listaSituacaoIdentificador.get(rs.getString("codigoSituacaoIdentificadorFK")));
                    identificadorDebito.setTextoIdentificadorAnterior(nroIdentificadorAntigo);
                    identificadorDebito.setDataUltimaRemessa((java.util.Date)rs.getDate("dataUltimaRemessa"));
                    identificadorDebito.setDataAlteracaoRemessa((java.util.Date)rs.getDate("dataRemessaAlteracao"));
                    identificadorDebito.setNumeroAlteracaoRemessa(Integer.valueOf(rs.getInt("numeroRemessaAlteracao")));
                    identificadorDebito.setTextoDescricaoOcorrencia(rs.getString("textoDescricaoOcorrencia"));
                    String indicadorImpressao = rs.getString("indicadorImpressao");
                    if (indicadorImpressao != null && indicadorImpressao.trim().length() > 0) {
                        identificadorDebito.setIndicadorImpressao(Character.valueOf(indicadorImpressao.charAt(0)));
                    }
                    ContaCorrenteClienteTO contaCorrente = listaContas.get(String.valueOf(codigoAgencia) + codigoConta);
                    identificadorDebito.setContaCorrenteClienteTO(contaCorrente);
                    listaIdent.add(identificadorDebito);
                }
            }
            catch (UtilMigracaoException e) {
                e.setNomeTabela("IdentificadorClienteDBT");
                e.setNomeBase(BASE_ANTIGA);
                e.setPessoaTO(listaPessoas.get(codigoPessoa) != null ? listaPessoas.get(codigoPessoa).getPessoaTO() : new PessoaTO());
                listaExceptions.add(e);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        decorator.setListaExceptions(listaExceptions);
        decorator.setMapaDeObjetosSetEncadeados(lista);
        return decorator;
    }

    public Map<String, SituacaoIdentificadorDebitoTO> consultarSituacaoIdentificadorDebito() {
        HashMap<String, SituacaoIdentificadorDebitoTO> lista = new HashMap<String, SituacaoIdentificadorDebitoTO>();
        String query = "SELECT * FROM SituacaoIdentificadorDBT";
        try {
            Statement statement = this.getConexao().createStatement();
            ResultSet rs = statement.executeQuery(query);
            while (rs.next()) {
                SituacaoIdentificadorDebitoTO situacaoIdentificador = this.getTOFactory().novoSituacaoIdentificadorDebitoTO();
                String codigoIdentificador = rs.getString("codigoSituacaoIdentificador");
                situacaoIdentificador.setTextoSituacaoIdentificador(codigoIdentificador.charAt(0));
                situacaoIdentificador.setTextoDescricao(rs.getString("textoDescricao"));
                String indicadorEstado = rs.getString("indicadorEstado");
                if (indicadorEstado != null && indicadorEstado.trim().length() > 0) {
                    situacaoIdentificador.setIndicadorEstadoSituacaoIdentificador(Character.valueOf(indicadorEstado.charAt(0)));
                }
                lista.put(codigoIdentificador, situacaoIdentificador);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return lista;
    }

    public MigrarBaseDecorator<String, RecebimentoDebitoTO> consultarRecebimentos(String codigoPessoaConvenente, Map<String, ConvenioTO> listaConveniosMap, Map<String, TipoOcorrenciaRecebimentoDebitoTO> listaTipoOcorrencia, Map<String, SituacaoRecebimentoTO> listaSituacaoRecebimento, Map<String, RemessaTO> listaRemessas, Map<String, SituacaoIdentificadorDebitoTO> listaSituacaoIdentificador, Map<String, PessoaTODecorator> listaPessoas, Map<String, AgenciaInstituicaoFinanceiraTO> listaAgencias, Map<String, ContaCorrenteClienteTO> listaContas) {
        StringBuffer query = new StringBuffer();
        query.append("SELECT ");
        query.append("RCBT_DEB.codigoPessoaFK, RCBT_DEB.IDRegistro, RCBT_DEB.numeroConvenioDBT, RCBT_DEB.numeroRemessaFK, ");
        query.append("RCBT_DEB.dataRemessaFK, RCBT_DEB.numeroIdentificadorFK, RCBT_DEB.codigoSituacaoRecebimentoFK, RCBT_DEB.codigoTipoRetornoFK, ");
        query.append("RCBT_DEB.codigoRetornoFK, RCBT_DEB.codigoBancoLiquidacao,\tRCBT_DEB.codigoPrefixoAgenciaLiquidacao, RCBT_DEB.numeroContaCorrenteLiquidacao, ");
        query.append("RCBT_DEB.data, RCBT_DEB.valor, RCBT_DEB.dataDebitoEfetuado, RCBT_DEB.valorDebitoEfetuado, RCBT_DEB.numeroRecebimentoDBT, ");
        query.append("IDDBT.codigoPessoaFK, IDDBT.codigoPessoaIdentificadorFK, IDDBT.codigoPessoaBancoFK, IDDBT.codigoPrefixoAgenciaFK, IDDBT.numeroContaCorrenteFK, ");
        query.append("IDDBT.numeroConvenioDBTFK,  IDDBT.codigoSituacaoIdentificadorFK, IDDBT.numeroIdentificadorAntigo, IDDBT.dataUltimaRemessa, ");
        query.append("IDDBT.dataRemessaAlteracao, IDDBT.numeroRemessaAlteracao, IDDBT.textoDescricaoOcorrencia, IDDBT.indicadorImpressao ");
        query.append("FROM RecebimentoDBT as RCBT_DEB ");
        query.append("INNER JOIN IdentificadorClienteDBT as IDDBT on (IDDBT.codigoIdentificadorFK = RCBT_DEB.codigoIdentificadorFK ");
        query.append("AND IDDBT.numeroIdentificadorFK = RCBT_DEB.numeroIdentificadorFK) ");
        query.append("WHERE RCBT_DEB.codigoPessoaIdentificadorFK='");
        ArrayList<RecebimentoDebitoTO> listaRecebimentos = new ArrayList<RecebimentoDebitoTO>();
        query.append(codigoPessoaConvenente);
        query.append("'");
        boolean isPrimeiro = true;
        for (ConvenioTO convenio : listaConveniosMap.values()) {
            if (isPrimeiro) {
                query.append(" AND ").append("RCBT_DEB.numeroConvenioDBT IN (");
                isPrimeiro = false;
            } else {
                query.append(", ");
            }
            query.append("'");
            query.append(UtilString.completarAEsquerda((String)convenio.getNumeroConvenio().toString(), (String)"0", (int)5)).append("'");
        }
        query.append(") ");
        query.append("ORDER BY  RCBT_DEB.codigoPessoaFK");
        HashMap<String, ArrayList<RecebimentoDebitoTO>> lista = new HashMap<String, ArrayList<RecebimentoDebitoTO>>();
        MigrarBaseDecorator<String, RecebimentoDebitoTO> decorator = new MigrarBaseDecorator<String, RecebimentoDebitoTO>();
        ArrayList<UtilMigracaoException> listaExceptions = new ArrayList<UtilMigracaoException>();
        String erroInserirRecebimentoDBT = " - Erro ao inserir o Recebimento de D\u00e9bito";
        String motivo = "";
        String codigoPessoa = "";
        try {
            Statement statement = this.getConexao().createStatement();
            ResultSet rs = statement.executeQuery(query.toString());
            String temp = null;
            try {
                while (rs.next()) {
                    codigoPessoa = rs.getString("codigoPessoaFK");
                    String identificadorRegistro = rs.getString("IDRegistro");
                    String numeroConvenio = rs.getString("numeroConvenioDBT");
                    Integer numeroRemessa = rs.getInt("numeroRemessaFK");
                    String numeroIdentificador = rs.getString("numeroIdentificadorFK");
                    String codigoAgencia = rs.getString("codigoPrefixoAgenciaFK");
                    String codigoConta = rs.getString("numeroContaCorrenteFK");
                    String nroIdentificadorAntigo = rs.getString("numeroIdentificadorAntigo");
                    String codigoSituacaoRecebimento = rs.getString("codigoSituacaoRecebimentoFK");
                    Integer codigoTipoRetorno = rs.getInt("codigoTipoRetornoFK");
                    Integer codigoRetorno = rs.getInt("codigoRetornoFK");
                    String codigoBancoLiquidacao = rs.getString("codigoBancoLiquidacao");
                    String codigoAgenciaLiquidacao = rs.getString("codigoPrefixoAgenciaLiquidacao");
                    String numeroContaCorrenteLiquidacao = rs.getString("numeroContaCorrenteLiquidacao");
                    motivo = "RECEBIMENTO D\u00c9BITO N\u00c3O MIGRADO" + erroInserirRecebimentoDBT;
                    UtilValidaDadosMigracao.validarStringQueViraNumerico(7, codigoPessoa, motivo, "codigoPessoaFK");
                    UtilValidaDadosMigracao.validarStringSimples(25, numeroIdentificador, motivo, "numeroIdentificadorFK");
                    motivo = "AG\u00caNCIA N\u00c3O MIGRADA" + erroInserirRecebimentoDBT;
                    UtilValidaDadosMigracao.validarAgenciaOuConta(5, codigoAgencia, motivo, "codigoPrefixoAgenciaFK");
                    motivo = "CONTA CORRENTE N\u00c3O MIGRADA" + erroInserirRecebimentoDBT;
                    UtilValidaDadosMigracao.validarAgenciaOuConta(12, codigoConta, motivo, "numeroContaCorrenteFK");
                    motivo = "RECEBIMENTO D\u00c9BITO N\u00c3O MIGRADO" + erroInserirRecebimentoDBT;
                    UtilValidaDadosMigracao.validarStringSimples(25, nroIdentificadorAntigo, motivo, "numeroIdentificadorAntigo");
                    UtilValidaDadosMigracao.validarNumeroNotNullZeroValido(codigoTipoRetorno, motivo, "codigoTipoRetornoFK");
                    UtilValidaDadosMigracao.validarNumeroNotNullZeroValido(codigoRetorno, motivo, "codigoRetornoFK");
                    motivo = "BANCO N\u00c3O MIGRADO" + erroInserirRecebimentoDBT;
                    UtilValidaDadosMigracao.validarStringQueViraNumericoPermiteNull(3, codigoBancoLiquidacao, motivo, "codigoBancoLiquidacao");
                    motivo = "AG\u00caNCIA N\u00c3O MIGRADA" + erroInserirRecebimentoDBT;
                    UtilValidaDadosMigracao.validarAgenciaOuContaPermiteNull(5, codigoAgenciaLiquidacao, motivo, "codigoPrefixoAgenciaLiquidacao");
                    motivo = "CONTA CORRENTE N\u00c3O MIGRADA" + erroInserirRecebimentoDBT;
                    UtilValidaDadosMigracao.validarAgenciaOuContaPermiteNull(12, numeroContaCorrenteLiquidacao, motivo, "numeroContaCorrenteLiquidacao");
                    RecebimentoDebitoTO toRecebimento = this.getTOFactory().novoRecebimentoDebitoTO();
                    if (temp != null && !temp.equals(codigoPessoa)) {
                        listaRecebimentos = new ArrayList();
                    }
                    temp = codigoPessoa;
                    toRecebimento.setConvenioDebitoTO(this.getConvenioDebitoTO(listaConveniosMap.get(numeroConvenio)));
                    RemessaTO remessaTO = listaRemessas.get(String.valueOf(numeroConvenio) + "-" + numeroRemessa);
                    toRecebimento.setRemessaTO(remessaTO);
                    IdentificadorClienteDebitoTO identificadorClienteDebitoTO = this.getTOFactory().novoIdentificadorClienteDebitoTO();
                    identificadorClienteDebitoTO.setTextoIdentificadorDebito(numeroIdentificador);
                    identificadorClienteDebitoTO.setConvenioDebitoTO(toRecebimento.getConvenioDebitoTO());
                    ContaCorrenteClienteTO contaCorrente = listaContas.get(String.valueOf(codigoAgencia) + codigoConta);
                    identificadorClienteDebitoTO.setContaCorrenteClienteTO(contaCorrente);
                    AgenciaInstituicaoFinanceiraTO agenciaTO = listaAgencias.get(codigoAgencia);
                    ContaCorrenteClienteTOId contaCorrenteClienteTOId = this.getTOFactory().novoContaCorrenteClienteTOId();
                    contaCorrenteClienteTOId.setCodigoAgencia(Integer.valueOf(Integer.parseInt(codigoAgencia.substring(0, codigoAgencia.length() - 1))));
                    identificadorClienteDebitoTO.setAgenciaInstituicaoFinanceiraTO(agenciaTO);
                    identificadorClienteDebitoTO.setContaCorrenteClienteTO(contaCorrente);
                    ConvenioDebitoTO convenioDebito = this.getConvenioDebitoTO(listaConveniosMap.get(rs.getString("numeroConvenioDBTFK")));
                    identificadorClienteDebitoTO.setConvenioDebitoTO(convenioDebito);
                    identificadorClienteDebitoTO.setPessoaTO(listaPessoas.get(codigoPessoa).getPessoaTO());
                    identificadorClienteDebitoTO.setSituacaoIdentificadorDebitoTO(listaSituacaoIdentificador.get(rs.getString("codigoSituacaoIdentificadorFK")));
                    identificadorClienteDebitoTO.setTextoIdentificadorAnterior(nroIdentificadorAntigo);
                    identificadorClienteDebitoTO.setDataUltimaRemessa((java.util.Date)rs.getDate("dataUltimaRemessa"));
                    identificadorClienteDebitoTO.setDataAlteracaoRemessa((java.util.Date)rs.getDate("dataRemessaAlteracao"));
                    identificadorClienteDebitoTO.setNumeroAlteracaoRemessa(Integer.valueOf(rs.getInt("numeroRemessaAlteracao")));
                    identificadorClienteDebitoTO.setTextoDescricaoOcorrencia(rs.getString("textoDescricaoOcorrencia"));
                    String indicadorImpressao = rs.getString("indicadorImpressao");
                    if (indicadorImpressao != null && indicadorImpressao.trim().length() > 0) {
                        identificadorClienteDebitoTO.setIndicadorImpressao(Character.valueOf(indicadorImpressao.charAt(0)));
                    }
                    toRecebimento.setIdentificadorClienteDebitoTO(identificadorClienteDebitoTO);
                    toRecebimento.setSituacaoRecebimentoTO(listaSituacaoRecebimento.get(codigoSituacaoRecebimento));
                    String chave = String.valueOf(UtilString.completarAEsquerda((String)("" + codigoTipoRetorno), (String)"0", (int)3)) + UtilString.completarAEsquerda((String)("" + codigoRetorno), (String)"0", (int)3);
                    toRecebimento.setTipoOcorrenciaRecebimentoDebitoTO(listaTipoOcorrencia.get(chave));
                    toRecebimento.setCodigoBancoLiquidacao(UtilConversorDeString.converterParaInteger((String)codigoBancoLiquidacao));
                    toRecebimento.setCodigoAgenciaLiquidacao(UtilConversorDeString.converterParaInteger((String)codigoAgenciaLiquidacao));
                    toRecebimento.setCodigoContaCorrenteLiquidacao(UtilConversorDeString.converterParaInteger((String)numeroContaCorrenteLiquidacao));
                    toRecebimento.setDataRecebimento((java.util.Date)rs.getDate("data"));
                    toRecebimento.setValorRecebimento(rs.getBigDecimal("valor"));
                    toRecebimento.setDataDebito((java.util.Date)rs.getDate("dataDebitoEfetuado"));
                    toRecebimento.setValorDebito(rs.getBigDecimal("valorDebitoEfetuado"));
                    toRecebimento.setTextoIdentificadorRegistro(identificadorRegistro);
                    Integer numeroRecebimento = rs.getInt("numeroRecebimentoDBT");
                    toRecebimento.setNumeroRecebimento(numeroRecebimento);
                    listaRecebimentos.add(toRecebimento);
                    lista.put(codigoPessoa, listaRecebimentos);
                }
            }
            catch (UtilMigracaoException e) {
                if (e.getCampoComErro().equals("codigoPessoaFK") || e.getCampoComErro().equals("numeroIdentificadorFK") || e.getCampoComErro().equals("codigoPrefixoAgenciaFK") || e.getCampoComErro().equals("numeroContaCorrenteFK") || e.getCampoComErro().equals("numeroIdentificadorAntigo")) {
                    e.setNomeTabela("IdentificadorClienteDBT");
                } else {
                    e.setNomeTabela("RecebimentoDBT");
                }
                e.setNomeBase(BASE_ANTIGA);
                e.setPessoaTO(listaPessoas.get(codigoPessoa) != null ? listaPessoas.get(codigoPessoa).getPessoaTO() : new PessoaTO());
                listaExceptions.add(e);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        decorator.setListaExceptions(listaExceptions);
        decorator.setMapaDeObjetosListEncadeados(lista);
        return decorator;
    }

    public MigrarBaseDecorator<String, TipoOcorrenciaRecebimentoDebitoTO> consultarTipoOcorrencia() {
        HashMap<String, TipoOcorrenciaRecebimentoDebitoTO> lista = new HashMap<String, TipoOcorrenciaRecebimentoDebitoTO>();
        String query = "SELECT * FROM TipoOcorrenciaRecebimentoDBT";
        MigrarBaseDecorator<String, TipoOcorrenciaRecebimentoDebitoTO> decorator = new MigrarBaseDecorator<String, TipoOcorrenciaRecebimentoDebitoTO>();
        ArrayList<UtilMigracaoException> listaExceptions = new ArrayList<UtilMigracaoException>();
        String erroInserirTipoOcorrenciaRecebimentoDBT = " - Erro ao inserir o Tipo de Ocorr\u00eancia do Recebimento de D\u00e9bito";
        String motivo = "";
        try {
            Statement statement = this.getConexao().createStatement();
            ResultSet rs = statement.executeQuery(query);
            try {
                while (rs.next()) {
                    Integer codigoTipoRetorno = rs.getInt("codigoTipoRetorno");
                    Integer codigoRetorno = rs.getInt("codigoRetorno");
                    String indicadorEstado = rs.getString("indicadorEstado");
                    motivo = "TIPO OCOR\u00caNCIA RECEBIMENTO D\u00c9BITO N\u00c3O MIGRADO" + erroInserirTipoOcorrenciaRecebimentoDBT + (codigoTipoRetorno != null ? ". C\u00f3d. do Tipo Retorno: " + codigoTipoRetorno : "");
                    UtilValidaDadosMigracao.validarNumeroNotNullZeroValido(codigoTipoRetorno, motivo, "codigoTipoRetorno");
                    UtilValidaDadosMigracao.validarNumeroNotNullZeroValido(codigoRetorno, motivo, "codigoRetorno");
                    TipoOcorrenciaRecebimentoDebitoTO tipoOcorrenciaTO = this.getTOFactory().novoTipoOcorrenciaRecebimentoDebitoTO();
                    String chave = String.valueOf(UtilString.completarAEsquerda((String)("" + codigoTipoRetorno), (String)"0", (int)3)) + UtilString.completarAEsquerda((String)("" + codigoRetorno), (String)"0", (int)3);
                    tipoOcorrenciaTO.getId().setCodigoRetorno(codigoRetorno.intValue());
                    tipoOcorrenciaTO.getId().setTextoTipoRetorno(codigoTipoRetorno == 1 ? (char)'P' : 'A');
                    tipoOcorrenciaTO.setTextoDescricao(rs.getString("textoDescricao"));
                    tipoOcorrenciaTO.setIndicadorEstadoTipoOcorrencia(indicadorEstado != null && indicadorEstado.length() > 0 ? Character.valueOf(indicadorEstado.charAt(0)) : null);
                    lista.put(chave, tipoOcorrenciaTO);
                }
            }
            catch (UtilMigracaoException e) {
                e.setNomeTabela("TipoOcorrenciaRecebimentoDBT");
                e.setNomeBase(BASE_ANTIGA);
                listaExceptions.add(e);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        decorator.setListaExceptions(listaExceptions);
        decorator.setMapaDeObjetos(lista);
        return decorator;
    }

    public MigrarBaseDecorator<String, SituacaoRecebimentoTO> consultarSituacaoRecebimento() {
        HashMap<String, SituacaoRecebimentoTO> lista = new HashMap<String, SituacaoRecebimentoTO>();
        String query = "SELECT * FROM SituacaoRecebimento";
        MigrarBaseDecorator<String, SituacaoRecebimentoTO> decorator = new MigrarBaseDecorator<String, SituacaoRecebimentoTO>();
        ArrayList<UtilMigracaoException> listaExceptions = new ArrayList<UtilMigracaoException>();
        String erroInserirSituacaoRecebimento = " - Erro ao inserir a Situa\u00e7\u00e3o do Recebimento";
        String motivo = "";
        try {
            Statement statement = this.getConexao().createStatement();
            ResultSet rs = statement.executeQuery(query);
            try {
                while (rs.next()) {
                    String codigoSituacao = rs.getString("codigoSituacaoRecebimento");
                    String indicadorEstado = rs.getString("indicadorEstado");
                    motivo = "SITUA\u00c7\u00c3O RECEBIMENTO N\u00c3O MIGRADA" + erroInserirSituacaoRecebimento + (codigoSituacao != null ? ". C\u00f3d. da Situa\u00e7\u00e3o Recebimento: " + codigoSituacao : "");
                    UtilValidaDadosMigracao.validarStringCompleto(1, codigoSituacao, motivo, "codigoSituacaoRecebimento");
                    UtilValidaDadosMigracao.validarStringSimples(1, indicadorEstado, motivo, "indicadorEstado");
                    SituacaoRecebimentoTO situacaoTO = this.getTOFactory().novoSituacaoRecebimentoTO();
                    situacaoTO.setCodigoSituacaoRecebimento(Character.valueOf(codigoSituacao.charAt(0)));
                    situacaoTO.setTextoDescricao(rs.getString("textoDescricao"));
                    situacaoTO.setCodigoHierarquia(Integer.valueOf(rs.getInt("codigoHierarquia")));
                    situacaoTO.setIndicadorEstadoSituacaoRecebimento(indicadorEstado != null && indicadorEstado.length() > 0 ? Character.valueOf(indicadorEstado.charAt(0)) : null);
                    lista.put(codigoSituacao, situacaoTO);
                }
            }
            catch (UtilMigracaoException e) {
                e.setNomeTabela("SituacaoRecebimento");
                e.setNomeBase(BASE_ANTIGA);
                listaExceptions.add(e);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        decorator.setListaExceptions(listaExceptions);
        decorator.setMapaDeObjetos(lista);
        return decorator;
    }

    public Map<Integer, String> consultarCodigoPessoasRecebimentos(String codigoPessoaConvenente, Collection<ConvenioTO> listaConvenios) {
        String query = "SELECT * FROM RecebimentoDBT WHERE codigoPessoaIdentificadorFK='" + codigoPessoaConvenente + "'";
        String subQuery = "";
        for (ConvenioTO convenio : listaConvenios) {
            subQuery = subQuery.trim().length() == 0 ? String.valueOf(subQuery) + " AND numeroConvenioDBT IN (" : String.valueOf(subQuery) + ", ";
            subQuery = String.valueOf(subQuery) + "'" + UtilString.completarAEsquerda((String)convenio.getNumeroConvenio().toString(), (String)"0", (int)5) + "'";
        }
        if (subQuery.trim().length() > 0) {
            subQuery = String.valueOf(subQuery) + ")";
        }
        HashMap<Integer, String> lista = new HashMap<Integer, String>();
        try {
            Statement statement = this.getConexao().createStatement();
            ResultSet rs = statement.executeQuery(String.valueOf(query) + subQuery + " ORDER BY codigoPessoaFK");
            while (rs.next()) {
                RecebimentoDebitoTO toRecebimento = this.getTOFactory().novoRecebimentoDebitoTO();
                String codigoPessoa = rs.getString("codigoPessoaFK");
                Integer numeroRecebimento = rs.getInt("numeroRecebimentoDBT");
                lista.put(numeroRecebimento, codigoPessoa);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return lista;
    }

    public String getFiltroPessoasComRecebimentos(Collection<ConvenioTO> listaConvenios) {
        String subQuery = "";
        for (ConvenioTO convenio : listaConvenios) {
            subQuery = subQuery.trim().length() == 0 ? "SELECT DISTINCT codigoPessoaFK FROM RecebimentoDBT WHERE numeroConvenioDBT IN (" : String.valueOf(subQuery) + ", ";
            subQuery = String.valueOf(subQuery) + "'" + UtilString.completarAEsquerda((String)convenio.getNumeroConvenio().toString(), (String)"0", (int)5) + "'";
        }
        if (subQuery.trim().length() > 0) {
            subQuery = String.valueOf(subQuery) + ")";
        }
        return subQuery;
    }

    public String getFiltroPessoasComConvenios(Collection<ConvenioTO> listaConvenios) {
        StringBuffer subQuery = new StringBuffer();
        for (ConvenioTO convenio : listaConvenios) {
            if (subQuery.length() == 0) {
                subQuery.append("SELECT DISTINCT codigoPessoaFK FROM IdentificadorClienteDBT WHERE numeroConvenioDBTFK IN (");
            } else {
                subQuery.append(", ");
            }
            subQuery.append("'");
            subQuery.append(String.valueOf(UtilString.completarAEsquerda((String)convenio.getNumeroConvenio().toString(), (String)"0", (int)5)) + "'");
        }
        if (subQuery.length() > 0) {
            subQuery.append(")");
        }
        return subQuery.toString();
    }

    public String getFiltroRemessasRecebimentos(Collection<ConvenioTO> listaConvenios) {
        String subQuery = "";
        for (ConvenioTO convenio : listaConvenios) {
            subQuery = subQuery.trim().length() == 0 ? "SELECT DISTINCT numeroRemessaFK FROM RecebimentoDBT WHERE numeroConvenioDBT IN (" : String.valueOf(subQuery) + ", ";
            subQuery = String.valueOf(subQuery) + "'" + UtilString.completarAEsquerda((String)convenio.getNumeroConvenio().toString(), (String)"0", (int)5) + "'";
        }
        if (subQuery.trim().length() > 0) {
            subQuery = String.valueOf(subQuery) + ")";
        }
        return subQuery;
    }

    public MigrarBaseDecorator<String, RemessaTO> consultarRemessas(String codigoPessoaConvenente, Map<String, ConvenioTO> listaConveniosMap, String filtroRemessa) {
        String query = "SELECT * FROM RemessaDBT WHERE codigoPessoaFK='" + codigoPessoaConvenente + "'";
        String subQuery = "";
        for (ConvenioTO convenio : listaConveniosMap.values()) {
            subQuery = subQuery.trim().length() == 0 ? String.valueOf(subQuery) + " AND numeroConvenioDBTFK IN (" : String.valueOf(subQuery) + ", ";
            subQuery = String.valueOf(subQuery) + "'" + UtilString.completarAEsquerda((String)convenio.getNumeroConvenio().toString(), (String)"0", (int)5) + "'";
        }
        if (subQuery.trim().length() > 0) {
            subQuery = String.valueOf(subQuery) + ")";
        }
        query = String.valueOf(query) + subQuery;
        if (filtroRemessa != null && filtroRemessa.trim().length() > 0) {
            query = String.valueOf(query) + " AND numeroRemessa IN (" + filtroRemessa + ")";
        }
        HashMap<String, RemessaTO> lista = new HashMap<String, RemessaTO>();
        MigrarBaseDecorator<String, RemessaTO> decorator = new MigrarBaseDecorator<String, RemessaTO>();
        ArrayList<UtilMigracaoException> listaExceptions = new ArrayList<UtilMigracaoException>();
        String erroInserirRemessa = " - Erro ao inserir a Remessa";
        String motivo = "";
        try {
            Statement statement = this.getConexao().createStatement();
            ResultSet rs = statement.executeQuery(String.valueOf(query) + subQuery);
            try {
                while (rs.next()) {
                    String numeroRemessa = rs.getString("numeroRemessa");
                    String numeroConvenio = rs.getString("numeroConvenioDBTFK");
                    Date dataRemessa = rs.getDate("dataRemessa");
                    BigDecimal vlrRemessa = rs.getBigDecimal("valorRemessa");
                    motivo = "REMESSA N\u00c3O MIGRADA" + erroInserirRemessa + (numeroRemessa != null ? ". Nr. da Remessa: " + numeroRemessa : "");
                    UtilValidaDadosMigracao.validarStringQueViraNumerico(7, numeroRemessa, motivo, "numeroRemessa");
                    UtilValidaDadosMigracao.validarDataNotNull(dataRemessa, motivo, "dataRemessa");
                    UtilValidaDadosMigracao.validarValorBigDecimalNotNull(vlrRemessa, motivo, "valorRemessa");
                    RemessaTO remessaTO = this.getTOFactory().novoRemessaTO();
                    ConvenioTO convenioTO = listaConveniosMap.get(numeroConvenio);
                    remessaTO.setConvenioTO(convenioTO);
                    remessaTO.getId().setNumeroRemessa(this.converterParaInteiro(numeroRemessa));
                    remessaTO.getId().setDataRemessa((java.util.Date)dataRemessa);
                    remessaTO.setValorRemessa(vlrRemessa);
                    remessaTO.setTextoNomeArquivo(rs.getString("nomeArquivo"));
                    lista.put(String.valueOf(numeroConvenio) + "-" + numeroRemessa, remessaTO);
                }
            }
            catch (UtilMigracaoException e) {
                e.setNomeTabela("RemessaDBT");
                e.setNomeBase(BASE_ANTIGA);
                listaExceptions.add(e);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        decorator.setListaExceptions(listaExceptions);
        decorator.setMapaDeObjetos(lista);
        return decorator;
    }
}

