/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.dbt.apresentacao.mantercliente.dao;

import br.com.bb.plugins.dbt.apresentacao.mantercliente.dao.BancoAcessDAOAbstrato;
import br.com.bb.plugins.gac.negocio.to.ContaCorrenteClienteTO;
import br.com.bb.plugins.gac.negocio.to.IdentificacaoTO;
import br.com.bb.plugins.gac.negocio.to.PessoaTO;
import br.com.bb.plugins.gac.negocio.to.TipoDocumentoTO;
import br.com.bb.plugins.gac.negocio.to.decorator.ContaCorrenteClienteTODecorator;
import br.com.bb.plugins.gac.negocio.to.decorator.GrupoClienteRecebimentoTODecorator;
import br.com.bb.plugins.gac.negocio.to.decorator.IdentificacaoTODecorator;
import br.com.bb.plugins.gac.negocio.to.decorator.IdentificadorClienteDebitoTODecorator;
import br.com.bb.plugins.gac.negocio.to.decorator.PessoaTODecorator;
import br.com.bb.plugins.gac.negocio.to.decorator.RecebimentoDebitoTODecorator;
import br.com.bb.plugins.gac.util.dominio.UtilDominioTipoDocumento;
import br.com.politec.generico.string.UtilString;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MigrarDadosRecebimentoDAO
extends BancoAcessDAOAbstrato {
    public PessoaTO consultarPessoaPorInscricao(String numeroInscricao) {
        String query = "SELECT distinct codigoPessoaFK FROM identificacao WHERE identificacao.numeroIdentificador='" + numeroInscricao + "'";
        PessoaTO pessoa = null;
        try {
            Statement statement = this.getConexao().createStatement();
            ResultSet rs = statement.executeQuery(query);
            if (rs.next()) {
                pessoa = this.getTOFactory().novoPessoaTO();
                pessoa.setCodigoPessoa(Integer.valueOf(rs.getString("codigoPessoaFK")));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return pessoa;
    }

    public ArrayList<String> consultarConvenioDoRecebimentoPorPessoa(String codigoPessoa) {
        String query = "SELECT numeroConvenioDBT FROM RecebimentoDBT WHERE codigoPessoaIdentificadorFK='" + codigoPessoa + "'";
        ArrayList<String> lista = new ArrayList<String>(1);
        try {
            Statement statement = this.getConexao().createStatement();
            ResultSet rs = statement.executeQuery(query);
            while (rs.next()) {
                lista.add(rs.getString("numeroConvenioDBT"));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return lista;
    }

    public ArrayList<PessoaTODecorator> consultarPessoaRecebimentoPorConvenio(String codigoConvenio) {
        ResultSet rs = null;
        String qry = "SELECT r.codigoPessoaFK as codigoPessoa, p.textoNome as textoNome,p.textoEndereco as logradouro, p.codigoCEP as cep,p.textoCidade as cidade,p.textoBairro as bairro, p.textoSiglaUFFK as uf, p.codigoTipoPessoaFK as tipoPessoa FROM RecebimentoDBT r, Pessoa p WHERE p.codigoPessoa like r.codigoPessoaFK  AND r.numeroConvenioDBT='" + codigoConvenio + "'";
        ArrayList<PessoaTODecorator> lista = new ArrayList<PessoaTODecorator>(1);
        try {
            Statement stm = this.getConexao().createStatement();
            rs = stm.executeQuery(qry);
            while (rs.next()) {
                PessoaTODecorator decorator = this.getTOFactory().novoPessoaTODecorator();
                decorator.setCodigoPessoa(Integer.valueOf(UtilString.removerPrefixo((String)rs.getString("codigoPessoa"), (String)"0")));
                decorator.setTextoNome(rs.getString("textoNome"));
                decorator.setEndereco(rs.getString("logradouro"));
                decorator.setCep(rs.getString("cep"));
                decorator.setCidade(rs.getString("cidade"));
                decorator.setBairro(rs.getString("bairro"));
                decorator.setUf(rs.getString("uf"));
                decorator.setCodigoTipoPessoa(Integer.valueOf(rs.getInt("tipoPessoa")));
                decorator.setIdentificacaoTOs(this.consultaIdentificacaoPorCodigoPessoa(decorator.getCodigoPessoa()));
                lista.add(decorator);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return lista;
    }

    private Set<IdentificacaoTO> consultaIdentificacaoPorCodigoPessoa(Integer codigoPessoa) {
        String qry = "SELECT numeroIdentificador, codigoIdentificadorFK as tipoDocumento FROM Identificacao WHERE codigoPessoaFK like '" + UtilString.completarAEsquerda((String)codigoPessoa.toString(), (String)"0", (int)7) + "'";
        ResultSet rs = null;
        Statement stm = null;
        HashSet<IdentificacaoTO> colecao = new HashSet<IdentificacaoTO>(1);
        try {
            stm = this.getConexao().createStatement();
            rs = stm.executeQuery(qry);
            while (rs.next()) {
                IdentificacaoTODecorator identificacao = this.getTOFactory().novoIdentificacaoTODecorator();
                identificacao.setTextoIdentificador(rs.getString("numeroIdentificador"));
                TipoDocumentoTO to = this.getTOFactory().novoTipoDocumentoTO();
                to.setTextoDescricao(rs.getString("tipoDocumento"));
                if (to.getTextoDescricao().equals("CNPJ")) {
                    to.setCodigoTipoDocumento(UtilDominioTipoDocumento.CNPJ_PJ);
                } else if (to.getTextoDescricao().equals("CPF")) {
                    to.setCodigoTipoDocumento(UtilDominioTipoDocumento.CPF_PF);
                } else {
                    to.setCodigoTipoDocumento(UtilDominioTipoDocumento.REFERENCIA_PJ);
                }
                identificacao.setTipoDocumentoTO(to);
                colecao.add(identificacao.getIdentificacaoTO());
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return colecao;
    }

    private Set<ContaCorrenteClienteTO> consultarContaCorrenteCliente(String codigoPessoa) {
        HashSet<ContaCorrenteClienteTO> colecao = new HashSet<ContaCorrenteClienteTO>(1);
        String qry = "SELECT codigoPrefixoAgenciaFK as agencia, numeroContaCorrente as contaCorrente FROM ContaCorrente WHERE codigoPessoaFK='" + codigoPessoa + "'";
        ResultSet rs = null;
        Statement stm = null;
        try {
            stm = this.getConexao().createStatement();
            rs = stm.executeQuery(qry);
            while (rs.next()) {
                ContaCorrenteClienteTODecorator decorator = this.getTOFactory().novoContaCorrenteClienteTODecorator();
                String agencia = UtilString.removerPrefixo((String)rs.getString("agencia"), (String)"0");
                String digitoVerificadorAgencia = agencia.substring(agencia.length() - 1);
                agencia = agencia.substring(0, agencia.length() - 1);
                decorator.setCodigoAgencia(Integer.parseInt(agencia));
                decorator.getAgenciaInstituicaoFinanceiraTO().setDigitoVerificadorAgencia(Character.valueOf(digitoVerificadorAgencia.charAt(0)));
                String cc = UtilString.removerPrefixo((String)rs.getString("contaCorrente"), (String)"0");
                String digitoVerificadorCC = cc.substring(cc.length() - 1);
                cc = cc.substring(0, cc.length() - 1);
                decorator.setCodigoContaCorrente(Long.valueOf(cc));
                decorator.setDigitoVerificadorContaCorrente(digitoVerificadorCC.charAt(0));
                decorator.setCodigoInstituicaoFinanceira(1);
                colecao.add(decorator.getContaCorrenteClienteTO());
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return colecao;
    }

    public ArrayList<IdentificadorClienteDebitoTODecorator> consultarIdentificadorDebitoPorClienteEConvenio(Integer codigoConvenio, Integer codigoPessoa) {
        ArrayList<IdentificadorClienteDebitoTODecorator> lista = new ArrayList<IdentificadorClienteDebitoTODecorator>(1);
        String qry = "SELECT numeroConvenioDBTFK as numeroConvenio, numeroIdentificadorFK as textoIdentificadorDebito, numeroContaCorrenteFK as contaCorrente, codigoPrefixoAgenciaFK as agencia, codigoSituacaoIdentificadorFK as codigoSituacaoIdentificador, numeroIdentificadorAntigo as identificadorAnterior, dataUltimaRemessa ,dataRemessaAlteracao,  numeroRemessaAlteracao, textoDescricaoOcorrencia , indicadorImpressao FROM IdentificadorClienteDBT WHERE codigoPessoaFK like " + UtilString.completarAEsquerda((String)codigoPessoa.toString(), (String)"0", (int)7) + " AND numeroConvenioDBTFK like " + codigoConvenio;
        ResultSet rs = null;
        Statement stm = null;
        try {
            stm = this.getConexao().createStatement();
            rs = stm.executeQuery(qry);
            while (rs.next()) {
                IdentificadorClienteDebitoTODecorator dec = this.getTOFactory().novoIdentificadorClienteDebitoTODecorator();
                dec.setNumeroConvenio(Integer.valueOf(rs.getString("numeroConvenio")));
                dec.setTextoIdentificadorDebito(rs.getString("textoIdentificadorDebito"));
                dec.setCodigoContaCorrenteCliente(Long.valueOf(this.separaCodigoDoDigitoVerificador(rs.getString("contaCorrente"))));
                dec.setDigitoVerificadorContaCorrente(this.separaDigitoVerificadorDoCodigo(rs.getString("contaCorrente")));
                dec.setCodigoAgencia(Integer.valueOf(this.separaCodigoDoDigitoVerificador(rs.getString("agencia"))));
                dec.setDigitoVerificadorAgencia(this.separaDigitoVerificadorDoCodigo(rs.getString("agencia")));
                dec.setTextoSituacaoIdentificador(rs.getString("codigoSituacaoIdentificador"));
                dec.setTextoIdentificadorAnterior(rs.getString("identificadorAnterior"));
                dec.setDataUltimaRemessa((Date)rs.getDate("dataUltimaRemessa"));
                dec.setDataAlteracaoRemessa((Date)rs.getDate("dataRemessaAlteracao"));
                dec.setNumeroAlteracaoRemessa(Integer.valueOf(rs.getInt("numeroRemessaAlteracao")));
                dec.setTextoDescricaoOcorrencia(rs.getString("textoDescricaoOcorrencia"));
                dec.setIndicadorImpressao(rs.getString("indicadorImpressao"));
                lista.add(dec);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return lista;
    }

    private String separaCodigoDoDigitoVerificador(String cc) {
        return cc.substring(0, cc.length() - 1);
    }

    private String separaDigitoVerificadorDoCodigo(String cc) {
        return cc.substring(cc.length() - 1);
    }

    public GrupoClienteRecebimentoTODecorator consultarGrupoClienteRecebimentoPorConvenenteEConvenio(Integer codigoConvenio, Integer codigoPessoa) {
        GrupoClienteRecebimentoTODecorator to = null;
        String qry = "SELECT numeroConvenioDBTFK as numeroConvenio, codigoPessoaFK as codigoPessoaConvenente,  textoDescricao FROM GrupoClienteRecebimento WHERE numeroConvenioDBTFK like '" + codigoConvenio + "' AND codigoPessoaFK like '" + UtilString.completarAEsquerda((String)codigoPessoa.toString(), (String)"0", (int)7) + "'";
        ResultSet rs = null;
        Statement stm = null;
        try {
            stm = this.getConexao().createStatement();
            rs = stm.executeQuery(qry);
            if (rs.next()) {
                to = this.getTOFactory().novoGrupoClienteRecebimentoTODecorator();
                to.setNumeroConvenio(Integer.valueOf(Integer.parseInt(rs.getString("numeroConvenio"))));
                to.setCodigoPessoaConvenente(Integer.valueOf(Integer.parseInt(rs.getString("codigoPessoaConvenente"))));
                to.setTextoDescricao(rs.getString("textoDescricao"));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return to;
    }

    public ArrayList<RecebimentoDebitoTODecorator> consultarRecebimentoDebitoPorPessoaConvenioEConvenente(Integer codigoPessoa, Integer codigoConvenio, Integer convenente) {
        RecebimentoDebitoTODecorator dec = null;
        ArrayList<RecebimentoDebitoTODecorator> lista = new ArrayList<RecebimentoDebitoTODecorator>(1);
        String qry = "SELECT numeroRemessaFK as numeroRemessa, codigoTipoRetornoFK as codigoTipoRetorno, codigoRetornoFK as codigoRetorno,codigoSituacaoRecebimentoFK as codigoSituacaoRecebimento, data, valor, codigoBancoLiquidacao, codigoPrefixoAgenciaLiquidacao as codigoAgenciaLiquidacao, numeroContaCorrenteLiquidacao , dataDebitoEfetuado, valorDebitoEfetuado, IDRegistro as textoIdentificadorRegistro FROM RecebimentoDBT WHERE numeroConvenioDBTFK like '" + codigoConvenio + "' AND codigoPessoaFK like '" + UtilString.completarAEsquerda((String)codigoPessoa.toString(), (String)"0", (int)7) + "' AND codigoPessoaIdentificadorFK like '" + convenente + "'";
        ResultSet rs = null;
        Statement stm = null;
        try {
            stm = this.getConexao().createStatement();
            rs = stm.executeQuery(qry);
            if (rs.next()) {
                dec = this.getTOFactory().novoRecebimentoDebitoTODecorator();
                dec.setNumeroRemessa(this.isReferencia(rs.getString("numeroRemessa")) ? Integer.valueOf(rs.getString("numeroRemessa")) : null);
                dec.setCodigoTipoRetorno(rs.getString("codigoTipoRetorno"));
                dec.setCodigoRetorno(this.isReferencia(rs.getString("codigoRetorno")) ? Integer.valueOf(rs.getString("codigoRetorno")) : null);
                dec.setCodigoSituacaoRecebimento(rs.getString("codigoSituacaoRecebimento"));
                dec.setDataRecebimento(rs.getDate("data"));
                dec.setValorRecebimento(rs.getBigDecimal("valor"));
                dec.setCodigoBancoLiquidacao(rs.getString("codigoBancoLiquidacao"));
                dec.setCodigoAgenciaLiquidacao(rs.getString("codigoAgenciaLiquidacao"));
                dec.setContaCorrenteLiquidacao(rs.getString("numeroContaCorrenteLiquidacao"));
                dec.setDataDebito(rs.getDate("dataDebitoEfetuado"));
                dec.setValorDebito(rs.getBigDecimal("valorDebitoEfetuado"));
                dec.setTextoIdentificadorRegistro(rs.getString("textoIdentificadorRegistro"));
                lista.add(dec);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return lista;
    }
}

