/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.dbt.apresentacao.manterconvenente.view;

import br.com.bb.plugins.dbt.apresentacao.DBTBasicInternalFrame;
import br.com.bb.plugins.dbt.apresentacao.manterconvenente.action.CarregarViewManterConvenioAction;
import br.com.bb.plugins.dbt.apresentacao.manterconvenente.action.EditarConvenenteAction;
import br.com.bb.plugins.dbt.apresentacao.manterconvenente.form.ManterConvenenteForm;
import br.com.bb.plugins.gac.apresentacao.action.PluginActionAbstrato;
import br.com.bb.plugins.gac.apresentacao.form.PluginFormAbstrato;
import br.com.bb.plugins.gac.negocio.to.IdentificacaoTO;
import br.com.bb.plugins.gac.negocio.to.IdentificadorTO;
import br.com.bb.plugins.gac.negocio.to.LogradouroTO;
import br.com.bb.plugins.gac.negocio.to.PessoaTO;
import br.com.bb.plugins.gac.negocio.to.TipoDocumentoTO;
import br.com.bb.plugins.gac.negocio.to.UnidadeFederativaBrasilTO;
import br.com.bb.plugins.gac.negocio.to.decorator.ConvenenteTODecorator;
import br.com.bb.plugins.gac.util.Util;
import br.com.bb.plugins.gac.util.UtilIdentificadorProprio;
import br.com.bb.plugins.gac.util.swing.BBJBordaOval;
import br.com.bb.plugins.gac.util.swing.componente.BBJButton;
import br.com.bb.plugins.gac.util.swing.componente.BBJComboBoxUFLabel;
import br.com.bb.plugins.gac.util.swing.componente.BBJEstilos;
import br.com.bb.plugins.gac.util.swing.componente.BBJMask;
import br.com.bb.plugins.gac.util.swing.componente.BBJMaskLabel;
import br.com.bb.plugins.gac.util.swing.componente.BBJMaskLabelCPFCNPJ;
import br.com.bb.plugins.gac.util.swing.componente.BBJPopupMensagem;
import br.com.bb.plugins.gac.util.swing.componente.BBJRadioButton;
import br.com.bb.plugins.gac.util.swing.componente.BBJRadioButtonLabel;
import br.com.bb.plugins.gac.util.swing.componente.BBJText;
import br.com.bb.plugins.gac.util.swing.componente.BBJTextLabel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.InvalidObjectException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViewManterConvenente
extends DBTBasicInternalFrame {
    private static final Character ALFABETICO = Character.valueOf('A');
    private static final Character NUMERICO = Character.valueOf('N');
    private JPanel panelMain = null;
    private JPanel panelDadosConvenente = null;
    private BBJRadioButtonLabel radioTipo = null;
    private BBJMaskLabelCPFCNPJ txtInscricao = null;
    private BBJTextLabel txtNome = null;
    private BBJTextLabel txtEndereco = null;
    private BBJTextLabel txtBairro = null;
    private BBJTextLabel txtCidade = null;
    private JPanel panelBotoes = null;
    private BBJMaskLabel txtCep = null;
    private BBJComboBoxUFLabel<UnidadeFederativaBrasilTO> cmbUf = null;
    private JPanel panelIdentificador = null;
    private JCheckBox chkPossuiIdentificador = null;
    private BBJRadioButtonLabel radioTipoIdentificador = null;
    private BBJTextLabel txtSiglaIdentificador = null;
    private BBJMaskLabel txtTamanhoIdentificador = null;
    private BBJTextLabel txtFormatoIdentificador = null;
    private JButton btnConfirmar;
    private JButton btnVoltar;
    private BBJRadioButton rdNumerico;
    private BBJRadioButton rdAlfanumerico;
    private BBJRadioButton rdCpf;
    private BBJRadioButton rdCnpj;
    private boolean pessoaFisica = false;
    private boolean pessoaJuridica = false;
    private boolean foiClicado = false;
    private BBJButton btnConvenios;

    public ViewManterConvenente() {
        super("Editar Convenente", false, false);
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.add(this.getPanelMain(), "Center");
    }

    public JPanel getPanelMain() {
        if (this.panelMain == null) {
            this.panelMain = new JPanel();
            this.panelMain.setLayout(new BorderLayout());
            this.panelMain.setOpaque(false);
            this.panelMain.add((Component)this.getPanelDadosConvenente(), "North");
            this.panelMain.add((Component)this.getPanelBotoes(), "Center");
        }
        return this.panelMain;
    }

    public JPanel getPanelDadosConvenente() {
        if (this.panelDadosConvenente == null) {
            this.panelDadosConvenente = new JPanel();
            this.panelDadosConvenente.setLayout(new GridBagLayout());
            this.panelDadosConvenente.setOpaque(false);
            this.panelDadosConvenente.setBorder(BBJBordaOval.createOvalBorder());
            this.panelDadosConvenente.setPreferredSize(new Dimension(0, 250));
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.insets = new Insets(4, 4, 4, 4);
            gbc.anchor = 17;
            gbc.fill = 2;
            gbc.gridy = 0;
            gbc.gridx = 0;
            gbc.weightx = 0.99;
            gbc.gridwidth = 3;
            this.panelDadosConvenente.add((Component)this.getRadioTipo(), gbc);
            ++gbc.gridy;
            gbc.gridwidth = 1;
            gbc.weightx = 0.5;
            this.panelDadosConvenente.add((Component)this.getTxtInscricao(), gbc);
            ++gbc.gridx;
            gbc.gridwidth = 2;
            this.panelDadosConvenente.add((Component)this.getTxtNome(), gbc);
            gbc.gridx = 0;
            ++gbc.gridy;
            gbc.gridwidth = 2;
            this.panelDadosConvenente.add((Component)this.getTxtEndereco(), gbc);
            gbc.gridx += 2;
            gbc.gridwidth = 1;
            this.panelDadosConvenente.add((Component)this.getTxtBairro(), gbc);
            gbc.gridx = 0;
            ++gbc.gridy;
            gbc.gridwidth = 1;
            gbc.weightx = 0.4;
            this.panelDadosConvenente.add((Component)this.getTxtCidade(), gbc);
            ++gbc.gridx;
            gbc.weightx = 0.3;
            this.panelDadosConvenente.add((Component)this.getTxtCep(), gbc);
            ++gbc.gridx;
            gbc.weightx = 0.3;
            this.panelDadosConvenente.add((Component)this.getCmbUf(), gbc);
            gbc.gridx = 0;
            ++gbc.gridy;
            gbc.gridwidth = 3;
            gbc.weightx = 0.99;
            this.panelDadosConvenente.add((Component)this.getChkPossuiIdentificador(), gbc);
            ++gbc.gridy;
            this.panelDadosConvenente.add((Component)this.getPanelIdentificador(), gbc);
        }
        return this.panelDadosConvenente;
    }

    public BBJTextLabel getTxtBairro() {
        if (this.txtBairro == null) {
            this.txtBairro = new BBJTextLabel("Bairro:", 30, true, 0, 0, 45);
            this.txtBairro.setToolTipText(this.getMensagem("MH031"));
            this.txtBairro.setName("textoBairro");
            this.txtBairro.getJtfCampo().addFocusListener(new FocusListener(){

                public void focusLost(FocusEvent e) {
                    ViewManterConvenente.this.txtBairro.getJtfCampo().setText(Util.substituirCaracteresEspeciais((String)ViewManterConvenente.this.txtBairro.getText()));
                }

                public void focusGained(FocusEvent e) {
                }
            });
        }
        return this.txtBairro;
    }

    public BBJMaskLabel getTxtCep() {
        if (this.txtCep == null) {
            this.txtCep = new BBJMaskLabel("CEP:", true, 0, 120, 45);
            this.txtCep.getJtfCampo().setMask("#####-###");
            this.txtCep.setToolTipText(this.getMensagem("MH033"));
            this.txtCep.getJtfCampo().setName("textoCep");
        }
        return this.txtCep;
    }

    public BBJTextLabel getTxtCidade() {
        if (this.txtCidade == null) {
            this.txtCidade = new BBJTextLabel("Cidade:", 30, true, 0, 0, 65);
            this.txtCidade.setToolTipText(this.getMensagem("MH032"));
            this.txtCidade.setName("textoCidade");
            this.txtCidade.getJtfCampo().addFocusListener(new FocusListener(){

                public void focusLost(FocusEvent e) {
                    ViewManterConvenente.this.txtCidade.getJtfCampo().setText(Util.substituirCaracteresEspeciais((String)ViewManterConvenente.this.txtCidade.getText()));
                }

                public void focusGained(FocusEvent e) {
                }
            });
        }
        return this.txtCidade;
    }

    public BBJTextLabel getTxtEndereco() {
        if (this.txtEndereco == null) {
            this.txtEndereco = new BBJTextLabel("Endere\u00e7o:", 50, true, 0, 0, 65);
            this.txtEndereco.setToolTipText(this.getMensagem("MH030"));
            this.txtEndereco.setName("textoLogradouro");
            this.txtEndereco.getJtfCampo().addFocusListener(new FocusListener(){

                public void focusLost(FocusEvent e) {
                    ViewManterConvenente.this.txtEndereco.getJtfCampo().setText(Util.substituirCaracteresEspeciais((String)ViewManterConvenente.this.txtEndereco.getText()));
                }

                public void focusGained(FocusEvent e) {
                }
            });
        }
        return this.txtEndereco;
    }

    public BBJTextLabel getTxtFormatoIdentificador() {
        if (this.txtFormatoIdentificador == null) {
            this.txtFormatoIdentificador = new BBJTextLabel("Formato:", 25, true, 0, 0, 65, 7);
            this.txtFormatoIdentificador.getJtfCampo().setName("formatoIdentificador");
            this.txtFormatoIdentificador.setVisible(false);
            this.txtFormatoIdentificador.getJtfCampo().addKeyListener(new KeyListener(){

                public void keyPressed(KeyEvent e) {
                    char i = e.getKeyChar();
                    String str = Character.toString(i);
                    if (ViewManterConvenente.this.getRadioTipoIdentificador().getSelected() == ViewManterConvenente.this.getRdNumerico()) {
                        if (str.equals("#")) {
                            ViewManterConvenente.this.txtFormatoIdentificador.getJtfCampo().setTipoEntrada(8);
                            ViewManterConvenente.this.getTxtTamanhoIdentificador().setData(String.valueOf(ViewManterConvenente.this.txtFormatoIdentificador.getJtfCampo().getText().length()));
                        }
                    } else if (ViewManterConvenente.this.getRadioTipoIdentificador().getSelected() == ViewManterConvenente.this.getRdAlfanumerico()) {
                        if (str.equals("@")) {
                            ViewManterConvenente.this.txtFormatoIdentificador.getJtfCampo().setTipoEntrada(9);
                            ViewManterConvenente.this.getTxtTamanhoIdentificador().setData(String.valueOf(ViewManterConvenente.this.txtFormatoIdentificador.getJtfCampo().getText().length()));
                        }
                    } else {
                        ViewManterConvenente.this.txtFormatoIdentificador.getJtfCampo().setTipoEntrada(7);
                    }
                }

                public void keyReleased(KeyEvent e) {
                }

                public void keyTyped(KeyEvent e) {
                }
            });
            this.txtFormatoIdentificador.setEditavel(false);
        }
        return this.txtFormatoIdentificador;
    }

    public BBJMaskLabelCPFCNPJ getTxtInscricao() {
        if (this.txtInscricao == null) {
            this.txtInscricao = new BBJMaskLabelCPFCNPJ("Inscri\u00e7\u00e3o:", BBJMask.TIPO_SEM_VALIDACAO.intValue(), 14, false, 0, 150, 65);
        }
        return this.txtInscricao;
    }

    public BBJTextLabel getTxtNome() {
        if (this.txtNome == null) {
            this.txtNome = new BBJTextLabel("Nome:", 50, false, 0, 0, 45);
            this.txtNome.setEditavel(false);
        }
        return this.txtNome;
    }

    public JPanel getPanelIdentificador() {
        if (this.panelIdentificador == null) {
            this.panelIdentificador = new JPanel();
            this.panelIdentificador.setLayout(new GridBagLayout());
            this.panelIdentificador.setOpaque(false);
            this.panelIdentificador.setBorder(BBJBordaOval.createOvalBorder((String)"Defini\u00e7\u00e3o do Identificador Pr\u00f3prio"));
            this.panelIdentificador.setPreferredSize(new Dimension(0, 90));
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.insets = new Insets(4, 4, 4, 4);
            gbc.anchor = 17;
            gbc.fill = 2;
            gbc.gridy = 0;
            gbc.gridx = 0;
            gbc.weightx = 0.5;
            gbc.gridwidth = 2;
            this.panelIdentificador.add((Component)this.getRadioTipoIdentificador(), gbc);
            gbc.gridx += 2;
            gbc.weightx = 0.5;
            gbc.gridwidth = 1;
            ++gbc.gridy;
            gbc.gridx = 0;
            gbc.gridwidth = 1;
            gbc.weightx = 0.33;
            this.panelIdentificador.add((Component)this.getTxtSiglaIdentificador(), gbc);
            ++gbc.gridx;
            this.panelIdentificador.add((Component)this.getTxtTamanhoIdentificador(), gbc);
            ++gbc.gridx;
            this.panelIdentificador.add((Component)this.getTxtFormatoIdentificador(), gbc);
        }
        return this.panelIdentificador;
    }

    public JCheckBox getChkPossuiIdentificador() {
        if (this.chkPossuiIdentificador == null) {
            this.chkPossuiIdentificador = new JCheckBox("Possui Identificador Pr\u00f3prio para Clientes");
            this.chkPossuiIdentificador.setOpaque(false);
            this.chkPossuiIdentificador.setFont(BBJEstilos.LABELTEXTO.getFont());
            this.chkPossuiIdentificador.setForeground(BBJEstilos.LABELTEXTO.getColor());
            this.chkPossuiIdentificador.setName("possuiIdentificadorProprio");
            this.chkPossuiIdentificador.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ViewManterConvenente.this.habilitarIdentificadorProprio(ViewManterConvenente.this.chkPossuiIdentificador.isSelected());
                    ViewManterConvenente.this.getManterConvenenteForm().getConvenenteTOSelecionado().setApagarDocumento(!ViewManterConvenente.this.chkPossuiIdentificador.isSelected());
                }
            });
        }
        return this.chkPossuiIdentificador;
    }

    public BBJTextLabel getTxtSiglaIdentificador() {
        if (this.txtSiglaIdentificador == null) {
            this.txtSiglaIdentificador = new BBJTextLabel("Nome Identificador Pr\u00f3prio: ", 30, true, 0, 150, 150);
            this.txtSiglaIdentificador.setName("nomeIdentificador");
            this.txtSiglaIdentificador.getJtfCampo().addFocusListener(new FocusListener(){

                public void focusLost(FocusEvent e) {
                    ViewManterConvenente.this.txtSiglaIdentificador.getJtfCampo().setText(Util.substituirCaracteresEspeciais((String)ViewManterConvenente.this.txtSiglaIdentificador.getText()));
                }

                public void focusGained(FocusEvent e) {
                }
            });
        }
        return this.txtSiglaIdentificador;
    }

    public BBJMaskLabel getTxtTamanhoIdentificador() {
        if (this.txtTamanhoIdentificador == null) {
            this.txtTamanhoIdentificador = new BBJMaskLabel("Tamanho:", true, 0, 160, 65);
            this.txtTamanhoIdentificador.getJtfCampo().setName("tamanhoIdentificador");
            this.txtTamanhoIdentificador.getJtfCampo().setMask("##");
            this.txtTamanhoIdentificador.setEnabled(true);
            this.txtTamanhoIdentificador.getJtfCampo().addFocusListener(new FocusListener(){

                public void focusGained(FocusEvent arg0) {
                }

                public void focusLost(FocusEvent arg0) {
                    String strTamanho = ViewManterConvenente.this.txtTamanhoIdentificador.getJtfCampo().getText();
                    if (strTamanho.length() != 0) {
                        int itam = strTamanho.trim().equals("") ? 0 : Integer.valueOf(strTamanho.trim());
                        ViewManterConvenente.this.getTxtFormatoIdentificador().setEditavel(false);
                        if (itam != 0) {
                            String mascara = "";
                            BBJText campo = ViewManterConvenente.this.getTxtFormatoIdentificador().getJtfCampo();
                            int tipoent = campo.getTipoEntrada();
                            campo.setTipoEntrada(-1);
                            int i = 0;
                            while (i < itam) {
                                if (ViewManterConvenente.this.getRdAlfanumerico().isSelected()) {
                                    mascara = String.valueOf(mascara) + "@";
                                } else if (ViewManterConvenente.this.getRdNumerico().isSelected()) {
                                    mascara = String.valueOf(mascara) + "#";
                                }
                                ++i;
                            }
                            campo.setText(mascara);
                            campo.setTipoEntrada(tipoent);
                            ViewManterConvenente.this.getTxtFormatoIdentificador().setJtfCampo(campo);
                        }
                    }
                }
            });
        }
        return this.txtTamanhoIdentificador;
    }

    public BBJRadioButtonLabel getRadioTipo() {
        if (this.radioTipo == null) {
            this.radioTipo = new BBJRadioButtonLabel("Tipo:", 0, null, 65);
            LinkedHashMap<String, BBJRadioButton> opcradio = new LinkedHashMap<String, BBJRadioButton>();
            opcradio.put("opc1", this.getRdCpf());
            opcradio.put("opc2", this.getRdCnpj());
            this.radioTipo.setOpcoesRadio(opcradio);
            this.radioTipo.loadRadios();
        }
        return this.radioTipo;
    }

    public BBJRadioButtonLabel getRadioTipoIdentificador() {
        if (this.radioTipoIdentificador == null) {
            this.radioTipoIdentificador = new BBJRadioButtonLabel("Tipo:", 0, null, 65);
            LinkedHashMap<String, BBJRadioButton> opcradio = new LinkedHashMap<String, BBJRadioButton>();
            opcradio.put("opc1", this.getRdNumerico());
            opcradio.put("opc2", this.getRdAlfanumerico());
            this.radioTipoIdentificador.setOpcoesRadio(opcradio);
            this.radioTipoIdentificador.loadRadios();
            this.radioTipoIdentificador.setEnabled(true);
            this.radioTipoIdentificador.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent arg0) {
                    BBJText campo = ViewManterConvenente.this.getTxtFormatoIdentificador().getJtfCampo();
                    int tamanho = campo.getText().length();
                    ViewManterConvenente.this.getTxtFormatoIdentificador().getJtfCampo().clear();
                    String mascara = "";
                    int i = 0;
                    while (i < tamanho) {
                        if (ViewManterConvenente.this.rdNumerico.isSelected()) {
                            mascara = String.valueOf(mascara) + "#";
                        } else if (ViewManterConvenente.this.rdAlfanumerico.isSelected()) {
                            mascara = String.valueOf(mascara) + "@";
                        }
                        ++i;
                    }
                    int tipoent = campo.getTipoEntrada();
                    campo.setTipoEntrada(-1);
                    campo.setText(mascara);
                    campo.setTipoEntrada(tipoent);
                    ViewManterConvenente.this.getTxtFormatoIdentificador().setJtfCampo(campo);
                }
            });
        }
        return this.radioTipoIdentificador;
    }

    public BBJComboBoxUFLabel<UnidadeFederativaBrasilTO> getCmbUf() {
        if (this.cmbUf == null) {
            this.cmbUf = new BBJComboBoxUFLabel("UF: ", false, 0, 120, 45);
            this.cmbUf.setToolTipText(this.getMensagem("MH019"));
            this.cmbUf.setName("unidadeFederativaBrasilTO");
        }
        return this.cmbUf;
    }

    public JPanel getPanelBotoes() {
        if (this.panelBotoes == null) {
            this.panelBotoes = this.getPainelFactory().novoJPainel();
            this.panelBotoes.setOpaque(false);
            FlowLayout flayout = this.getLayoutFactory().novoFlowLayout();
            flayout.setAlignment(2);
            this.panelBotoes.setLayout(flayout);
            this.panelBotoes.add((Component)this.getBtnConvenios());
            this.panelBotoes.add(this.getBtnConfirmar());
            this.panelBotoes.add(this.getBtnVoltar());
        }
        return this.panelBotoes;
    }

    public void preExecucaoEditarConvenenteAction() {
        if (this.getManterConvenenteForm().getPossuiIdentificadorProprio().booleanValue()) {
            this.getManterConvenenteForm().setTamanhoIdentificador(this.getTxtTamanhoIdentificador().getJtfCampo().getText());
            this.getManterConvenenteForm().setNomeIdentificador(this.getTxtSiglaIdentificador().getJtfCampo().getText());
            this.getManterConvenenteForm().setFormatoIdentificador(this.getTxtFormatoIdentificador().getJtfCampo().getText());
        }
    }

    public JButton getBtnConfirmar() {
        if (this.btnConfirmar == null) {
            EditarConvenenteAction action = this.getDBTActionFactory().novoEditarConvenenteAction();
            this.btnConfirmar = this.getBotaoFactory().novoConfirmar((PluginActionAbstrato)action);
        }
        return this.btnConfirmar;
    }

    public void posExecucaoEditarConvenenteAction() {
        BBJPopupMensagem.exibirMensagem((String)this.getMensagem("MP002"));
        this.doClose(null);
    }

    public JButton getBtnVoltar() {
        if (this.btnVoltar == null) {
            this.btnVoltar = this.getBotaoFactory().novoVoltar();
            this.btnVoltar.addFocusListener(new FocusListener(){

                public void focusGained(FocusEvent e) {
                }

                public void focusLost(FocusEvent e) {
                    ViewManterConvenente.this.getTxtEndereco().requestFocus();
                }
            });
        }
        return this.btnVoltar;
    }

    public BBJButton getBtnConvenios() {
        if (!this.isReferencia(this.btnConvenios)) {
            CarregarViewManterConvenioAction action = this.getDBTActionFactory().novoCarregarViewManterConvenioAction();
            this.btnConvenios = this.getBotaoFactory().novoConvenio((PluginActionAbstrato)action);
            this.btnConvenios.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent arg0) {
                    ManterConvenenteForm convenenteForm = (ManterConvenenteForm)ViewManterConvenente.this.getForm();
                    if (!convenenteForm.isExisteConvenioConvenente()) {
                        BBJPopupMensagem.exibirMensagem((String)"Nenhum conv\u00eanio encontrado para a Convenente selecionado.");
                    }
                }
            });
        }
        return this.btnConvenios;
    }

    public void posExecucaoFecharAction() {
        this.doClose(null);
    }

    public void doShow(Map context) {
        this.carregaComboUF();
        this.getTxtFormatoIdentificador().getJtfCampo().setEnabled(false);
        this.getTxtEndereco().requestFocus();
        super.doShow(context);
        this.setVisible(true);
    }

    private void carregaComboUF() {
        if (this.getCmbUf().getComboBox().getModel().getSize() == 0 || this.getCmbUf().getComboBox().getSelectedItem() == null) {
            this.getCmbUf().getComboBox().carregar();
        }
    }

    private void limpaForm() {
        this.getManterConvenenteForm().setConvenenteTO(null);
        this.getChkPossuiIdentificador().setSelected(false);
        this.getRdNumerico().setSelected(false);
        this.getRdAlfanumerico().setSelected(false);
        this.getTxtCep().getJtfCampo().clean();
        this.getTxtCep().getJtfCampo().clean();
        this.getTxtSiglaIdentificador().getJtfCampo().clear();
        this.getTxtTamanhoIdentificador().getJtfCampo().clean();
        this.getTxtFormatoIdentificador().getJtfCampo().clear();
        this.habilitarIdentificadorProprio(false);
        this.getCmbUf().setSelectedItem(null);
    }

    public void inicializaTela() {
        this.limparTextTela();
        this.preencherTelaComConvenete();
    }

    private void limparTextTela() {
        this.getTxtInscricao().setText("");
        this.getTxtNome().setText("");
        this.getTxtEndereco().setText("");
        this.getTxtBairro().setText("");
        this.getTxtCidade().setText("");
        this.getTxtCep().setText("");
        this.getTxtSiglaIdentificador().setText("");
        this.getTxtTamanhoIdentificador().setText("");
        this.getTxtFormatoIdentificador().setText("");
        this.getRdAlfanumerico().setSelected(false);
        this.getRdNumerico().setSelected(false);
        this.getRdCpf().setSelected(false);
        this.getRdCnpj().setSelected(false);
        this.getCmbUf().setSelectedItem(null);
    }

    private void preencherTelaComConvenete() {
        ConvenenteTODecorator convenenteTO = this.getManterConvenenteForm().getConvenenteTOSelecionado();
        this.preencherDadosPessoais(convenenteTO.getPessoaTO());
        this.preencherDadosLogradouro(convenenteTO.getPessoaTO().getLogradouroTOs(), convenenteTO.getPessoaTO());
        this.preencherDadosIdentificador(convenenteTO);
    }

    private void preencherDadosIdentificador(ConvenenteTODecorator convenenteTO) {
        IdentificadorTO ident = UtilIdentificadorProprio.getInstancia().consultaIdentificadorProprioPor(convenenteTO.getConvenente(), this.getServicoAtual());
        this.getChkPossuiIdentificador().setSelected(false);
        this.habilitarIdentificadorProprio(false);
        if (ident == null || ident.getNomeIdentificador() == null) {
            return;
        }
        this.getChkPossuiIdentificador().setSelected(true);
        this.habilitarIdentificadorProprio(this.getChkPossuiIdentificador().isSelected());
        String mascara = null;
        if (ident.getIndicadorDominio() != null) {
            if (ident.getIndicadorDominio().equals(NUMERICO)) {
                this.getRdNumerico().setSelected(true);
                this.getRdAlfanumerico().setSelected(false);
                mascara = ident.getTextoMascara().replace("9", "#");
                this.getTxtFormatoIdentificador().getJtfCampo().setTipoEntrada(-1);
                this.getTxtFormatoIdentificador().getJtfCampo().setText(mascara);
                this.getTxtFormatoIdentificador().getJtfCampo().setTipoEntrada(8);
            } else if (ident.getIndicadorDominio().equals(ALFABETICO)) {
                this.getRdAlfanumerico().setSelected(true);
                this.getRdNumerico().setSelected(false);
                this.getRadioTipoIdentificador().setEnabled(true);
                mascara = ident.getTextoMascara().replace("9", "@");
                this.getTxtFormatoIdentificador().getJtfCampo().setTipoEntrada(-1);
                this.getTxtFormatoIdentificador().getJtfCampo().setText(mascara);
                this.getTxtFormatoIdentificador().getJtfCampo().setTipoEntrada(9);
            }
        }
        this.getTxtSiglaIdentificador().getJtfCampo().setBackground(new Color(255, 255, 255));
        this.getTxtTamanhoIdentificador().getJtfCampo().setBackground(new Color(255, 255, 255));
        this.getTxtSiglaIdentificador().getJtfCampo().setEnabled(false);
        this.getTxtTamanhoIdentificador().getJtfCampo().setEnabled(false);
        this.getRdNumerico().setEnabled(false);
        this.getRdAlfanumerico().setEnabled(false);
        this.getTxtFormatoIdentificador().getJtfCampo().setEnabled(false);
        try {
            this.getTxtSiglaIdentificador().getJtfCampo().setText(ident.getNomeIdentificador());
            String tamanho = ident.getNumeroTamanhoIdentificador().toString();
            this.getTxtTamanhoIdentificador().getJtfCampo().setData(tamanho);
        }
        catch (InvalidObjectException e) {
            e.printStackTrace();
        }
    }

    private void preencherDadosPessoais(PessoaTO pessoaTO) {
        this.getTxtNome().setText(pessoaTO.getTextoNome());
        IdentificacaoTO ident = null;
        for (IdentificacaoTO identificacaoTO : pessoaTO.getIdentificacaoTOs()) {
            if (identificacaoTO.getIdentificadorTO().getNomeIdentificador().trim().equals("CPF")) {
                this.getRdCpf().setSelected(true);
                ident = identificacaoTO;
                break;
            }
            if (identificacaoTO.getIdentificadorTO().getNomeIdentificador().trim().equals("CNPJ")) {
                this.getRdCnpj().setSelected(true);
                ident = identificacaoTO;
                break;
            }
            ident = identificacaoTO;
        }
        if (!this.getRdCpf().isSelected() || !this.getRdCnpj().isSelected()) {
            if (pessoaTO.getTipoPessoaTO().getCodigoTipoPessoa() == 1) {
                this.getRdCpf().setSelected(true);
                this.getRdCnpj().setSelected(false);
            } else {
                this.getRdCpf().setSelected(false);
                this.getRdCnpj().setSelected(true);
            }
        }
        if (pessoaTO.getIdentificacaoTOs() != null && pessoaTO.getIdentificacaoTOs().size() > 0 && ident.getIdentificadorTO() != null) {
            String inscricao = ident.getId().getTextoIdentificacao();
            String mascara = ident.getIdentificadorTO().getTextoMascara();
            mascara = mascara.replace("9", "#");
            this.getTxtInscricao().getJtfCampo().setMask(mascara);
            this.getTxtInscricao().getJtfCampo().setData(inscricao);
        }
        this.getRadioTipo().setEnabled(false);
    }

    public IdentificacaoTO getIdentificacaoTO(PessoaTO pessoaTO) {
        Set colecaoIdentificacaoTO = pessoaTO.getIdentificacaoTOs();
        IdentificacaoTO resultado = this.getTOFactory().novoIdentificacaoTO();
        for (IdentificacaoTO identificacaoTO : colecaoIdentificacaoTO) {
            TipoDocumentoTO tipoDocumentoTO = identificacaoTO.getTipoDocumentoTO();
            if (!this.isPessoaFisica(tipoDocumentoTO, pessoaTO) && !this.isPessoaJuridica(tipoDocumentoTO, pessoaTO)) continue;
            resultado = identificacaoTO;
            this.getManterConvenenteForm().setIdentificacaoTO(identificacaoTO);
        }
        return resultado;
    }

    private boolean isPessoaJuridica(TipoDocumentoTO tipoDocumentoTO, PessoaTO pessoaTO) {
        if (pessoaTO == null || pessoaTO.getTipoPessoaTO() == null || tipoDocumentoTO == null) {
            boolean bl = false;
        }
        boolean retorno = pessoaTO.getTipoPessoaTO().getCodigoTipoPessoa() == 2 && tipoDocumentoTO.getTextoDescricao().equals("CNPJ");
        this.setPessoaJuridica(retorno);
        return retorno;
    }

    private boolean isPessoaFisica(TipoDocumentoTO tipoDocumentoTO, PessoaTO pessoaTO) {
        if (pessoaTO == null || pessoaTO.getTipoPessoaTO() == null || tipoDocumentoTO == null) {
            boolean bl = false;
        }
        boolean retorno = pessoaTO.getTipoPessoaTO().getCodigoTipoPessoa() == 1;
        this.setPessoaFisica(retorno);
        return retorno;
    }

    private void preencherDadosLogradouro(Set<LogradouroTO> logradouroTOs, PessoaTO pessoaTO) {
        for (LogradouroTO logradouro : logradouroTOs) {
            if (logradouro.getPessoaTO() == null || !logradouro.getPessoaTO().getCodigoPessoa().equals(pessoaTO.getCodigoPessoa())) continue;
            this.getManterConvenenteForm().setLogradouroTO(logradouro);
            this.getTxtEndereco().setText(logradouro.getTextoLogradouro());
            this.getTxtBairro().setText(logradouro.getTextoBairro());
            this.getTxtCidade().setText(logradouro.getTextoCidade());
            try {
                String cep = logradouro.getTextoCep();
                this.getTxtCep().getJtfCampo().clean();
                this.getTxtCep().getJtfCampo().setData(cep);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            this.getCmbUf().setSelectedItem((Object)logradouro.getUnidadeFederativaBrasilTO());
        }
    }

    private ManterConvenenteForm getManterConvenenteForm() {
        return (ManterConvenenteForm)this.getForm();
    }

    protected PluginFormAbstrato novoForm() {
        return this.getFormAnterior();
    }

    public void doClose(Map context) {
        this.limpaForm();
        super.doClose(context);
    }

    public BBJRadioButton getRdNumerico() {
        if (this.rdNumerico == null) {
            this.rdNumerico = this.getPainelFactory().novoBBJRadioButton("Num\u00e9rico", false);
        }
        return this.rdNumerico;
    }

    public BBJRadioButton getRdAlfanumerico() {
        if (this.rdAlfanumerico == null) {
            this.rdAlfanumerico = this.getPainelFactory().novoBBJRadioButton("Alfanum\u00e9rico", false);
        }
        return this.rdAlfanumerico;
    }

    public BBJRadioButton getRdCpf() {
        if (this.rdCpf == null) {
            this.rdCpf = this.getPainelFactory().novoBBJRadioButton("CPF", false);
        }
        return this.rdCpf;
    }

    public BBJRadioButton getRdCnpj() {
        if (this.rdCnpj == null) {
            this.rdCnpj = this.getPainelFactory().novoBBJRadioButton("CNPJ", false);
        }
        return this.rdCnpj;
    }

    public boolean isPessoaFisica() {
        return this.pessoaFisica;
    }

    public void setPessoaFisica(boolean pessoaFisica) {
        this.pessoaFisica = pessoaFisica;
    }

    public boolean isPessoaJuridica() {
        return this.pessoaJuridica;
    }

    public void setPessoaJuridica(boolean pessoaJuridica) {
        this.pessoaJuridica = pessoaJuridica;
    }

    private void habilitarIdentificadorProprio(boolean habilitar) {
        IdentificadorTO ident;
        this.getRdNumerico().setEnabled(habilitar);
        this.getRdAlfanumerico().setEnabled(habilitar);
        this.getTxtSiglaIdentificador().getJtfCampo().setEnabled(habilitar);
        this.getTxtTamanhoIdentificador().getJtfCampo().setEnabled(habilitar);
        this.getTxtFormatoIdentificador().getJtfCampo().setEnabled(habilitar);
        IdentificadorTO identificadorTO = ident = this.getManterConvenenteForm().getConvenenteTOSelecionado() != null ? UtilIdentificadorProprio.getInstancia().consultaIdentificadorProprioPor(this.getManterConvenenteForm().getConvenenteTOSelecionado().getConvenente(), this.getServicoAtual()) : null;
        if (habilitar) {
            if (ident != null) {
                try {
                    this.getTxtSiglaIdentificador().getJtfCampo().setText(ident.getNomeIdentificador());
                    String tamanho = ident.getNumeroTamanhoIdentificador().toString();
                    this.getTxtTamanhoIdentificador().getJtfCampo().setData(tamanho);
                }
                catch (InvalidObjectException e) {
                    e.printStackTrace();
                }
            }
        } else {
            this.getChkPossuiIdentificador().setSelected(false);
            this.getRdNumerico().setSelected(false);
            this.getRdAlfanumerico().setSelected(false);
            this.getTxtSiglaIdentificador().getJtfCampo().setBackground(new Color(227, 227, 227));
            this.getTxtTamanhoIdentificador().getJtfCampo().setBackground(new Color(227, 227, 227));
            this.getTxtSiglaIdentificador().getJtfCampo().clear();
            this.getTxtTamanhoIdentificador().getJtfCampo().clean();
        }
        if (!this.getTxtSiglaIdentificador().getJtfCampo().getText().trim().equals("") || !this.getTxtTamanhoIdentificador().getJtfCampo().getText().trim().equals("")) {
            this.getTxtSiglaIdentificador().getJtfCampo().setBackground(new Color(255, 255, 255));
            this.getTxtTamanhoIdentificador().getJtfCampo().setBackground(new Color(255, 255, 255));
            this.getTxtFormatoIdentificador().getJtfCampo().setEnabled(false);
            this.getTxtSiglaIdentificador().getJtfCampo().setEnabled(false);
            this.getTxtTamanhoIdentificador().getJtfCampo().setEnabled(false);
            this.getRdNumerico().setEnabled(false);
            this.getRdAlfanumerico().setEnabled(false);
        } else {
            this.getTxtSiglaIdentificador().getJtfCampo().setBackground(new Color(255, 255, 255));
            this.getTxtTamanhoIdentificador().getJtfCampo().setBackground(new Color(255, 255, 255));
        }
    }

    public boolean isFoiClicado() {
        return this.foiClicado;
    }

    public void setFoiClicado(boolean foiClicado) {
        this.foiClicado = foiClicado;
    }
}

