/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.dbt.apresentacao.mantergrupocliente.view;

import br.com.bb.plugins.dbt.apresentacao.DBTBasicInternalFrame;
import br.com.bb.plugins.dbt.apresentacao.mantergrupocliente.action.CarregarPopupGrupoClientesEditarAction;
import br.com.bb.plugins.dbt.apresentacao.mantergrupocliente.action.CarregarPopupGrupoClientesNovoAction;
import br.com.bb.plugins.dbt.apresentacao.mantergrupocliente.action.ConsultarListaGruposClienteAction;
import br.com.bb.plugins.dbt.apresentacao.mantergrupocliente.action.ExcluirGrupoClienteAction;
import br.com.bb.plugins.dbt.apresentacao.mantergrupocliente.action.ImprimirListaGrupoClientesAction;
import br.com.bb.plugins.dbt.apresentacao.mantergrupocliente.form.ManterGrupoClienteForm;
import br.com.bb.plugins.dbt.util.objecttablemodel.DadosGrupo;
import br.com.bb.plugins.gac.apresentacao.action.PluginActionAbstrato;
import br.com.bb.plugins.gac.apresentacao.form.PluginFormAbstrato;
import br.com.bb.plugins.gac.excecao.BBException;
import br.com.bb.plugins.gac.negocio.to.GrupoClienteRecebimentoTO;
import br.com.bb.plugins.gac.negocio.to.decorator.RelatorioGrupoClientesDecorator;
import br.com.bb.plugins.gac.util.UtilRelatorioJasper;
import br.com.bb.plugins.gac.util.constante.Arquivo;
import br.com.bb.plugins.gac.util.controller.view.ControlableView;
import br.com.bb.plugins.gac.util.controller.view.ViewController;
import br.com.bb.plugins.gac.util.swing.IFormulario;
import br.com.bb.plugins.gac.util.swing.componente.BBJButton;
import br.com.bb.plugins.gac.util.swing.componente.BBJLabel;
import br.com.bb.plugins.gac.util.swing.componente.BBJPaginacao;
import br.com.bb.plugins.gac.util.swing.componente.BBJPopupMensagem;
import br.com.bb.plugins.gac.util.swing.componente.BBJTable;
import br.com.bb.plugins.gac.util.swing.componente.BBJTableImpl;
import br.com.bb.plugins.gac.util.swing.componente.BBJTablePagina;
import br.com.politec.generico.arquivo.UtilArquivo;
import br.com.politec.generico.colecao.UtilColecao;
import br.com.politec.generico.objeto.UtilObjeto;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.table.TableModel;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.view.JasperViewer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViewManterGrupoClientes
extends DBTBasicInternalFrame {
    private JPanel paineltitulo = null;
    private JPanel panelPrincipal = null;
    private JPanel panelDados = null;
    private final String[] columnNames = new String[]{"Conv\u00eanio", "Grupo"};
    private final int[] columnSizes = new int[]{100, 300};
    private final int[] columnAligment = new int[]{2, 2};
    private BBJTablePagina<DadosGrupo> tableGrupo = null;
    private JPanel panelBotoes = null;
    private BBJButton btnNovo;
    private BBJButton btnEditar;
    private BBJButton btnExcluir;
    private BBJButton btnVoltar;
    private BBJPaginacao paginacao = null;
    private Map context;
    private BBJButton btnImprimir;
    boolean exibirMensagemVazio;

    public BBJPaginacao getPaginacao() {
        if (!this.isReferencia(this.paginacao)) {
            this.paginacao = this.getPainelFactory().novoBBJPaginacao();
        }
        return this.paginacao;
    }

    public void setPaginacao(BBJPaginacao paginacao) {
        this.paginacao = paginacao;
    }

    public ViewManterGrupoClientes() {
        super("Consultar Grupos", false, false);
        this.initialize();
    }

    private void initialize() {
        this.add(this.getPanelPrincipal());
    }

    public JPanel getPanelPrincipal() {
        if (!this.isReferencia(this.panelPrincipal)) {
            this.panelPrincipal = this.getPainelFactory().novoJPainel();
            this.panelPrincipal.setLayout(this.getLayoutFactory().novoBorderLayout());
            this.panelPrincipal.setOpaque(false);
            this.panelPrincipal.add((Component)this.getPanelDados(), "North");
            this.panelPrincipal.add((Component)this.getPanelBotoes(), "Center");
        }
        return this.panelPrincipal;
    }

    public BBJTablePagina<DadosGrupo> getTableGrupos() {
        if (!this.isReferencia(this.tableGrupo)) {
            this.tableGrupo = this.getPainelFactory().novoBBJTablePagina(this.columnNames, this.columnSizes, this.columnAligment, "", 0, 5, this.getBotoesPaginacao());
            BBJTable tableModel = this.tableGrupo.getTable().getBbtModel();
            this.tableGrupo.getTable().setModel((TableModel)tableModel);
            tableModel.setOrdenacaoAutomatica(true);
            tableModel.setNomeColunas(new String[]{"convenioDebitoTO.convenioTO.numeroConvenio", "textoDescricao"});
            this.tableGrupo.setName("listaGrupoClienteTabela");
            tableModel.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ViewManterGrupoClientes.this.habilitarBotoes(e.getActionCommand().equalsIgnoreCase("SELECIONADO"));
                    if (e.getActionCommand().equalsIgnoreCase("EVENTO_ORDENACAO")) {
                        ViewManterGrupoClientes.this.ordenarTabela();
                    }
                }
            });
        }
        return this.tableGrupo;
    }

    private void ordenarTabela() {
        BBJTableImpl table = this.getTableGrupos().getTable();
        BBJTable bbtModel = table.getBbtModel();
        this.getManterGrupoClienteForm().getClienteRecebimentoTODecorator().setNomeColunaOrdenada(bbtModel.getNomeColunaOrdenada());
        this.getManterGrupoClienteForm().getClienteRecebimentoTODecorator().setTipoOrdenacao(bbtModel.getTipoordenacao());
        this.preencherTela();
    }

    private void preencherTabelaGrupoCliente() {
        Collection<GrupoClienteRecebimentoTO> listaGrupo = this.getManterGrupoClienteForm().getColecaoDeRegistros();
        ArrayList<DadosGrupo> dados = new ArrayList<DadosGrupo>();
        for (GrupoClienteRecebimentoTO grupo : listaGrupo) {
            dados.add(new DadosGrupo(grupo));
        }
        this.getTableGrupos().addDataListTabela(dados);
        this.getPaginacao().setValorMaximo(this.getForm().getNumeroDePaginas().intValue());
        if (UtilColecao.isVazio(listaGrupo)) {
            if (this.exibirMensagemVazio) {
                BBJPopupMensagem.exibirMensagem((String)this.getMensagem("MP004"));
            }
        } else {
            this.getBtnImprimir().setEnabled(true);
        }
    }

    private void consultarListaGrupoCliente() {
        ConsultarListaGruposClienteAction action = this.getDBTActionFactory().novoConsultarListaGruposClienteAction();
        action.executar(this.getManterGrupoClienteForm());
    }

    private BBJPaginacao getBotoesPaginacao() {
        BBJPaginacao paginacao = this.getPaginacao();
        paginacao.addPropertyChangeListener("paginacao", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                ViewManterGrupoClientes.this.getManterGrupoClienteForm().setPaginaAtual((Integer)evt.getNewValue());
                ViewManterGrupoClientes.this.preencherTela();
            }
        });
        return paginacao;
    }

    private ManterGrupoClienteForm getManterGrupoClienteForm() {
        return (ManterGrupoClienteForm)this.getForm();
    }

    protected PluginFormAbstrato novoForm() {
        return this.getDBTFormFactory().novoManterGrupoClienteForm();
    }

    private void habilitarBotoes(boolean habilitar) {
        this.getBtnEditar().setEnabled(habilitar);
        this.getBtnExcluir().setEnabled(habilitar);
        this.getBtnImprimir().setEnabled(habilitar);
    }

    public JPanel getPanelDados() {
        if (!this.isReferencia(this.panelDados)) {
            this.panelDados = new JPanel();
            this.panelDados.setLayout(new BorderLayout());
            this.panelDados.setOpaque(false);
            this.panelDados.add((Component)this.getPaineltitulo(), "North");
            this.panelDados.add((Component)this.getTableGrupos(), "Center");
        }
        return this.panelDados;
    }

    public JPanel getPaineltitulo() {
        if (!this.isReferencia(this.paineltitulo)) {
            this.paineltitulo = new JPanel();
            this.paineltitulo.setOpaque(false);
            this.paineltitulo.setLayout(new BoxLayout(this.paineltitulo, 0));
            this.paineltitulo.add(Box.createRigidArea(new Dimension(12, 0)));
            this.paineltitulo.add((Component)new BBJLabel("Selecione o Grupo de Clientes e escolha a op\u00e7\u00e3o desejada."));
            this.paineltitulo.setPreferredSize(new Dimension(200, 20));
            this.paineltitulo.setSize(new Dimension(200, 20));
        }
        return this.paineltitulo;
    }

    public JPanel getPanelBotoes() {
        if (!this.isReferencia(this.panelBotoes)) {
            this.panelBotoes = this.getPainelFactory().novoJPainel();
            this.panelBotoes.setOpaque(false);
            FlowLayout flayout = this.getLayoutFactory().novoFlowLayout();
            flayout.setAlignment(2);
            this.panelBotoes.setLayout(flayout);
            this.panelBotoes.add((Component)this.getBtnNovo());
            this.panelBotoes.add((Component)this.getBtnEditar());
            this.panelBotoes.add((Component)this.getBtnExcluir());
            this.panelBotoes.add((Component)this.getBtnImprimir());
            this.panelBotoes.add((Component)this.getBtnVoltar());
        }
        return this.panelBotoes;
    }

    public BBJButton getBtnNovo() {
        if (!this.isReferencia(this.btnNovo)) {
            CarregarPopupGrupoClientesNovoAction action = this.getDBTActionFactory().novoCarregarPopupGrupoClientesNovoAction();
            this.btnNovo = this.getBotaoFactory().novoNovo((PluginActionAbstrato)action);
        }
        return this.btnNovo;
    }

    public void posExecucaoCarregarPopupGrupoClientesNovoAction() {
        this.getContext().put("ACAO", 1);
        ControlableView view = ViewController.getInstance().goToView("DBTNOVOGRUPOCLIENTEPOPUP", this.getContext(), false);
        view.doShow(this.getContext());
        this.preencherTela();
    }

    public BBJButton getBtnEditar() {
        if (!this.isReferencia(this.btnEditar)) {
            CarregarPopupGrupoClientesEditarAction action = this.getDBTActionFactory().novoCarregarPopupGrupoClientesEditarAction();
            this.btnEditar = this.getBotaoFactory().novoEditar((PluginActionAbstrato)action);
        }
        return this.btnEditar;
    }

    public void posExecucaoCarregarPopupGrupoClientesEditarAction() {
        this.getContext().put("ACAO", 2);
        this.getContext().put("colecao", this.getTableGrupos().getTable().getItensChecadosCheckBox());
        ControlableView view = ViewController.getInstance().goToView("DBTEDITARGRUPOCLIENTEPOPUP", null, false);
        view.doShow(this.getContext());
        this.preencherTela();
    }

    public BBJButton getBtnExcluir() {
        if (!this.isReferencia(this.btnExcluir)) {
            ExcluirGrupoClienteAction acao = this.getDBTActionFactory().novoExcluirGrupoClienteAction();
            this.btnExcluir = this.getBotaoFactory().novoExcluir((PluginActionAbstrato)acao);
        }
        return this.btnExcluir;
    }

    public void posExecucaoExcluirGrupoClienteAction() {
        BBJPopupMensagem.exibirMensagem((String)this.getMensagem("MP003"));
        this.preencherTela();
    }

    public BBJButton getBtnVoltar() {
        if (!this.isReferencia(this.btnVoltar)) {
            this.btnVoltar = this.getBotaoFactory().novoVoltar();
        }
        return this.btnVoltar;
    }

    public void posExecucaoFecharAction() {
        super.posExecucaoFecharAction();
    }

    public void doShow(Map context) {
        this.setVisible(true);
        this.exibirMensagemVazio = true;
        this.preencherTela();
        this.exibirMensagemVazio = false;
        this.getBtnNovo().requestFocus();
        this.getManterGrupoClienteForm().setPaginaAtual(1);
        this.getManterGrupoClienteForm().getTODecoratorParaOrdenacao().setNomeColunaOrdenada("textoDescricao");
        this.getManterGrupoClienteForm().getTODecoratorParaOrdenacao().setTipoOrdenacao("ASC");
        this.getPaginacao().setValorPos(1);
        this.getPaginacao().setValorMaximo(this.getForm().getNumeroDePaginas().intValue());
        this.getPaginacao().atualiza();
    }

    public void preencherTela() {
        this.consultarListaGrupoCliente();
        this.preencherTabelaGrupoCliente();
    }

    public Map getContext() {
        if (!UtilObjeto.isReferencia((Object)this.context)) {
            this.context = new HashMap();
        }
        return this.context;
    }

    protected BBJButton getBtnImprimir() {
        if (!this.isReferencia(this.btnImprimir)) {
            ImprimirListaGrupoClientesAction acao = this.getDBTActionFactory().novoImprimirListaGrupoClientesAction();
            this.btnImprimir = this.getBotaoFactory().novoImprimir((PluginActionAbstrato)acao);
        }
        return this.btnImprimir;
    }

    public void posExecucaoImprimirListaGrupoClientesAction() {
        if (this.isReferencia(this.getManterGrupoClienteForm().getColecaoDeRegistros())) {
            this.imprimirGrupos();
        } else {
            BBJPopupMensagem.exibirMensagem((String)this.getUtilMensagem().getMensagem("MP004"));
        }
    }

    private void imprimirGrupos() {
        JasperPrint impressao = null;
        try {
            impressao = UtilRelatorioJasper.imprimirRelatorio((String)Arquivo.JASPER_LISTA_GRUPO_DR_CLIENTES, (Map)this.getMapaSubRelatorio(), this.getListaGrupos());
            JasperViewer jrviewer = new JasperViewer(impressao, false);
            jrviewer.setIconImage(new ImageIcon(((Object)((Object)this)).getClass().getResource("/images/BBRelatorio.gif")).getImage());
            jrviewer.setVisible(true);
        }
        catch (BBException e) {
            this.processarMensagemDeErro((IFormulario)this, e);
        }
        catch (JRException e) {
            this.processarMensagemDeErro((IFormulario)this, e);
        }
    }

    private Map getMapaSubRelatorio() {
        Map mapa = this.getColecaoFactory().novoHashMap();
        mapa.put("telefonesOuvidoria", "Suporte T\u00e9cnico: 4004-0001 (capitais e regi\u00f5es metropolitanas) e 0800-729-0001 (demais localidades) SAC: 0800729-0722 / Ouvidoria: 0800-729-5678");
        mapa.put("subRelatorio", UtilArquivo.getInputStream((String)Arquivo.JASPER_LISTA_CONVENIOS_CONVENENTE));
        return mapa;
    }

    private Collection<RelatorioGrupoClientesDecorator> getListaGrupos() {
        ArrayList<RelatorioGrupoClientesDecorator> colecaoDecorator = new ArrayList<RelatorioGrupoClientesDecorator>();
        Collection<GrupoClienteRecebimentoTO> lista = this.getManterGrupoClienteForm().getColecaoDeRegistros();
        for (GrupoClienteRecebimentoTO to : lista) {
            colecaoDecorator.add(this.novoRelatorioGrupoClientesDecorator(to));
        }
        return colecaoDecorator;
    }

    private RelatorioGrupoClientesDecorator novoRelatorioGrupoClientesDecorator(GrupoClienteRecebimentoTO to) {
        RelatorioGrupoClientesDecorator retorno = new RelatorioGrupoClientesDecorator();
        retorno.setConvenio("");
        retorno.setGrupo("");
        if (to.getConvenioDebitoTO().getConvenioTO().getNumeroConvenio() != null) {
            retorno.setConvenio(to.getConvenioDebitoTO().getConvenioTO().getNumeroConvenio().toString());
        }
        if (!to.getTextoDescricao().equals("")) {
            retorno.setGrupo(to.getTextoDescricao());
        }
        return retorno;
    }
}

