/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.dbt.apresentacao.manterrecebimentos.action;

import br.com.bb.plugins.dbt.apresentacao.action.DBTPluginActionAbstrato;
import br.com.bb.plugins.dbt.apresentacao.manterrecebimentos.form.ManterRecebimentoForm;
import br.com.bb.plugins.dbt.negocio.facade.ManterRecebimentoFacade;
import br.com.bb.plugins.gac.apresentacao.form.PluginFormAbstrato;
import br.com.bb.plugins.gac.excecao.BBException;
import br.com.bb.plugins.gac.negocio.to.ConvenenteTO;
import br.com.bb.plugins.gac.negocio.to.PessoaTO;
import br.com.politec.generico.conversor.UtilConversorDeString;

public class ConsultarDadosPessoaAction
extends DBTPluginActionAbstrato {
    private ManterRecebimentoFacade facade;
    private ManterRecebimentoForm recForm;

    public void preExecutar(PluginFormAbstrato form) {
        form.setPermitirValidacao(false);
    }

    public String executar(PluginFormAbstrato form) throws BBException {
        this.recForm = (ManterRecebimentoForm)form;
        this.facade = this.getDBTFacadeFactory().novoManterRecebimentoFacade();
        int opcaoConsulta = UtilConversorDeString.converterParaInt((String)this.recForm.getOpcaoConsulta());
        this.recForm.setPessoaTO(null);
        switch (opcaoConsulta) {
            case 2: {
                this.consultarPessoaPelaIdentificacaoDebito();
                break;
            }
            case 3: {
                this.consultarPessoaPelaContaCorrente();
                break;
            }
            case 4: {
                this.consultarPessoaPeloIDProprio();
            }
        }
        return null;
    }

    private void consultarPessoaPeloIDProprio() {
        ConvenenteTO convenenteTO = this.recForm.getConvenenteTO();
        PessoaTO pessoaTO = this.facade.consultarPessoaPorIdProprioEConvenente(this.recForm.getTextoIdentificadorProprio(), convenenteTO);
        this.recForm.setPessoaTO(pessoaTO);
    }

    private void consultarPessoaPelaIdentificacaoDebito() {
        PessoaTO pessoaTO = this.facade.consultarPessoaPelaIdentificacao(this.recForm.getTextoIdentificadorDebito());
        this.recForm.setPessoaTO(pessoaTO);
    }

    private void consultarPessoaPelaContaCorrente() {
        PessoaTO pessoaTO = this.facade.consultarPessoaPelaContaCorrente(1, this.recForm.getCodigoAgencia(), this.recForm.getCodigoContaCorrente());
        this.recForm.setPessoaTO(pessoaTO);
    }
}

