/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.dbt.apresentacao.migrardadosdedebito.view;

import br.com.bb.plugins.dbt.apresentacao.DBTBasicInternalFrame;
import br.com.bb.plugins.dbt.apresentacao.migrardadosdedebito.action.ImprimirMigracaoDadosDebitoAction;
import br.com.bb.plugins.dbt.apresentacao.migrardadosdedebito.form.MigrarDadosDebitoForm;
import br.com.bb.plugins.dbt.util.objecttablemodel.IObjectMigrarDadosDebito;
import br.com.bb.plugins.gac.apresentacao.action.PluginActionAbstrato;
import br.com.bb.plugins.gac.apresentacao.form.PluginFormAbstrato;
import br.com.bb.plugins.gac.excecao.BBException;
import br.com.bb.plugins.gac.negocio.to.PaginadorTO;
import br.com.bb.plugins.gac.negocio.to.decorator.MigrarDadosDebitoTODecorator;
import br.com.bb.plugins.gac.negocio.to.decorator.PessoaTODecorator;
import br.com.bb.plugins.gac.util.UtilRelatorioJasper;
import br.com.bb.plugins.gac.util.constante.Arquivo;
import br.com.bb.plugins.gac.util.controller.view.ViewController;
import br.com.bb.plugins.gac.util.swing.IFormulario;
import br.com.bb.plugins.gac.util.swing.componente.BBJButton;
import br.com.bb.plugins.gac.util.swing.componente.BBJLabel;
import br.com.bb.plugins.gac.util.swing.componente.BBJPaginacao;
import br.com.bb.plugins.gac.util.swing.componente.BBJTablePagina;
import br.com.bb.plugins.gac.util.view.BBJPanelBotoesManut;
import br.com.bb.plugins.gac.util.view.FramePrincipal;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.view.JasperViewer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViewMigrarDadosResumoDBT
extends DBTBasicInternalFrame {
    private static final long serialVersionUID = 1L;
    protected static final String NOME_TELA_RESUMO = "ViewMigrarDadosResumoDBT";
    private static final String TELA_ERROS_MIGRACAO = "MIGRACAOLISTAERROSDBT";
    private static final String KEY_MIGRADOS = "MIGRADOS";
    private static final String LISTA_ERROS_GRAVES_MIGRACAO = "listaErrosGravesMigracao";
    private static final String KEY_FORM = "FORM";
    private static final int TOTAL_MAX_REGISTROS = 10;
    private String[] columnNames = new String[]{"Descri\u00e7\u00e3o", ""};
    private int[] columnSizes;
    private int[] columnAligment;
    private BBJTablePagina<IObjectMigrarDadosDebito> tableRelatorio;
    private JPanel panelMain;
    private JPanel panelStatus;
    private JPanel panelBotoesImprimir;
    private BBJButton botaoOcorrencias;
    private BBJButton botaoImprimr;
    private BBJButton botaoFechar;
    private BBJPaginacao paginacao;
    private BBJLabel labelMigrados;
    private MigrarDadosDebitoForm form;

    public ViewMigrarDadosResumoDBT() {
        super("Migrar Base de Dados de Vers\u00f5es Anteriores - Migrados", false, false);
        int[] nArray = new int[2];
        nArray[0] = 1200;
        this.columnSizes = nArray;
        this.columnAligment = new int[]{2, 2};
        this.tableRelatorio = null;
        this.panelMain = null;
        this.panelStatus = null;
        this.panelBotoesImprimir = null;
        this.paginacao = null;
        this.labelMigrados = null;
    }

    public void doShow(Map context) {
        this.initialize();
        boolean exibirBtnOcorrencias = context.containsKey(LISTA_ERROS_GRAVES_MIGRACAO);
        this.getBotaoOcorrencias().setVisible(exibirBtnOcorrencias);
        this.setFormMigrarDadosDebitoForm((MigrarDadosDebitoForm)((Object)context.get(KEY_FORM)));
        this.getPaginacao().setValorMaximo(this.calculaTotalDePaginas().intValue());
        this.getLabelMigrados().setText("" + context.get(KEY_MIGRADOS));
        this.getPaginacao().setValorPos(1);
        this.getPaginacao().setValorMaximo(this.calculaTotalDePaginas().intValue());
        this.getPaginacao().atualiza();
        this.setVisible(true);
    }

    private BBJLabel getLabelMigrados() {
        if (this.labelMigrados == null) {
            this.labelMigrados = new BBJLabel("");
        }
        return this.labelMigrados;
    }

    private BBJButton getBotaoOcorrencias() {
        if (this.botaoOcorrencias == null) {
            this.botaoOcorrencias = new BBJButton("LISTAR OCORR\u00caNCIAS");
            this.botaoOcorrencias.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent arg0) {
                    ViewMigrarDadosResumoDBT.this.abrirTelaErrosMigracao();
                }
            });
        }
        return this.botaoOcorrencias;
    }

    private Integer calculaTotalDePaginas() {
        Integer totalDeRegistros = 10 - this.getFormMigrarDadosDebitoForm().getTotalDeRegistros() % 10;
        if (totalDeRegistros == 10) {
            totalDeRegistros = 0;
        }
        totalDeRegistros = totalDeRegistros + this.getFormMigrarDadosDebitoForm().getTotalDeRegistros();
        return totalDeRegistros / 10;
    }

    private void initialize() {
        JPanel panel = new JPanel();
        panel.setOpaque(false);
        panel.setLayout(new BorderLayout());
        panel.add((Component)this.getPanelMain(), "North");
        this.add(panel);
    }

    private JPanel getPanelMain() {
        if (this.panelMain == null) {
            this.panelMain = new JPanel();
            this.panelMain.setOpaque(false);
            this.panelMain.setLayout(new BorderLayout());
            this.getPanelMain().add((Component)this.getTableRelatorio(), "North");
            this.getPanelMain().add((Component)this.getPanelStatus(), "Center");
            this.getPanelMain().add((Component)this.getPanelBotoesImprimir(), "South");
        }
        return this.panelMain;
    }

    private JPanel getPanelStatus() {
        if (this.panelStatus == null) {
            this.panelStatus = new JPanel();
            this.panelStatus.setOpaque(false);
            this.panelStatus.setLayout(new GridBagLayout());
            this.panelStatus.setPreferredSize(new Dimension(0, 42));
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.anchor = 17;
            gbc.insets = new Insets(1, 10, 1, 1);
            gbc.fill = 1;
            gbc.weightx = 0.2;
            gbc.gridx = 0;
            gbc.gridy = 0;
            this.panelStatus.add((Component)new BBJLabel("Migrados"), gbc);
            gbc.weightx = 0.8;
            gbc.gridx = 1;
            this.panelStatus.add((Component)this.getLabelMigrados(), gbc);
        }
        return this.panelStatus;
    }

    private void preencherTabela() {
        List dados = this.getColecaoFactory().novoArrayList();
        for (PessoaTODecorator pessoaTODecorator : this.getFormMigrarDadosDebitoForm().getListaPessoasMigradasPaginador()) {
            IObjectMigrarDadosDebito dadosDebito = new IObjectMigrarDadosDebito(pessoaTODecorator);
            dados.add(dadosDebito);
        }
        this.getTableRelatorio().setDataListTabela(dados);
    }

    private BBJTablePagina<IObjectMigrarDadosDebito> getTableRelatorio() {
        if (this.tableRelatorio == null) {
            this.tableRelatorio = new BBJTablePagina(this.columnNames, this.columnSizes, this.columnAligment, null, 0, 5, this.getBotoesPaginacao());
            this.tableRelatorio.getPanelTabela().setPreferredSize(new Dimension(0, 220));
            this.tableRelatorio.setPreferredSize(new Dimension(0, 250));
            this.tableRelatorio.getTable().setOrdenacaoAutomatica(false);
            this.tableRelatorio.getTable().getBbtModel().setColunaordenada(1);
            this.tableRelatorio.getTable().getBbtModel().setTipoordenacao("ASC");
            this.tableRelatorio.getTable().setNomeColunas(new String[]{"1", "2"});
            this.tableRelatorio.getTable().getBbtModel().addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (e.getActionCommand().equals("EVENTO_ORDENACAO")) {
                        ViewMigrarDadosResumoDBT.this.getFormMigrarDadosDebitoForm().setNomeColunaOrdenada(ViewMigrarDadosResumoDBT.this.tableRelatorio.getTable().getBbtModel().getNomeColunaOrdenada());
                        ViewMigrarDadosResumoDBT.this.getFormMigrarDadosDebitoForm().setTipoOrdenacao(ViewMigrarDadosResumoDBT.this.tableRelatorio.getTable().getBbtModel().getTipoordenacao());
                        ViewMigrarDadosResumoDBT.this.ordenarTabela(ViewMigrarDadosResumoDBT.this.tableRelatorio.getTable().getBbtModel().getColunaordenada());
                        PaginadorTO retorno = ViewMigrarDadosResumoDBT.this.novoPaginadorCom10Registros(ViewMigrarDadosResumoDBT.this.getFormMigrarDadosDebitoForm().getColecaoMigrarDadosDebito(), ViewMigrarDadosResumoDBT.this.getFormMigrarDadosDebitoForm().getPaginaAtual(), ViewMigrarDadosResumoDBT.this.getFormMigrarDadosDebitoForm().getColecaoMigrarDadosDebito().size());
                        ViewMigrarDadosResumoDBT.this.getFormMigrarDadosDebitoForm().setPaginadorTO(retorno);
                        ViewMigrarDadosResumoDBT.this.preencherTabela();
                    }
                }
            });
        }
        return this.tableRelatorio;
    }

    protected void ordenarTabela(int colunaOrdenada) {
        final int colOrdenada = colunaOrdenada;
        String tipoOrdenacao = this.getFormMigrarDadosDebitoForm().getTipoOrdenacao();
        final boolean isASC = tipoOrdenacao == null ? true : tipoOrdenacao.equals("ASC");
        Collections.sort((List)this.getFormMigrarDadosDebitoForm().getMigrarDadosDebitoTODecorator().getColecaoMigrarDadosDebito(), new Comparator<PessoaTODecorator>(){

            @Override
            public int compare(PessoaTODecorator p1, PessoaTODecorator p2) {
                PessoaTODecorator comparado1 = null;
                PessoaTODecorator comparado2 = null;
                if (isASC) {
                    comparado1 = p1;
                    comparado2 = p2;
                } else {
                    comparado1 = p2;
                    comparado2 = p1;
                }
                switch (colOrdenada) {
                    case 1: {
                        return comparado1.getNome().compareToIgnoreCase(comparado2.getNome());
                    }
                }
                return 0;
            }
        });
    }

    protected JPanel getPanelBotoesImprimir() {
        if (this.panelBotoesImprimir == null) {
            this.panelBotoesImprimir = this.getPainelFactory().novoJPainelDeBotoes(this.getColecaoBotoesImprimir());
            new BBJPanelBotoesManut(new String[]{"IMPRIMIR", "FECHAR"});
        }
        return this.panelBotoesImprimir;
    }

    private Collection<BBJButton> getColecaoBotoesImprimir() {
        ArrayList<BBJButton> colecao = new ArrayList<BBJButton>(1);
        colecao.add(this.getBotaoOcorrencias());
        colecao.add(this.getBotaoImprimir());
        colecao.add(this.getBotaoFechar());
        return colecao;
    }

    private BBJButton getBotaoImprimir() {
        if (!this.isReferencia(this.botaoImprimr)) {
            ImprimirMigracaoDadosDebitoAction acao = this.getDBTActionFactory().novoImprimirMigracaoDadosDebitoAction();
            this.botaoImprimr = this.getBotaoFactory().novoImprimir((PluginActionAbstrato)acao);
        }
        return this.botaoImprimr;
    }

    private BBJButton getBotaoFechar() {
        if (!this.isReferencia(this.botaoFechar)) {
            this.botaoFechar = new BBJButton("FECHAR");
            this.botaoFechar.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent arg0) {
                    ViewMigrarDadosResumoDBT.this.doClose(null);
                }
            });
        }
        return this.botaoFechar;
    }

    public void posExecucaoImprimirMigracaoDadosDebitoAction() {
        this.imprimirRelatorioMigrarDadosDebito();
    }

    private void imprimirRelatorioMigrarDadosDebito() {
        JasperPrint jasper = null;
        try {
            jasper = UtilRelatorioJasper.imprimirRelatorio((String)Arquivo.JASPER_MIGRAR_DADOS_DEBITO, (Map)this.getMapaDeParametrosRelatorio(this.getFormMigrarDadosDebitoForm().getMigrarDadosDebitoTODecorator()), (Collection)this.getFormMigrarDadosDebitoForm().getColecaoMigrarDadosDebito());
        }
        catch (BBException e) {
            this.processarMensagemDeErro((IFormulario)this, e);
        }
        catch (JRException e) {
            this.processarMensagemDeErro((IFormulario)this, e);
        }
        JasperViewer jrviewer = new JasperViewer(jasper, false);
        jrviewer.setIconImage(new ImageIcon(((Object)((Object)this)).getClass().getResource("/images/BBRelatorio.gif")).getImage());
        jrviewer.setVisible(true);
    }

    private Map getMapaDeParametrosRelatorio(MigrarDadosDebitoTODecorator decorator) {
        Map mapa = this.getColecaoFactory().novoHashMap();
        mapa.put("migrados", decorator.getRegistrosMigrados());
        mapa.put("nomeDoConvenente", FramePrincipal.getInstance().getPanelInferior().getConvenente());
        mapa.put("telefonesOuvidoria", "Suporte T\u00e9cnico: 4004-0001 (capitais e regi\u00f5es metropolitanas) e 0800-729-0001 (demais localidades) SAC: 0800729-0722 / Ouvidoria: 0800-729-5678");
        return mapa;
    }

    private BBJPaginacao getBotoesPaginacao() {
        if (!this.isReferencia(this.paginacao)) {
            this.paginacao = new BBJPaginacao();
            this.paginacao.setValorIncremento(1);
            this.paginacao.addPropertyChangeListener("paginacao", new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    ViewMigrarDadosResumoDBT.this.getFormMigrarDadosDebitoForm().setNomeColunaOrdenada(ViewMigrarDadosResumoDBT.this.getTableRelatorio().getTable().getBbtModel().getNomeColunaOrdenada());
                    ViewMigrarDadosResumoDBT.this.getFormMigrarDadosDebitoForm().setTipoOrdenacao(ViewMigrarDadosResumoDBT.this.getTableRelatorio().getTable().getBbtModel().getTipoordenacao());
                    ViewMigrarDadosResumoDBT.this.ordenarTabela(ViewMigrarDadosResumoDBT.this.getTableRelatorio().getTable().getBbtModel().getColunaordenada());
                    ViewMigrarDadosResumoDBT.this.getFormMigrarDadosDebitoForm().setPaginaAtual((Integer)evt.getNewValue());
                    PaginadorTO retorno = ViewMigrarDadosResumoDBT.this.novoPaginadorCom10Registros(ViewMigrarDadosResumoDBT.this.getFormMigrarDadosDebitoForm().getColecaoMigrarDadosDebito(), ViewMigrarDadosResumoDBT.this.getFormMigrarDadosDebitoForm().getPaginaAtual(), ViewMigrarDadosResumoDBT.this.getFormMigrarDadosDebitoForm().getColecaoMigrarDadosDebito().size());
                    ViewMigrarDadosResumoDBT.this.getFormMigrarDadosDebitoForm().setPaginadorTO(retorno);
                    ViewMigrarDadosResumoDBT.this.preencherTabela();
                }
            });
        }
        return this.paginacao;
    }

    public BBJPaginacao getPaginacao() {
        if (!this.isReferencia(this.paginacao)) {
            this.paginacao = this.getPainelFactory().novoBBJPaginacao();
        }
        return this.paginacao;
    }

    public PaginadorTO novoPaginadorCom10Registros(Collection<?> colecao, Integer paginaAtual, Integer totalDeRegistros) {
        int ultimaPagina = 0;
        int quantidade = 10;
        int inicio = quantidade * ((paginaAtual = Integer.valueOf(paginaAtual == 0 ? 1 : paginaAtual)) - 1);
        int fim = inicio + quantidade;
        if (fim > totalDeRegistros) {
            fim = totalDeRegistros;
        }
        List colecaoPaginada = new LinkedList(colecao).subList(inicio, fim);
        ultimaPagina = totalDeRegistros / quantidade;
        if (totalDeRegistros % quantidade > 0) {
            ++ultimaPagina;
        }
        if (paginaAtual > ultimaPagina) {
            paginaAtual = ultimaPagina;
        }
        PaginadorTO paginadorTO = new PaginadorTO();
        paginadorTO.setPaginaAtual(paginaAtual);
        paginadorTO.setTotalDeRegistros(totalDeRegistros);
        paginadorTO.setColecaoDeRegistros(colecaoPaginada);
        return paginadorTO;
    }

    private void setFormMigrarDadosDebitoForm(MigrarDadosDebitoForm form) {
        this.form = form;
    }

    private MigrarDadosDebitoForm getFormMigrarDadosDebitoForm() {
        return this.form;
    }

    protected PluginFormAbstrato novoForm() {
        return this.getDBTFormFactory().novoMigrarDadosDebitoForm();
    }

    private void abrirTelaErrosMigracao() {
        Map<String, Object> context = this.getFormMigrarDadosDebitoForm().getResumoMigrarDecorator().getContext();
        if (!context.containsKey(NOME_TELA_RESUMO)) {
            context.put(NOME_TELA_RESUMO, (Object)this);
        }
        ViewController.getInstance().goToView(TELA_ERROS_MIGRACAO, context, false);
    }
}

