/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.dbt.integracao.dao;

import br.com.bb.plugins.gac.excecao.BBException;
import br.com.bb.plugins.gac.integracao.dao.controle.JDBCDAOSuport;
import br.com.bb.plugins.gac.negocio.to.RecebimentoDebitoTO;
import br.com.bb.plugins.gac.util.UtilMensagem;
import br.com.politec.generico.conversor.UtilConversorDeData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExecutarExpurgoAutomaticoDAO
extends JDBCDAOSuport {
    private List<RecebimentoDebitoTO> recebimentos = new ArrayList<RecebimentoDebitoTO>();
    private int dias;
    private String nomeModulo;

    public ExecutarExpurgoAutomaticoDAO() {
        super("BDGERAL");
        this.setNomeModulo("DBT");
    }

    public int consultaNumeroDiasRetencaoDados() throws BBException {
        int dias = 0;
        String s_sql = "select * from SRVC where TX_IDFR_SRVC = ?";
        try {
            PreparedStatement pstm = this.getConexao().prepareStatement(s_sql);
            pstm.setString(1, "DBT");
            ResultSet rs = pstm.executeQuery();
            while (rs.next()) {
                dias = rs.getInt("NR_DD_RTC_DADO");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BBException(UtilMensagem.getInstancia().getErroDeSistema(e.getMessage()));
        }
        return dias;
    }

    public Collection<RecebimentoDebitoTO> consultaRecebimentosParaExpurgo() throws BBException {
        String s_sql = "select NR_RCBT, DT_RCBT from RCBT_DEB";
        try {
            PreparedStatement pstm = this.getConexao().prepareStatement(s_sql);
            ResultSet rs = pstm.executeQuery();
            while (rs.next()) {
                RecebimentoDebitoTO to = new RecebimentoDebitoTO();
                to.setNumeroRecebimento(Integer.valueOf(rs.getInt("NR_RCBT")));
                to.setDataRecebimento((Date)rs.getDate("DT_RCBT"));
                this.recebimentos.add(to);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BBException(UtilMensagem.getInstancia().getErroDeSistema(e.getMessage()));
        }
        return this.recebimentos;
    }

    public void atualizaDataUltimaExclusao() throws BBException {
        String s_sql = "update SRVC set DT_EXEA_ULT_EXCL = ? WHERE TX_IDFR_SRVC = ?";
        Date agora = new Date();
        try {
            PreparedStatement pstm = this.getConexao().prepareStatement(s_sql);
            pstm.setDate(1, UtilConversorDeData.converterParaSqlDate((Date)agora));
            pstm.setString(2, this.getNomeModulo());
            pstm.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BBException(UtilMensagem.getInstancia().getErroDeSistema(e.getMessage()));
        }
    }

    public int expurgaListaDeRecebimentos(Collection<RecebimentoDebitoTO> lista) throws BBException {
        int ret = 0;
        String s_sql = "delete from RCBT_DEB where NR_RCBT = ?";
        try {
            PreparedStatement pstm = this.getConexao().prepareStatement(s_sql);
            for (RecebimentoDebitoTO rcbt : lista) {
                pstm.setInt(1, rcbt.getNumeroRecebimento());
                ret += pstm.executeUpdate();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BBException(UtilMensagem.getInstancia().getErroDeSistema(e.getMessage()));
        }
        return ret;
    }

    public List<RecebimentoDebitoTO> getRecebimentos() {
        return this.recebimentos;
    }

    public void setRecebimentos(List<RecebimentoDebitoTO> recebimentos) {
        this.recebimentos = recebimentos;
    }

    public String getNomeModulo() {
        return this.nomeModulo;
    }

    public void setNomeModulo(String nomeModulo) {
        this.nomeModulo = nomeModulo;
    }
}

