/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.dbt.integracao.dao;

import br.com.bb.plugins.dbt.integracao.dao.GrupoClienteRecebimentoDAO;
import br.com.bb.plugins.gac.integracao.dao.HibernateDAO;
import br.com.bb.plugins.gac.negocio.to.ConvenioDebitoTOId;
import br.com.bb.plugins.gac.negocio.to.GrupoClienteRecebimentoTO;
import br.com.bb.plugins.gac.negocio.to.PaginadorTO;
import br.com.bb.plugins.gac.negocio.to.PluginTODecoratorAbstrato;
import br.com.bb.plugins.gac.negocio.to.decorator.GrupoClienteRecebimentoTODecorator;
import java.util.Collection;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GrupoClienteRecebimentoDAOImpl
extends HibernateDAO<GrupoClienteRecebimentoTO, Integer>
implements GrupoClienteRecebimentoDAO {
    protected Integer getChavePrimaria(GrupoClienteRecebimentoTO to) {
        return to.getCodigoGrupoClienteRecebimento();
    }

    protected Class<GrupoClienteRecebimentoTO> novoTipoDeObjetoPersistente() {
        return GrupoClienteRecebimentoTO.class;
    }

    @Override
    public PaginadorTO consultarPorConvenente(GrupoClienteRecebimentoTODecorator decorator) {
        Criteria query = this.novaCriteria();
        query.add(this.novoCriterioEQ("convenioDebitoTO.id.codigoPessoaConvenente", decorator.getCodigoPessoaConvenente()));
        return this.novoPaginadorTO(query, (PluginTODecoratorAbstrato)decorator);
    }

    @Override
    public Collection<GrupoClienteRecebimentoTO> consultarPorConvenioEConvenente(GrupoClienteRecebimentoTO to) {
        GrupoClienteRecebimentoTODecorator decorator = this.novoGrupoClienteRecebimentoTODecorator(to);
        Criteria query = this.novaCriteria();
        this.adicionarCriterioConsultarPorConvenio(query, decorator);
        return query.list();
    }

    @Override
    public boolean isExisteVinculacaoConvenio(ConvenioDebitoTOId id) {
        Criteria query = this.novaCriteria();
        this.adicionarCriteriaConsultarPeloConvenio(query, id);
        return !this.isVazio(query.list());
    }

    private void adicionarCriterioConsultarPorConvenio(Criteria query, GrupoClienteRecebimentoTODecorator decorator) {
        int numero = decorator.getConvenioDebitoTO().getConvenioTO().getId().getNumeroConvenio();
        int codigo = decorator.getConvenioDebitoTO().getConvenioTO().getConvenenteTO().getCodigoPessoaConvenente();
        if (!this.isZero(numero)) {
            Criteria convenioDeb = this.getCriteria(query, "convenioDebitoTO");
            Criteria cvn = this.getCriteria(convenioDeb, "convenioTO");
            cvn.add(this.novoCriterioEQ("id.numeroConvenio", numero));
            cvn.add(this.novoCriterioEQ("id.codigoPessoaConvenente", codigo));
        }
    }

    private GrupoClienteRecebimentoTODecorator novoGrupoClienteRecebimentoTODecorator(GrupoClienteRecebimentoTO to) {
        return this.getTOFactory().novoGrupoClienteRecebimentoTODecorator(to);
    }

    private void adicionarCriteriaConsultarPeloConvenio(Criteria query, ConvenioDebitoTOId id) {
        int convenente = id.getCodigoPessoaConvenente();
        String servico = id.getTextoIdentificadorServico();
        int convenio = id.getNumeroConvenio();
        if (!(this.isZero(convenente) || this.isZero(convenio) || this.isVazio(servico))) {
            query.add(this.novoCriterioEQ("convenioDebitoTO.id.codigoPessoaConvenente", convenente));
            query.add(this.novoCriterioEQ("convenioDebitoTO.id.textoIdentificadorServico", servico));
            query.add(this.novoCriterioEQ("convenioDebitoTO.id.numeroConvenio", convenio));
        }
    }

    @Override
    public Collection<GrupoClienteRecebimentoTO> consultarGrupoEDescricaoGrupo(GrupoClienteRecebimentoTO to) {
        Criteria query = this.novaCriteria();
        query.add(this.novoCriterioEQ("convenioDebitoTO.id.codigoPessoaConvenente", to.getConvenioDebitoTO().getId().getCodigoPessoaConvenente()));
        query.add(this.novoCriterioEQ("convenioDebitoTO.id.textoIdentificadorServico", to.getConvenioDebitoTO().getId().getTextoIdentificadorServico()));
        query.add(this.novoCriterioEQ("convenioDebitoTO.id.numeroConvenio", to.getConvenioDebitoTO().getConvenioTO().getId().getNumeroConvenio()));
        query.add(this.novoCriterioEQ("textoDescricao", to.getTextoDescricao()));
        return query.list();
    }

    @Override
    public Collection<GrupoClienteRecebimentoTO> consultarPorConvenioOuConvenente(GrupoClienteRecebimentoTO to) {
        GrupoClienteRecebimentoTODecorator decorator = this.novoGrupoClienteRecebimentoTODecorator(to);
        Criteria query = this.novaCriteria();
        this.adicionarCriterioConsultarPorConvenioOuConvenente(query, decorator);
        return query.list();
    }

    private void adicionarCriterioConsultarPorConvenioOuConvenente(Criteria query, GrupoClienteRecebimentoTODecorator decorator) {
        int numero = decorator.getConvenioDebitoTO().getConvenioTO().getId().getNumeroConvenio();
        int codigo = decorator.getConvenioDebitoTO().getConvenioTO().getConvenenteTO().getCodigoPessoaConvenente();
        Criteria convenioDeb = this.getCriteria(query, "convenioDebitoTO");
        Criteria cvn = this.getCriteria(convenioDeb, "convenioTO");
        if (!this.isZero(numero)) {
            cvn.add(this.novoCriterioEQ("id.numeroConvenio", numero));
        }
        cvn.add(this.novoCriterioEQ("id.codigoPessoaConvenente", codigo));
    }

    @Override
    public Collection<GrupoClienteRecebimentoTO> consultaPor(int codigoPessoaConvenente, String textoIdentificadorServico) {
        Criteria query = this.novaCriteria();
        Criterion criterionPessoaConvenente = this.novoCriterioEQ("convenioDebitoTO.id.codigoPessoaConvenente", codigoPessoaConvenente);
        Criterion criterionTextoIdentificadorServico = this.novoCriterioEQ("convenioDebitoTO.id.textoIdentificadorServico", textoIdentificadorServico);
        query.add((Criterion)Restrictions.and((Criterion)criterionPessoaConvenente, (Criterion)criterionTextoIdentificadorServico));
        return query.list();
    }

    @Override
    public void excluirPorConvenente(int codigoPessoaConvenente) {
        String hql = " delete GrupoClienteRecebimentoTO grupoClientRecebimento  where grupoClientRecebimento.convenioDebitoTO.id.codigoPessoaConvenente = :codigoPessoaConvenente ";
        Query query = this.novaQuery(hql);
        query.setInteger("codigoPessoaConvenente", codigoPessoaConvenente);
        query.executeUpdate();
    }
}

