/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.dbt.negocio.model;

import br.com.bb.plugins.dbt.integracao.dao.ConvenioDebitoDAO;
import br.com.bb.plugins.dbt.integracao.dao.GrupoClienteRecebimentoDAO;
import br.com.bb.plugins.dbt.integracao.dao.IdentificadorClienteDebitoDAO;
import br.com.bb.plugins.gac.integracao.dao.ConvenioDAO;
import br.com.bb.plugins.gac.integracao.dao.RemessaDAO;
import br.com.bb.plugins.gac.negocio.model.PluginModelAbstrato;
import br.com.bb.plugins.gac.negocio.to.ConvenioDebitoTO;
import br.com.bb.plugins.gac.negocio.to.ConvenioDebitoTOId;
import br.com.bb.plugins.gac.negocio.to.ConvenioTO;
import br.com.bb.plugins.gac.negocio.to.GrupoClienteRecebimentoTO;
import br.com.bb.plugins.gac.negocio.to.PaginadorTO;
import br.com.bb.plugins.gac.negocio.to.RemessaTO;
import br.com.bb.plugins.gac.negocio.to.RemessaTOId;
import br.com.bb.plugins.gac.negocio.to.decorator.ConvenioTODecorator;
import java.util.ArrayList;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManterConvenioModel
extends PluginModelAbstrato {
    private ConvenioDAO convenioDAO;
    private IdentificadorClienteDebitoDAO identificadorClienteDebitoDAO;
    private ConvenioDebitoDAO convenioDebitoDAO;
    private GrupoClienteRecebimentoDAO grupoClienteRecebimentoDAO;
    private RemessaDAO remessaDAO;

    public GrupoClienteRecebimentoDAO getGrupoClienteRecebimentoDAO() {
        return this.grupoClienteRecebimentoDAO;
    }

    public void setGrupoClienteRecebimentoDAO(GrupoClienteRecebimentoDAO grupoClienteRecebimentoDAO) {
        this.grupoClienteRecebimentoDAO = grupoClienteRecebimentoDAO;
    }

    public RemessaDAO getRemessaDAO() {
        return this.remessaDAO;
    }

    public void setRemessaDAO(RemessaDAO remessaDAO) {
        this.remessaDAO = remessaDAO;
    }

    public ConvenioDebitoDAO getConvenioDebitoDAO() {
        return this.convenioDebitoDAO;
    }

    public void setConvenioDebitoDAO(ConvenioDebitoDAO convenioDebitoDAO) {
        this.convenioDebitoDAO = convenioDebitoDAO;
    }

    public IdentificadorClienteDebitoDAO getIdentificadorClienteDebitoDAO() {
        return this.identificadorClienteDebitoDAO;
    }

    public void setIdentificadorClienteDebitoDAO(IdentificadorClienteDebitoDAO identificadorClienteDebitoDAO) {
        this.identificadorClienteDebitoDAO = identificadorClienteDebitoDAO;
    }

    public ConvenioDAO getConvenioDAO() {
        return this.convenioDAO;
    }

    public void setConvenioDAO(ConvenioDAO convenioDAO) {
        this.convenioDAO = convenioDAO;
    }

    public PaginadorTO listar(ConvenioTODecorator convenioTODecorator) {
        convenioTODecorator.getServicoTO().setTextoIdentificadorServico("DBT");
        return this.getConvenioDAO().consultarPorConvenenteServico(convenioTODecorator);
    }

    public void alterar(ConvenioTODecorator convenioTODecorator) {
        convenioTODecorator.getServicoTO().setTextoIdentificadorServico("DBT");
        this.getConvenioDAO().alterarPorCodigoPessoaENumeroConvenio(convenioTODecorator.getConvenioTO());
    }

    public boolean delete(ConvenioTODecorator to) {
        boolean exclui;
        boolean existeConvenioClienteDebito = this.getIdentificadorClienteDebitoDAO().isExisteConvenio(to.getConvenioTO());
        RemessaTOId id = this.getFabricaDeTO().novoRemessaTOId();
        id.setCodigoPessoaConvenente(to.getCodigoPessoaConvenente().intValue());
        id.setNumeroConvenio(to.getNumeroConvenio().intValue());
        id.setTextoIdentificadorServico(to.getTextoIdentificadorServico());
        RemessaTO remessaTO = this.getFabricaDeTO().novoRemessaTO();
        remessaTO.setId(id);
        remessaTO.setConvenioTO(to.getConvenioTO());
        boolean existeConvenioRemessa = this.getRemessaDAO().isExisteRemessaVinculadaConvenio(remessaTO);
        GrupoClienteRecebimentoTO grupoClienteRecebimentoTO = this.getFabricaDeTO().novoGrupoClienteRecebimentoTO();
        ConvenioDebitoTO convenioDebitoTO = this.getFabricaDeTO().novoConvenioDebitoTO();
        ConvenioDebitoTOId convenioDebitoTOId = this.getFabricaDeTO().novoConvenioDebitoTOId();
        convenioDebitoTOId.setCodigoPessoaConvenente(to.getCodigoPessoaConvenente());
        convenioDebitoTOId.setNumeroConvenio(to.getNumeroConvenio());
        convenioDebitoTOId.setTextoIdentificadorServico(to.getTextoIdentificadorServico());
        convenioDebitoTO.setId(convenioDebitoTOId);
        grupoClienteRecebimentoTO.setConvenioDebitoTO(convenioDebitoTO);
        boolean existeGrupoClienteRecebimento = this.getGrupoClienteRecebimentoDAO().isExisteVinculacaoConvenio(convenioDebitoTOId);
        boolean bl = exclui = !existeConvenioClienteDebito && !existeConvenioRemessa && !existeGrupoClienteRecebimento;
        if (exclui) {
            ConvenioDebitoTOId convenioDebitoId = this.getFabricaDeTO().novoConvenioDebitoTOId();
            convenioDebitoId.setCodigoPessoaConvenente(to.getCodigoPessoaConvenente());
            convenioDebitoId.setNumeroConvenio(to.getNumeroConvenio());
            convenioDebitoId.setTextoIdentificadorServico(to.getTextoIdentificadorServico());
            this.getConvenioDebitoDAO().excluirPorConvenio(convenioDebitoId);
            this.getConvenioDAO().excluirPorCodigoPessoaENumeroConvenio(to.getConvenioTO());
        }
        return exclui;
    }

    public Collection<String> restricoesExcluir(ConvenioTODecorator to) {
        ArrayList<String> restricoes = new ArrayList<String>();
        if (this.getIdentificadorClienteDebitoDAO().isExisteConvenio(to.getConvenioTO())) {
            restricoes.add("Existe(m) Lan\u00e7amento(s) vinculado(s) ao Conv\u00eanio.");
        }
        RemessaTOId id = this.getFabricaDeTO().novoRemessaTOId();
        id.setCodigoPessoaConvenente(to.getCodigoPessoaConvenente().intValue());
        id.setNumeroConvenio(to.getNumeroConvenio().intValue());
        id.setTextoIdentificadorServico(to.getTextoIdentificadorServico());
        RemessaTO remessaTO = this.getFabricaDeTO().novoRemessaTO();
        remessaTO.setId(id);
        remessaTO.setConvenioTO(to.getConvenioTO());
        if (this.getRemessaDAO().isExisteRemessaVinculadaConvenio(remessaTO)) {
            restricoes.add("Existe(m) Remessa(s) vinculada(s) ao Conv\u00eanio.");
        }
        GrupoClienteRecebimentoTO grupoClienteRecebimentoTO = this.getFabricaDeTO().novoGrupoClienteRecebimentoTO();
        ConvenioDebitoTO convenioDebitoTO = this.getFabricaDeTO().novoConvenioDebitoTO();
        ConvenioDebitoTOId convenioDebitoTOId = this.getFabricaDeTO().novoConvenioDebitoTOId();
        convenioDebitoTOId.setCodigoPessoaConvenente(to.getCodigoPessoaConvenente());
        convenioDebitoTOId.setNumeroConvenio(to.getNumeroConvenio());
        convenioDebitoTOId.setTextoIdentificadorServico(to.getTextoIdentificadorServico());
        convenioDebitoTO.setId(convenioDebitoTOId);
        grupoClienteRecebimentoTO.setConvenioDebitoTO(convenioDebitoTO);
        if (this.getGrupoClienteRecebimentoDAO().isExisteVinculacaoConvenio(convenioDebitoTOId)) {
            restricoes.add("Existe(m) Grupo(s) Recebimento(s) vinculado(s) ao Conv\u00eanio.");
        }
        return restricoes;
    }

    public void excluir(ConvenioTODecorator to) {
        ConvenioDebitoTOId convenioDebitoId = this.getFabricaDeTO().novoConvenioDebitoTOId();
        convenioDebitoId.setCodigoPessoaConvenente(to.getCodigoPessoaConvenente());
        convenioDebitoId.setNumeroConvenio(to.getNumeroConvenio());
        convenioDebitoId.setTextoIdentificadorServico(to.getTextoIdentificadorServico());
        this.getConvenioDebitoDAO().excluirPorConvenio(convenioDebitoId);
        this.getConvenioDAO().excluirPorCodigoPessoaENumeroConvenio(to.getConvenioTO());
    }

    public ConvenioDebitoTO obtemConvenioDebitoPor(ConvenioTO convenioTO) {
        return this.getConvenioDebitoDAO().consultar(convenioTO.getNumeroConvenio(), convenioTO.getId().getTextoIdentificadorServico());
    }

    public void salvarTipoLayout(ConvenioDebitoTO convenioDebitoTO) {
        this.getConvenioDebitoDAO().alterar(convenioDebitoTO);
    }

    public void alterarTipoLayout(int tipoLayout, int numeroConvenio) {
        this.getConvenioDebitoDAO().alterarTipoLayout(tipoLayout, numeroConvenio);
    }
}

