/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.dbt.negocio.model;

import br.com.bb.plugins.dbt.integracao.dao.ConvenioDebitoDAO;
import br.com.bb.plugins.dbt.integracao.dao.IdentificadorClienteDebitoDAO;
import br.com.bb.plugins.dbt.integracao.dao.RecebimentoDebitoDAO;
import br.com.bb.plugins.dbt.integracao.dao.SituacaoRecebimentoDAO;
import br.com.bb.plugins.dbt.negocio.to.decorator.RecebimentoDebitoTODecorator;
import br.com.bb.plugins.gac.excecao.BBException;
import br.com.bb.plugins.gac.factory.TOFactory;
import br.com.bb.plugins.gac.integracao.dao.ContaCorrenteClienteDAO;
import br.com.bb.plugins.gac.integracao.dao.ConvenentePessoaDAO;
import br.com.bb.plugins.gac.integracao.dao.IdentificacaoDAO;
import br.com.bb.plugins.gac.integracao.dao.PessoaDAO;
import br.com.bb.plugins.gac.negocio.model.PluginModelAbstrato;
import br.com.bb.plugins.gac.negocio.to.ContaCorrenteClienteTO;
import br.com.bb.plugins.gac.negocio.to.ConvenentePessoaTO;
import br.com.bb.plugins.gac.negocio.to.ConvenenteTO;
import br.com.bb.plugins.gac.negocio.to.ConvenioTO;
import br.com.bb.plugins.gac.negocio.to.GrupoClienteRecebimentoTO;
import br.com.bb.plugins.gac.negocio.to.IdentificacaoTO;
import br.com.bb.plugins.gac.negocio.to.IdentificadorClienteDebitoTO;
import br.com.bb.plugins.gac.negocio.to.PaginadorTO;
import br.com.bb.plugins.gac.negocio.to.PessoaTO;
import br.com.bb.plugins.gac.negocio.to.RecebimentoDebitoTO;
import br.com.bb.plugins.gac.negocio.to.SituacaoRecebimentoTO;
import java.math.BigDecimal;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManterRecebimentoModel
extends PluginModelAbstrato {
    private RecebimentoDebitoDAO recebimentoDebitoDAO;
    private IdentificadorClienteDebitoDAO clienteDebitoDAO;
    private ConvenentePessoaDAO convenentePessoaDAO;
    private SituacaoRecebimentoDAO situacaoRecebimentoDAO;
    private ConvenioDebitoDAO convenioDebitoDAO;
    private ContaCorrenteClienteDAO contaCorrenteClienteDAO;
    private IdentificacaoDAO identificacaoDAO;
    private PessoaDAO pessoaDAO;

    public PaginadorTO consultar(RecebimentoDebitoTODecorator recebimentoTODecorator) {
        PaginadorTO paginadorTO = this.getRecebimentoDebitoDAO().consultarPorFiltro(recebimentoTODecorator);
        return paginadorTO;
    }

    public Collection<RecebimentoDebitoTO> consultarPorFiltroSemPaginacaoImpressao(RecebimentoDebitoTODecorator decorator) {
        return this.getRecebimentoDebitoDAO().consultarPorFiltroSemPaginacaoImpressao(decorator);
    }

    public Collection<RecebimentoDebitoTO> listarPorFiltro(RecebimentoDebitoTODecorator decorator) {
        return this.getRecebimentoDebitoDAO().listarPorFiltro(decorator);
    }

    public RecebimentoDebitoDAO getRecebimentoDebitoDAO() {
        return this.recebimentoDebitoDAO;
    }

    public void setRecebimentoDebitoDAO(RecebimentoDebitoDAO recebimentoDebitoDAO) {
        this.recebimentoDebitoDAO = recebimentoDebitoDAO;
    }

    public ConvenentePessoaDAO getConvenentePessoaDAO() {
        return this.convenentePessoaDAO;
    }

    public void setConvenentePessoaDAO(ConvenentePessoaDAO convenentePessoaDAO) {
        this.convenentePessoaDAO = convenentePessoaDAO;
    }

    public SituacaoRecebimentoDAO getSituacaoRecebimentoDAO() {
        return this.situacaoRecebimentoDAO;
    }

    public void setSituacaoRecebimentoDAO(SituacaoRecebimentoDAO situacaoRecebimentoDAO) {
        this.situacaoRecebimentoDAO = situacaoRecebimentoDAO;
    }

    public ConvenioDebitoDAO getConvenioDebitoDAO() {
        return this.convenioDebitoDAO;
    }

    public void setConvenioDebitoDAO(ConvenioDebitoDAO convenioDebitoDAO) {
        this.convenioDebitoDAO = convenioDebitoDAO;
    }

    public ContaCorrenteClienteDAO getContaCorrenteClienteDAO() {
        return this.contaCorrenteClienteDAO;
    }

    public void setContaCorrenteClienteDAO(ContaCorrenteClienteDAO contaCorrenteClienteDAO) {
        this.contaCorrenteClienteDAO = contaCorrenteClienteDAO;
    }

    public IdentificacaoDAO getIdentificacaoDAO() {
        return this.identificacaoDAO;
    }

    public void setIdentificacaoDAO(IdentificacaoDAO identificacaoDAO) {
        this.identificacaoDAO = identificacaoDAO;
    }

    public void alterar(RecebimentoDebitoTODecorator recebimentoSelecionado) {
        if (recebimentoSelecionado.getSituacaoRecebimentoTO().getCodigoSituacaoRecebimento().equals(Character.valueOf('O'))) {
            SituacaoRecebimentoTO situacaoTO = TOFactory.getInstancia().novoSituacaoRecebimentoTO();
            situacaoTO.setCodigoSituacaoRecebimento(Character.valueOf('G'));
            recebimentoSelecionado.setSituacaoRecebimentoTO(situacaoTO);
            recebimentoSelecionado.getRecebimentoDebitoTO().setTipoOcorrenciaRecebimentoDebitoTO(null);
            recebimentoSelecionado.getRecebimentoDebitoTO().setRemessaTO(null);
            recebimentoSelecionado.getRecebimentoDebitoTO().setDataRemessa(null);
        }
        this.getRecebimentoDebitoDAO().incluirOuAlterar(recebimentoSelecionado.getRecebimentoDebitoTO());
    }

    public void excluir(RecebimentoDebitoTODecorator recebimentoSelecionado) {
        this.getRecebimentoDebitoDAO().excluir(recebimentoSelecionado.getRecebimentoDebitoTO());
    }

    public Collection<IdentificadorClienteDebitoTO> consultarListaIdentificacaoDebito(PessoaTO pessoaTO, ConvenioTO convenio) {
        return this.getClienteDebitoDAO().listarIdentificadorClienteDebitoPelaPessoaEConvenio(pessoaTO, convenio);
    }

    public IdentificadorClienteDebitoDAO getClienteDebitoDAO() {
        return this.clienteDebitoDAO;
    }

    public void setClienteDebitoDAO(IdentificadorClienteDebitoDAO clienteDebitoDAO) {
        this.clienteDebitoDAO = clienteDebitoDAO;
    }

    public void incluir(RecebimentoDebitoTO recebimentoTO) {
        SituacaoRecebimentoTO situacaoTO = TOFactory.getInstancia().novoSituacaoRecebimentoTO();
        situacaoTO.setCodigoSituacaoRecebimento(Character.valueOf('G'));
        recebimentoTO.setSituacaoRecebimentoTO(situacaoTO);
        this.getRecebimentoDebitoDAO().incluir(recebimentoTO);
    }

    public Collection<ConvenentePessoaTO> consultarListaPessoasDoConvenente(ConvenenteTO convenenteTO, GrupoClienteRecebimentoTO grupoClienteRecebimentoTO, String textoIdentificadorServico) {
        return this.getConvenentePessoaDAO().consultarPorConvenente(convenenteTO, grupoClienteRecebimentoTO, textoIdentificadorServico);
    }

    public PessoaTO consultarPessoaPelaIdentificacao(String textoIdentificadorDebito) {
        PessoaTO pessoaTO = null;
        IdentificadorClienteDebitoTO to = this.getClienteDebitoDAO().listarPeloIdentificador(textoIdentificadorDebito);
        if (to != null) {
            pessoaTO = to.getPessoaTO();
        }
        return pessoaTO;
    }

    public PessoaTO consultarPessoaPelaContaCorrente(Integer instituicao, Integer agencia, Long conta) {
        ContaCorrenteClienteTO contaTO = null;
        PessoaTO pessoaTO = null;
        contaTO = this.getContaCorrenteClienteDAO().consultar(instituicao, agencia, conta);
        if (contaTO != null) {
            pessoaTO = contaTO.getPessoaTO();
        }
        return pessoaTO;
    }

    public PessoaTO consultarPessoaPorIdProprioEConvenente(String textoIdentificadorProprio, ConvenenteTO convenenteTO) {
        PessoaTO pessoaTO = null;
        IdentificacaoTO identificacaoTO = null;
        identificacaoTO = this.getIdentificacaoDAO().consultarIdentificacaoPorIdProprioEConvenente(textoIdentificadorProprio, convenenteTO);
        if (identificacaoTO != null) {
            pessoaTO = identificacaoTO.getPessoaTO();
        }
        return pessoaTO;
    }

    public BigDecimal totalizarRecebimentos(RecebimentoDebitoTODecorator decorator) throws BBException {
        return this.getRecebimentoDebitoDAO().totalizarValorRecebimentoPorFiltro(decorator);
    }

    public Collection<IdentificadorClienteDebitoTO> consultarListaIdentificacaoDebito(GrupoClienteRecebimentoTO grupoClienteRecebimentoTO, ConvenioTO convenioTO) {
        return this.getClienteDebitoDAO().listarIdentificadorClienteDebitoPorConvenioEGrupo(convenioTO, grupoClienteRecebimentoTO);
    }

    public PessoaDAO getPessoaDAO() {
        return this.pessoaDAO;
    }

    public void setPessoaDAO(PessoaDAO pessoaDAO) {
        this.pessoaDAO = pessoaDAO;
    }
}

