/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.dbt.negocio.model;

import br.com.bb.plugins.dbt.integracao.dao.ConvenioDebitoDAO;
import br.com.bb.plugins.dbt.integracao.dao.IdentificadorClienteDebitoDAO;
import br.com.bb.plugins.dbt.integracao.dao.RecebimentoDebitoDAO;
import br.com.bb.plugins.dbt.integracao.dao.SituacaoRecebimentoDAO;
import br.com.bb.plugins.dbt.integracao.dao.TipoOcorrenciaRecebimentoDebitoDAO;
import br.com.bb.plugins.dbt.negocio.model.ManterDadosDeDebitoModel;
import br.com.bb.plugins.gac.excecao.BBException;
import br.com.bb.plugins.gac.factory.ArquivoFactory;
import br.com.bb.plugins.gac.integracao.dao.AgenciaInstituicaoFinanceiraDAO;
import br.com.bb.plugins.gac.integracao.dao.ContaCorrenteClienteDAO;
import br.com.bb.plugins.gac.integracao.dao.ConvenioDAO;
import br.com.bb.plugins.gac.integracao.dao.InstituicaoFinanceiraDAO;
import br.com.bb.plugins.gac.integracao.dao.PessoaDAO;
import br.com.bb.plugins.gac.integracao.dao.ServicoDAO;
import br.com.bb.plugins.gac.negocio.model.PluginModelAbstrato;
import br.com.bb.plugins.gac.negocio.to.AgenciaInstituicaoFinanceiraTO;
import br.com.bb.plugins.gac.negocio.to.AgenciaInstituicaoFinanceiraTOId;
import br.com.bb.plugins.gac.negocio.to.ContaCorrenteClienteTO;
import br.com.bb.plugins.gac.negocio.to.ContaCorrenteClienteTOId;
import br.com.bb.plugins.gac.negocio.to.ConvenenteTO;
import br.com.bb.plugins.gac.negocio.to.ConvenioDebitoTO;
import br.com.bb.plugins.gac.negocio.to.ConvenioDebitoTOId;
import br.com.bb.plugins.gac.negocio.to.ConvenioTO;
import br.com.bb.plugins.gac.negocio.to.ConvenioTOId;
import br.com.bb.plugins.gac.negocio.to.IdentificadorClienteDebitoTO;
import br.com.bb.plugins.gac.negocio.to.InstituicaoFinanceiraTO;
import br.com.bb.plugins.gac.negocio.to.LancamentoTO;
import br.com.bb.plugins.gac.negocio.to.LancamentosArquivoTO;
import br.com.bb.plugins.gac.negocio.to.PessoaTO;
import br.com.bb.plugins.gac.negocio.to.RecebimentoDebitoTO;
import br.com.bb.plugins.gac.negocio.to.RemessaTO;
import br.com.bb.plugins.gac.negocio.to.ServicoTO;
import br.com.bb.plugins.gac.negocio.to.SituacaoRecebimentoTO;
import br.com.bb.plugins.gac.negocio.to.TipoOcorrenciaRecebimentoDebitoTO;
import br.com.bb.plugins.gac.negocio.to.TipoOcorrenciaRecebimentoDebitoTOId;
import br.com.bb.plugins.gac.negocio.to.TipoPessoaTO;
import br.com.bb.plugins.gac.negocio.to.decorator.AgenciaInstituicaoFinanceiraTODecorator;
import br.com.bb.plugins.gac.negocio.to.decorator.ConvenioTODecorator;
import br.com.bb.plugins.gac.negocio.to.decorator.IdentificadorClienteDebitoTODecorator;
import br.com.bb.plugins.gac.negocio.to.decorator.RetornoTODecorator;
import br.com.bb.plugins.gac.util.CalculaDigitoVerificador;
import br.com.bb.plugins.gac.util.UtilArquivoConfiguracao;
import br.com.bb.plugins.gac.util.UtilBBException;
import br.com.bb.plugins.gac.util.UtilNotificador;
import br.com.bb.plugins.gac.util.parserarquivo.IParserArquivo;
import br.com.bb.plugins.gac.util.parserarquivo.IParserArquivoFactory;
import br.com.bb.plugins.gac.util.parserarquivo.ParserArquivoFactory;
import br.com.politec.generico.colecao.UtilColecao;
import br.com.politec.generico.conversor.UtilConversorDeInteger;
import br.com.politec.generico.conversor.UtilConversorDeString;
import br.com.politec.generico.string.UtilString;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessarArquivosRetornosModel2
extends PluginModelAbstrato {
    private ConvenioDebitoDAO convenioDebitoDAO;
    private IdentificadorClienteDebitoDAO identificadorClienteDebitoDAO;
    private ContaCorrenteClienteDAO contaCorrenteClienteDAO;
    private RecebimentoDebitoDAO recebimentoDebitoDAO;
    private TipoOcorrenciaRecebimentoDebitoDAO tipoOcorrenciaRecebimentoDebitoDAO;
    private SituacaoRecebimentoDAO situacaoRecebimentoDAO;
    private AgenciaInstituicaoFinanceiraDAO agenciaInstituicaoFinanceiraDAO;
    private InstituicaoFinanceiraDAO instituicaoFinanceiraDAO;
    private PessoaDAO pessoaDAO;
    private ConvenioDAO convenioDAO;
    private ServicoDAO servicoDAO;
    private IParserArquivo parser;
    private ConvenioTO convenioTO;
    private ConvenioDebitoTO convenioDebitoTO;
    private ConvenenteTO convenenteTO;
    private ContaCorrenteClienteTO contaCorrenteClienteTO;
    private AgenciaInstituicaoFinanceiraTO agenciaInstituicaoFinanceiraTO;
    private PessoaTO pessoaTO;
    ManterDadosDeDebitoModel manterDadosDeDebitoModel;

    public PessoaTO getPessoaTO() {
        return this.pessoaTO;
    }

    public void setPessoaTO(PessoaTO pessoaTO) {
        this.pessoaTO = pessoaTO;
    }

    public AgenciaInstituicaoFinanceiraTO getAgenciaInstituicaoFinanceiraTO() {
        return this.agenciaInstituicaoFinanceiraTO;
    }

    public void setAgenciaInstituicaoFinanceiraTO(AgenciaInstituicaoFinanceiraTO agenciaInstituicaoFinanceiraTO) {
        this.agenciaInstituicaoFinanceiraTO = agenciaInstituicaoFinanceiraTO;
    }

    public ManterDadosDeDebitoModel getManterDadosDeDebitoModel() {
        return this.manterDadosDeDebitoModel;
    }

    public void setManterDadosDeDebitoModel(ManterDadosDeDebitoModel manterDadosDeDebitoModel) {
        this.manterDadosDeDebitoModel = manterDadosDeDebitoModel;
    }

    public RecebimentoDebitoDAO getRecebimentoDebitoDAO() {
        return this.recebimentoDebitoDAO;
    }

    public void setRecebimentoDebitoDAO(RecebimentoDebitoDAO recebimentoDebitoDAO) {
        this.recebimentoDebitoDAO = recebimentoDebitoDAO;
    }

    public ContaCorrenteClienteDAO getContaCorrenteClienteDAO() {
        return this.contaCorrenteClienteDAO;
    }

    public void setContaCorrenteClienteDAO(ContaCorrenteClienteDAO contaCorrenteClienteDAO) {
        this.contaCorrenteClienteDAO = contaCorrenteClienteDAO;
    }

    public IdentificadorClienteDebitoDAO getIdentificadorClienteDebitoDAO() {
        return this.identificadorClienteDebitoDAO;
    }

    public void setIdentificadorClienteDebitoDAO(IdentificadorClienteDebitoDAO identificadorClienteDebitoDAO) {
        this.identificadorClienteDebitoDAO = identificadorClienteDebitoDAO;
    }

    public PessoaDAO getPessoaDAO() {
        return this.pessoaDAO;
    }

    public void setPessoaDAO(PessoaDAO pessoaDAO) {
        this.pessoaDAO = pessoaDAO;
    }

    public ConvenioDebitoDAO getConvenioDebitoDAO() {
        return this.convenioDebitoDAO;
    }

    public void setConvenioDebitoDAO(ConvenioDebitoDAO convenioDebitoDAO) {
        this.convenioDebitoDAO = convenioDebitoDAO;
    }

    public TipoOcorrenciaRecebimentoDebitoDAO getTipoOcorrenciaRecebimentoDebitoDAO() {
        return this.tipoOcorrenciaRecebimentoDebitoDAO;
    }

    public void setTipoOcorrenciaRecebimentoDebitoDAO(TipoOcorrenciaRecebimentoDebitoDAO tipoOcorrenciaRecebimentoDebitoDAO) {
        this.tipoOcorrenciaRecebimentoDebitoDAO = tipoOcorrenciaRecebimentoDebitoDAO;
    }

    public SituacaoRecebimentoDAO getSituacaoRecebimentoDAO() {
        return this.situacaoRecebimentoDAO;
    }

    public void setSituacaoRecebimentoDAO(SituacaoRecebimentoDAO situacaoRecebimentoDAO) {
        this.situacaoRecebimentoDAO = situacaoRecebimentoDAO;
    }

    public AgenciaInstituicaoFinanceiraDAO getAgenciaInstituicaoFinanceiraDAO() {
        return this.agenciaInstituicaoFinanceiraDAO;
    }

    public void setAgenciaInstituicaoFinanceiraDAO(AgenciaInstituicaoFinanceiraDAO agenciaInstituicaoFinanceiraDAO) {
        this.agenciaInstituicaoFinanceiraDAO = agenciaInstituicaoFinanceiraDAO;
    }

    public InstituicaoFinanceiraDAO getInstituicaoFinanceiraDAO() {
        return this.instituicaoFinanceiraDAO;
    }

    public void setInstituicaoFinanceiraDAO(InstituicaoFinanceiraDAO instituicaoFinanceiraDAO) {
        this.instituicaoFinanceiraDAO = instituicaoFinanceiraDAO;
    }

    public ConvenioDAO getConvenioDAO() {
        return this.convenioDAO;
    }

    public void setConvenioDAO(ConvenioDAO convenioDAO) {
        this.convenioDAO = convenioDAO;
    }

    public ServicoDAO getServicoDAO() {
        return this.servicoDAO;
    }

    public void setServicoDAO(ServicoDAO servicoDAO) {
        this.servicoDAO = servicoDAO;
    }

    public Collection<RetornoTODecorator> recuperaArquivosRetorno(ConvenenteTO convenenteTO) throws BBException {
        IParserArquivoFactory factory = ParserArquivoFactory.getInstancia();
        File[] arquivos = this.recuperaArquivosDeRetorno();
        List colecaoRetornos = this.getColecaoFactory().novoArrayList();
        Collection<ConvenioTO> listaConveniosConvenente = this.getListaConveniosConvenente(convenenteTO);
        if (arquivos == null) {
            return colecaoRetornos;
        }
        File[] fileArray = arquivos;
        int n = arquivos.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            IParserArquivo parser = factory.novoParserArquivo(file);
            if (this.verificaConvenio(parser.getValorDoCabecalhoString("Convenio"), listaConveniosConvenente)) {
                colecaoRetornos.add(this.preencherRetornoTO(parser, file));
            }
            ++n2;
        }
        return colecaoRetornos;
    }

    private Collection<ConvenioTO> getListaConveniosConvenente(ConvenenteTO convenenteTO) {
        ConvenioTO convenio = this.getFabricaDeTO().novoConvenioTO();
        convenio.setConvenenteTO(convenenteTO);
        convenio.getServicoTO().setTextoIdentificadorServico("DBT");
        return this.getConvenioDAO().consultarPorConvenenteServico(convenio);
    }

    public Collection<LancamentosArquivoTO> processarArquivosRetornos(Collection<RetornoTODecorator> colecaoRetornos, ConvenenteTO convenenteTO, UtilNotificador utilNotificador) throws BBException {
        File arquivoRetorno;
        ArrayList<LancamentosArquivoTO> lancamentoArquivo = new ArrayList<LancamentosArquivoTO>();
        IParserArquivoFactory factory = ParserArquivoFactory.getInstancia();
        int totalGeralRegistros = 0;
        for (RetornoTODecorator retornoTODecorator : colecaoRetornos) {
            arquivoRetorno = this.recuperaArquivoRetorno(retornoTODecorator);
            if (!this.isReferencia(arquivoRetorno)) continue;
            this.setParser(factory.novoParserArquivo(arquivoRetorno));
            totalGeralRegistros += this.getTotalDeRegistros();
        }
        int registroProcessados = 0;
        for (RetornoTODecorator retornoTODecorator : colecaoRetornos) {
            arquivoRetorno = this.recuperaArquivoRetorno(retornoTODecorator);
            if (this.isReferencia(arquivoRetorno)) {
                this.setParser(factory.novoParserArquivo(arquivoRetorno));
                ArrayList<LancamentoTO> lancamentos = new ArrayList<LancamentoTO>();
                LancamentosArquivoTO lancamentoArquivoTO = new LancamentosArquivoTO();
                lancamentoArquivoTO.setNomeArquivo(this.getNomeArquivo(arquivoRetorno));
                lancamentoArquivoTO.setConvenio(this.getConvenioArquivo());
                lancamentoArquivoTO.setNumeroRetorno(this.getNumeroRetorno());
                lancamentoArquivoTO.setDataRetorno(this.getDataArquivo());
                lancamentoArquivoTO.setTipoRegistro("LAN\u00c7AMENTO COM OCORR\u00caNCIA");
                lancamentoArquivoTO.setListaLancamentoTO(lancamentos);
                lancamentoArquivo.add(lancamentoArquivoTO);
                int totalRegistros = this.getTotalDeRegistros();
                int indice = 0;
                while (indice < totalRegistros) {
                    this.setContaCorrenteClienteTO(null);
                    if (this.isRegistroTipoB(indice)) {
                        this.processarRegistroTipoB(convenenteTO, lancamentos, indice);
                    } else if (this.isRegistroTipoF(indice)) {
                        this.processarRegistroTipoF(lancamentos, indice);
                    } else if (this.isRegistroTipoH(indice)) {
                        this.processarRegistroTipoH(lancamentos, indice);
                    }
                    this.atualizaPorcentagem(utilNotificador, totalGeralRegistros, ++registroProcessados);
                    ++indice;
                }
            }
            this.moverArquivoRetornoProcessado(arquivoRetorno);
        }
        return lancamentoArquivo;
    }

    private void atualizaPorcentagem(UtilNotificador notificaImportacao, int totalRegistros, int numeroLinha) {
        int porcentagem = numeroLinha * 100 / totalRegistros;
        notificaImportacao.notifyObservers((Object)porcentagem);
    }

    private void processarRegistroTipoH(List<LancamentoTO> lancamentos, int indice) throws BBException {
        IdentificadorClienteDebitoTO recDebitoAnt = this.consultarIdentificadorClienteDebitoAnterior(indice);
        IdentificadorClienteDebitoTO recDebitoAtual = this.consultarIdentificadorClienteDebitoAtual(indice);
        if (this.getCodigoMovimentoArquivo(indice).equals(0)) {
            if (!this.getValorStringArquivo(indice, "IdDbtAnt").equals("")) {
                this.atualizaCodigoSituacaoIdentificadorDebito(recDebitoAnt, 'I');
                this.atualizaCodigoSituacaoIdentificadorDebito(recDebitoAtual, 'A');
                this.gerarLancamento(recDebitoAtual.getContaCorrenteClienteTO().getPessoaTO().getTextoNome(), recDebitoAtual.getTextoIdentificadorDebito(), "Banco do Brasil", recDebitoAtual.getAgenciaInstituicaoFinanceiraTO().getCodigoAgencia() + "-" + recDebitoAtual.getAgenciaInstituicaoFinanceiraTO().getDigitoVerificadorAgencia(), recDebitoAtual.getContaCorrenteClienteTO().getId().getCodigoContaCorrente() + "-" + recDebitoAtual.getContaCorrenteClienteTO().getDigitoVerificadorContaCorrente(), this.getParser().getValorDoCabecalhoDate("DataArq"), 0.0, "Ativo", recDebitoAtual.getTextoDescricaoOcorrencia(), lancamentos);
            }
        } else if (this.isReferencia(recDebitoAnt)) {
            this.atualizaCodigoSituacaoIdentificadorDebito(recDebitoAnt, 'A');
            this.atualizaCodigoSituacaoIdentificadorDebito(recDebitoAtual, 'O');
            this.gerarLancamento(recDebitoAtual.getContaCorrenteClienteTO().getPessoaTO().getTextoNome(), recDebitoAtual.getTextoIdentificadorDebito(), "Banco do Brasil", recDebitoAtual.getAgenciaInstituicaoFinanceiraTO().getCodigoAgencia() + "-" + recDebitoAtual.getAgenciaInstituicaoFinanceiraTO().getDigitoVerificadorAgencia(), recDebitoAtual.getContaCorrenteClienteTO().getId().getCodigoContaCorrente() + "-" + recDebitoAtual.getContaCorrenteClienteTO().getDigitoVerificadorContaCorrente(), this.getParser().getValorDoCabecalhoDate("DataArq"), 0.0, "Altera\u00e7\u00e3o de Identifica\u00e7\u00e3o de d\u00e9bito n\u00e3o processada no BB. Registro importado com sucesso na aplicativo", "N\u00c3O CADASTRADA NO BB", lancamentos);
        }
    }

    private void processarRegistroTipoF(List<LancamentoTO> lancamentos, int indice) throws BBException {
        RecebimentoDebitoTO recDebTO = this.consultarRecebimentoPeloTxIdeReg(this.getIdRecebimentoArquivo(indice));
        if (!this.isReferencia(recDebTO)) {
            this.gerarLancamento("", this.getValorStringArquivo(indice, "IdDbt"), "Banco do Brasil", recDebTO.getIdentificadorClienteDebitoTO().getAgenciaInstituicaoFinanceiraTO().getCodigoAgencia() + "-" + recDebTO.getIdentificadorClienteDebitoTO().getAgenciaInstituicaoFinanceiraTO().getDigitoVerificadorAgencia(), recDebTO.getIdentificadorClienteDebitoTO().getContaCorrenteClienteTO().getId().getCodigoAgencia() + "-" + recDebTO.getIdentificadorClienteDebitoTO().getContaCorrenteClienteTO().getDigitoVerificadorContaCorrente(), this.getValorDateArquivo(indice, "DataOpcao"), this.getValorDoubleArquivo(indice, "ValorDBT"), "", "Recebimento n\u00e3o cadastrado.", lancamentos);
        } else if (UtilConversorDeString.converterParaInt((String)this.getValorStringArquivo(indice, "CodRet")) == 0 || UtilConversorDeString.converterParaInt((String)this.getValorStringArquivo(indice, "CodRet")) == 31) {
            this.atualizaRecebimentoDebito(recDebTO, 'D', indice);
            String descricaoOcorrencia = recDebTO.getTipoOcorrenciaRecebimentoDebitoTO() == null ? "" : recDebTO.getTipoOcorrenciaRecebimentoDebitoTO().getTextoDescricao();
            this.gerarLancamento(recDebTO.getIdentificadorClienteDebitoTO().getContaCorrenteClienteTO().getPessoaTO().getTextoNome(), this.getValorStringArquivo(indice, "IdDbt"), "Banco do Brasil", recDebTO.getIdentificadorClienteDebitoTO().getAgenciaInstituicaoFinanceiraTO().getCodigoAgencia() + "-" + recDebTO.getIdentificadorClienteDebitoTO().getAgenciaInstituicaoFinanceiraTO().getDigitoVerificadorAgencia(), recDebTO.getIdentificadorClienteDebitoTO().getContaCorrenteClienteTO().getId().getCodigoAgencia() + "-" + recDebTO.getIdentificadorClienteDebitoTO().getContaCorrenteClienteTO().getDigitoVerificadorContaCorrente(), this.getValorDateArquivo(indice, "DataOpcao"), this.getValorDoubleArquivo(indice, "ValorDBT"), "D\u00e9bito efetuado", descricaoOcorrencia, lancamentos);
        } else {
            this.atualizaCodigoSituacaoRecebimento(recDebTO, 'O', indice);
            String descricaoOcorrencia = recDebTO.getTipoOcorrenciaRecebimentoDebitoTO() == null ? "" : recDebTO.getTipoOcorrenciaRecebimentoDebitoTO().getTextoDescricao();
            this.gerarLancamento(recDebTO.getIdentificadorClienteDebitoTO().getContaCorrenteClienteTO().getPessoaTO().getTextoNome(), this.getValorStringArquivo(indice, "IdDbt"), "Banco do Brasil", recDebTO.getIdentificadorClienteDebitoTO().getAgenciaInstituicaoFinanceiraTO().getCodigoAgencia() + "-" + recDebTO.getIdentificadorClienteDebitoTO().getAgenciaInstituicaoFinanceiraTO().getDigitoVerificadorAgencia(), recDebTO.getIdentificadorClienteDebitoTO().getContaCorrenteClienteTO().getId().getCodigoAgencia() + "-" + recDebTO.getIdentificadorClienteDebitoTO().getContaCorrenteClienteTO().getDigitoVerificadorContaCorrente(), this.getValorDateArquivo(indice, "DataOpcao"), this.getValorDoubleArquivo(indice, "ValorDBT"), "D\u00e9bito n\u00e3o efetuado", descricaoOcorrencia, lancamentos);
        }
        this.atualizaRecebimento(recDebTO, 'O', indice);
    }

    private void processarRegistroTipoB(ConvenenteTO convenenteTO, List<LancamentoTO> lancamentos, int indice) throws BBException {
        int codigoMovimentoArquivo;
        String identificador = this.getValorStringArquivo(indice, "IdDbt");
        IdentificadorClienteDebitoTO idCliDbt = this.consultarIdentificadorClienteDebitoCabecalho(identificador);
        int n = codigoMovimentoArquivo = this.getCodigoMovimentoArquivo(indice) == null ? 0 : this.getCodigoMovimentoArquivo(indice);
        if (codigoMovimentoArquivo == 1) {
            if (this.isReferencia(idCliDbt)) {
                this.atualizarExclusao(idCliDbt, indice, lancamentos);
            } else {
                ContaCorrenteClienteTO ccClienteTO = this.recuperaContaCorrenteClienteTO(indice);
                if (!this.isReferencia(ccClienteTO)) {
                    this.idDbtCadastradoPelaAplicacao(ccClienteTO, indice, lancamentos);
                } else {
                    this.clienteCadastradoPeloAplicativo(indice, lancamentos);
                }
            }
        } else if (codigoMovimentoArquivo == 2) {
            if (this.isReferencia(idCliDbt)) {
                this.atualizarInclusao(idCliDbt, lancamentos, indice);
            } else {
                ContaCorrenteClienteTO ccClienteTO = this.recuperaContaCorrenteClienteTO(indice);
                if (!this.isReferencia(ccClienteTO)) {
                    this.idDbtCadastradoPelaAplicacao(ccClienteTO, indice, lancamentos);
                } else {
                    this.clienteCadastradoPeloAplicativo(indice, lancamentos);
                }
            }
        }
    }

    private void clienteCadastradoPeloAplicativo(int indice, List<LancamentoTO> lancamentos) throws BBException {
        IdentificadorClienteDebitoTO idCliDbt;
        ContaCorrenteClienteTO ccClienteTO;
        AgenciaInstituicaoFinanceiraTO agencia = this.recuperaAgenciaInstituicaoFinanceiraTO(indice);
        if (!this.isReferencia(agencia)) {
            agencia = this.cadastrarAgenciaTO(indice);
        }
        if (!this.isReferencia(ccClienteTO = this.recuperaContaCorrenteClienteTO(indice))) {
            PessoaTO pessoaTO = this.cadastraPessoaTO();
            ccClienteTO = this.cadastraContaCorrenteClienteTO(pessoaTO, agencia, indice);
        }
        if (!this.isReferencia(idCliDbt = this.consultarIdentificadorClienteDebitoCabecalho(this.getValorStringArquivo(indice, "IdDbt")))) {
            this.cadastrarIdentificadorClienteDebitoTO(ccClienteTO, indice, lancamentos);
        }
    }

    private void cadastrarIdentificadorClienteDebitoTO(ContaCorrenteClienteTO ccClienteTO, int indice, List<LancamentoTO> lancamentos) throws BBException {
        ccClienteTO = this.adicionarContaCorrenteClienteTO(indice);
        IdentificadorClienteDebitoTODecorator decorator = this.geraIdentificadorContaClienteTODecorator(this.convenenteTO, indice, ccClienteTO);
        this.incluirIdentificadorClienteDebito(decorator);
        this.gerarLancamento(decorator.getPessoaTO().getTextoNome(), this.getValorStringArquivo(indice, "IdDbt"), "Banco do Brasil", decorator.getAgenciaInstituicaoFinanceiraTO().getCodigoAgencia() + "-" + decorator.getAgenciaInstituicaoFinanceiraTO().getDigitoVerificadorAgencia(), decorator.getContaCorrenteClienteTO().getId().getCodigoAgencia() + "-" + decorator.getContaCorrenteClienteTO().getDigitoVerificadorContaCorrente(), this.getValorDateArquivo(indice, "DataOpcao"), 0.0, "Cliente cadastrado pela aplica\u00e7\u00e3o durante o tratamento do arquivo de retorno", "", lancamentos);
    }

    private ContaCorrenteClienteTO cadastraContaCorrenteClienteTO(PessoaTO pessoaTO, AgenciaInstituicaoFinanceiraTO agenciaTO, int indice) throws BBException {
        ContaCorrenteClienteTO contaCorrenteClienteTO = this.getFabricaDeTO().novoContaCorrenteClienteTO();
        ContaCorrenteClienteTOId contaCorrenteClienteTOId = this.getFabricaDeTO().novoContaCorrenteClienteTOId();
        Long contaCorrente = this.getValorLongArquivo(indice, "NumConta");
        contaCorrenteClienteTOId.setCodigoAgencia(agenciaTO.getId().getCodigoAgencia());
        contaCorrenteClienteTOId.setCodigoContaCorrente(contaCorrente);
        contaCorrenteClienteTOId.setCodigoInstituicaoFinanceira(agenciaTO.getId().getCodigoInstituicaoFinanceira());
        contaCorrenteClienteTOId.setCodigoPessoa(pessoaTO.getCodigoPessoa().intValue());
        contaCorrenteClienteTO.setId(contaCorrenteClienteTOId);
        String codigoVerificador = CalculaDigitoVerificador.calcularModulo10((String)contaCorrente.toString());
        contaCorrenteClienteTO.setDigitoVerificadorContaCorrente(Character.valueOf(codigoVerificador.charAt(0)));
        contaCorrenteClienteTO.setTextoDescricaoContaCorrente("CADASTRADO PELO ARQUIVO DE RETORNO");
        return (ContaCorrenteClienteTO)this.getContaCorrenteClienteDAO().incluir((Object)contaCorrenteClienteTO);
    }

    private PessoaTO cadastraPessoaTO() {
        PessoaTO pessoaTO = this.getFabricaDeTO().novoPessoaTO();
        TipoPessoaTO tipoPessoaTO = this.getFabricaDeTO().novoTipoPessoaFisica();
        tipoPessoaTO.setCodigoTipoPessoa(Integer.valueOf(0));
        pessoaTO.setTipoPessoaTO(tipoPessoaTO);
        pessoaTO.setTextoNome("INCLU\u00cdDO PELA APLICA\u00c7\u00c3O");
        pessoaTO.setTextoObservacao("CADASTRADO PELO ARQUIVO DE RETORNO");
        return (PessoaTO)this.getPessoaDAO().incluir((Object)pessoaTO);
    }

    private AgenciaInstituicaoFinanceiraTO cadastrarAgenciaTO(int indice) throws BBException {
        AgenciaInstituicaoFinanceiraTO agencia = this.getFabricaDeTO().novoAgenciaInstituicaoFinanceiraTO();
        AgenciaInstituicaoFinanceiraTOId agenciaId = this.getFabricaDeTO().novoAgenciaInstituicaoFinanceiraTOId();
        Integer codigoAgencia = 123;
        agenciaId.setCodigoAgencia(codigoAgencia);
        agenciaId.setCodigoInstituicaoFinanceira(Integer.valueOf(1));
        agencia.setId(agenciaId);
        String codigoVerificador = CalculaDigitoVerificador.calcularModulo11((String)codigoAgencia.toString());
        agencia.setDigitoVerificadorAgencia(Character.valueOf(codigoVerificador.charAt(0)));
        agencia.setIndicadorTipoAgencia(Character.valueOf('A'));
        agencia.setTextoDescricao("CADASTRADA PELO ARQUIVO DE RETORNO");
        agencia.setInstituicaoFinanceiraTO((InstituicaoFinanceiraTO)this.instituicaoFinanceiraDAO.listar((Serializable)Integer.valueOf(1)));
        boolean existeInstituicao = this.getAgenciaInstituicaoFinanceiraDAO().isExisteAgenciaParaInstistituicao(agencia);
        if (!existeInstituicao) {
            return (AgenciaInstituicaoFinanceiraTO)this.getAgenciaInstituicaoFinanceiraDAO().incluir((Object)agencia);
        }
        return (AgenciaInstituicaoFinanceiraTO)this.getAgenciaInstituicaoFinanceiraDAO().listar((Object)agencia);
    }

    private AgenciaInstituicaoFinanceiraTO recuperaAgenciaInstituicaoFinanceiraTO(int indice) throws BBException {
        if (this.agenciaInstituicaoFinanceiraTO == null) {
            AgenciaInstituicaoFinanceiraTO to = this.getFabricaDeTO().novoAgenciaInstituicaoFinanceiraTO();
            to.getId().setCodigoAgencia(this.getValorIntegerArquivo(indice, "NumAgencia"));
            to.getId().setCodigoInstituicaoFinanceira(Integer.valueOf(1));
            this.agenciaInstituicaoFinanceiraTO = (AgenciaInstituicaoFinanceiraTO)this.getAgenciaInstituicaoFinanceiraDAO().listar((Object)to);
        }
        return this.agenciaInstituicaoFinanceiraTO;
    }

    private void atualizarExclusao(IdentificadorClienteDebitoTO idCliDbt, int indice, List<LancamentoTO> lancamentos) throws BBException {
        this.atualizaCodigoSituacaoIdentificadorDebito(idCliDbt, 'I');
        this.gerarLancamento(idCliDbt.getPessoaTO().getTextoNome(), this.getValorStringArquivo(indice, "IdDbt"), "Banco do Brasil", idCliDbt.getAgenciaInstituicaoFinanceiraTO().getCodigoAgencia() + "-" + idCliDbt.getAgenciaInstituicaoFinanceiraTO().getDigitoVerificadorAgencia(), idCliDbt.getContaCorrenteClienteTO().getId().getCodigoAgencia() + "-" + idCliDbt.getContaCorrenteClienteTO().getDigitoVerificadorContaCorrente(), this.getValorDateArquivo(indice, "DataOpcao"), 0.0, "Identificador de d\u00e9bito inativo", "", lancamentos);
    }

    private void atualizarInclusao(IdentificadorClienteDebitoTO idCliDbt, List<LancamentoTO> lancamentos, int indice) throws BBException {
        this.atualizaCodigoSituacaoIdentificadorDebito(idCliDbt, 'A');
        this.gerarLancamento(idCliDbt.getPessoaTO().getTextoNome(), this.getValorStringArquivo(indice, "IdDbt"), "Banco do Brasil", idCliDbt.getAgenciaInstituicaoFinanceiraTO().getCodigoAgencia() + "-" + idCliDbt.getAgenciaInstituicaoFinanceiraTO().getDigitoVerificadorAgencia(), idCliDbt.getContaCorrenteClienteTO().getId().getCodigoAgencia() + "-" + idCliDbt.getContaCorrenteClienteTO().getDigitoVerificadorContaCorrente(), this.getValorDateArquivo(indice, "DataOpcao"), 0.0, "Identificador de d\u00e9bito ativo", "", lancamentos);
        IdentificadorClienteDebitoTO idCliDbtAntigo = this.consultarIdentificadorClienteDebitoCabecalho(idCliDbt.getTextoIdentificadorAnterior());
        if (this.isReferencia(idCliDbtAntigo)) {
            this.atualizaCodigoSituacaoIdentificadorDebito(idCliDbtAntigo, 'I');
        }
    }

    private void idDbtCadastradoPelaAplicacao(ContaCorrenteClienteTO ccClienteTO, int indice, List<LancamentoTO> lancamentos) throws BBException {
        ccClienteTO = this.adicionarContaCorrenteClienteTO(indice);
        IdentificadorClienteDebitoTODecorator decorator = this.geraIdentificadorContaClienteTODecorator(this.convenenteTO, indice, ccClienteTO);
        this.incluirIdentificadorClienteDebito(decorator);
        this.gerarLancamento(decorator.getPessoaTO().getTextoNome(), this.getValorStringArquivo(indice, "IdDbt"), "Banco do Brasil", decorator.getAgenciaInstituicaoFinanceiraTO().getCodigoAgencia() + "-" + decorator.getAgenciaInstituicaoFinanceiraTO().getDigitoVerificadorAgencia(), decorator.getContaCorrenteClienteTO().getId().getCodigoAgencia() + "-" + decorator.getContaCorrenteClienteTO().getDigitoVerificadorContaCorrente(), this.getValorDateArquivo(indice, "DataOpcao"), 0.0, "", "Cliente cadastrado pelo aplicativo.", lancamentos);
    }

    private void idDbtCadastradoPeloAplicativo(List<LancamentoTO> lancamentos, int indice, ContaCorrenteClienteTO ccClienteTO) throws BBException {
        IdentificadorClienteDebitoTODecorator decorator = this.geraIdentificadorContaClienteTODecorator(this.convenenteTO, indice, ccClienteTO);
        this.incluirIdentificadorClienteDebito(decorator);
        this.gerarLancamento(decorator.getPessoaTO().getTextoNome(), this.getValorStringArquivo(indice, "IdDbt"), "Banco do Brasil", decorator.getAgenciaInstituicaoFinanceiraTO().getCodigoAgencia() + "-" + decorator.getAgenciaInstituicaoFinanceiraTO().getDigitoVerificadorAgencia(), decorator.getContaCorrenteClienteTO().getId().getCodigoAgencia() + "-" + decorator.getContaCorrenteClienteTO().getDigitoVerificadorContaCorrente(), this.getValorDateArquivo(indice, "DataOpcao"), 0.0, "", "Cliente cadastrado no aplicativo.", lancamentos);
    }

    public void incluirIdentificadorClienteDebito(IdentificadorClienteDebitoTODecorator decorator) throws BBException {
        decorator.getIdentificadorClienteDebitoTO().setCodigoIdentificadorClienteDebito(null);
        this.gravarIdentificacao(decorator, true);
    }

    private void gravarIdentificacao(IdentificadorClienteDebitoTODecorator decorator, boolean valida) throws BBException {
        decorator.setAgenciaInstituicaoFinanceiraTO(decorator.getAgenciaInstituicaoFinanceiraTODaDecorator());
        decorator.getConvenioDebitoTO().setConvenioTO(decorator.getConvenioTO());
        ConvenioDebitoTOId id = this.getFabricaDeTO().novoConvenioDebitoTOId();
        id.setCodigoPessoaConvenente(decorator.getConvenioTO().getConvenenteTO().getCodigoPessoaConvenente());
        id.setNumeroConvenio(decorator.getConvenioTO().getId().getNumeroConvenio());
        id.setTextoIdentificadorServico(decorator.getConvenioTO().getServicoTO().getTextoIdentificadorServico());
        ConvenioDebitoTO convenioDebitoTO = this.getConvenioDebitoTO(id);
        decorator.getIdentificadorClienteDebitoTO().setConvenioDebitoTO(convenioDebitoTO);
        decorator.getIdentificadorClienteDebitoTO().getContaCorrenteClienteTO().getId().setCodigoPessoa(decorator.getCodigoPessoaCliente().intValue());
        decorator.getIdentificadorClienteDebitoTO().getContaCorrenteClienteTO().getId().setCodigoAgencia(decorator.getAgenciaInstituicaoFinanceiraTO().getId().getCodigoAgencia());
        decorator.getIdentificadorClienteDebitoTO().getContaCorrenteClienteTO().getId().setCodigoInstituicaoFinanceira(decorator.getCodigoInstituicaoFinanceira());
        AgenciaInstituicaoFinanceiraTO agenciaInstituicaoFinanceiraTO = decorator.getIdentificadorClienteDebitoTO().getContaCorrenteClienteTO().getAgenciaInstituicaoFinanceiraTO();
        this.gravarContaCorrente(decorator, agenciaInstituicaoFinanceiraTO);
        decorator.getIdentificadorClienteDebitoTO().setAgenciaInstituicaoFinanceiraTO(agenciaInstituicaoFinanceiraTO);
        decorator.getIdentificadorClienteDebitoTO().setPessoaTO(decorator.getIdentificadorClienteDebitoTO().getContaCorrenteClienteTO().getPessoaTO());
        boolean existe = false;
        if (valida) {
            existe = this.getIdentificadorClienteDebitoDAO().isExistePeloTextoDeIdentificacaoConvenenteClienteEConvenio(decorator.getIdentificadorClienteDebitoTO());
        }
        if (!existe) {
            if (this.isReferencia(decorator.getMembroGrupoClienteRecebimentoTO().getGrupoClienteRecebimentoTO())) {
                decorator.getMembroGrupoClienteRecebimentoTO().setIdentificadorClienteDebitoTO(decorator.getIdentificadorClienteDebitoTO());
                decorator.getMembroGrupoClienteRecebimentoTO().setGrupoClienteRecebimentoTO(decorator.getGrupoClienteRecebimentoTO());
                decorator.getMembroGrupoClienteRecebimentoTO().getId().setCodigoGrupoClienteRecebimento(decorator.getGrupoClienteRecebimentoTO().getCodigoGrupoClienteRecebimento());
                decorator.getMembroGrupoClienteRecebimentoTO().getId().setCodigoPessoaCliente(decorator.getPessoaTO().getCodigoPessoa());
                decorator.getMembroGrupoClienteRecebimentoTO().setPessoaTO(decorator.getPessoaTO());
            } else {
                this.getIdentificadorClienteDebitoDAO().alterar(decorator.getIdentificadorClienteDebitoTO());
            }
        } else {
            throw new BBException("MP050");
        }
    }

    private void gravarContaCorrente(IdentificadorClienteDebitoTODecorator decorator, AgenciaInstituicaoFinanceiraTO agenciaInstituicaoFinanceiraTO) {
        Set contas = agenciaInstituicaoFinanceiraTO.getContaCorrenteClienteTOs();
        ContaCorrenteClienteTO containcluir = decorator.getIdentificadorClienteDebitoTO().getContaCorrenteClienteTO();
        for (ContaCorrenteClienteTO to : contas) {
            if (!to.equals((Object)containcluir)) continue;
            contas.remove(to);
            return;
        }
        contas.add(containcluir);
    }

    private ConvenioDebitoTO getConvenioDebitoTO(ConvenioDebitoTOId id) {
        return (ConvenioDebitoTO)this.getConvenioDebitoDAO().listar((Serializable)id);
    }

    private RecebimentoDebitoTO consultarRecebimentoPeloTxIdeReg(String idRecebimentoArquivo) {
        return this.getRecebimentoDebitoDAO().consultarPeloIDRegistro(this.verificarIDRegistro(idRecebimentoArquivo));
    }

    private String getIdRecebimentoArquivo(int indice) throws BBException {
        String valorRegistro = this.getValorStringArquivo(indice, "IdRecebimento");
        return valorRegistro == null ? "" : valorRegistro.trim();
    }

    private IdentificadorClienteDebitoTO consultarIdentificadorClienteDebitoCabecalho(String identificador) throws BBException {
        IdentificadorClienteDebitoTODecorator idClienteDebTO = this.getFabricaDeTO().novoIdentificadorClienteDebitoTODecorator();
        idClienteDebTO.setTextoIdentificadorDebito(identificador);
        return this.getUnicoIdentificadorClienteDebito(this.getIdentificadorClienteDebitoDAO().consultarPeloTextoIdentificacaoEAgenciaEContaCorrente(idClienteDebTO));
    }

    private String verificarIDRegistro(String IDDebito) {
        return IDDebito == null || IDDebito.trim().length() <= 25 ? IDDebito : IDDebito.substring(0, 25);
    }

    private IdentificadorClienteDebitoTO consultarIdentificadorClienteDebitoAnterior(int indice) throws BBException {
        IdentificadorClienteDebitoTO to = this.getFabricaDeTO().novoIdentificadorClienteDebitoTO();
        to.getConvenioDebitoTO().getId().setCodigoPessoaConvenente(this.getConvenente().getCodigoPessoaConvenente());
        to.getConvenioDebitoTO().getId().setNumeroConvenio(this.getConvenioArquivo());
        to.getConvenioDebitoTO().getId().setTextoIdentificadorServico(this.getRecebimentoDebitoAnteriorArquivo(indice));
        return this.getUnicoIdentificadorClienteDebito(this.getIdentificadorClienteDebitoDAO().consultar(to));
    }

    private IdentificadorClienteDebitoTO consultarIdentificadorClienteDebitoAtual(int indice) throws BBException {
        IdentificadorClienteDebitoTO to = this.getFabricaDeTO().novoIdentificadorClienteDebitoTO();
        to.getConvenioDebitoTO().getId().setCodigoPessoaConvenente(this.getConvenente().getCodigoPessoaConvenente());
        to.getConvenioDebitoTO().getId().setNumeroConvenio(this.getConvenioArquivo());
        to.getConvenioDebitoTO().getId().setTextoIdentificadorServico(this.getRecebimentoDebitoAtualArquivo(indice));
        return this.getUnicoIdentificadorClienteDebito(this.getIdentificadorClienteDebitoDAO().consultar(to));
    }

    private IdentificadorClienteDebitoTO getUnicoIdentificadorClienteDebito(Collection<IdentificadorClienteDebitoTO> consultar) {
        return (IdentificadorClienteDebitoTO)UtilColecao.getElementoDoIndice(consultar, (int)0);
    }

    private RecebimentoDebitoTO getUnicoRecebimentoDebito(Collection<RecebimentoDebitoTO> consultar) {
        return (RecebimentoDebitoTO)UtilColecao.getElementoDoIndice(consultar, (int)0);
    }

    private void moverArquivoRetornoProcessado(File arquivoRetorno) throws BBException {
        String arquivoDestino = String.valueOf(this.getDiretorioRetornoProcessado()) + "/" + arquivoRetorno.getName();
        try {
            FileWriter out = this.getArquivoFactory().novoFileWriter(arquivoDestino);
            FileReader in = this.getArquivoFactory().novoFileReader(arquivoRetorno);
            out.write(in.read());
            out.close();
            in.close();
            arquivoRetorno.delete();
        }
        catch (FileNotFoundException e) {
            throw UtilBBException.getErroDeSistema((IOException)e);
        }
        catch (IOException e) {
            throw UtilBBException.getErroDeSistema((IOException)e);
        }
    }

    private void atualizaRecebimento(RecebimentoDebitoTO recDebTO, char c, int indice) throws BBException {
        int codReceb = this.getValorIntegerArquivo(indice, "CodRet");
        if (codReceb == 0 && recDebTO != null) {
            recDebTO.setCodigoAgenciaDebito(this.getValorIntegerArquivo(indice, "NumAgencia"));
            recDebTO.setCodigoBancoDebito(Integer.valueOf(1));
            recDebTO.setCodigoContaCorrenteDebito(this.getValorIntegerArquivo(indice, "NumConta"));
            this.getRecebimentoDebitoDAO().alterar(recDebTO);
        }
    }

    private void atualizaCodigoSituacaoRecebimento(RecebimentoDebitoTO recDebTO, char c, int indice) throws BBException {
        TipoOcorrenciaRecebimentoDebitoTOId toID = this.getFabricaDeTO().novoTipoOcorrenciaRecebimentoDebitoTOId();
        toID.setCodigoRetorno(this.getValorIntegerArquivo(indice, "CodRet").intValue());
        toID.setTextoTipoRetorno('P');
        TipoOcorrenciaRecebimentoDebitoTO tipoOcorrenciaRecebimentoDebitoTO = (TipoOcorrenciaRecebimentoDebitoTO)this.getTipoOcorrenciaRecebimentoDebitoDAO().listar((Serializable)toID);
        recDebTO.setTipoOcorrenciaRecebimentoDebitoTO(tipoOcorrenciaRecebimentoDebitoTO);
        recDebTO.setSituacaoRecebimentoTO((SituacaoRecebimentoTO)this.getSituacaoRecebimentoDAO().listar(Character.valueOf(c)));
        this.getRecebimentoDebitoDAO().alterar(recDebTO);
    }

    private void gerarLancamento(String nome, String idDeb, String banco, String agencia, String conta, Date data, Double valor, String situacao, String ocorrencia, List<LancamentoTO> lancamentos) {
        LancamentoTO to = this.getFabricaDeTO().novoLancamentoTO();
        to.setNome(nome);
        to.setIdDeb(idDeb);
        to.setBanco(banco);
        to.setAgencia(agencia);
        to.setConta(conta);
        to.setData(data);
        to.setValor(valor);
        to.setSituacao(situacao);
        to.setOcorrencia(ocorrencia);
        lancamentos.add(to);
    }

    private Date getValorDateArquivo(int indice, String nomeCampo) throws BBException {
        return this.getParser().getValorDoRegistroDate(indice, nomeCampo);
    }

    private String getValorStringArquivo(int indice, String nomeCampo) throws BBException {
        return UtilString.trim((String)this.getParser().getValorDoRegistroString(indice, nomeCampo));
    }

    private Integer getValorIntegerArquivo(int indice, String nomeCampo) throws BBException {
        return new Integer(this.getParser().getValorDoRegistroString(indice, nomeCampo));
    }

    private Long getValorLongArquivo(int indice, String nomeCampo) throws BBException {
        return new Long(this.getParser().getValorDoRegistroString(indice, nomeCampo));
    }

    private Double getValorDoubleArquivo(int indice, String nomeCampo) throws BBException {
        return this.getParser().getValorDoRegistroDouble(indice, nomeCampo);
    }

    private void atualizaCodigoRetornoNoRecebimentoDebitoTO(int indice, RecebimentoDebitoTO recDebTO) throws BBException {
        Set remessas = recDebTO.getTipoOcorrenciaRecebimentoDebitoTO().getTipoRetornoTO().getRemessaTOs();
        for (RemessaTO remessaTO : remessas) {
            remessaTO.setCodigoRetorno(this.getValorIntegerArquivo(indice, "CodRet"));
        }
    }

    private IdentificadorClienteDebitoTO geraIdentificadorContaClienteTO(ConvenenteTO convenenteTO, int indice, ContaCorrenteClienteTO ccClienteTO) throws BBException {
        IdentificadorClienteDebitoTODecorator idClienteDebTO = this.getFabricaDeTO().novoIdentificadorClienteDebitoTODecorator();
        idClienteDebTO.setContaCorrenteClienteTO(ccClienteTO);
        idClienteDebTO.setConvenioDebitoTO(this.getConvenioDebitoTO());
        idClienteDebTO.setTextoSituacaoIdentificador("A");
        idClienteDebTO.setTextoIdentificadorDebito(this.getValorStringArquivo(indice, "IdDbt"));
        idClienteDebTO.setTextoIdentificadorAnterior(null);
        idClienteDebTO.setDataUltimaRemessa(null);
        idClienteDebTO.setDataAlteracaoRemessa(null);
        idClienteDebTO.setNumeroAlteracaoRemessa(null);
        idClienteDebTO.setTextoDescricaoOcorrencia(null);
        idClienteDebTO.setIndicadorImpressao("2");
        return idClienteDebTO.getIdentificadorClienteDebitoTO();
    }

    private IdentificadorClienteDebitoTODecorator geraIdentificadorContaClienteTODecorator(ConvenenteTO convenenteTO, int indice, ContaCorrenteClienteTO ccClienteTO) throws BBException {
        IdentificadorClienteDebitoTODecorator idClienteDebTO = this.getFabricaDeTO().novoIdentificadorClienteDebitoTODecorator();
        idClienteDebTO.setContaCorrenteClienteTO(ccClienteTO);
        idClienteDebTO.setConvenioDebitoTO(this.getConvenioDebitoTO());
        idClienteDebTO.setTextoSituacaoIdentificador("A");
        idClienteDebTO.setTextoIdentificadorDebito(this.getValorStringArquivo(indice, "IdDbt"));
        idClienteDebTO.setTextoIdentificadorAnterior(null);
        idClienteDebTO.setDataUltimaRemessa(new Date());
        idClienteDebTO.setDataAlteracaoRemessa(null);
        idClienteDebTO.setNumeroAlteracaoRemessa(null);
        idClienteDebTO.setTextoDescricaoOcorrencia(null);
        idClienteDebTO.setIndicadorImpressao("2");
        ccClienteTO.getAgenciaInstituicaoFinanceiraTO().setCodigoInstituicaoFinanceira(Integer.valueOf(1));
        ccClienteTO.getAgenciaInstituicaoFinanceiraTO().setCodigoAgencia(this.getValorIntegerArquivo(indice, "NumAgencia"));
        idClienteDebTO.setAgenciaInstituicaoFinanceiraTO(ccClienteTO.getAgenciaInstituicaoFinanceiraTO());
        AgenciaInstituicaoFinanceiraTODecorator aifTODecorator = new AgenciaInstituicaoFinanceiraTODecorator();
        aifTODecorator.setAgenciaInstituicaoFinanceiraTO(ccClienteTO.getAgenciaInstituicaoFinanceiraTO());
        idClienteDebTO.setAgenciaInstituicaoFinanceiraTODecorator(aifTODecorator);
        return idClienteDebTO;
    }

    private ContaCorrenteClienteTO adicionarContaCorrenteClienteTO(int indice) throws BBException {
        if (this.contaCorrenteClienteTO == null) {
            ContaCorrenteClienteTO to = this.getFabricaDeTO().novoContaCorrenteClienteTO();
            AgenciaInstituicaoFinanceiraTOId agenciaId = this.getFabricaDeTO().novoAgenciaInstituicaoFinanceiraTOId();
            agenciaId.setCodigoAgencia(this.getValorIntegerArquivo(indice, "NumAgencia"));
            agenciaId.setCodigoInstituicaoFinanceira(Integer.valueOf(1));
            to.setAgenciaInstituicaoFinanceiraTO((AgenciaInstituicaoFinanceiraTO)this.getAgenciaInstituicaoFinanceiraDAO().listar((Serializable)agenciaId));
            to.getId().setCodigoContaCorrente(this.getValorLongArquivo(indice, "NumConta"));
            this.contaCorrenteClienteTO = this.getContaCorrenteClienteDAO().listarPorBancoAgenciaConta(to);
        }
        return this.contaCorrenteClienteTO;
    }

    private ContaCorrenteClienteTO recuperaContaCorrenteClienteTO(int indice) throws BBException {
        if (this.contaCorrenteClienteTO == null) {
            ContaCorrenteClienteTO to = this.getFabricaDeTO().novoContaCorrenteClienteTO();
            AgenciaInstituicaoFinanceiraTOId agenciaId = this.getFabricaDeTO().novoAgenciaInstituicaoFinanceiraTOId();
            agenciaId.setCodigoAgencia(this.getValorIntegerArquivo(indice, "NumAgencia"));
            agenciaId.setCodigoInstituicaoFinanceira(Integer.valueOf(1));
            to.setAgenciaInstituicaoFinanceiraTO((AgenciaInstituicaoFinanceiraTO)this.getAgenciaInstituicaoFinanceiraDAO().listar((Serializable)agenciaId));
            to.getId().setCodigoContaCorrente(this.getValorLongArquivo(indice, "NumConta"));
            this.contaCorrenteClienteTO = this.getContaCorrenteClienteDAO().listarPorBancoAgenciaConta(to);
        }
        return this.contaCorrenteClienteTO;
    }

    public void setContaCorrenteClienteTO(ContaCorrenteClienteTO contaCorrenteClienteTO) {
        this.contaCorrenteClienteTO = contaCorrenteClienteTO;
    }

    private void atualizaCodigoSituacaoIdentificadorDebito(IdentificadorClienteDebitoTO idCliDbt, char codigoSituacaoIdentificador) {
        if (idCliDbt == null) {
            return;
        }
        idCliDbt.getSituacaoIdentificadorDebitoTO().setTextoSituacaoIdentificador(codigoSituacaoIdentificador);
        this.getIdentificadorClienteDebitoDAO().alterar(idCliDbt);
    }

    private Integer getCodigoMovimentoArquivo(int indice) throws BBException {
        return this.getParser().getValorDoRegistroInteger(indice, "CodMovimento");
    }

    private boolean isRegistroTipoH(int indice) throws BBException {
        return "H".equals(this.getParser().getNomeDoRegistro(indice));
    }

    private boolean isRegistroTipoB(int indice) throws BBException {
        return "B".equals(this.getParser().getNomeDoRegistro(indice));
    }

    private boolean isRegistroTipoF(int indice) throws BBException {
        return "F".equals(this.getParser().getNomeDoRegistro(indice));
    }

    private boolean isRegistroTipoZ(int indice) throws BBException {
        return "Z".equals(this.getParser().getNomeDoRegistro(indice));
    }

    private void atualizaRecebimentoDebito(RecebimentoDebitoTO recebimentoDebitoTO, char codigoSituacaoRecebimento, int indice) throws BBException {
        recebimentoDebitoTO.getSituacaoRecebimentoTO().setCodigoSituacaoRecebimento(Character.valueOf(codigoSituacaoRecebimento));
        recebimentoDebitoTO.setCodigoBancoLiquidacao(Integer.valueOf(1));
        recebimentoDebitoTO.setCodigoAgenciaLiquidacao(this.getValorIntegerArquivo(indice, "NumAgencia"));
        recebimentoDebitoTO.setCodigoContaCorrenteLiquidacao(this.getValorIntegerArquivo(indice, "NumConta"));
        recebimentoDebitoTO.setDataDebito(this.getValorDateArquivo(indice, "DataOpcao"));
        recebimentoDebitoTO.setValorDebito(new BigDecimal(this.getValorDoubleArquivo(indice, "ValorDBT")));
        this.getRecebimentoDebitoDAO().alterar(recebimentoDebitoTO);
    }

    private String getRecebimentoDebitoAnteriorArquivo(int indice) throws BBException {
        return this.getValorStringArquivo(indice, "IdDbtAnt");
    }

    private String getRecebimentoDebitoAtualArquivo(int indice) throws BBException {
        return this.getValorStringArquivo(indice, "IdDbtAtual");
    }

    private Integer getNumeroConvenio(Set<ConvenioTO> convenioTOs) {
        Iterator<ConvenioTO> iterator = convenioTOs.iterator();
        if (iterator.hasNext()) {
            ConvenioTO convenioTO = iterator.next();
            return convenioTO.getId().getNumeroConvenio();
        }
        return null;
    }

    private File recuperaArquivoRetorno(RetornoTODecorator retornoTODecorator) {
        return ArquivoFactory.getInstancia().novoFile(String.valueOf(this.getPathDiretorioRetorno()) + "\\" + retornoTODecorator.getNomeArquivo() + ".RET");
    }

    private RetornoTODecorator preencherRetornoTO(IParserArquivo parser, File file) throws BBException {
        RetornoTODecorator retornoDecorator = this.getFabricaDeTO().novoRetornoTODecorator();
        retornoDecorator.setNomeArquivo(this.getNomeArquivo(file));
        retornoDecorator.setNumeroConvenio(new Integer(parser.getValorDoCabecalhoString("Convenio")));
        retornoDecorator.setNumeroIdentificadorRetorno(parser.getValorDoCabecalhoInteger("SequencialArq").intValue());
        retornoDecorator.setDataProcessamentoRetorno(parser.getValorDoCabecalhoDate("DataArq"));
        return retornoDecorator;
    }

    private Integer getNumeroRetorno() throws BBException {
        return this.getParser().getValorDoCabecalhoInteger("SequencialArq");
    }

    private Date getDataArquivo() throws BBException {
        return this.getParser().getValorDoCabecalhoDate("DataArq");
    }

    private String getNomeArquivo(File file) {
        String f = file.getName();
        return f.substring(0, f.lastIndexOf(46));
    }

    private boolean verificaConvenio(String valorDoCabecalhoString, Collection<ConvenioTO> listaConveniosConvenente) {
        if (valorDoCabecalhoString == null) {
            return false;
        }
        Integer valorConvenioArquivo = new Integer(valorDoCabecalhoString);
        for (ConvenioTO convenioTO : listaConveniosConvenente) {
            if (!convenioTO.getId().getNumeroConvenio().equals(valorConvenioArquivo)) continue;
            return true;
        }
        return false;
    }

    private File[] recuperaArquivosDeRetorno() {
        File diretorioArquivos = this.getArquivoFactory().novoFile(this.getPathDiretorioRetorno());
        File[] listaArquivos = diretorioArquivos.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                int fimExtensaoArquivo;
                int inicioExtensaoArquivo = name.length() - 4;
                return name.substring(inicioExtensaoArquivo, fimExtensaoArquivo = name.length()).equalsIgnoreCase(".RET");
            }
        });
        return listaArquivos;
    }

    private String getPathDiretorioRetorno() {
        return UtilArquivoConfiguracao.getInstancia().getValorPropertie("diretorio.retorno");
    }

    private String getDiretorioRetornoProcessado() {
        return UtilArquivoConfiguracao.getInstancia().getValorPropertie("diretorio.processados");
    }

    protected IParserArquivo getParser() {
        return this.parser;
    }

    protected void setParser(IParserArquivo parser) {
        this.parser = parser;
    }

    protected int getTotalDeRegistros() throws BBException {
        return this.getParser().getTotalDeRegistros();
    }

    protected Integer getConvenioArquivo() throws BBException {
        return UtilConversorDeInteger.converterParaInteger((String)this.getParser().getValorDoCabecalhoString("Convenio"));
    }

    public ConvenioTO getConvenioTO() throws BBException {
        if (this.convenioTO == null) {
            ConvenioTOId toId = this.getFabricaDeTO().novoConvenioTOId();
            toId.setCodigoPessoaConvenente(this.getConvenente().getCodigoPessoaConvenente());
            toId.setServicoTO((ServicoTO)this.getServicoDAO().listar((Serializable)((Object)"DBT")));
            toId.setNumeroConvenio(this.getConvenioArquivo());
            this.convenioTO = (ConvenioTO)this.getConvenioDAO().listar((Serializable)toId);
        }
        return this.convenioTO;
    }

    public void setConvenioTO(ConvenioTO convenioTO) {
        this.convenioTO = convenioTO;
    }

    public ConvenioDebitoTO getConvenioDebitoTO() throws BBException {
        if (this.convenioDebitoTO == null) {
            ConvenioDebitoTOId toId = this.getFabricaDeTO().novoConvenioDebitoTOId();
            toId.setConvenioTO(this.getConvenioTO());
            this.convenioDebitoTO = (ConvenioDebitoTO)this.getConvenioDebitoDAO().listar((Serializable)toId);
        }
        return this.convenioDebitoTO;
    }

    public void setConvenioDebitoTO(ConvenioDebitoTO convenioDebitoTO) {
        this.convenioDebitoTO = convenioDebitoTO;
    }

    public ConvenenteTO getConvenenteTO() {
        return this.convenenteTO;
    }

    public void setConvenenteTO(ConvenenteTO convenenteTO) {
        this.convenenteTO = convenenteTO;
    }

    public ConvenenteTO getConvenente() throws BBException {
        if (this.convenenteTO == null) {
            ConvenioTODecorator convenioTODecorator = this.getFabricaDeTO().novoConvenioTODecorator();
            convenioTODecorator.setNumeroConvenio(this.getConvenioArquivo());
            convenioTODecorator.setTextoIdentificadorServico("DBT");
            this.convenenteTO = this.getConvenioDAO().consultarPorConvenioServico(convenioTODecorator).getConvenenteTO();
        }
        return this.convenenteTO;
    }
}

