/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.dbt.negocio.model;

import br.com.bb.plugins.dbt.integracao.dao.ConvenioDebitoDAO;
import br.com.bb.plugins.dbt.integracao.dao.RecebimentoDebitoDAO;
import br.com.bb.plugins.gac.excecao.BBException;
import br.com.bb.plugins.gac.factory.TOFactory;
import br.com.bb.plugins.gac.integracao.dao.ConvenioDAO;
import br.com.bb.plugins.gac.integracao.dao.RemessaDAO;
import br.com.bb.plugins.gac.negocio.model.PluginModelAbstrato;
import br.com.bb.plugins.gac.negocio.to.ConvenenteTO;
import br.com.bb.plugins.gac.negocio.to.ConvenioDebitoTO;
import br.com.bb.plugins.gac.negocio.to.ConvenioTO;
import br.com.bb.plugins.gac.negocio.to.RecebimentoDebitoTO;
import br.com.bb.plugins.gac.negocio.to.RemessaTO;
import br.com.bb.plugins.gac.negocio.to.RemessaTOId;
import br.com.bb.plugins.gac.negocio.to.SituacaoRecebimentoTO;
import br.com.bb.plugins.gac.negocio.to.decorator.RemessaTODecorator;
import br.com.bb.plugins.gac.util.ComparatorUtil;
import br.com.bb.plugins.gac.util.UtilArquivoConfiguracao;
import br.com.bb.plugins.gac.util.UtilNotificador;
import br.com.bb.plugins.gac.util.parserarquivo.IParserArquivo;
import br.com.bb.plugins.gac.util.parserarquivo.IParserArquivoFactory;
import br.com.bb.plugins.gac.util.parserarquivo.ParserArquivoFactory;
import br.com.bb.plugins.gac.util.seguranca.PluginControladorDeAcesso;
import br.com.politec.generico.colecao.UtilColecao;
import br.com.politec.generico.conversor.UtilConversorDeInteger;
import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RecuperarRemessaModel
extends PluginModelAbstrato {
    private RemessaDAO remessaDAO;
    private ConvenioDAO convenioDAO;
    private RecebimentoDebitoDAO recebimentoDebitoDAO;
    private ConvenioDebitoDAO convenioDebitoDAO;
    private IParserArquivo parserArquivo;

    public void recuperarRemessas(RemessaTODecorator remessaF) throws BBException {
        Collection remessas = remessaF.getListaRemessa();
        UtilNotificador notificaStatus = remessaF.getNotificaProcessarRemessa();
        int i = 0;
        for (RemessaTODecorator remessaTODecorator : remessas) {
            ++i;
            RemessaTO remessaRecuperada = this.recuperarItemRemessa(remessaTODecorator);
            RemessaTOId remessaId = this.clonarRemessaTOId(remessaRecuperada);
            this.atualizarRecebimentoDebito(remessaRecuperada);
            this.excluirItemRemessa(remessaId);
            this.atualizarConvenioDebito(remessaRecuperada);
            this.excluirArquivoRemessa(remessaTODecorator);
            this.atualizaPorcentagem(notificaStatus, remessas.size(), i);
        }
    }

    private void atualizaPorcentagem(UtilNotificador notificaImportacao, int totalRegistros, int numeroLinha) {
        int porcentagem = numeroLinha * 100 / totalRegistros;
        notificaImportacao.notifyObservers((Object)porcentagem);
    }

    private void atualizarConvenioDebito(RemessaTO remessaRecuperada) throws BBException {
        ConvenioTO conveio = remessaRecuperada.getConvenioTO();
        ConvenioDebitoTO convenioDebito = null;
        int remessaAterior = 0;
        convenioDebito = this.getConvenioDebitoDAO().consultar(conveio.getNumeroConvenio(), conveio.getServicoTO().getTextoIdentificadorServico());
        remessaAterior = this.numeroRemessaAnterior(conveio);
        convenioDebito.setNumeroUltimaRemessa(Integer.valueOf(remessaAterior));
        this.getConvenioDebitoDAO().alterar(convenioDebito);
    }

    private int numeroRemessaAnterior(ConvenioTO conveio) {
        Integer maiorRemessa = this.getRemessaDAO().consultarMaiorRemessa(conveio);
        return maiorRemessa == null ? 0 : maiorRemessa;
    }

    private void excluirArquivoRemessa(RemessaTODecorator remessa) throws BBException {
        this.getArquivoRemessa(remessa.getTextoNomeArquivo()).delete();
    }

    private void excluirItemRemessa(RemessaTOId id) {
        this.getRemessaDAO().excluir((Serializable)id);
    }

    private RemessaTOId clonarRemessaTOId(RemessaTO remessaRecuperada) {
        RemessaTOId id = this.getFabricaDeTO().novoRemessaTOId();
        id.setCodigoPessoaConvenente(remessaRecuperada.getId().getCodigoPessoaConvenente());
        id.setNumeroConvenio(remessaRecuperada.getId().getNumeroConvenio());
        id.setNumeroRemessa(remessaRecuperada.getId().getNumeroRemessa());
        id.setTextoIdentificadorServico(remessaRecuperada.getId().getTextoIdentificadorServico());
        id.setDataRemessa(remessaRecuperada.getId().getDataRemessa());
        return id;
    }

    private void atualizarRecebimentoDebito(RemessaTO remessaRecuperada) {
        SituacaoRecebimentoTO s = this.getFabricaDeTO().novoSituacaoRecebimentoTO();
        s.setCodigoSituacaoRecebimento(Character.valueOf('G'));
        for (RecebimentoDebitoTO recTO : remessaRecuperada.getRecebimentoDebitoTOs()) {
            recTO.setRemessaTO(null);
            recTO.setTextoIdentificadorRegistro(null);
            recTO.setSituacaoRecebimentoTO(s);
            this.getRecebimentoDebitoDAO().alterar(recTO);
        }
    }

    private RemessaTO recuperarItemRemessa(RemessaTODecorator remessa) {
        return (RemessaTO)this.getRemessaDAO().listar((Serializable)remessa.getRemessaTO().getId());
    }

    public List<RemessaTODecorator> listar(ConvenenteTO convenenteTO) throws BBException {
        List listaRetorno = this.getColecaoFactory().novoArrayList();
        File[] listaArquivoPastaRemessa = this.processaRecuperarRemessa();
        if (listaArquivoPastaRemessa != null) {
            int i = 0;
            while (i < listaArquivoPastaRemessa.length) {
                File file = listaArquivoPastaRemessa[i];
                if (file.isFile()) {
                    try {
                        this.setParserArquivo(this.getParserArquivoFactory().novoParserArquivo(file));
                        if (this.isServicoDbt() && this.isConvenioConvenente(convenenteTO)) {
                            RemessaTODecorator remessaTODecorator = this.getFabricaDeTO().novoRemessaTODecorator();
                            List remessas = (List)this.consultarRemessaPorArquivoRemessa();
                            for (RemessaTO remessa : remessas) {
                                if (remessa == null) continue;
                                remessaTODecorator.setRemessaTO(remessa);
                                remessaTODecorator.setTextoNomeArquivo(file.getName());
                                if (listaRetorno.contains(remessaTODecorator)) continue;
                                listaRetorno.add(remessaTODecorator);
                            }
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                ++i;
            }
        }
        UtilColecao.ordenar((Collection)listaRetorno, (Comparator)ComparatorUtil.getComparator((String[])new String[]{"id.dataRemessa", "id.numeroConvenio", "id.numeroRemessa"}, (int)0));
        return listaRetorno;
    }

    private boolean isUltimaRemessa() throws BBException {
        boolean retorno = false;
        ConvenioDebitoTO convDebito = this.getConvenioDebitoDAO().consultar(this.getCodigoConvenio(), "DBT");
        if (convDebito != null && convDebito.getNumeroUltimaRemessa() != null) {
            retorno = convDebito.getNumeroUltimaRemessa().equals(this.getNumeroRemessa());
        }
        return retorno;
    }

    private boolean isServicoDbt() {
        String identificadorServico;
        block3: {
            try {
                identificadorServico = this.getIdentificadorServico();
                if (identificadorServico != null) break block3;
                return false;
            }
            catch (BBException e) {
                System.out.println(e.getMessage());
                return false;
            }
        }
        return identificadorServico.startsWith("DBT");
    }

    private boolean isConvenioConvenente(ConvenenteTO convenenteTO) throws BBException {
        boolean retorno = false;
        Set listaConvenio = null;
        if (convenenteTO != null) {
            listaConvenio = convenenteTO.getConvenioTOs();
            for (ConvenioTO convenioTO : listaConvenio) {
                if (!convenioTO.getId().getNumeroConvenio().equals(this.getCodigoConvenio())) continue;
                retorno = true;
                break;
            }
        } else {
            retorno = true;
        }
        return retorno;
    }

    private IParserArquivoFactory getParserArquivoFactory() {
        return ParserArquivoFactory.getInstancia();
    }

    private Collection<RemessaTO> consultarRemessa() throws BBException {
        RemessaTO remessaTO = TOFactory.getInstancia().novoRemessaTO();
        ConvenioDebitoTO convDebito = this.getConvenioDebitoDAO().consultar(this.getCodigoConvenio(), "DBT");
        remessaTO.getId().setNumeroConvenio(convDebito.getId().getNumeroConvenio().intValue());
        remessaTO.getId().setCodigoPessoaConvenente(convDebito.getId().getCodigoPessoaConvenente().intValue());
        remessaTO.getId().setTextoIdentificadorServico(convDebito.getId().getTextoIdentificadorServico());
        remessaTO.getId().setDataRemessa(this.getDataRemessa());
        return this.getRemessaDAO().listarRecuperarRemessa(remessaTO);
    }

    private Collection<RemessaTO> consultarRemessaPorArquivoRemessa() throws BBException {
        RemessaTO remessaTO = TOFactory.getInstancia().novoRemessaTO();
        ConvenioDebitoTO convDebito = this.getConvenioDebitoDAO().consultar(this.getCodigoConvenio(), "DBT");
        remessaTO.getId().setNumeroRemessa(this.getNumeroRemessaDoArquivo());
        remessaTO.getId().setNumeroConvenio(convDebito.getId().getNumeroConvenio().intValue());
        remessaTO.getId().setCodigoPessoaConvenente(convDebito.getId().getCodigoPessoaConvenente().intValue());
        remessaTO.getId().setTextoIdentificadorServico(convDebito.getId().getTextoIdentificadorServico());
        remessaTO.getId().setDataRemessa(this.getDataRemessa());
        return this.getRemessaDAO().listarRecuperarRemessaPorCodigoRemessa(remessaTO);
    }

    private Integer getNumeroRemessaDoArquivo() throws BBException {
        return this.getParserArquivo().getNumeroRemessa();
    }

    private Date getDataRemessa() throws BBException {
        return this.getParserArquivo().getValorDoCabecalhoDate("DataArq");
    }

    private ConvenioDebitoTO consultarConvenioDebito(ConvenioDebitoTO convenioDebitoTO) {
        return (ConvenioDebitoTO)this.getConvenioDebitoDAO().listar(convenioDebitoTO);
    }

    private Integer getCodigoConveneteTela() {
        PluginControladorDeAcesso acesso = this.getFabricaDeControladorDeAcesso().novoPluginControladorDeAcesso();
        return acesso.getConvenenteTO().getCodigoPessoaConvenente();
    }

    private String getIdentificadorServico() throws BBException {
        return this.getParserArquivo().getValorDoCabecalhoString("Debito");
    }

    private Integer getCodigoConvenio() throws BBException {
        return this.converterParaInteger(this.getParserArquivo().getValorDoCabecalhoString("Convenio"));
    }

    private Integer getNumeroRemessa() throws BBException {
        return this.getParserArquivo().getValorDoCabecalhoInteger("SequencialArq");
    }

    private Integer converterParaInteger(String valor) {
        return UtilConversorDeInteger.converterParaInteger((String)valor);
    }

    public ConvenioDAO getConvenioDAO() {
        return this.convenioDAO;
    }

    public void setConvenioDAO(ConvenioDAO convenioDAO) {
        this.convenioDAO = convenioDAO;
    }

    private File[] processaRecuperarRemessa() {
        File file = this.getPastaRemessa(this.getPastaArquivosRemessa());
        File[] listaArquivoPastaRemessa = file.listFiles();
        return listaArquivoPastaRemessa;
    }

    private File getArquivoRemessa(String nomeArquivo) {
        return this.getArquivoFactory().novoFile(String.valueOf(this.getPastaArquivosRemessa()) + "\\" + nomeArquivo);
    }

    private String getPastaArquivosRemessa() {
        UtilArquivoConfiguracao instanciaUtilArquivoConfiguraca = this.getInstanciaUtilArquivoConfiguraca();
        return instanciaUtilArquivoConfiguraca.getValorPropertie("diretorio.remessa");
    }

    private File getPastaRemessa(String diretorioRemessa) {
        return this.getArquivoFactory().novoFile(diretorioRemessa);
    }

    private UtilArquivoConfiguracao getInstanciaUtilArquivoConfiguraca() {
        return UtilArquivoConfiguracao.getInstancia();
    }

    public RemessaDAO getRemessaDAO() {
        return this.remessaDAO;
    }

    public void setRemessaDAO(RemessaDAO remessaDAO) {
        this.remessaDAO = remessaDAO;
    }

    public IParserArquivo getParserArquivo() {
        return this.parserArquivo;
    }

    public void setParserArquivo(IParserArquivo parserArquivo) {
        this.parserArquivo = parserArquivo;
    }

    public RecebimentoDebitoDAO getRecebimentoDebitoDAO() {
        return this.recebimentoDebitoDAO;
    }

    public void setRecebimentoDebitoDAO(RecebimentoDebitoDAO recebimentoDebitoDAO) {
        this.recebimentoDebitoDAO = recebimentoDebitoDAO;
    }

    public ConvenioDebitoDAO getConvenioDebitoDAO() {
        return this.convenioDebitoDAO;
    }

    public void setConvenioDebitoDAO(ConvenioDebitoDAO convenioDebitoDAO) {
        this.convenioDebitoDAO = convenioDebitoDAO;
    }
}

